# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RestorePointArgs', 'RestorePoint']

@pulumi.input_type
class RestorePointArgs:
    def __init__(__self__, *,
                 virtual_machine_restore_point_collection_id: pulumi.Input[_builtins.str],
                 crash_consistency_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 excluded_disks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RestorePoint resource.
        :param pulumi.Input[_builtins.str] virtual_machine_restore_point_collection_id: Specifies the ID of the Virtual Machine Restore Point Collection the Virtual Machine Restore Point will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] crash_consistency_mode_enabled: Whether the Consistency Mode of the Virtual Machine Restore Point is set to `CrashConsistent`. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_disks: A list of disks that will be excluded from the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "virtual_machine_restore_point_collection_id", virtual_machine_restore_point_collection_id)
        if crash_consistency_mode_enabled is not None:
            pulumi.set(__self__, "crash_consistency_mode_enabled", crash_consistency_mode_enabled)
        if excluded_disks is not None:
            pulumi.set(__self__, "excluded_disks", excluded_disks)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="virtualMachineRestorePointCollectionId")
    def virtual_machine_restore_point_collection_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Virtual Machine Restore Point Collection the Virtual Machine Restore Point will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_restore_point_collection_id")

    @virtual_machine_restore_point_collection_id.setter
    def virtual_machine_restore_point_collection_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_machine_restore_point_collection_id", value)

    @_builtins.property
    @pulumi.getter(name="crashConsistencyModeEnabled")
    def crash_consistency_mode_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Consistency Mode of the Virtual Machine Restore Point is set to `CrashConsistent`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "crash_consistency_mode_enabled")

    @crash_consistency_mode_enabled.setter
    def crash_consistency_mode_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "crash_consistency_mode_enabled", value)

    @_builtins.property
    @pulumi.getter(name="excludedDisks")
    def excluded_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of disks that will be excluded from the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "excluded_disks")

    @excluded_disks.setter
    def excluded_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_disks", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RestorePointState:
    def __init__(__self__, *,
                 crash_consistency_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 excluded_disks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_restore_point_collection_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RestorePoint resources.
        :param pulumi.Input[_builtins.bool] crash_consistency_mode_enabled: Whether the Consistency Mode of the Virtual Machine Restore Point is set to `CrashConsistent`. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_disks: A list of disks that will be excluded from the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_machine_restore_point_collection_id: Specifies the ID of the Virtual Machine Restore Point Collection the Virtual Machine Restore Point will be associated with. Changing this forces a new resource to be created.
        """
        if crash_consistency_mode_enabled is not None:
            pulumi.set(__self__, "crash_consistency_mode_enabled", crash_consistency_mode_enabled)
        if excluded_disks is not None:
            pulumi.set(__self__, "excluded_disks", excluded_disks)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if virtual_machine_restore_point_collection_id is not None:
            pulumi.set(__self__, "virtual_machine_restore_point_collection_id", virtual_machine_restore_point_collection_id)

    @_builtins.property
    @pulumi.getter(name="crashConsistencyModeEnabled")
    def crash_consistency_mode_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the Consistency Mode of the Virtual Machine Restore Point is set to `CrashConsistent`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "crash_consistency_mode_enabled")

    @crash_consistency_mode_enabled.setter
    def crash_consistency_mode_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "crash_consistency_mode_enabled", value)

    @_builtins.property
    @pulumi.getter(name="excludedDisks")
    def excluded_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of disks that will be excluded from the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "excluded_disks")

    @excluded_disks.setter
    def excluded_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "excluded_disks", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineRestorePointCollectionId")
    def virtual_machine_restore_point_collection_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Virtual Machine Restore Point Collection the Virtual Machine Restore Point will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_restore_point_collection_id")

    @virtual_machine_restore_point_collection_id.setter
    def virtual_machine_restore_point_collection_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_machine_restore_point_collection_id", value)


@pulumi.type_token("azure:compute/restorePoint:RestorePoint")
class RestorePoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crash_consistency_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 excluded_disks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_restore_point_collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Virtual Machine Restore Point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            network_interface_ids=[example_network_interface.id],
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": std.file(input="~/.ssh/id_rsa.pub").result,
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_restore_point_collection = azure.compute.RestorePointCollection("example",
            name="example-collection",
            resource_group_name=example.name,
            location=example_linux_virtual_machine.location,
            source_virtual_machine_id=example_linux_virtual_machine.id)
        example_restore_point = azure.compute.RestorePoint("example",
            name="example-restore-point",
            virtual_machine_restore_point_collection_id=example_restore_point_collection.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2024-03-01

        ## Import

        Virtual Machine Restore Point can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/restorePoint:RestorePoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/restorePointCollections/collection1/restorePoints/restorePoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] crash_consistency_mode_enabled: Whether the Consistency Mode of the Virtual Machine Restore Point is set to `CrashConsistent`. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_disks: A list of disks that will be excluded from the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_machine_restore_point_collection_id: Specifies the ID of the Virtual Machine Restore Point Collection the Virtual Machine Restore Point will be associated with. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RestorePointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Virtual Machine Restore Point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="example-machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_F2",
            admin_username="adminuser",
            network_interface_ids=[example_network_interface.id],
            admin_ssh_keys=[{
                "username": "adminuser",
                "public_key": std.file(input="~/.ssh/id_rsa.pub").result,
            }],
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_restore_point_collection = azure.compute.RestorePointCollection("example",
            name="example-collection",
            resource_group_name=example.name,
            location=example_linux_virtual_machine.location,
            source_virtual_machine_id=example_linux_virtual_machine.id)
        example_restore_point = azure.compute.RestorePoint("example",
            name="example-restore-point",
            virtual_machine_restore_point_collection_id=example_restore_point_collection.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2024-03-01

        ## Import

        Virtual Machine Restore Point can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/restorePoint:RestorePoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/restorePointCollections/collection1/restorePoints/restorePoint1
        ```

        :param str resource_name: The name of the resource.
        :param RestorePointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RestorePointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 crash_consistency_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 excluded_disks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_machine_restore_point_collection_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RestorePointArgs.__new__(RestorePointArgs)

            __props__.__dict__["crash_consistency_mode_enabled"] = crash_consistency_mode_enabled
            __props__.__dict__["excluded_disks"] = excluded_disks
            __props__.__dict__["name"] = name
            if virtual_machine_restore_point_collection_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_restore_point_collection_id'")
            __props__.__dict__["virtual_machine_restore_point_collection_id"] = virtual_machine_restore_point_collection_id
        super(RestorePoint, __self__).__init__(
            'azure:compute/restorePoint:RestorePoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            crash_consistency_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            excluded_disks: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_machine_restore_point_collection_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RestorePoint':
        """
        Get an existing RestorePoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] crash_consistency_mode_enabled: Whether the Consistency Mode of the Virtual Machine Restore Point is set to `CrashConsistent`. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] excluded_disks: A list of disks that will be excluded from the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_machine_restore_point_collection_id: Specifies the ID of the Virtual Machine Restore Point Collection the Virtual Machine Restore Point will be associated with. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RestorePointState.__new__(_RestorePointState)

        __props__.__dict__["crash_consistency_mode_enabled"] = crash_consistency_mode_enabled
        __props__.__dict__["excluded_disks"] = excluded_disks
        __props__.__dict__["name"] = name
        __props__.__dict__["virtual_machine_restore_point_collection_id"] = virtual_machine_restore_point_collection_id
        return RestorePoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="crashConsistencyModeEnabled")
    def crash_consistency_mode_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the Consistency Mode of the Virtual Machine Restore Point is set to `CrashConsistent`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "crash_consistency_mode_enabled")

    @_builtins.property
    @pulumi.getter(name="excludedDisks")
    def excluded_disks(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of disks that will be excluded from the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "excluded_disks")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Virtual Machine Restore Point. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="virtualMachineRestorePointCollectionId")
    def virtual_machine_restore_point_collection_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Virtual Machine Restore Point Collection the Virtual Machine Restore Point will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_restore_point_collection_id")

