# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScaleSetArgs', 'ScaleSet']

@pulumi.input_type
class ScaleSetArgs:
    def __init__(__self__, *,
                 network_profiles: pulumi.Input[Sequence[pulumi.Input['ScaleSetNetworkProfileArgs']]],
                 os_profile: pulumi.Input['ScaleSetOsProfileArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input['ScaleSetSkuArgs'],
                 storage_profile_os_disk: pulumi.Input['ScaleSetStorageProfileOsDiskArgs'],
                 upgrade_policy_mode: pulumi.Input[_builtins.str],
                 automatic_os_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot_diagnostics: Optional[pulumi.Input['ScaleSetBootDiagnosticsArgs']] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetExtensionArgs']]]] = None,
                 health_probe_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ScaleSetIdentityArgs']] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_profile_linux_config: Optional[pulumi.Input['ScaleSetOsProfileLinuxConfigArgs']] = None,
                 os_profile_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetOsProfileSecretArgs']]]] = None,
                 os_profile_windows_config: Optional[pulumi.Input['ScaleSetOsProfileWindowsConfigArgs']] = None,
                 overprovision: Optional[pulumi.Input[_builtins.bool]] = None,
                 plan: Optional[pulumi.Input['ScaleSetPlanArgs']] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input['ScaleSetRollingUpgradePolicyArgs']] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_profile_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetStorageProfileDataDiskArgs']]]] = None,
                 storage_profile_image_reference: Optional[pulumi.Input['ScaleSetStorageProfileImageReferenceArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ScaleSet resource.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleSetNetworkProfileArgs']]] network_profiles: A collection of `network_profile` blocks as documented below.
        :param pulumi.Input['ScaleSetOsProfileArgs'] os_profile: A `os_profile` block as documented below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the virtual machine scale set. Changing this forces a new resource to be created.
        :param pulumi.Input['ScaleSetSkuArgs'] sku: A `sku` block as documented below.
        :param pulumi.Input['ScaleSetStorageProfileOsDiskArgs'] storage_profile_os_disk: A `storage_profile_os_disk` block as documented below.
        :param pulumi.Input[_builtins.str] upgrade_policy_mode: Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing `Rolling`, you will need to set a health probe.
        :param pulumi.Input[_builtins.bool] automatic_os_upgrade: Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        :param pulumi.Input['ScaleSetBootDiagnosticsArgs'] boot_diagnostics: A `boot_diagnostics` block as referenced below.
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **NOTE:** `eviction_policy` can only be set when `priority` is set to `Low`.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleSetExtensionArgs']]] extensions: Can be specified multiple times to add extension profiles to the scale set. Each `extension` block supports the fields documented below.
        :param pulumi.Input[_builtins.str] health_probe_id: Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`.
        :param pulumi.Input['ScaleSetIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: (Optional, when a Windows machine) Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the virtual machine scale set resource. Changing this forces a new resource to be created.
        :param pulumi.Input['ScaleSetOsProfileLinuxConfigArgs'] os_profile_linux_config: A `os_profile_linux_config` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleSetOsProfileSecretArgs']]] os_profile_secrets: A collection of `os_profile_secrets` blocks as documented below.
        :param pulumi.Input['ScaleSetOsProfileWindowsConfigArgs'] os_profile_windows_config: A `os_profile_windows_config` block as documented below.
        :param pulumi.Input[_builtins.bool] overprovision: Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        :param pulumi.Input['ScaleSetPlanArgs'] plan: A `plan` block as documented below.
        :param pulumi.Input[_builtins.str] priority: Specifies the priority for the Virtual Machines in the Scale Set. Possible values are `Low` and `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group to which this Virtual Machine should be assigned. Changing this forces a new resource to be created
        :param pulumi.Input['ScaleSetRollingUpgradePolicyArgs'] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is only applicable when the `upgrade_policy_mode` is `Rolling`.
        :param pulumi.Input[_builtins.bool] single_placement_group: Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Changing this forces a new resource to be created. See [documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-placement-groups) for more information. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleSetStorageProfileDataDiskArgs']]] storage_profile_data_disks: A `storage_profile_data_disk` block as documented below.
        :param pulumi.Input['ScaleSetStorageProfileImageReferenceArgs'] storage_profile_image_reference: A `storage_profile_image_reference` block as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: A collection of availability zones to spread the Virtual Machines over. Changing this forces a new resource to be created.
               
               > **NOTE:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        pulumi.set(__self__, "network_profiles", network_profiles)
        pulumi.set(__self__, "os_profile", os_profile)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "storage_profile_os_disk", storage_profile_os_disk)
        pulumi.set(__self__, "upgrade_policy_mode", upgrade_policy_mode)
        if automatic_os_upgrade is not None:
            pulumi.set(__self__, "automatic_os_upgrade", automatic_os_upgrade)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if health_probe_id is not None:
            pulumi.set(__self__, "health_probe_id", health_probe_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_profile_linux_config is not None:
            pulumi.set(__self__, "os_profile_linux_config", os_profile_linux_config)
        if os_profile_secrets is not None:
            pulumi.set(__self__, "os_profile_secrets", os_profile_secrets)
        if os_profile_windows_config is not None:
            pulumi.set(__self__, "os_profile_windows_config", os_profile_windows_config)
        if overprovision is not None:
            pulumi.set(__self__, "overprovision", overprovision)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if rolling_upgrade_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_policy", rolling_upgrade_policy)
        if single_placement_group is not None:
            pulumi.set(__self__, "single_placement_group", single_placement_group)
        if storage_profile_data_disks is not None:
            pulumi.set(__self__, "storage_profile_data_disks", storage_profile_data_disks)
        if storage_profile_image_reference is not None:
            pulumi.set(__self__, "storage_profile_image_reference", storage_profile_image_reference)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="networkProfiles")
    def network_profiles(self) -> pulumi.Input[Sequence[pulumi.Input['ScaleSetNetworkProfileArgs']]]:
        """
        A collection of `network_profile` blocks as documented below.
        """
        return pulumi.get(self, "network_profiles")

    @network_profiles.setter
    def network_profiles(self, value: pulumi.Input[Sequence[pulumi.Input['ScaleSetNetworkProfileArgs']]]):
        pulumi.set(self, "network_profiles", value)

    @_builtins.property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> pulumi.Input['ScaleSetOsProfileArgs']:
        """
        A `os_profile` block as documented below.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: pulumi.Input['ScaleSetOsProfileArgs']):
        pulumi.set(self, "os_profile", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the virtual machine scale set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input['ScaleSetSkuArgs']:
        """
        A `sku` block as documented below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['ScaleSetSkuArgs']):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="storageProfileOsDisk")
    def storage_profile_os_disk(self) -> pulumi.Input['ScaleSetStorageProfileOsDiskArgs']:
        """
        A `storage_profile_os_disk` block as documented below.
        """
        return pulumi.get(self, "storage_profile_os_disk")

    @storage_profile_os_disk.setter
    def storage_profile_os_disk(self, value: pulumi.Input['ScaleSetStorageProfileOsDiskArgs']):
        pulumi.set(self, "storage_profile_os_disk", value)

    @_builtins.property
    @pulumi.getter(name="upgradePolicyMode")
    def upgrade_policy_mode(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing `Rolling`, you will need to set a health probe.
        """
        return pulumi.get(self, "upgrade_policy_mode")

    @upgrade_policy_mode.setter
    def upgrade_policy_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "upgrade_policy_mode", value)

    @_builtins.property
    @pulumi.getter(name="automaticOsUpgrade")
    def automatic_os_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_os_upgrade")

    @automatic_os_upgrade.setter
    def automatic_os_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_os_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional[pulumi.Input['ScaleSetBootDiagnosticsArgs']]:
        """
        A `boot_diagnostics` block as referenced below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @boot_diagnostics.setter
    def boot_diagnostics(self, value: Optional[pulumi.Input['ScaleSetBootDiagnosticsArgs']]):
        pulumi.set(self, "boot_diagnostics", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **NOTE:** `eviction_policy` can only be set when `priority` is set to `Low`.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetExtensionArgs']]]]:
        """
        Can be specified multiple times to add extension profiles to the scale set. Each `extension` block supports the fields documented below.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter(name="healthProbeId")
    def health_probe_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`.
        """
        return pulumi.get(self, "health_probe_id")

    @health_probe_id.setter
    def health_probe_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_probe_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ScaleSetIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ScaleSetIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional, when a Windows machine) Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the virtual machine scale set resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osProfileLinuxConfig")
    def os_profile_linux_config(self) -> Optional[pulumi.Input['ScaleSetOsProfileLinuxConfigArgs']]:
        """
        A `os_profile_linux_config` block as documented below.
        """
        return pulumi.get(self, "os_profile_linux_config")

    @os_profile_linux_config.setter
    def os_profile_linux_config(self, value: Optional[pulumi.Input['ScaleSetOsProfileLinuxConfigArgs']]):
        pulumi.set(self, "os_profile_linux_config", value)

    @_builtins.property
    @pulumi.getter(name="osProfileSecrets")
    def os_profile_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetOsProfileSecretArgs']]]]:
        """
        A collection of `os_profile_secrets` blocks as documented below.
        """
        return pulumi.get(self, "os_profile_secrets")

    @os_profile_secrets.setter
    def os_profile_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetOsProfileSecretArgs']]]]):
        pulumi.set(self, "os_profile_secrets", value)

    @_builtins.property
    @pulumi.getter(name="osProfileWindowsConfig")
    def os_profile_windows_config(self) -> Optional[pulumi.Input['ScaleSetOsProfileWindowsConfigArgs']]:
        """
        A `os_profile_windows_config` block as documented below.
        """
        return pulumi.get(self, "os_profile_windows_config")

    @os_profile_windows_config.setter
    def os_profile_windows_config(self, value: Optional[pulumi.Input['ScaleSetOsProfileWindowsConfigArgs']]):
        pulumi.set(self, "os_profile_windows_config", value)

    @_builtins.property
    @pulumi.getter
    def overprovision(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        """
        return pulumi.get(self, "overprovision")

    @overprovision.setter
    def overprovision(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "overprovision", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['ScaleSetPlanArgs']]:
        """
        A `plan` block as documented below.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['ScaleSetPlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the priority for the Virtual Machines in the Scale Set. Possible values are `Low` and `Regular`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Proximity Placement Group to which this Virtual Machine should be assigned. Changing this forces a new resource to be created
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> Optional[pulumi.Input['ScaleSetRollingUpgradePolicyArgs']]:
        """
        A `rolling_upgrade_policy` block as defined below. This is only applicable when the `upgrade_policy_mode` is `Rolling`.
        """
        return pulumi.get(self, "rolling_upgrade_policy")

    @rolling_upgrade_policy.setter
    def rolling_upgrade_policy(self, value: Optional[pulumi.Input['ScaleSetRollingUpgradePolicyArgs']]):
        pulumi.set(self, "rolling_upgrade_policy", value)

    @_builtins.property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Changing this forces a new resource to be created. See [documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-placement-groups) for more information. Defaults to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @single_placement_group.setter
    def single_placement_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "single_placement_group", value)

    @_builtins.property
    @pulumi.getter(name="storageProfileDataDisks")
    def storage_profile_data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetStorageProfileDataDiskArgs']]]]:
        """
        A `storage_profile_data_disk` block as documented below.
        """
        return pulumi.get(self, "storage_profile_data_disks")

    @storage_profile_data_disks.setter
    def storage_profile_data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetStorageProfileDataDiskArgs']]]]):
        pulumi.set(self, "storage_profile_data_disks", value)

    @_builtins.property
    @pulumi.getter(name="storageProfileImageReference")
    def storage_profile_image_reference(self) -> Optional[pulumi.Input['ScaleSetStorageProfileImageReferenceArgs']]:
        """
        A `storage_profile_image_reference` block as documented below.
        """
        return pulumi.get(self, "storage_profile_image_reference")

    @storage_profile_image_reference.setter
    def storage_profile_image_reference(self, value: Optional[pulumi.Input['ScaleSetStorageProfileImageReferenceArgs']]):
        pulumi.set(self, "storage_profile_image_reference", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A collection of availability zones to spread the Virtual Machines over. Changing this forces a new resource to be created.

        > **NOTE:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _ScaleSetState:
    def __init__(__self__, *,
                 automatic_os_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot_diagnostics: Optional[pulumi.Input['ScaleSetBootDiagnosticsArgs']] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetExtensionArgs']]]] = None,
                 health_probe_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ScaleSetIdentityArgs']] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetNetworkProfileArgs']]]] = None,
                 os_profile: Optional[pulumi.Input['ScaleSetOsProfileArgs']] = None,
                 os_profile_linux_config: Optional[pulumi.Input['ScaleSetOsProfileLinuxConfigArgs']] = None,
                 os_profile_secrets: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetOsProfileSecretArgs']]]] = None,
                 os_profile_windows_config: Optional[pulumi.Input['ScaleSetOsProfileWindowsConfigArgs']] = None,
                 overprovision: Optional[pulumi.Input[_builtins.bool]] = None,
                 plan: Optional[pulumi.Input['ScaleSetPlanArgs']] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input['ScaleSetRollingUpgradePolicyArgs']] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku: Optional[pulumi.Input['ScaleSetSkuArgs']] = None,
                 storage_profile_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetStorageProfileDataDiskArgs']]]] = None,
                 storage_profile_image_reference: Optional[pulumi.Input['ScaleSetStorageProfileImageReferenceArgs']] = None,
                 storage_profile_os_disk: Optional[pulumi.Input['ScaleSetStorageProfileOsDiskArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_policy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ScaleSet resources.
        :param pulumi.Input[_builtins.bool] automatic_os_upgrade: Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        :param pulumi.Input['ScaleSetBootDiagnosticsArgs'] boot_diagnostics: A `boot_diagnostics` block as referenced below.
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **NOTE:** `eviction_policy` can only be set when `priority` is set to `Low`.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleSetExtensionArgs']]] extensions: Can be specified multiple times to add extension profiles to the scale set. Each `extension` block supports the fields documented below.
        :param pulumi.Input[_builtins.str] health_probe_id: Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`.
        :param pulumi.Input['ScaleSetIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: (Optional, when a Windows machine) Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the virtual machine scale set resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleSetNetworkProfileArgs']]] network_profiles: A collection of `network_profile` blocks as documented below.
        :param pulumi.Input['ScaleSetOsProfileArgs'] os_profile: A `os_profile` block as documented below.
        :param pulumi.Input['ScaleSetOsProfileLinuxConfigArgs'] os_profile_linux_config: A `os_profile_linux_config` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleSetOsProfileSecretArgs']]] os_profile_secrets: A collection of `os_profile_secrets` blocks as documented below.
        :param pulumi.Input['ScaleSetOsProfileWindowsConfigArgs'] os_profile_windows_config: A `os_profile_windows_config` block as documented below.
        :param pulumi.Input[_builtins.bool] overprovision: Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        :param pulumi.Input['ScaleSetPlanArgs'] plan: A `plan` block as documented below.
        :param pulumi.Input[_builtins.str] priority: Specifies the priority for the Virtual Machines in the Scale Set. Possible values are `Low` and `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group to which this Virtual Machine should be assigned. Changing this forces a new resource to be created
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the virtual machine scale set. Changing this forces a new resource to be created.
        :param pulumi.Input['ScaleSetRollingUpgradePolicyArgs'] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is only applicable when the `upgrade_policy_mode` is `Rolling`.
        :param pulumi.Input[_builtins.bool] single_placement_group: Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Changing this forces a new resource to be created. See [documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-placement-groups) for more information. Defaults to `true`.
        :param pulumi.Input['ScaleSetSkuArgs'] sku: A `sku` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ScaleSetStorageProfileDataDiskArgs']]] storage_profile_data_disks: A `storage_profile_data_disk` block as documented below.
        :param pulumi.Input['ScaleSetStorageProfileImageReferenceArgs'] storage_profile_image_reference: A `storage_profile_image_reference` block as documented below.
        :param pulumi.Input['ScaleSetStorageProfileOsDiskArgs'] storage_profile_os_disk: A `storage_profile_os_disk` block as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] upgrade_policy_mode: Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing `Rolling`, you will need to set a health probe.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: A collection of availability zones to spread the Virtual Machines over. Changing this forces a new resource to be created.
               
               > **NOTE:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        if automatic_os_upgrade is not None:
            pulumi.set(__self__, "automatic_os_upgrade", automatic_os_upgrade)
        if boot_diagnostics is not None:
            pulumi.set(__self__, "boot_diagnostics", boot_diagnostics)
        if eviction_policy is not None:
            pulumi.set(__self__, "eviction_policy", eviction_policy)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if health_probe_id is not None:
            pulumi.set(__self__, "health_probe_id", health_probe_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_profiles is not None:
            pulumi.set(__self__, "network_profiles", network_profiles)
        if os_profile is not None:
            pulumi.set(__self__, "os_profile", os_profile)
        if os_profile_linux_config is not None:
            pulumi.set(__self__, "os_profile_linux_config", os_profile_linux_config)
        if os_profile_secrets is not None:
            pulumi.set(__self__, "os_profile_secrets", os_profile_secrets)
        if os_profile_windows_config is not None:
            pulumi.set(__self__, "os_profile_windows_config", os_profile_windows_config)
        if overprovision is not None:
            pulumi.set(__self__, "overprovision", overprovision)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if proximity_placement_group_id is not None:
            pulumi.set(__self__, "proximity_placement_group_id", proximity_placement_group_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if rolling_upgrade_policy is not None:
            pulumi.set(__self__, "rolling_upgrade_policy", rolling_upgrade_policy)
        if single_placement_group is not None:
            pulumi.set(__self__, "single_placement_group", single_placement_group)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if storage_profile_data_disks is not None:
            pulumi.set(__self__, "storage_profile_data_disks", storage_profile_data_disks)
        if storage_profile_image_reference is not None:
            pulumi.set(__self__, "storage_profile_image_reference", storage_profile_image_reference)
        if storage_profile_os_disk is not None:
            pulumi.set(__self__, "storage_profile_os_disk", storage_profile_os_disk)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgrade_policy_mode is not None:
            pulumi.set(__self__, "upgrade_policy_mode", upgrade_policy_mode)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="automaticOsUpgrade")
    def automatic_os_upgrade(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_os_upgrade")

    @automatic_os_upgrade.setter
    def automatic_os_upgrade(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "automatic_os_upgrade", value)

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> Optional[pulumi.Input['ScaleSetBootDiagnosticsArgs']]:
        """
        A `boot_diagnostics` block as referenced below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @boot_diagnostics.setter
    def boot_diagnostics(self, value: Optional[pulumi.Input['ScaleSetBootDiagnosticsArgs']]):
        pulumi.set(self, "boot_diagnostics", value)

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **NOTE:** `eviction_policy` can only be set when `priority` is set to `Low`.
        """
        return pulumi.get(self, "eviction_policy")

    @eviction_policy.setter
    def eviction_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eviction_policy", value)

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetExtensionArgs']]]]:
        """
        Can be specified multiple times to add extension profiles to the scale set. Each `extension` block supports the fields documented below.
        """
        return pulumi.get(self, "extensions")

    @extensions.setter
    def extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetExtensionArgs']]]]):
        pulumi.set(self, "extensions", value)

    @_builtins.property
    @pulumi.getter(name="healthProbeId")
    def health_probe_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`.
        """
        return pulumi.get(self, "health_probe_id")

    @health_probe_id.setter
    def health_probe_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "health_probe_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ScaleSetIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ScaleSetIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional, when a Windows machine) Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the virtual machine scale set resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkProfiles")
    def network_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetNetworkProfileArgs']]]]:
        """
        A collection of `network_profile` blocks as documented below.
        """
        return pulumi.get(self, "network_profiles")

    @network_profiles.setter
    def network_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetNetworkProfileArgs']]]]):
        pulumi.set(self, "network_profiles", value)

    @_builtins.property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> Optional[pulumi.Input['ScaleSetOsProfileArgs']]:
        """
        A `os_profile` block as documented below.
        """
        return pulumi.get(self, "os_profile")

    @os_profile.setter
    def os_profile(self, value: Optional[pulumi.Input['ScaleSetOsProfileArgs']]):
        pulumi.set(self, "os_profile", value)

    @_builtins.property
    @pulumi.getter(name="osProfileLinuxConfig")
    def os_profile_linux_config(self) -> Optional[pulumi.Input['ScaleSetOsProfileLinuxConfigArgs']]:
        """
        A `os_profile_linux_config` block as documented below.
        """
        return pulumi.get(self, "os_profile_linux_config")

    @os_profile_linux_config.setter
    def os_profile_linux_config(self, value: Optional[pulumi.Input['ScaleSetOsProfileLinuxConfigArgs']]):
        pulumi.set(self, "os_profile_linux_config", value)

    @_builtins.property
    @pulumi.getter(name="osProfileSecrets")
    def os_profile_secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetOsProfileSecretArgs']]]]:
        """
        A collection of `os_profile_secrets` blocks as documented below.
        """
        return pulumi.get(self, "os_profile_secrets")

    @os_profile_secrets.setter
    def os_profile_secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetOsProfileSecretArgs']]]]):
        pulumi.set(self, "os_profile_secrets", value)

    @_builtins.property
    @pulumi.getter(name="osProfileWindowsConfig")
    def os_profile_windows_config(self) -> Optional[pulumi.Input['ScaleSetOsProfileWindowsConfigArgs']]:
        """
        A `os_profile_windows_config` block as documented below.
        """
        return pulumi.get(self, "os_profile_windows_config")

    @os_profile_windows_config.setter
    def os_profile_windows_config(self, value: Optional[pulumi.Input['ScaleSetOsProfileWindowsConfigArgs']]):
        pulumi.set(self, "os_profile_windows_config", value)

    @_builtins.property
    @pulumi.getter
    def overprovision(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        """
        return pulumi.get(self, "overprovision")

    @overprovision.setter
    def overprovision(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "overprovision", value)

    @_builtins.property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input['ScaleSetPlanArgs']]:
        """
        A `plan` block as documented below.
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input['ScaleSetPlanArgs']]):
        pulumi.set(self, "plan", value)

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the priority for the Virtual Machines in the Scale Set. Possible values are `Low` and `Regular`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "priority", value)

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Proximity Placement Group to which this Virtual Machine should be assigned. Changing this forces a new resource to be created
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @proximity_placement_group_id.setter
    def proximity_placement_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proximity_placement_group_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the virtual machine scale set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> Optional[pulumi.Input['ScaleSetRollingUpgradePolicyArgs']]:
        """
        A `rolling_upgrade_policy` block as defined below. This is only applicable when the `upgrade_policy_mode` is `Rolling`.
        """
        return pulumi.get(self, "rolling_upgrade_policy")

    @rolling_upgrade_policy.setter
    def rolling_upgrade_policy(self, value: Optional[pulumi.Input['ScaleSetRollingUpgradePolicyArgs']]):
        pulumi.set(self, "rolling_upgrade_policy", value)

    @_builtins.property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Changing this forces a new resource to be created. See [documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-placement-groups) for more information. Defaults to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @single_placement_group.setter
    def single_placement_group(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "single_placement_group", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['ScaleSetSkuArgs']]:
        """
        A `sku` block as documented below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['ScaleSetSkuArgs']]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="storageProfileDataDisks")
    def storage_profile_data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetStorageProfileDataDiskArgs']]]]:
        """
        A `storage_profile_data_disk` block as documented below.
        """
        return pulumi.get(self, "storage_profile_data_disks")

    @storage_profile_data_disks.setter
    def storage_profile_data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScaleSetStorageProfileDataDiskArgs']]]]):
        pulumi.set(self, "storage_profile_data_disks", value)

    @_builtins.property
    @pulumi.getter(name="storageProfileImageReference")
    def storage_profile_image_reference(self) -> Optional[pulumi.Input['ScaleSetStorageProfileImageReferenceArgs']]:
        """
        A `storage_profile_image_reference` block as documented below.
        """
        return pulumi.get(self, "storage_profile_image_reference")

    @storage_profile_image_reference.setter
    def storage_profile_image_reference(self, value: Optional[pulumi.Input['ScaleSetStorageProfileImageReferenceArgs']]):
        pulumi.set(self, "storage_profile_image_reference", value)

    @_builtins.property
    @pulumi.getter(name="storageProfileOsDisk")
    def storage_profile_os_disk(self) -> Optional[pulumi.Input['ScaleSetStorageProfileOsDiskArgs']]:
        """
        A `storage_profile_os_disk` block as documented below.
        """
        return pulumi.get(self, "storage_profile_os_disk")

    @storage_profile_os_disk.setter
    def storage_profile_os_disk(self, value: Optional[pulumi.Input['ScaleSetStorageProfileOsDiskArgs']]):
        pulumi.set(self, "storage_profile_os_disk", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="upgradePolicyMode")
    def upgrade_policy_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing `Rolling`, you will need to set a health probe.
        """
        return pulumi.get(self, "upgrade_policy_mode")

    @upgrade_policy_mode.setter
    def upgrade_policy_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_policy_mode", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A collection of availability zones to spread the Virtual Machines over. Changing this forces a new resource to be created.

        > **NOTE:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:compute/scaleSet:ScaleSet")
class ScaleSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_os_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot_diagnostics: Optional[pulumi.Input[Union['ScaleSetBootDiagnosticsArgs', 'ScaleSetBootDiagnosticsArgsDict']]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetExtensionArgs', 'ScaleSetExtensionArgsDict']]]]] = None,
                 health_probe_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ScaleSetIdentityArgs', 'ScaleSetIdentityArgsDict']]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetNetworkProfileArgs', 'ScaleSetNetworkProfileArgsDict']]]]] = None,
                 os_profile: Optional[pulumi.Input[Union['ScaleSetOsProfileArgs', 'ScaleSetOsProfileArgsDict']]] = None,
                 os_profile_linux_config: Optional[pulumi.Input[Union['ScaleSetOsProfileLinuxConfigArgs', 'ScaleSetOsProfileLinuxConfigArgsDict']]] = None,
                 os_profile_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetOsProfileSecretArgs', 'ScaleSetOsProfileSecretArgsDict']]]]] = None,
                 os_profile_windows_config: Optional[pulumi.Input[Union['ScaleSetOsProfileWindowsConfigArgs', 'ScaleSetOsProfileWindowsConfigArgsDict']]] = None,
                 overprovision: Optional[pulumi.Input[_builtins.bool]] = None,
                 plan: Optional[pulumi.Input[Union['ScaleSetPlanArgs', 'ScaleSetPlanArgsDict']]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input[Union['ScaleSetRollingUpgradePolicyArgs', 'ScaleSetRollingUpgradePolicyArgsDict']]] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku: Optional[pulumi.Input[Union['ScaleSetSkuArgs', 'ScaleSetSkuArgsDict']]] = None,
                 storage_profile_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetStorageProfileDataDiskArgs', 'ScaleSetStorageProfileDataDiskArgsDict']]]]] = None,
                 storage_profile_image_reference: Optional[pulumi.Input[Union['ScaleSetStorageProfileImageReferenceArgs', 'ScaleSetStorageProfileImageReferenceArgsDict']]] = None,
                 storage_profile_os_disk: Optional[pulumi.Input[Union['ScaleSetStorageProfileOsDiskArgs', 'ScaleSetStorageProfileOsDiskArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_policy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a virtual machine scale set.

        ## Example Usage

        ### With Managed Disks (Recommended)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            domain_name_label=example.name,
            tags={
                "environment": "staging",
            })
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        bpepool = azure.lb.BackendAddressPool("bpepool",
            loadbalancer_id=example_load_balancer.id,
            name="BackEndAddressPool")
        lbnatpool = azure.lb.NatPool("lbnatpool",
            resource_group_name=example.name,
            name="ssh",
            loadbalancer_id=example_load_balancer.id,
            protocol="Tcp",
            frontend_port_start=50000,
            frontend_port_end=50119,
            backend_port=22,
            frontend_ip_configuration_name="PublicIPAddress")
        example_probe = azure.lb.Probe("example",
            loadbalancer_id=example_load_balancer.id,
            name="http-probe",
            protocol="Http",
            request_path="/health",
            port=8080)
        example_scale_set = azure.compute.ScaleSet("example",
            name="mytestscaleset-1",
            location=example.location,
            resource_group_name=example.name,
            automatic_os_upgrade=True,
            upgrade_policy_mode="Rolling",
            rolling_upgrade_policy={
                "max_batch_instance_percent": 20,
                "max_unhealthy_instance_percent": 20,
                "max_unhealthy_upgraded_instance_percent": 5,
                "pause_time_between_batches": "PT0S",
            },
            health_probe_id=example_probe.id,
            sku={
                "name": "Standard_F2",
                "tier": "Standard",
                "capacity": 2,
            },
            storage_profile_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            storage_profile_os_disk={
                "name": "",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "managed_disk_type": "Standard_LRS",
            },
            storage_profile_data_disks=[{
                "lun": 0,
                "caching": "ReadWrite",
                "create_option": "Empty",
                "disk_size_gb": 10,
            }],
            os_profile={
                "computer_name_prefix": "testvm",
                "admin_username": "myadmin",
            },
            os_profile_linux_config={
                "disable_password_authentication": True,
                "ssh_keys": [{
                    "path": "/home/myadmin/.ssh/authorized_keys",
                    "key_data": std.file(input="~/.ssh/demo_key.pub").result,
                }],
            },
            network_profiles=[{
                "name": "mynetworkprofile",
                "primary": True,
                "ip_configurations": [{
                    "name": "TestIPConfiguration",
                    "primary": True,
                    "subnet_id": example_subnet.id,
                    "load_balancer_backend_address_pool_ids": [bpepool.id],
                    "load_balancer_inbound_nat_rules_ids": [lbnatpool.id],
                }],
            }],
            tags={
                "environment": "staging",
            })
        ```

        ### With Unmanaged Disks

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_account = azure.storage.Account("example",
            name="accsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            tags={
                "environment": "staging",
            })
        example_container = azure.storage.Container("example",
            name="vhds",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_scale_set = azure.compute.ScaleSet("example",
            name="mytestscaleset-1",
            location=example.location,
            resource_group_name=example.name,
            upgrade_policy_mode="Manual",
            sku={
                "name": "Standard_F2",
                "tier": "Standard",
                "capacity": 2,
            },
            os_profile={
                "computer_name_prefix": "testvm",
                "admin_username": "myadmin",
            },
            os_profile_linux_config={
                "disable_password_authentication": True,
                "ssh_keys": [{
                    "path": "/home/myadmin/.ssh/authorized_keys",
                    "key_data": std.file(input="~/.ssh/demo_key.pub").result,
                }],
            },
            network_profiles=[{
                "name": "TestNetworkProfile",
                "primary": True,
                "ip_configurations": [{
                    "name": "TestIPConfiguration",
                    "primary": True,
                    "subnet_id": example_subnet.id,
                }],
            }],
            storage_profile_os_disk={
                "name": "osDiskProfile",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "vhd_containers": [pulumi.Output.all(
                    primary_blob_endpoint=example_account.primary_blob_endpoint,
                    name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}")
        ],
            },
            storage_profile_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        ```

        ## Example of storage_profile_image_reference with id

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.compute.Image("example", name="test")
        example_scale_set = azure.compute.ScaleSet("example",
            name="test",
            storage_profile_image_reference={
                "id": example.id,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2024-11-01

        ## Import

        Virtual Machine Scale Sets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/scaleSet:ScaleSet scaleset1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachineScaleSets/scaleset1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] automatic_os_upgrade: Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        :param pulumi.Input[Union['ScaleSetBootDiagnosticsArgs', 'ScaleSetBootDiagnosticsArgsDict']] boot_diagnostics: A `boot_diagnostics` block as referenced below.
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **NOTE:** `eviction_policy` can only be set when `priority` is set to `Low`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetExtensionArgs', 'ScaleSetExtensionArgsDict']]]] extensions: Can be specified multiple times to add extension profiles to the scale set. Each `extension` block supports the fields documented below.
        :param pulumi.Input[_builtins.str] health_probe_id: Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`.
        :param pulumi.Input[Union['ScaleSetIdentityArgs', 'ScaleSetIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: (Optional, when a Windows machine) Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the virtual machine scale set resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetNetworkProfileArgs', 'ScaleSetNetworkProfileArgsDict']]]] network_profiles: A collection of `network_profile` blocks as documented below.
        :param pulumi.Input[Union['ScaleSetOsProfileArgs', 'ScaleSetOsProfileArgsDict']] os_profile: A `os_profile` block as documented below.
        :param pulumi.Input[Union['ScaleSetOsProfileLinuxConfigArgs', 'ScaleSetOsProfileLinuxConfigArgsDict']] os_profile_linux_config: A `os_profile_linux_config` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetOsProfileSecretArgs', 'ScaleSetOsProfileSecretArgsDict']]]] os_profile_secrets: A collection of `os_profile_secrets` blocks as documented below.
        :param pulumi.Input[Union['ScaleSetOsProfileWindowsConfigArgs', 'ScaleSetOsProfileWindowsConfigArgsDict']] os_profile_windows_config: A `os_profile_windows_config` block as documented below.
        :param pulumi.Input[_builtins.bool] overprovision: Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        :param pulumi.Input[Union['ScaleSetPlanArgs', 'ScaleSetPlanArgsDict']] plan: A `plan` block as documented below.
        :param pulumi.Input[_builtins.str] priority: Specifies the priority for the Virtual Machines in the Scale Set. Possible values are `Low` and `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group to which this Virtual Machine should be assigned. Changing this forces a new resource to be created
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the virtual machine scale set. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ScaleSetRollingUpgradePolicyArgs', 'ScaleSetRollingUpgradePolicyArgsDict']] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is only applicable when the `upgrade_policy_mode` is `Rolling`.
        :param pulumi.Input[_builtins.bool] single_placement_group: Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Changing this forces a new resource to be created. See [documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-placement-groups) for more information. Defaults to `true`.
        :param pulumi.Input[Union['ScaleSetSkuArgs', 'ScaleSetSkuArgsDict']] sku: A `sku` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetStorageProfileDataDiskArgs', 'ScaleSetStorageProfileDataDiskArgsDict']]]] storage_profile_data_disks: A `storage_profile_data_disk` block as documented below.
        :param pulumi.Input[Union['ScaleSetStorageProfileImageReferenceArgs', 'ScaleSetStorageProfileImageReferenceArgsDict']] storage_profile_image_reference: A `storage_profile_image_reference` block as documented below.
        :param pulumi.Input[Union['ScaleSetStorageProfileOsDiskArgs', 'ScaleSetStorageProfileOsDiskArgsDict']] storage_profile_os_disk: A `storage_profile_os_disk` block as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] upgrade_policy_mode: Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing `Rolling`, you will need to set a health probe.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: A collection of availability zones to spread the Virtual Machines over. Changing this forces a new resource to be created.
               
               > **NOTE:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScaleSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a virtual machine scale set.

        ## Example Usage

        ### With Managed Disks (Recommended)

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            domain_name_label=example.name,
            tags={
                "environment": "staging",
            })
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="test",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        bpepool = azure.lb.BackendAddressPool("bpepool",
            loadbalancer_id=example_load_balancer.id,
            name="BackEndAddressPool")
        lbnatpool = azure.lb.NatPool("lbnatpool",
            resource_group_name=example.name,
            name="ssh",
            loadbalancer_id=example_load_balancer.id,
            protocol="Tcp",
            frontend_port_start=50000,
            frontend_port_end=50119,
            backend_port=22,
            frontend_ip_configuration_name="PublicIPAddress")
        example_probe = azure.lb.Probe("example",
            loadbalancer_id=example_load_balancer.id,
            name="http-probe",
            protocol="Http",
            request_path="/health",
            port=8080)
        example_scale_set = azure.compute.ScaleSet("example",
            name="mytestscaleset-1",
            location=example.location,
            resource_group_name=example.name,
            automatic_os_upgrade=True,
            upgrade_policy_mode="Rolling",
            rolling_upgrade_policy={
                "max_batch_instance_percent": 20,
                "max_unhealthy_instance_percent": 20,
                "max_unhealthy_upgraded_instance_percent": 5,
                "pause_time_between_batches": "PT0S",
            },
            health_probe_id=example_probe.id,
            sku={
                "name": "Standard_F2",
                "tier": "Standard",
                "capacity": 2,
            },
            storage_profile_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            storage_profile_os_disk={
                "name": "",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "managed_disk_type": "Standard_LRS",
            },
            storage_profile_data_disks=[{
                "lun": 0,
                "caching": "ReadWrite",
                "create_option": "Empty",
                "disk_size_gb": 10,
            }],
            os_profile={
                "computer_name_prefix": "testvm",
                "admin_username": "myadmin",
            },
            os_profile_linux_config={
                "disable_password_authentication": True,
                "ssh_keys": [{
                    "path": "/home/myadmin/.ssh/authorized_keys",
                    "key_data": std.file(input="~/.ssh/demo_key.pub").result,
                }],
            },
            network_profiles=[{
                "name": "mynetworkprofile",
                "primary": True,
                "ip_configurations": [{
                    "name": "TestIPConfiguration",
                    "primary": True,
                    "subnet_id": example_subnet.id,
                    "load_balancer_backend_address_pool_ids": [bpepool.id],
                    "load_balancer_inbound_nat_rules_ids": [lbnatpool.id],
                }],
            }],
            tags={
                "environment": "staging",
            })
        ```

        ### With Unmanaged Disks

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="acctvn",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="acctsub",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_account = azure.storage.Account("example",
            name="accsa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS",
            tags={
                "environment": "staging",
            })
        example_container = azure.storage.Container("example",
            name="vhds",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_scale_set = azure.compute.ScaleSet("example",
            name="mytestscaleset-1",
            location=example.location,
            resource_group_name=example.name,
            upgrade_policy_mode="Manual",
            sku={
                "name": "Standard_F2",
                "tier": "Standard",
                "capacity": 2,
            },
            os_profile={
                "computer_name_prefix": "testvm",
                "admin_username": "myadmin",
            },
            os_profile_linux_config={
                "disable_password_authentication": True,
                "ssh_keys": [{
                    "path": "/home/myadmin/.ssh/authorized_keys",
                    "key_data": std.file(input="~/.ssh/demo_key.pub").result,
                }],
            },
            network_profiles=[{
                "name": "TestNetworkProfile",
                "primary": True,
                "ip_configurations": [{
                    "name": "TestIPConfiguration",
                    "primary": True,
                    "subnet_id": example_subnet.id,
                }],
            }],
            storage_profile_os_disk={
                "name": "osDiskProfile",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "vhd_containers": [pulumi.Output.all(
                    primary_blob_endpoint=example_account.primary_blob_endpoint,
                    name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}")
        ],
            },
            storage_profile_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        ```

        ## Example of storage_profile_image_reference with id

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.compute.Image("example", name="test")
        example_scale_set = azure.compute.ScaleSet("example",
            name="test",
            storage_profile_image_reference={
                "id": example.id,
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute`: 2024-11-01

        ## Import

        Virtual Machine Scale Sets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/scaleSet:ScaleSet scaleset1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/virtualMachineScaleSets/scaleset1
        ```

        :param str resource_name: The name of the resource.
        :param ScaleSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScaleSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_os_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
                 boot_diagnostics: Optional[pulumi.Input[Union['ScaleSetBootDiagnosticsArgs', 'ScaleSetBootDiagnosticsArgsDict']]] = None,
                 eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetExtensionArgs', 'ScaleSetExtensionArgsDict']]]]] = None,
                 health_probe_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ScaleSetIdentityArgs', 'ScaleSetIdentityArgsDict']]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetNetworkProfileArgs', 'ScaleSetNetworkProfileArgsDict']]]]] = None,
                 os_profile: Optional[pulumi.Input[Union['ScaleSetOsProfileArgs', 'ScaleSetOsProfileArgsDict']]] = None,
                 os_profile_linux_config: Optional[pulumi.Input[Union['ScaleSetOsProfileLinuxConfigArgs', 'ScaleSetOsProfileLinuxConfigArgsDict']]] = None,
                 os_profile_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetOsProfileSecretArgs', 'ScaleSetOsProfileSecretArgsDict']]]]] = None,
                 os_profile_windows_config: Optional[pulumi.Input[Union['ScaleSetOsProfileWindowsConfigArgs', 'ScaleSetOsProfileWindowsConfigArgsDict']]] = None,
                 overprovision: Optional[pulumi.Input[_builtins.bool]] = None,
                 plan: Optional[pulumi.Input[Union['ScaleSetPlanArgs', 'ScaleSetPlanArgsDict']]] = None,
                 priority: Optional[pulumi.Input[_builtins.str]] = None,
                 proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rolling_upgrade_policy: Optional[pulumi.Input[Union['ScaleSetRollingUpgradePolicyArgs', 'ScaleSetRollingUpgradePolicyArgsDict']]] = None,
                 single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
                 sku: Optional[pulumi.Input[Union['ScaleSetSkuArgs', 'ScaleSetSkuArgsDict']]] = None,
                 storage_profile_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetStorageProfileDataDiskArgs', 'ScaleSetStorageProfileDataDiskArgsDict']]]]] = None,
                 storage_profile_image_reference: Optional[pulumi.Input[Union['ScaleSetStorageProfileImageReferenceArgs', 'ScaleSetStorageProfileImageReferenceArgsDict']]] = None,
                 storage_profile_os_disk: Optional[pulumi.Input[Union['ScaleSetStorageProfileOsDiskArgs', 'ScaleSetStorageProfileOsDiskArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_policy_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScaleSetArgs.__new__(ScaleSetArgs)

            __props__.__dict__["automatic_os_upgrade"] = automatic_os_upgrade
            __props__.__dict__["boot_diagnostics"] = boot_diagnostics
            __props__.__dict__["eviction_policy"] = eviction_policy
            __props__.__dict__["extensions"] = extensions
            __props__.__dict__["health_probe_id"] = health_probe_id
            __props__.__dict__["identity"] = identity
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if network_profiles is None and not opts.urn:
                raise TypeError("Missing required property 'network_profiles'")
            __props__.__dict__["network_profiles"] = network_profiles
            if os_profile is None and not opts.urn:
                raise TypeError("Missing required property 'os_profile'")
            __props__.__dict__["os_profile"] = os_profile
            __props__.__dict__["os_profile_linux_config"] = os_profile_linux_config
            __props__.__dict__["os_profile_secrets"] = os_profile_secrets
            __props__.__dict__["os_profile_windows_config"] = os_profile_windows_config
            __props__.__dict__["overprovision"] = overprovision
            __props__.__dict__["plan"] = plan
            __props__.__dict__["priority"] = priority
            __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["rolling_upgrade_policy"] = rolling_upgrade_policy
            __props__.__dict__["single_placement_group"] = single_placement_group
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["storage_profile_data_disks"] = storage_profile_data_disks
            __props__.__dict__["storage_profile_image_reference"] = storage_profile_image_reference
            if storage_profile_os_disk is None and not opts.urn:
                raise TypeError("Missing required property 'storage_profile_os_disk'")
            __props__.__dict__["storage_profile_os_disk"] = storage_profile_os_disk
            __props__.__dict__["tags"] = tags
            if upgrade_policy_mode is None and not opts.urn:
                raise TypeError("Missing required property 'upgrade_policy_mode'")
            __props__.__dict__["upgrade_policy_mode"] = upgrade_policy_mode
            __props__.__dict__["zones"] = zones
        super(ScaleSet, __self__).__init__(
            'azure:compute/scaleSet:ScaleSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automatic_os_upgrade: Optional[pulumi.Input[_builtins.bool]] = None,
            boot_diagnostics: Optional[pulumi.Input[Union['ScaleSetBootDiagnosticsArgs', 'ScaleSetBootDiagnosticsArgsDict']]] = None,
            eviction_policy: Optional[pulumi.Input[_builtins.str]] = None,
            extensions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetExtensionArgs', 'ScaleSetExtensionArgsDict']]]]] = None,
            health_probe_id: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ScaleSetIdentityArgs', 'ScaleSetIdentityArgsDict']]] = None,
            license_type: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetNetworkProfileArgs', 'ScaleSetNetworkProfileArgsDict']]]]] = None,
            os_profile: Optional[pulumi.Input[Union['ScaleSetOsProfileArgs', 'ScaleSetOsProfileArgsDict']]] = None,
            os_profile_linux_config: Optional[pulumi.Input[Union['ScaleSetOsProfileLinuxConfigArgs', 'ScaleSetOsProfileLinuxConfigArgsDict']]] = None,
            os_profile_secrets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetOsProfileSecretArgs', 'ScaleSetOsProfileSecretArgsDict']]]]] = None,
            os_profile_windows_config: Optional[pulumi.Input[Union['ScaleSetOsProfileWindowsConfigArgs', 'ScaleSetOsProfileWindowsConfigArgsDict']]] = None,
            overprovision: Optional[pulumi.Input[_builtins.bool]] = None,
            plan: Optional[pulumi.Input[Union['ScaleSetPlanArgs', 'ScaleSetPlanArgsDict']]] = None,
            priority: Optional[pulumi.Input[_builtins.str]] = None,
            proximity_placement_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            rolling_upgrade_policy: Optional[pulumi.Input[Union['ScaleSetRollingUpgradePolicyArgs', 'ScaleSetRollingUpgradePolicyArgsDict']]] = None,
            single_placement_group: Optional[pulumi.Input[_builtins.bool]] = None,
            sku: Optional[pulumi.Input[Union['ScaleSetSkuArgs', 'ScaleSetSkuArgsDict']]] = None,
            storage_profile_data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetStorageProfileDataDiskArgs', 'ScaleSetStorageProfileDataDiskArgsDict']]]]] = None,
            storage_profile_image_reference: Optional[pulumi.Input[Union['ScaleSetStorageProfileImageReferenceArgs', 'ScaleSetStorageProfileImageReferenceArgsDict']]] = None,
            storage_profile_os_disk: Optional[pulumi.Input[Union['ScaleSetStorageProfileOsDiskArgs', 'ScaleSetStorageProfileOsDiskArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            upgrade_policy_mode: Optional[pulumi.Input[_builtins.str]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ScaleSet':
        """
        Get an existing ScaleSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] automatic_os_upgrade: Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        :param pulumi.Input[Union['ScaleSetBootDiagnosticsArgs', 'ScaleSetBootDiagnosticsArgsDict']] boot_diagnostics: A `boot_diagnostics` block as referenced below.
        :param pulumi.Input[_builtins.str] eviction_policy: Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.
               
               > **NOTE:** `eviction_policy` can only be set when `priority` is set to `Low`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetExtensionArgs', 'ScaleSetExtensionArgsDict']]]] extensions: Can be specified multiple times to add extension profiles to the scale set. Each `extension` block supports the fields documented below.
        :param pulumi.Input[_builtins.str] health_probe_id: Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`.
        :param pulumi.Input[Union['ScaleSetIdentityArgs', 'ScaleSetIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: (Optional, when a Windows machine) Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the virtual machine scale set resource. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetNetworkProfileArgs', 'ScaleSetNetworkProfileArgsDict']]]] network_profiles: A collection of `network_profile` blocks as documented below.
        :param pulumi.Input[Union['ScaleSetOsProfileArgs', 'ScaleSetOsProfileArgsDict']] os_profile: A `os_profile` block as documented below.
        :param pulumi.Input[Union['ScaleSetOsProfileLinuxConfigArgs', 'ScaleSetOsProfileLinuxConfigArgsDict']] os_profile_linux_config: A `os_profile_linux_config` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetOsProfileSecretArgs', 'ScaleSetOsProfileSecretArgsDict']]]] os_profile_secrets: A collection of `os_profile_secrets` blocks as documented below.
        :param pulumi.Input[Union['ScaleSetOsProfileWindowsConfigArgs', 'ScaleSetOsProfileWindowsConfigArgsDict']] os_profile_windows_config: A `os_profile_windows_config` block as documented below.
        :param pulumi.Input[_builtins.bool] overprovision: Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        :param pulumi.Input[Union['ScaleSetPlanArgs', 'ScaleSetPlanArgsDict']] plan: A `plan` block as documented below.
        :param pulumi.Input[_builtins.str] priority: Specifies the priority for the Virtual Machines in the Scale Set. Possible values are `Low` and `Regular`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] proximity_placement_group_id: The ID of the Proximity Placement Group to which this Virtual Machine should be assigned. Changing this forces a new resource to be created
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the virtual machine scale set. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ScaleSetRollingUpgradePolicyArgs', 'ScaleSetRollingUpgradePolicyArgsDict']] rolling_upgrade_policy: A `rolling_upgrade_policy` block as defined below. This is only applicable when the `upgrade_policy_mode` is `Rolling`.
        :param pulumi.Input[_builtins.bool] single_placement_group: Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Changing this forces a new resource to be created. See [documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-placement-groups) for more information. Defaults to `true`.
        :param pulumi.Input[Union['ScaleSetSkuArgs', 'ScaleSetSkuArgsDict']] sku: A `sku` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ScaleSetStorageProfileDataDiskArgs', 'ScaleSetStorageProfileDataDiskArgsDict']]]] storage_profile_data_disks: A `storage_profile_data_disk` block as documented below.
        :param pulumi.Input[Union['ScaleSetStorageProfileImageReferenceArgs', 'ScaleSetStorageProfileImageReferenceArgsDict']] storage_profile_image_reference: A `storage_profile_image_reference` block as documented below.
        :param pulumi.Input[Union['ScaleSetStorageProfileOsDiskArgs', 'ScaleSetStorageProfileOsDiskArgsDict']] storage_profile_os_disk: A `storage_profile_os_disk` block as documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] upgrade_policy_mode: Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing `Rolling`, you will need to set a health probe.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: A collection of availability zones to spread the Virtual Machines over. Changing this forces a new resource to be created.
               
               > **NOTE:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScaleSetState.__new__(_ScaleSetState)

        __props__.__dict__["automatic_os_upgrade"] = automatic_os_upgrade
        __props__.__dict__["boot_diagnostics"] = boot_diagnostics
        __props__.__dict__["eviction_policy"] = eviction_policy
        __props__.__dict__["extensions"] = extensions
        __props__.__dict__["health_probe_id"] = health_probe_id
        __props__.__dict__["identity"] = identity
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_profiles"] = network_profiles
        __props__.__dict__["os_profile"] = os_profile
        __props__.__dict__["os_profile_linux_config"] = os_profile_linux_config
        __props__.__dict__["os_profile_secrets"] = os_profile_secrets
        __props__.__dict__["os_profile_windows_config"] = os_profile_windows_config
        __props__.__dict__["overprovision"] = overprovision
        __props__.__dict__["plan"] = plan
        __props__.__dict__["priority"] = priority
        __props__.__dict__["proximity_placement_group_id"] = proximity_placement_group_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["rolling_upgrade_policy"] = rolling_upgrade_policy
        __props__.__dict__["single_placement_group"] = single_placement_group
        __props__.__dict__["sku"] = sku
        __props__.__dict__["storage_profile_data_disks"] = storage_profile_data_disks
        __props__.__dict__["storage_profile_image_reference"] = storage_profile_image_reference
        __props__.__dict__["storage_profile_os_disk"] = storage_profile_os_disk
        __props__.__dict__["tags"] = tags
        __props__.__dict__["upgrade_policy_mode"] = upgrade_policy_mode
        __props__.__dict__["zones"] = zones
        return ScaleSet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automaticOsUpgrade")
    def automatic_os_upgrade(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Automatic OS patches can be applied by Azure to your scaleset. This is particularly useful when `upgrade_policy_mode` is set to `Rolling`. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_os_upgrade")

    @_builtins.property
    @pulumi.getter(name="bootDiagnostics")
    def boot_diagnostics(self) -> pulumi.Output[Optional['outputs.ScaleSetBootDiagnostics']]:
        """
        A `boot_diagnostics` block as referenced below.
        """
        return pulumi.get(self, "boot_diagnostics")

    @_builtins.property
    @pulumi.getter(name="evictionPolicy")
    def eviction_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the eviction policy for Virtual Machines in this Scale Set. Possible values are `Deallocate` and `Delete`. Changing this forces a new resource to be created.

        > **NOTE:** `eviction_policy` can only be set when `priority` is set to `Low`.
        """
        return pulumi.get(self, "eviction_policy")

    @_builtins.property
    @pulumi.getter
    def extensions(self) -> pulumi.Output[Optional[Sequence['outputs.ScaleSetExtension']]]:
        """
        Can be specified multiple times to add extension profiles to the scale set. Each `extension` block supports the fields documented below.
        """
        return pulumi.get(self, "extensions")

    @_builtins.property
    @pulumi.getter(name="healthProbeId")
    def health_probe_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the identifier for the load balancer health probe. Required when using `Rolling` as your `upgrade_policy_mode`.
        """
        return pulumi.get(self, "health_probe_id")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ScaleSetIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[_builtins.str]:
        """
        (Optional, when a Windows machine) Specifies the Windows OS license type. If supplied, the only allowed values are `Windows_Client` and `Windows_Server`.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the virtual machine scale set resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkProfiles")
    def network_profiles(self) -> pulumi.Output[Sequence['outputs.ScaleSetNetworkProfile']]:
        """
        A collection of `network_profile` blocks as documented below.
        """
        return pulumi.get(self, "network_profiles")

    @_builtins.property
    @pulumi.getter(name="osProfile")
    def os_profile(self) -> pulumi.Output['outputs.ScaleSetOsProfile']:
        """
        A `os_profile` block as documented below.
        """
        return pulumi.get(self, "os_profile")

    @_builtins.property
    @pulumi.getter(name="osProfileLinuxConfig")
    def os_profile_linux_config(self) -> pulumi.Output['outputs.ScaleSetOsProfileLinuxConfig']:
        """
        A `os_profile_linux_config` block as documented below.
        """
        return pulumi.get(self, "os_profile_linux_config")

    @_builtins.property
    @pulumi.getter(name="osProfileSecrets")
    def os_profile_secrets(self) -> pulumi.Output[Optional[Sequence['outputs.ScaleSetOsProfileSecret']]]:
        """
        A collection of `os_profile_secrets` blocks as documented below.
        """
        return pulumi.get(self, "os_profile_secrets")

    @_builtins.property
    @pulumi.getter(name="osProfileWindowsConfig")
    def os_profile_windows_config(self) -> pulumi.Output[Optional['outputs.ScaleSetOsProfileWindowsConfig']]:
        """
        A `os_profile_windows_config` block as documented below.
        """
        return pulumi.get(self, "os_profile_windows_config")

    @_builtins.property
    @pulumi.getter
    def overprovision(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the virtual machine scale set should be overprovisioned. Defaults to `true`.
        """
        return pulumi.get(self, "overprovision")

    @_builtins.property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional['outputs.ScaleSetPlan']]:
        """
        A `plan` block as documented below.
        """
        return pulumi.get(self, "plan")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the priority for the Virtual Machines in the Scale Set. Possible values are `Low` and `Regular`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="proximityPlacementGroupId")
    def proximity_placement_group_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Proximity Placement Group to which this Virtual Machine should be assigned. Changing this forces a new resource to be created
        """
        return pulumi.get(self, "proximity_placement_group_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the virtual machine scale set. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="rollingUpgradePolicy")
    def rolling_upgrade_policy(self) -> pulumi.Output[Optional['outputs.ScaleSetRollingUpgradePolicy']]:
        """
        A `rolling_upgrade_policy` block as defined below. This is only applicable when the `upgrade_policy_mode` is `Rolling`.
        """
        return pulumi.get(self, "rolling_upgrade_policy")

    @_builtins.property
    @pulumi.getter(name="singlePlacementGroup")
    def single_placement_group(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the scale set is limited to a single placement group with a maximum size of 100 virtual machines. If set to false, managed disks must be used. Changing this forces a new resource to be created. See [documentation](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-placement-groups) for more information. Defaults to `true`.
        """
        return pulumi.get(self, "single_placement_group")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.ScaleSetSku']:
        """
        A `sku` block as documented below.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="storageProfileDataDisks")
    def storage_profile_data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.ScaleSetStorageProfileDataDisk']]]:
        """
        A `storage_profile_data_disk` block as documented below.
        """
        return pulumi.get(self, "storage_profile_data_disks")

    @_builtins.property
    @pulumi.getter(name="storageProfileImageReference")
    def storage_profile_image_reference(self) -> pulumi.Output['outputs.ScaleSetStorageProfileImageReference']:
        """
        A `storage_profile_image_reference` block as documented below.
        """
        return pulumi.get(self, "storage_profile_image_reference")

    @_builtins.property
    @pulumi.getter(name="storageProfileOsDisk")
    def storage_profile_os_disk(self) -> pulumi.Output['outputs.ScaleSetStorageProfileOsDisk']:
        """
        A `storage_profile_os_disk` block as documented below.
        """
        return pulumi.get(self, "storage_profile_os_disk")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="upgradePolicyMode")
    def upgrade_policy_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the mode of an upgrade to virtual machines in the scale set. Possible values, `Rolling`, `Manual`, or `Automatic`. When choosing `Rolling`, you will need to set a health probe.
        """
        return pulumi.get(self, "upgrade_policy_mode")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A collection of availability zones to spread the Virtual Machines over. Changing this forces a new resource to be created.

        > **NOTE:** Availability Zones are [only supported in several regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zones")

