# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegistryScopeMapArgs', 'RegistryScopeMap']

@pulumi.input_type
class RegistryScopeMapArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 container_registry_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RegistryScopeMap resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: A list of actions to attach to the scope map (e.g. `repo/content/read`, `repo2/content/delete`).
        :param pulumi.Input[_builtins.str] container_registry_name: The name of the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description of the Container Registry.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the scope map. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "container_registry_name", container_registry_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of actions to attach to the scope map (e.g. `repo/content/read`, `repo2/content/delete`).
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistryName")
    def container_registry_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Container Registry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_registry_name")

    @container_registry_name.setter
    def container_registry_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_registry_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Container Registry.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the scope map. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _RegistryScopeMapState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 container_registry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegistryScopeMap resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: A list of actions to attach to the scope map (e.g. `repo/content/read`, `repo2/content/delete`).
        :param pulumi.Input[_builtins.str] container_registry_name: The name of the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description of the Container Registry.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the scope map. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if container_registry_name is not None:
            pulumi.set(__self__, "container_registry_name", container_registry_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of actions to attach to the scope map (e.g. `repo/content/read`, `repo2/content/delete`).
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistryName")
    def container_registry_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Container Registry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_registry_name")

    @container_registry_name.setter
    def container_registry_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_registry_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Container Registry.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the scope map. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:containerservice/registryScopeMap:RegistryScopeMap")
class RegistryScopeMap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 container_registry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Container Registry scope map.  For more information on scope maps see the [product documentation](https://learn.microsoft.com/en-us/azure/container-registry/container-registry-repository-scoped-permissions).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="exampleregistry",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic",
            admin_enabled=False,
            georeplications=[
                {
                    "location": "East US",
                },
                {
                    "location": "West Europe",
                },
            ])
        example_registry_scope_map = azure.containerservice.RegistryScopeMap("example",
            name="example-scope-map",
            container_registry_name=example_registry.name,
            resource_group_name=example.name,
            actions=[
                "repositories/repo1/content/read",
                "repositories/repo1/content/write",
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry`: 2023-11-01-preview

        ## Import

        Container Registries can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registryScopeMap:RegistryScopeMap example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ContainerRegistry/registries/myregistry1/scopeMaps/scopemap1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: A list of actions to attach to the scope map (e.g. `repo/content/read`, `repo2/content/delete`).
        :param pulumi.Input[_builtins.str] container_registry_name: The name of the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description of the Container Registry.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the scope map. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryScopeMapArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Container Registry scope map.  For more information on scope maps see the [product documentation](https://learn.microsoft.com/en-us/azure/container-registry/container-registry-repository-scoped-permissions).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource-group",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="exampleregistry",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic",
            admin_enabled=False,
            georeplications=[
                {
                    "location": "East US",
                },
                {
                    "location": "West Europe",
                },
            ])
        example_registry_scope_map = azure.containerservice.RegistryScopeMap("example",
            name="example-scope-map",
            container_registry_name=example_registry.name,
            resource_group_name=example.name,
            actions=[
                "repositories/repo1/content/read",
                "repositories/repo1/content/write",
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry`: 2023-11-01-preview

        ## Import

        Container Registries can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/registryScopeMap:RegistryScopeMap example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ContainerRegistry/registries/myregistry1/scopeMaps/scopemap1
        ```

        :param str resource_name: The name of the resource.
        :param RegistryScopeMapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryScopeMapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 container_registry_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryScopeMapArgs.__new__(RegistryScopeMapArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            if container_registry_name is None and not opts.urn:
                raise TypeError("Missing required property 'container_registry_name'")
            __props__.__dict__["container_registry_name"] = container_registry_name
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        super(RegistryScopeMap, __self__).__init__(
            'azure:containerservice/registryScopeMap:RegistryScopeMap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            container_registry_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegistryScopeMap':
        """
        Get an existing RegistryScopeMap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] actions: A list of actions to attach to the scope map (e.g. `repo/content/read`, `repo2/content/delete`).
        :param pulumi.Input[_builtins.str] container_registry_name: The name of the Container Registry. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description of the Container Registry.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the scope map. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryScopeMapState.__new__(_RegistryScopeMapState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["container_registry_name"] = container_registry_name
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        return RegistryScopeMap(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of actions to attach to the scope map (e.g. `repo/content/read`, `repo2/content/delete`).
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="containerRegistryName")
    def container_registry_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Container Registry. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_registry_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Container Registry.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the scope map. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Container Registry token. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

