# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RegistryTaskScheduleRunNowArgs', 'RegistryTaskScheduleRunNow']

@pulumi.input_type
class RegistryTaskScheduleRunNowArgs:
    def __init__(__self__, *,
                 container_registry_task_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a RegistryTaskScheduleRunNow resource.
        :param pulumi.Input[_builtins.str] container_registry_task_id: The ID of the Container Registry Task that to be scheduled. Changing this forces a new Container Registry Task Schedule to be created.
        """
        pulumi.set(__self__, "container_registry_task_id", container_registry_task_id)

    @_builtins.property
    @pulumi.getter(name="containerRegistryTaskId")
    def container_registry_task_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Container Registry Task that to be scheduled. Changing this forces a new Container Registry Task Schedule to be created.
        """
        return pulumi.get(self, "container_registry_task_id")

    @container_registry_task_id.setter
    def container_registry_task_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_registry_task_id", value)


@pulumi.input_type
class _RegistryTaskScheduleRunNowState:
    def __init__(__self__, *,
                 container_registry_task_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RegistryTaskScheduleRunNow resources.
        :param pulumi.Input[_builtins.str] container_registry_task_id: The ID of the Container Registry Task that to be scheduled. Changing this forces a new Container Registry Task Schedule to be created.
        """
        if container_registry_task_id is not None:
            pulumi.set(__self__, "container_registry_task_id", container_registry_task_id)

    @_builtins.property
    @pulumi.getter(name="containerRegistryTaskId")
    def container_registry_task_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Container Registry Task that to be scheduled. Changing this forces a new Container Registry Task Schedule to be created.
        """
        return pulumi.get(self, "container_registry_task_id")

    @container_registry_task_id.setter
    def container_registry_task_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_registry_task_id", value)


@pulumi.type_token("azure:containerservice/registryTaskScheduleRunNow:RegistryTaskScheduleRunNow")
class RegistryTaskScheduleRunNow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_registry_task_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Runs a Container Registry Task Schedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="example-acr",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        example_registry_task = azure.containerservice.RegistryTask("example",
            name="example-task",
            container_registry_id=example_registry.id,
            platform={
                "os": "Linux",
            },
            docker_step={
                "dockerfile_path": "Dockerfile",
                "context_path": "https://github.com/<user name>/acr-build-helloworld-node#main",
                "context_access_token": "<github personal access token>",
                "image_names": ["helloworld:{{.Run.ID}}"],
            })
        example_registry_task_schedule_run_now = azure.containerservice.RegistryTaskScheduleRunNow("example", container_registry_task_id=example_registry_task.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry`: 2019-06-01-preview

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] container_registry_task_id: The ID of the Container Registry Task that to be scheduled. Changing this forces a new Container Registry Task Schedule to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistryTaskScheduleRunNowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Runs a Container Registry Task Schedule.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_registry = azure.containerservice.Registry("example",
            name="example-acr",
            resource_group_name=example.name,
            location=example.location,
            sku="Basic")
        example_registry_task = azure.containerservice.RegistryTask("example",
            name="example-task",
            container_registry_id=example_registry.id,
            platform={
                "os": "Linux",
            },
            docker_step={
                "dockerfile_path": "Dockerfile",
                "context_path": "https://github.com/<user name>/acr-build-helloworld-node#main",
                "context_access_token": "<github personal access token>",
                "image_names": ["helloworld:{{.Run.ID}}"],
            })
        example_registry_task_schedule_run_now = azure.containerservice.RegistryTaskScheduleRunNow("example", container_registry_task_id=example_registry_task.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ContainerRegistry`: 2019-06-01-preview

        :param str resource_name: The name of the resource.
        :param RegistryTaskScheduleRunNowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistryTaskScheduleRunNowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_registry_task_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistryTaskScheduleRunNowArgs.__new__(RegistryTaskScheduleRunNowArgs)

            if container_registry_task_id is None and not opts.urn:
                raise TypeError("Missing required property 'container_registry_task_id'")
            __props__.__dict__["container_registry_task_id"] = container_registry_task_id
        super(RegistryTaskScheduleRunNow, __self__).__init__(
            'azure:containerservice/registryTaskScheduleRunNow:RegistryTaskScheduleRunNow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container_registry_task_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RegistryTaskScheduleRunNow':
        """
        Get an existing RegistryTaskScheduleRunNow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] container_registry_task_id: The ID of the Container Registry Task that to be scheduled. Changing this forces a new Container Registry Task Schedule to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistryTaskScheduleRunNowState.__new__(_RegistryTaskScheduleRunNowState)

        __props__.__dict__["container_registry_task_id"] = container_registry_task_id
        return RegistryTaskScheduleRunNow(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="containerRegistryTaskId")
    def container_registry_task_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Container Registry Task that to be scheduled. Changing this forces a new Container Registry Task Schedule to be created.
        """
        return pulumi.get(self, "container_registry_task_id")

