# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetSqlDatabaseResult',
    'AwaitableGetSqlDatabaseResult',
    'get_sql_database',
    'get_sql_database_output',
]

@pulumi.output_type
class GetSqlDatabaseResult:
    """
    A collection of values returned by getSqlDatabase.
    """
    def __init__(__self__, account_name=None, autoscale_settings=None, id=None, name=None, resource_group_name=None, throughput=None):
        if account_name and not isinstance(account_name, str):
            raise TypeError("Expected argument 'account_name' to be a str")
        pulumi.set(__self__, "account_name", account_name)
        if autoscale_settings and not isinstance(autoscale_settings, list):
            raise TypeError("Expected argument 'autoscale_settings' to be a list")
        pulumi.set(__self__, "autoscale_settings", autoscale_settings)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if throughput and not isinstance(throughput, int):
            raise TypeError("Expected argument 'throughput' to be a int")
        pulumi.set(__self__, "throughput", throughput)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> _builtins.str:
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter(name="autoscaleSettings")
    def autoscale_settings(self) -> Sequence['outputs.GetSqlDatabaseAutoscaleSettingResult']:
        """
        An `autoscale_settings` block as defined below.
        """
        return pulumi.get(self, "autoscale_settings")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> _builtins.int:
        """
        The throughput of SQL database (RU/s).
        """
        return pulumi.get(self, "throughput")


class AwaitableGetSqlDatabaseResult(GetSqlDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlDatabaseResult(
            account_name=self.account_name,
            autoscale_settings=self.autoscale_settings,
            id=self.id,
            name=self.name,
            resource_group_name=self.resource_group_name,
            throughput=self.throughput)


def get_sql_database(account_name: Optional[_builtins.str] = None,
                     name: Optional[_builtins.str] = None,
                     resource_group_name: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlDatabaseResult:
    """
    Use this data source to access information about an existing CosmosDB SQL Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cosmosdb.get_sql_database(name="tfex-cosmosdb-sql-database",
        resource_group_name="tfex-cosmosdb-sql-database-rg",
        account_name="tfex-cosmosdb-sql-database-account-name")
    ```


    :param _builtins.str account_name: The name of the Cosmos DB SQL Database to create the table within.
    :param _builtins.str name: Specifies the name of the Cosmos DB SQL Database.
    :param _builtins.str resource_group_name: The name of the resource group in which the Cosmos DB SQL Database is created.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:cosmosdb/getSqlDatabase:getSqlDatabase', __args__, opts=opts, typ=GetSqlDatabaseResult).value

    return AwaitableGetSqlDatabaseResult(
        account_name=pulumi.get(__ret__, 'account_name'),
        autoscale_settings=pulumi.get(__ret__, 'autoscale_settings'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        throughput=pulumi.get(__ret__, 'throughput'))
def get_sql_database_output(account_name: Optional[pulumi.Input[_builtins.str]] = None,
                            name: Optional[pulumi.Input[_builtins.str]] = None,
                            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSqlDatabaseResult]:
    """
    Use this data source to access information about an existing CosmosDB SQL Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.cosmosdb.get_sql_database(name="tfex-cosmosdb-sql-database",
        resource_group_name="tfex-cosmosdb-sql-database-rg",
        account_name="tfex-cosmosdb-sql-database-account-name")
    ```


    :param _builtins.str account_name: The name of the Cosmos DB SQL Database to create the table within.
    :param _builtins.str name: Specifies the name of the Cosmos DB SQL Database.
    :param _builtins.str resource_group_name: The name of the resource group in which the Cosmos DB SQL Database is created.
    """
    __args__ = dict()
    __args__['accountName'] = account_name
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:cosmosdb/getSqlDatabase:getSqlDatabase', __args__, opts=opts, typ=GetSqlDatabaseResult)
    return __ret__.apply(lambda __response__: GetSqlDatabaseResult(
        account_name=pulumi.get(__response__, 'account_name'),
        autoscale_settings=pulumi.get(__response__, 'autoscale_settings'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        throughput=pulumi.get(__response__, 'throughput')))
