# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CredentialServicePrincipalArgs', 'CredentialServicePrincipal']

@pulumi.input_type
class CredentialServicePrincipalArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[_builtins.str],
                 service_principal_id: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str],
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input['CredentialServicePrincipalServicePrincipalKeyArgs']] = None):
        """
        The set of arguments for constructing a CredentialServicePrincipal resource.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Credential with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] service_principal_id: The Client ID of the Service Principal.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID of the Service Principal.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Credential.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Credential.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Credential. Changing this forces a new resource to be created.
        :param pulumi.Input['CredentialServicePrincipalServicePrincipalKeyArgs'] service_principal_key: A `service_principal_key` block as defined below.
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        pulumi.set(__self__, "service_principal_id", service_principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Data Factory ID in which to associate the Credential with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Client ID of the Service Principal.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Tenant ID of the Service Principal.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Credential.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Credential.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Credential. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input['CredentialServicePrincipalServicePrincipalKeyArgs']]:
        """
        A `service_principal_key` block as defined below.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input['CredentialServicePrincipalServicePrincipalKeyArgs']]):
        pulumi.set(self, "service_principal_key", value)


@pulumi.input_type
class _CredentialServicePrincipalState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input['CredentialServicePrincipalServicePrincipalKeyArgs']] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CredentialServicePrincipal resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Credential.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Credential with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Credential.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Credential. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_principal_id: The Client ID of the Service Principal.
        :param pulumi.Input['CredentialServicePrincipalServicePrincipalKeyArgs'] service_principal_key: A `service_principal_key` block as defined below.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID of the Service Principal.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Credential.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Factory ID in which to associate the Credential with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Credential.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Credential. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the Service Principal.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input['CredentialServicePrincipalServicePrincipalKeyArgs']]:
        """
        A `service_principal_key` block as defined below.
        """
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input['CredentialServicePrincipalServicePrincipalKeyArgs']]):
        pulumi.set(self, "service_principal_key", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID of the Service Principal.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("azure:datafactory/credentialServicePrincipal:CredentialServicePrincipal")
class CredentialServicePrincipal(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[Union['CredentialServicePrincipalServicePrincipalKeyArgs', 'CredentialServicePrincipalServicePrincipalKeyArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage a Data Factory Service Principal credential resource. These resources are used by Data Factory to access data sources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="westeurope")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "key_permissions": [
                    "Create",
                    "Get",
                ],
                "secret_permissions": [
                    "Set",
                    "Get",
                    "Delete",
                    "Purge",
                    "Recover",
                ],
            }])
        example_secret = azure.keyvault.Secret("example",
            name="example",
            value="example-secret",
            key_vault_id=example_key_vault.id)
        example_linked_service_key_vault = azure.datafactory.LinkedServiceKeyVault("example",
            name="example",
            data_factory_id=example_factory.id,
            key_vault_id=example_key_vault.id)
        example_credential_service_principal = azure.datafactory.CredentialServicePrincipal("example",
            name="example",
            description="example description",
            data_factory_id=example_factory.id,
            tenant_id=current.tenant_id,
            service_principal_id=current.client_id,
            service_principal_key={
                "linked_service_name": example_linked_service_key_vault.name,
                "secret_name": example_secret.name,
                "secret_version": example_secret.version,
            },
            annotations=[
                "1",
                "2",
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataFactory`: 2018-06-01

        ## Import

        Data Factory Credentials can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/credentialServicePrincipal:CredentialServicePrincipal example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.DataFactory/factories/example/credentials/credential1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Credential.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Credential with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Credential.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Credential. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_principal_id: The Client ID of the Service Principal.
        :param pulumi.Input[Union['CredentialServicePrincipalServicePrincipalKeyArgs', 'CredentialServicePrincipalServicePrincipalKeyArgsDict']] service_principal_key: A `service_principal_key` block as defined below.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID of the Service Principal.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CredentialServicePrincipalArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a Data Factory Service Principal credential resource. These resources are used by Data Factory to access data sources.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="westeurope")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            soft_delete_retention_days=7,
            access_policies=[{
                "tenant_id": current.tenant_id,
                "object_id": current.object_id,
                "key_permissions": [
                    "Create",
                    "Get",
                ],
                "secret_permissions": [
                    "Set",
                    "Get",
                    "Delete",
                    "Purge",
                    "Recover",
                ],
            }])
        example_secret = azure.keyvault.Secret("example",
            name="example",
            value="example-secret",
            key_vault_id=example_key_vault.id)
        example_linked_service_key_vault = azure.datafactory.LinkedServiceKeyVault("example",
            name="example",
            data_factory_id=example_factory.id,
            key_vault_id=example_key_vault.id)
        example_credential_service_principal = azure.datafactory.CredentialServicePrincipal("example",
            name="example",
            description="example description",
            data_factory_id=example_factory.id,
            tenant_id=current.tenant_id,
            service_principal_id=current.client_id,
            service_principal_key={
                "linked_service_name": example_linked_service_key_vault.name,
                "secret_name": example_secret.name,
                "secret_version": example_secret.version,
            },
            annotations=[
                "1",
                "2",
            ])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataFactory`: 2018-06-01

        ## Import

        Data Factory Credentials can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/credentialServicePrincipal:CredentialServicePrincipal example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.DataFactory/factories/example/credentials/credential1
        ```

        :param str resource_name: The name of the resource.
        :param CredentialServicePrincipalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CredentialServicePrincipalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[Union['CredentialServicePrincipalServicePrincipalKeyArgs', 'CredentialServicePrincipalServicePrincipalKeyArgsDict']]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CredentialServicePrincipalArgs.__new__(CredentialServicePrincipalArgs)

            __props__.__dict__["annotations"] = annotations
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if service_principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_principal_id'")
            __props__.__dict__["service_principal_id"] = service_principal_id
            __props__.__dict__["service_principal_key"] = service_principal_key
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(CredentialServicePrincipal, __self__).__init__(
            'azure:datafactory/credentialServicePrincipal:CredentialServicePrincipal',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_principal_key: Optional[pulumi.Input[Union['CredentialServicePrincipalServicePrincipalKeyArgs', 'CredentialServicePrincipalServicePrincipalKeyArgsDict']]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CredentialServicePrincipal':
        """
        Get an existing CredentialServicePrincipal resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Credential.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Credential with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Credential.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Credential. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] service_principal_id: The Client ID of the Service Principal.
        :param pulumi.Input[Union['CredentialServicePrincipalServicePrincipalKeyArgs', 'CredentialServicePrincipalServicePrincipalKeyArgsDict']] service_principal_key: A `service_principal_key` block as defined below.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID of the Service Principal.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CredentialServicePrincipalState.__new__(_CredentialServicePrincipalState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["service_principal_id"] = service_principal_id
        __props__.__dict__["service_principal_key"] = service_principal_key
        __props__.__dict__["tenant_id"] = tenant_id
        return CredentialServicePrincipal(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Credential.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Data Factory ID in which to associate the Credential with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the Data Factory Credential.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Credential. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Client ID of the Service Principal.
        """
        return pulumi.get(self, "service_principal_id")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> pulumi.Output[Optional['outputs.CredentialServicePrincipalServicePrincipalKey']]:
        """
        A `service_principal_key` block as defined below.
        """
        return pulumi.get(self, "service_principal_key")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Tenant ID of the Service Principal.
        """
        return pulumi.get(self, "tenant_id")

