# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatasetAzureSqlTableArgs', 'DatasetAzureSqlTable']

@pulumi.input_type
class DatasetAzureSqlTableArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[_builtins.str],
                 linked_service_id: pulumi.Input[_builtins.str],
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_columns: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAzureSqlTableSchemaColumnArgs']]]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DatasetAzureSqlTable resource.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] linked_service_id: The Data Factory Linked Service ID in which to associate the Dataset with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset Azure SQL Table. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] schema: The schema name of the table in the Azure SQL Database.
        :param pulumi.Input[Sequence[pulumi.Input['DatasetAzureSqlTableSchemaColumnArgs']]] schema_columns: A `schema_column` block as defined below.
        :param pulumi.Input[_builtins.str] table: The table name of the table in the Azure SQL Database.
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        pulumi.set(__self__, "linked_service_id", linked_service_id)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if schema_columns is not None:
            pulumi.set(__self__, "schema_columns", schema_columns)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter(name="linkedServiceId")
    def linked_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Data Factory Linked Service ID in which to associate the Dataset with.
        """
        return pulumi.get(self, "linked_service_id")

    @linked_service_id.setter
    def linked_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "linked_service_id", value)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Dataset Azure SQL Table. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema name of the table in the Azure SQL Database.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaColumns")
    def schema_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAzureSqlTableSchemaColumnArgs']]]]:
        """
        A `schema_column` block as defined below.
        """
        return pulumi.get(self, "schema_columns")

    @schema_columns.setter
    def schema_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAzureSqlTableSchemaColumnArgs']]]]):
        pulumi.set(self, "schema_columns", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The table name of the table in the Azure SQL Database.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table", value)


@pulumi.input_type
class _DatasetAzureSqlTableState:
    def __init__(__self__, *,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_columns: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAzureSqlTableSchemaColumnArgs']]]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatasetAzureSqlTable resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input[_builtins.str] linked_service_id: The Data Factory Linked Service ID in which to associate the Dataset with.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset Azure SQL Table. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] schema: The schema name of the table in the Azure SQL Database.
        :param pulumi.Input[Sequence[pulumi.Input['DatasetAzureSqlTableSchemaColumnArgs']]] schema_columns: A `schema_column` block as defined below.
        :param pulumi.Input[_builtins.str] table: The table name of the table in the Azure SQL Database.
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if linked_service_id is not None:
            pulumi.set(__self__, "linked_service_id", linked_service_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if schema_columns is not None:
            pulumi.set(__self__, "schema_columns", schema_columns)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="linkedServiceId")
    def linked_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Factory Linked Service ID in which to associate the Dataset with.
        """
        return pulumi.get(self, "linked_service_id")

    @linked_service_id.setter
    def linked_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "linked_service_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Dataset Azure SQL Table. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The schema name of the table in the Azure SQL Database.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaColumns")
    def schema_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAzureSqlTableSchemaColumnArgs']]]]:
        """
        A `schema_column` block as defined below.
        """
        return pulumi.get(self, "schema_columns")

    @schema_columns.setter
    def schema_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetAzureSqlTableSchemaColumnArgs']]]]):
        pulumi.set(self, "schema_columns", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The table name of the table in the Azure SQL Database.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table", value)


@pulumi.type_token("azure:datafactory/datasetAzureSqlTable:DatasetAzureSqlTable")
class DatasetAzureSqlTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetAzureSqlTableSchemaColumnArgs', 'DatasetAzureSqlTableSchemaColumnArgsDict']]]]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure SQL Table Dataset inside an Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_linked_service_azure_sql_database = azure.datafactory.LinkedServiceAzureSqlDatabase("example",
            name="example",
            data_factory_id=example_factory.id,
            connection_string="Integrated Security=False;Data Source=test;Initial Catalog=test;Initial Catalog=test;User ID=test;Password=test")
        example_dataset_azure_sql_table = azure.datafactory.DatasetAzureSqlTable("example",
            name="example",
            data_factory_id=example_factory.id,
            linked_service_id=example_linked_service_azure_sql_database.id)
        ```

        ## Import

        Data Factory Azure SQL Table Datasets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/datasetAzureSqlTable:DatasetAzureSqlTable example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/datasets/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input[_builtins.str] linked_service_id: The Data Factory Linked Service ID in which to associate the Dataset with.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset Azure SQL Table. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] schema: The schema name of the table in the Azure SQL Database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatasetAzureSqlTableSchemaColumnArgs', 'DatasetAzureSqlTableSchemaColumnArgsDict']]]] schema_columns: A `schema_column` block as defined below.
        :param pulumi.Input[_builtins.str] table: The table name of the table in the Azure SQL Database.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetAzureSqlTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure SQL Table Dataset inside an Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_linked_service_azure_sql_database = azure.datafactory.LinkedServiceAzureSqlDatabase("example",
            name="example",
            data_factory_id=example_factory.id,
            connection_string="Integrated Security=False;Data Source=test;Initial Catalog=test;Initial Catalog=test;User ID=test;Password=test")
        example_dataset_azure_sql_table = azure.datafactory.DatasetAzureSqlTable("example",
            name="example",
            data_factory_id=example_factory.id,
            linked_service_id=example_linked_service_azure_sql_database.id)
        ```

        ## Import

        Data Factory Azure SQL Table Datasets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/datasetAzureSqlTable:DatasetAzureSqlTable example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/datasets/example
        ```

        :param str resource_name: The name of the resource.
        :param DatasetAzureSqlTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetAzureSqlTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema: Optional[pulumi.Input[_builtins.str]] = None,
                 schema_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetAzureSqlTableSchemaColumnArgs', 'DatasetAzureSqlTableSchemaColumnArgsDict']]]]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetAzureSqlTableArgs.__new__(DatasetAzureSqlTableArgs)

            __props__.__dict__["additional_properties"] = additional_properties
            __props__.__dict__["annotations"] = annotations
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            __props__.__dict__["folder"] = folder
            if linked_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'linked_service_id'")
            __props__.__dict__["linked_service_id"] = linked_service_id
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["schema"] = schema
            __props__.__dict__["schema_columns"] = schema_columns
            __props__.__dict__["table"] = table
        super(DatasetAzureSqlTable, __self__).__init__(
            'azure:datafactory/datasetAzureSqlTable:DatasetAzureSqlTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            linked_service_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            schema: Optional[pulumi.Input[_builtins.str]] = None,
            schema_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetAzureSqlTableSchemaColumnArgs', 'DatasetAzureSqlTableSchemaColumnArgsDict']]]]] = None,
            table: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatasetAzureSqlTable':
        """
        Get an existing DatasetAzureSqlTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input[_builtins.str] linked_service_id: The Data Factory Linked Service ID in which to associate the Dataset with.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset Azure SQL Table. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset Azure SQL Table.
        :param pulumi.Input[_builtins.str] schema: The schema name of the table in the Azure SQL Database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatasetAzureSqlTableSchemaColumnArgs', 'DatasetAzureSqlTableSchemaColumnArgsDict']]]] schema_columns: A `schema_column` block as defined below.
        :param pulumi.Input[_builtins.str] table: The table name of the table in the Azure SQL Database.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatasetAzureSqlTableState.__new__(_DatasetAzureSqlTableState)

        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["folder"] = folder
        __props__.__dict__["linked_service_id"] = linked_service_id
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["schema"] = schema
        __props__.__dict__["schema_columns"] = schema_columns
        __props__.__dict__["table"] = table
        return DatasetAzureSqlTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of additional properties to associate with the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "additional_properties")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="linkedServiceId")
    def linked_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Data Factory Linked Service ID in which to associate the Dataset with.
        """
        return pulumi.get(self, "linked_service_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Data Factory Dataset Azure SQL Table. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of parameters to associate with the Data Factory Dataset Azure SQL Table.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def schema(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The schema name of the table in the Azure SQL Database.
        """
        return pulumi.get(self, "schema")

    @_builtins.property
    @pulumi.getter(name="schemaColumns")
    def schema_columns(self) -> pulumi.Output[Optional[Sequence['outputs.DatasetAzureSqlTableSchemaColumn']]]:
        """
        A `schema_column` block as defined below.
        """
        return pulumi.get(self, "schema_columns")

    @_builtins.property
    @pulumi.getter
    def table(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The table name of the table in the Azure SQL Database.
        """
        return pulumi.get(self, "table")

