# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatasetParquetArgs', 'DatasetParquet']

@pulumi.input_type
class DatasetParquetArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[_builtins.str],
                 linked_service_name: pulumi.Input[_builtins.str],
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 azure_blob_fs_location: Optional[pulumi.Input['DatasetParquetAzureBlobFsLocationArgs']] = None,
                 azure_blob_storage_location: Optional[pulumi.Input['DatasetParquetAzureBlobStorageLocationArgs']] = None,
                 compression_codec: Optional[pulumi.Input[_builtins.str]] = None,
                 compression_level: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 http_server_location: Optional[pulumi.Input['DatasetParquetHttpServerLocationArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema_columns: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetParquetSchemaColumnArgs']]]] = None):
        """
        The set of arguments for constructing a DatasetParquet resource.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] linked_service_name: The Data Factory Linked Service name in which to associate the Dataset with.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset.
               
               The following supported locations for a Parquet Dataset:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset.
        :param pulumi.Input['DatasetParquetAzureBlobFsLocationArgs'] azure_blob_fs_location: A `azure_blob_fs_location` block as defined below.
        :param pulumi.Input['DatasetParquetAzureBlobStorageLocationArgs'] azure_blob_storage_location: A `azure_blob_storage_location` block as defined below.
               
               The following supported arguments are specific to Parquet Dataset:
        :param pulumi.Input[_builtins.str] compression_codec: The compression codec used to read/write text files. Valid values are `bzip2`, `gzip`, `deflate`, `ZipDeflate`, `TarGzip`, `Tar`, `snappy`, or `lz4`. Please note these values are case-sensitive.
        :param pulumi.Input[_builtins.str] compression_level: Specifies the compression level. Possible values are `Optimal` and `Fastest`,
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input['DatasetParquetHttpServerLocationArgs'] http_server_location: A `http_server_location` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset.
        :param pulumi.Input[Sequence[pulumi.Input['DatasetParquetSchemaColumnArgs']]] schema_columns: A `schema_column` block as defined below.
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        pulumi.set(__self__, "linked_service_name", linked_service_name)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if azure_blob_fs_location is not None:
            pulumi.set(__self__, "azure_blob_fs_location", azure_blob_fs_location)
        if azure_blob_storage_location is not None:
            pulumi.set(__self__, "azure_blob_storage_location", azure_blob_storage_location)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if compression_level is not None:
            pulumi.set(__self__, "compression_level", compression_level)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if http_server_location is not None:
            pulumi.set(__self__, "http_server_location", http_server_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if schema_columns is not None:
            pulumi.set(__self__, "schema_columns", schema_columns)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Data Factory Linked Service name in which to associate the Dataset with.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "linked_service_name", value)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Dataset.

        The following supported locations for a Parquet Dataset:
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="azureBlobFsLocation")
    def azure_blob_fs_location(self) -> Optional[pulumi.Input['DatasetParquetAzureBlobFsLocationArgs']]:
        """
        A `azure_blob_fs_location` block as defined below.
        """
        return pulumi.get(self, "azure_blob_fs_location")

    @azure_blob_fs_location.setter
    def azure_blob_fs_location(self, value: Optional[pulumi.Input['DatasetParquetAzureBlobFsLocationArgs']]):
        pulumi.set(self, "azure_blob_fs_location", value)

    @_builtins.property
    @pulumi.getter(name="azureBlobStorageLocation")
    def azure_blob_storage_location(self) -> Optional[pulumi.Input['DatasetParquetAzureBlobStorageLocationArgs']]:
        """
        A `azure_blob_storage_location` block as defined below.

        The following supported arguments are specific to Parquet Dataset:
        """
        return pulumi.get(self, "azure_blob_storage_location")

    @azure_blob_storage_location.setter
    def azure_blob_storage_location(self, value: Optional[pulumi.Input['DatasetParquetAzureBlobStorageLocationArgs']]):
        pulumi.set(self, "azure_blob_storage_location", value)

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compression codec used to read/write text files. Valid values are `bzip2`, `gzip`, `deflate`, `ZipDeflate`, `TarGzip`, `Tar`, `snappy`, or `lz4`. Please note these values are case-sensitive.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression_codec", value)

    @_builtins.property
    @pulumi.getter(name="compressionLevel")
    def compression_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the compression level. Possible values are `Optimal` and `Fastest`,
        """
        return pulumi.get(self, "compression_level")

    @compression_level.setter
    def compression_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression_level", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Dataset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="httpServerLocation")
    def http_server_location(self) -> Optional[pulumi.Input['DatasetParquetHttpServerLocationArgs']]:
        """
        A `http_server_location` block as defined below.
        """
        return pulumi.get(self, "http_server_location")

    @http_server_location.setter
    def http_server_location(self, value: Optional[pulumi.Input['DatasetParquetHttpServerLocationArgs']]):
        pulumi.set(self, "http_server_location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="schemaColumns")
    def schema_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetParquetSchemaColumnArgs']]]]:
        """
        A `schema_column` block as defined below.
        """
        return pulumi.get(self, "schema_columns")

    @schema_columns.setter
    def schema_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetParquetSchemaColumnArgs']]]]):
        pulumi.set(self, "schema_columns", value)


@pulumi.input_type
class _DatasetParquetState:
    def __init__(__self__, *,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 azure_blob_fs_location: Optional[pulumi.Input['DatasetParquetAzureBlobFsLocationArgs']] = None,
                 azure_blob_storage_location: Optional[pulumi.Input['DatasetParquetAzureBlobStorageLocationArgs']] = None,
                 compression_codec: Optional[pulumi.Input[_builtins.str]] = None,
                 compression_level: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 http_server_location: Optional[pulumi.Input['DatasetParquetHttpServerLocationArgs']] = None,
                 linked_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema_columns: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetParquetSchemaColumnArgs']]]] = None):
        """
        Input properties used for looking up and filtering DatasetParquet resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset.
               
               The following supported locations for a Parquet Dataset:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset.
        :param pulumi.Input['DatasetParquetAzureBlobFsLocationArgs'] azure_blob_fs_location: A `azure_blob_fs_location` block as defined below.
        :param pulumi.Input['DatasetParquetAzureBlobStorageLocationArgs'] azure_blob_storage_location: A `azure_blob_storage_location` block as defined below.
               
               The following supported arguments are specific to Parquet Dataset:
        :param pulumi.Input[_builtins.str] compression_codec: The compression codec used to read/write text files. Valid values are `bzip2`, `gzip`, `deflate`, `ZipDeflate`, `TarGzip`, `Tar`, `snappy`, or `lz4`. Please note these values are case-sensitive.
        :param pulumi.Input[_builtins.str] compression_level: Specifies the compression level. Possible values are `Optimal` and `Fastest`,
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input['DatasetParquetHttpServerLocationArgs'] http_server_location: A `http_server_location` block as defined below.
        :param pulumi.Input[_builtins.str] linked_service_name: The Data Factory Linked Service name in which to associate the Dataset with.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset.
        :param pulumi.Input[Sequence[pulumi.Input['DatasetParquetSchemaColumnArgs']]] schema_columns: A `schema_column` block as defined below.
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if azure_blob_fs_location is not None:
            pulumi.set(__self__, "azure_blob_fs_location", azure_blob_fs_location)
        if azure_blob_storage_location is not None:
            pulumi.set(__self__, "azure_blob_storage_location", azure_blob_storage_location)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if compression_level is not None:
            pulumi.set(__self__, "compression_level", compression_level)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if http_server_location is not None:
            pulumi.set(__self__, "http_server_location", http_server_location)
        if linked_service_name is not None:
            pulumi.set(__self__, "linked_service_name", linked_service_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if schema_columns is not None:
            pulumi.set(__self__, "schema_columns", schema_columns)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Dataset.

        The following supported locations for a Parquet Dataset:
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="azureBlobFsLocation")
    def azure_blob_fs_location(self) -> Optional[pulumi.Input['DatasetParquetAzureBlobFsLocationArgs']]:
        """
        A `azure_blob_fs_location` block as defined below.
        """
        return pulumi.get(self, "azure_blob_fs_location")

    @azure_blob_fs_location.setter
    def azure_blob_fs_location(self, value: Optional[pulumi.Input['DatasetParquetAzureBlobFsLocationArgs']]):
        pulumi.set(self, "azure_blob_fs_location", value)

    @_builtins.property
    @pulumi.getter(name="azureBlobStorageLocation")
    def azure_blob_storage_location(self) -> Optional[pulumi.Input['DatasetParquetAzureBlobStorageLocationArgs']]:
        """
        A `azure_blob_storage_location` block as defined below.

        The following supported arguments are specific to Parquet Dataset:
        """
        return pulumi.get(self, "azure_blob_storage_location")

    @azure_blob_storage_location.setter
    def azure_blob_storage_location(self, value: Optional[pulumi.Input['DatasetParquetAzureBlobStorageLocationArgs']]):
        pulumi.set(self, "azure_blob_storage_location", value)

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compression codec used to read/write text files. Valid values are `bzip2`, `gzip`, `deflate`, `ZipDeflate`, `TarGzip`, `Tar`, `snappy`, or `lz4`. Please note these values are case-sensitive.
        """
        return pulumi.get(self, "compression_codec")

    @compression_codec.setter
    def compression_codec(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression_codec", value)

    @_builtins.property
    @pulumi.getter(name="compressionLevel")
    def compression_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the compression level. Possible values are `Optimal` and `Fastest`,
        """
        return pulumi.get(self, "compression_level")

    @compression_level.setter
    def compression_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression_level", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Dataset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="httpServerLocation")
    def http_server_location(self) -> Optional[pulumi.Input['DatasetParquetHttpServerLocationArgs']]:
        """
        A `http_server_location` block as defined below.
        """
        return pulumi.get(self, "http_server_location")

    @http_server_location.setter
    def http_server_location(self, value: Optional[pulumi.Input['DatasetParquetHttpServerLocationArgs']]):
        pulumi.set(self, "http_server_location", value)

    @_builtins.property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Factory Linked Service name in which to associate the Dataset with.
        """
        return pulumi.get(self, "linked_service_name")

    @linked_service_name.setter
    def linked_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "linked_service_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="schemaColumns")
    def schema_columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetParquetSchemaColumnArgs']]]]:
        """
        A `schema_column` block as defined below.
        """
        return pulumi.get(self, "schema_columns")

    @schema_columns.setter
    def schema_columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetParquetSchemaColumnArgs']]]]):
        pulumi.set(self, "schema_columns", value)


@pulumi.type_token("azure:datafactory/datasetParquet:DatasetParquet")
class DatasetParquet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 azure_blob_fs_location: Optional[pulumi.Input[Union['DatasetParquetAzureBlobFsLocationArgs', 'DatasetParquetAzureBlobFsLocationArgsDict']]] = None,
                 azure_blob_storage_location: Optional[pulumi.Input[Union['DatasetParquetAzureBlobStorageLocationArgs', 'DatasetParquetAzureBlobStorageLocationArgsDict']]] = None,
                 compression_codec: Optional[pulumi.Input[_builtins.str]] = None,
                 compression_level: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 http_server_location: Optional[pulumi.Input[Union['DatasetParquetHttpServerLocationArgs', 'DatasetParquetHttpServerLocationArgsDict']]] = None,
                 linked_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetParquetSchemaColumnArgs', 'DatasetParquetSchemaColumnArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages an Azure Parquet Dataset inside an Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_linked_service_web = azure.datafactory.LinkedServiceWeb("example",
            name="example",
            data_factory_id=example_factory.id,
            authentication_type="Anonymous",
            url="https://www.bing.com")
        example_dataset_parquet = azure.datafactory.DatasetParquet("example",
            name="example",
            data_factory_id=example_factory.id,
            linked_service_name=example_linked_service_web.name,
            http_server_location={
                "relative_url": "http://www.bing.com",
                "path": "foo/bar/",
                "filename": "fizz.txt",
            })
        ```

        ## Import

        Data Factory Datasets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/datasetParquet:DatasetParquet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/datasets/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset.
               
               The following supported locations for a Parquet Dataset:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset.
        :param pulumi.Input[Union['DatasetParquetAzureBlobFsLocationArgs', 'DatasetParquetAzureBlobFsLocationArgsDict']] azure_blob_fs_location: A `azure_blob_fs_location` block as defined below.
        :param pulumi.Input[Union['DatasetParquetAzureBlobStorageLocationArgs', 'DatasetParquetAzureBlobStorageLocationArgsDict']] azure_blob_storage_location: A `azure_blob_storage_location` block as defined below.
               
               The following supported arguments are specific to Parquet Dataset:
        :param pulumi.Input[_builtins.str] compression_codec: The compression codec used to read/write text files. Valid values are `bzip2`, `gzip`, `deflate`, `ZipDeflate`, `TarGzip`, `Tar`, `snappy`, or `lz4`. Please note these values are case-sensitive.
        :param pulumi.Input[_builtins.str] compression_level: Specifies the compression level. Possible values are `Optimal` and `Fastest`,
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input[Union['DatasetParquetHttpServerLocationArgs', 'DatasetParquetHttpServerLocationArgsDict']] http_server_location: A `http_server_location` block as defined below.
        :param pulumi.Input[_builtins.str] linked_service_name: The Data Factory Linked Service name in which to associate the Dataset with.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatasetParquetSchemaColumnArgs', 'DatasetParquetSchemaColumnArgsDict']]]] schema_columns: A `schema_column` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetParquetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Parquet Dataset inside an Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_linked_service_web = azure.datafactory.LinkedServiceWeb("example",
            name="example",
            data_factory_id=example_factory.id,
            authentication_type="Anonymous",
            url="https://www.bing.com")
        example_dataset_parquet = azure.datafactory.DatasetParquet("example",
            name="example",
            data_factory_id=example_factory.id,
            linked_service_name=example_linked_service_web.name,
            http_server_location={
                "relative_url": "http://www.bing.com",
                "path": "foo/bar/",
                "filename": "fizz.txt",
            })
        ```

        ## Import

        Data Factory Datasets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/datasetParquet:DatasetParquet example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/datasets/example
        ```

        :param str resource_name: The name of the resource.
        :param DatasetParquetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetParquetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 azure_blob_fs_location: Optional[pulumi.Input[Union['DatasetParquetAzureBlobFsLocationArgs', 'DatasetParquetAzureBlobFsLocationArgsDict']]] = None,
                 azure_blob_storage_location: Optional[pulumi.Input[Union['DatasetParquetAzureBlobStorageLocationArgs', 'DatasetParquetAzureBlobStorageLocationArgsDict']]] = None,
                 compression_codec: Optional[pulumi.Input[_builtins.str]] = None,
                 compression_level: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 http_server_location: Optional[pulumi.Input[Union['DatasetParquetHttpServerLocationArgs', 'DatasetParquetHttpServerLocationArgsDict']]] = None,
                 linked_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetParquetSchemaColumnArgs', 'DatasetParquetSchemaColumnArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetParquetArgs.__new__(DatasetParquetArgs)

            __props__.__dict__["additional_properties"] = additional_properties
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["azure_blob_fs_location"] = azure_blob_fs_location
            __props__.__dict__["azure_blob_storage_location"] = azure_blob_storage_location
            __props__.__dict__["compression_codec"] = compression_codec
            __props__.__dict__["compression_level"] = compression_level
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            __props__.__dict__["folder"] = folder
            __props__.__dict__["http_server_location"] = http_server_location
            if linked_service_name is None and not opts.urn:
                raise TypeError("Missing required property 'linked_service_name'")
            __props__.__dict__["linked_service_name"] = linked_service_name
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["schema_columns"] = schema_columns
        super(DatasetParquet, __self__).__init__(
            'azure:datafactory/datasetParquet:DatasetParquet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            azure_blob_fs_location: Optional[pulumi.Input[Union['DatasetParquetAzureBlobFsLocationArgs', 'DatasetParquetAzureBlobFsLocationArgsDict']]] = None,
            azure_blob_storage_location: Optional[pulumi.Input[Union['DatasetParquetAzureBlobStorageLocationArgs', 'DatasetParquetAzureBlobStorageLocationArgsDict']]] = None,
            compression_codec: Optional[pulumi.Input[_builtins.str]] = None,
            compression_level: Optional[pulumi.Input[_builtins.str]] = None,
            data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            http_server_location: Optional[pulumi.Input[Union['DatasetParquetHttpServerLocationArgs', 'DatasetParquetHttpServerLocationArgsDict']]] = None,
            linked_service_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            schema_columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DatasetParquetSchemaColumnArgs', 'DatasetParquetSchemaColumnArgsDict']]]]] = None) -> 'DatasetParquet':
        """
        Get an existing DatasetParquet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset.
               
               The following supported locations for a Parquet Dataset:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset.
        :param pulumi.Input[Union['DatasetParquetAzureBlobFsLocationArgs', 'DatasetParquetAzureBlobFsLocationArgsDict']] azure_blob_fs_location: A `azure_blob_fs_location` block as defined below.
        :param pulumi.Input[Union['DatasetParquetAzureBlobStorageLocationArgs', 'DatasetParquetAzureBlobStorageLocationArgsDict']] azure_blob_storage_location: A `azure_blob_storage_location` block as defined below.
               
               The following supported arguments are specific to Parquet Dataset:
        :param pulumi.Input[_builtins.str] compression_codec: The compression codec used to read/write text files. Valid values are `bzip2`, `gzip`, `deflate`, `ZipDeflate`, `TarGzip`, `Tar`, `snappy`, or `lz4`. Please note these values are case-sensitive.
        :param pulumi.Input[_builtins.str] compression_level: Specifies the compression level. Possible values are `Optimal` and `Fastest`,
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input[Union['DatasetParquetHttpServerLocationArgs', 'DatasetParquetHttpServerLocationArgsDict']] http_server_location: A `http_server_location` block as defined below.
        :param pulumi.Input[_builtins.str] linked_service_name: The Data Factory Linked Service name in which to associate the Dataset with.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DatasetParquetSchemaColumnArgs', 'DatasetParquetSchemaColumnArgsDict']]]] schema_columns: A `schema_column` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatasetParquetState.__new__(_DatasetParquetState)

        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["azure_blob_fs_location"] = azure_blob_fs_location
        __props__.__dict__["azure_blob_storage_location"] = azure_blob_storage_location
        __props__.__dict__["compression_codec"] = compression_codec
        __props__.__dict__["compression_level"] = compression_level
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["folder"] = folder
        __props__.__dict__["http_server_location"] = http_server_location
        __props__.__dict__["linked_service_name"] = linked_service_name
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["schema_columns"] = schema_columns
        return DatasetParquet(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of additional properties to associate with the Data Factory Dataset.

        The following supported locations for a Parquet Dataset:
        """
        return pulumi.get(self, "additional_properties")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Dataset.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="azureBlobFsLocation")
    def azure_blob_fs_location(self) -> pulumi.Output[Optional['outputs.DatasetParquetAzureBlobFsLocation']]:
        """
        A `azure_blob_fs_location` block as defined below.
        """
        return pulumi.get(self, "azure_blob_fs_location")

    @_builtins.property
    @pulumi.getter(name="azureBlobStorageLocation")
    def azure_blob_storage_location(self) -> pulumi.Output[Optional['outputs.DatasetParquetAzureBlobStorageLocation']]:
        """
        A `azure_blob_storage_location` block as defined below.

        The following supported arguments are specific to Parquet Dataset:
        """
        return pulumi.get(self, "azure_blob_storage_location")

    @_builtins.property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The compression codec used to read/write text files. Valid values are `bzip2`, `gzip`, `deflate`, `ZipDeflate`, `TarGzip`, `Tar`, `snappy`, or `lz4`. Please note these values are case-sensitive.
        """
        return pulumi.get(self, "compression_codec")

    @_builtins.property
    @pulumi.getter(name="compressionLevel")
    def compression_level(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the compression level. Possible values are `Optimal` and `Fastest`,
        """
        return pulumi.get(self, "compression_level")

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the Data Factory Dataset.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="httpServerLocation")
    def http_server_location(self) -> pulumi.Output[Optional['outputs.DatasetParquetHttpServerLocation']]:
        """
        A `http_server_location` block as defined below.
        """
        return pulumi.get(self, "http_server_location")

    @_builtins.property
    @pulumi.getter(name="linkedServiceName")
    def linked_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Data Factory Linked Service name in which to associate the Dataset with.
        """
        return pulumi.get(self, "linked_service_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of parameters to associate with the Data Factory Dataset.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="schemaColumns")
    def schema_columns(self) -> pulumi.Output[Optional[Sequence['outputs.DatasetParquetSchemaColumn']]]:
        """
        A `schema_column` block as defined below.
        """
        return pulumi.get(self, "schema_columns")

