# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkConnectionArgs', 'NetworkConnection']

@pulumi.input_type
class NetworkConnectionArgs:
    def __init__(__self__, *,
                 domain_join_type: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_password: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_username: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NetworkConnection resource.
        :param pulumi.Input[_builtins.str] domain_join_type: The Azure Active Directory Join type. Possible values are `AzureADJoin` and `HybridAzureADJoin`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet that is used to attach Virtual Machines.
        :param pulumi.Input[_builtins.str] domain_name: The name of the Azure Active Directory domain.
        :param pulumi.Input[_builtins.str] domain_password: The password for the account used to join domain.
        :param pulumi.Input[_builtins.str] domain_username: The username of the Azure Active Directory account (user or service account) that has permissions to create computer objects in Active Directory.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Network Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] organization_unit: The Azure Active Directory domain Organization Unit (OU).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Network Connection.
        """
        pulumi.set(__self__, "domain_join_type", domain_join_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if domain_password is not None:
            pulumi.set(__self__, "domain_password", domain_password)
        if domain_username is not None:
            pulumi.set(__self__, "domain_username", domain_username)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_unit is not None:
            pulumi.set(__self__, "organization_unit", organization_unit)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="domainJoinType")
    def domain_join_type(self) -> pulumi.Input[_builtins.str]:
        """
        The Azure Active Directory Join type. Possible values are `AzureADJoin` and `HybridAzureADJoin`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "domain_join_type")

    @domain_join_type.setter
    def domain_join_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_join_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group within which this Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Subnet that is used to attach Virtual Machines.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Active Directory domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="domainPassword")
    def domain_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the account used to join domain.
        """
        return pulumi.get(self, "domain_password")

    @domain_password.setter
    def domain_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_password", value)

    @_builtins.property
    @pulumi.getter(name="domainUsername")
    def domain_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the Azure Active Directory account (user or service account) that has permissions to create computer objects in Active Directory.
        """
        return pulumi.get(self, "domain_username")

    @domain_username.setter
    def domain_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_username", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Network Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationUnit")
    def organization_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Active Directory domain Organization Unit (OU).
        """
        return pulumi.get(self, "organization_unit")

    @organization_unit.setter
    def organization_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_unit", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Network Connection.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NetworkConnectionState:
    def __init__(__self__, *,
                 domain_join_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_password: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_username: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NetworkConnection resources.
        :param pulumi.Input[_builtins.str] domain_join_type: The Azure Active Directory Join type. Possible values are `AzureADJoin` and `HybridAzureADJoin`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] domain_name: The name of the Azure Active Directory domain.
        :param pulumi.Input[_builtins.str] domain_password: The password for the account used to join domain.
        :param pulumi.Input[_builtins.str] domain_username: The username of the Azure Active Directory account (user or service account) that has permissions to create computer objects in Active Directory.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Network Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] organization_unit: The Azure Active Directory domain Organization Unit (OU).
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet that is used to attach Virtual Machines.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Network Connection.
        """
        if domain_join_type is not None:
            pulumi.set(__self__, "domain_join_type", domain_join_type)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if domain_password is not None:
            pulumi.set(__self__, "domain_password", domain_password)
        if domain_username is not None:
            pulumi.set(__self__, "domain_username", domain_username)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_unit is not None:
            pulumi.set(__self__, "organization_unit", organization_unit)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="domainJoinType")
    def domain_join_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Active Directory Join type. Possible values are `AzureADJoin` and `HybridAzureADJoin`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "domain_join_type")

    @domain_join_type.setter
    def domain_join_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_join_type", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Active Directory domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="domainPassword")
    def domain_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The password for the account used to join domain.
        """
        return pulumi.get(self, "domain_password")

    @domain_password.setter
    def domain_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_password", value)

    @_builtins.property
    @pulumi.getter(name="domainUsername")
    def domain_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The username of the Azure Active Directory account (user or service account) that has permissions to create computer objects in Active Directory.
        """
        return pulumi.get(self, "domain_username")

    @domain_username.setter
    def domain_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_username", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Dev Center Network Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="organizationUnit")
    def organization_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Active Directory domain Organization Unit (OU).
        """
        return pulumi.get(self, "organization_unit")

    @organization_unit.setter
    def organization_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_unit", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group within which this Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet that is used to attach Virtual Machines.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Network Connection.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:devcenter/networkConnection:NetworkConnection")
class NetworkConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_join_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_password: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_username: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Dev Center Network Connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_connection = azure.devcenter.NetworkConnection("example",
            name="example-dcnc",
            resource_group_name=example.name,
            location=example.location,
            domain_join_type="AzureADJoin",
            subnet_id=example_subnet.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter`: 2025-02-01

        ## Import

        An existing Dev Center Network Connection can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/networkConnection:NetworkConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DevCenter/networkConnections/networkConnection1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_join_type: The Azure Active Directory Join type. Possible values are `AzureADJoin` and `HybridAzureADJoin`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] domain_name: The name of the Azure Active Directory domain.
        :param pulumi.Input[_builtins.str] domain_password: The password for the account used to join domain.
        :param pulumi.Input[_builtins.str] domain_username: The username of the Azure Active Directory account (user or service account) that has permissions to create computer objects in Active Directory.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Network Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] organization_unit: The Azure Active Directory domain Organization Unit (OU).
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet that is used to attach Virtual Machines.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Network Connection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dev Center Network Connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_connection = azure.devcenter.NetworkConnection("example",
            name="example-dcnc",
            resource_group_name=example.name,
            location=example.location,
            domain_join_type="AzureADJoin",
            subnet_id=example_subnet.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevCenter`: 2025-02-01

        ## Import

        An existing Dev Center Network Connection can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devcenter/networkConnection:NetworkConnection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DevCenter/networkConnections/networkConnection1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_join_type: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_password: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_username: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkConnectionArgs.__new__(NetworkConnectionArgs)

            if domain_join_type is None and not opts.urn:
                raise TypeError("Missing required property 'domain_join_type'")
            __props__.__dict__["domain_join_type"] = domain_join_type
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["domain_password"] = None if domain_password is None else pulumi.Output.secret(domain_password)
            __props__.__dict__["domain_username"] = domain_username
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["organization_unit"] = organization_unit
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["domainPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NetworkConnection, __self__).__init__(
            'azure:devcenter/networkConnection:NetworkConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_join_type: Optional[pulumi.Input[_builtins.str]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            domain_password: Optional[pulumi.Input[_builtins.str]] = None,
            domain_username: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            organization_unit: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'NetworkConnection':
        """
        Get an existing NetworkConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_join_type: The Azure Active Directory Join type. Possible values are `AzureADJoin` and `HybridAzureADJoin`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] domain_name: The name of the Azure Active Directory domain.
        :param pulumi.Input[_builtins.str] domain_password: The password for the account used to join domain.
        :param pulumi.Input[_builtins.str] domain_username: The username of the Azure Active Directory account (user or service account) that has permissions to create computer objects in Active Directory.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Dev Center Network Connection. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] organization_unit: The Azure Active Directory domain Organization Unit (OU).
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group within which this Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet that is used to attach Virtual Machines.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Dev Center Network Connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkConnectionState.__new__(_NetworkConnectionState)

        __props__.__dict__["domain_join_type"] = domain_join_type
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["domain_password"] = domain_password
        __props__.__dict__["domain_username"] = domain_username
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_unit"] = organization_unit
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        return NetworkConnection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="domainJoinType")
    def domain_join_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Active Directory Join type. Possible values are `AzureADJoin` and `HybridAzureADJoin`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "domain_join_type")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the Azure Active Directory domain.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="domainPassword")
    def domain_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The password for the account used to join domain.
        """
        return pulumi.get(self, "domain_password")

    @_builtins.property
    @pulumi.getter(name="domainUsername")
    def domain_username(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The username of the Azure Active Directory account (user or service account) that has permissions to create computer objects in Active Directory.
        """
        return pulumi.get(self, "domain_username")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Dev Center Network Connection. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="organizationUnit")
    def organization_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Azure Active Directory domain Organization Unit (OU).
        """
        return pulumi.get(self, "organization_unit")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group within which this Dev Center Network Connection should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Subnet that is used to attach Virtual Machines.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Dev Center Network Connection.
        """
        return pulumi.get(self, "tags")

