# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccessPolicyArgs', 'AccessPolicy']

@pulumi.input_type
class AccessPolicyArgs:
    def __init__(__self__, *,
                 key_vault_id: pulumi.Input[_builtins.str],
                 object_id: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str],
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 secret_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AccessPolicy resource.
        :param pulumi.Input[_builtins.str] key_vault_id: Specifies the id of the Key Vault resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] object_id: The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID of a service principal can be fetched from `azuread_service_principal.object_id`. The object ID must be unique for the list of access policies. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] application_id: The object ID of an Application in Azure Active Directory. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_permissions: List of certificate permissions, must be one or more from the following: `Backup`, `Create`, `Delete`, `DeleteIssuers`, `Get`, `GetIssuers`, `Import`, `List`, `ListIssuers`, `ManageContacts`, `ManageIssuers`, `Purge`, `Recover`, `Restore`, `SetIssuers` and `Update`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_permissions: List of key permissions, must be one or more from the following: `Backup`, `Create`, `Decrypt`, `Delete`, `Encrypt`, `Get`, `Import`, `List`, `Purge`, `Recover`, `Restore`, `Sign`, `UnwrapKey`, `Update`, `Verify`, `WrapKey`, `Release`, `Rotate`, `GetRotationPolicy` and `SetRotationPolicy`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secret_permissions: List of secret permissions, must be one or more from the following: `Backup`, `Delete`, `Get`, `List`, `Purge`, `Recover`, `Restore` and `Set`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_permissions: List of storage permissions, must be one or more from the following: `Backup`, `Delete`, `DeleteSAS`, `Get`, `GetSAS`, `List`, `ListSAS`, `Purge`, `Recover`, `RegenerateKey`, `Restore`, `Set`, `SetSAS` and `Update`.
        """
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if certificate_permissions is not None:
            pulumi.set(__self__, "certificate_permissions", certificate_permissions)
        if key_permissions is not None:
            pulumi.set(__self__, "key_permissions", key_permissions)
        if secret_permissions is not None:
            pulumi.set(__self__, "secret_permissions", secret_permissions)
        if storage_permissions is not None:
            pulumi.set(__self__, "storage_permissions", storage_permissions)

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the id of the Key Vault resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[_builtins.str]:
        """
        The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID of a service principal can be fetched from `azuread_service_principal.object_id`. The object ID must be unique for the list of access policies. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object ID of an Application in Azure Active Directory. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="certificatePermissions")
    def certificate_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of certificate permissions, must be one or more from the following: `Backup`, `Create`, `Delete`, `DeleteIssuers`, `Get`, `GetIssuers`, `Import`, `List`, `ListIssuers`, `ManageContacts`, `ManageIssuers`, `Purge`, `Recover`, `Restore`, `SetIssuers` and `Update`.
        """
        return pulumi.get(self, "certificate_permissions")

    @certificate_permissions.setter
    def certificate_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "certificate_permissions", value)

    @_builtins.property
    @pulumi.getter(name="keyPermissions")
    def key_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of key permissions, must be one or more from the following: `Backup`, `Create`, `Decrypt`, `Delete`, `Encrypt`, `Get`, `Import`, `List`, `Purge`, `Recover`, `Restore`, `Sign`, `UnwrapKey`, `Update`, `Verify`, `WrapKey`, `Release`, `Rotate`, `GetRotationPolicy` and `SetRotationPolicy`.
        """
        return pulumi.get(self, "key_permissions")

    @key_permissions.setter
    def key_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "key_permissions", value)

    @_builtins.property
    @pulumi.getter(name="secretPermissions")
    def secret_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of secret permissions, must be one or more from the following: `Backup`, `Delete`, `Get`, `List`, `Purge`, `Recover`, `Restore` and `Set`.
        """
        return pulumi.get(self, "secret_permissions")

    @secret_permissions.setter
    def secret_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secret_permissions", value)

    @_builtins.property
    @pulumi.getter(name="storagePermissions")
    def storage_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of storage permissions, must be one or more from the following: `Backup`, `Delete`, `DeleteSAS`, `Get`, `GetSAS`, `List`, `ListSAS`, `Purge`, `Recover`, `RegenerateKey`, `Restore`, `Set`, `SetSAS` and `Update`.
        """
        return pulumi.get(self, "storage_permissions")

    @storage_permissions.setter
    def storage_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "storage_permissions", value)


@pulumi.input_type
class _AccessPolicyState:
    def __init__(__self__, *,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccessPolicy resources.
        :param pulumi.Input[_builtins.str] application_id: The object ID of an Application in Azure Active Directory. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_permissions: List of certificate permissions, must be one or more from the following: `Backup`, `Create`, `Delete`, `DeleteIssuers`, `Get`, `GetIssuers`, `Import`, `List`, `ListIssuers`, `ManageContacts`, `ManageIssuers`, `Purge`, `Recover`, `Restore`, `SetIssuers` and `Update`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_permissions: List of key permissions, must be one or more from the following: `Backup`, `Create`, `Decrypt`, `Delete`, `Encrypt`, `Get`, `Import`, `List`, `Purge`, `Recover`, `Restore`, `Sign`, `UnwrapKey`, `Update`, `Verify`, `WrapKey`, `Release`, `Rotate`, `GetRotationPolicy` and `SetRotationPolicy`.
        :param pulumi.Input[_builtins.str] key_vault_id: Specifies the id of the Key Vault resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] object_id: The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID of a service principal can be fetched from `azuread_service_principal.object_id`. The object ID must be unique for the list of access policies. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secret_permissions: List of secret permissions, must be one or more from the following: `Backup`, `Delete`, `Get`, `List`, `Purge`, `Recover`, `Restore` and `Set`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_permissions: List of storage permissions, must be one or more from the following: `Backup`, `Delete`, `DeleteSAS`, `Get`, `GetSAS`, `List`, `ListSAS`, `Purge`, `Recover`, `RegenerateKey`, `Restore`, `Set`, `SetSAS` and `Update`.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault. Changing this forces a new resource to be created.
        """
        if application_id is not None:
            pulumi.set(__self__, "application_id", application_id)
        if certificate_permissions is not None:
            pulumi.set(__self__, "certificate_permissions", certificate_permissions)
        if key_permissions is not None:
            pulumi.set(__self__, "key_permissions", key_permissions)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if secret_permissions is not None:
            pulumi.set(__self__, "secret_permissions", secret_permissions)
        if storage_permissions is not None:
            pulumi.set(__self__, "storage_permissions", storage_permissions)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object ID of an Application in Azure Active Directory. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_id")

    @application_id.setter
    def application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_id", value)

    @_builtins.property
    @pulumi.getter(name="certificatePermissions")
    def certificate_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of certificate permissions, must be one or more from the following: `Backup`, `Create`, `Delete`, `DeleteIssuers`, `Get`, `GetIssuers`, `Import`, `List`, `ListIssuers`, `ManageContacts`, `ManageIssuers`, `Purge`, `Recover`, `Restore`, `SetIssuers` and `Update`.
        """
        return pulumi.get(self, "certificate_permissions")

    @certificate_permissions.setter
    def certificate_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "certificate_permissions", value)

    @_builtins.property
    @pulumi.getter(name="keyPermissions")
    def key_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of key permissions, must be one or more from the following: `Backup`, `Create`, `Decrypt`, `Delete`, `Encrypt`, `Get`, `Import`, `List`, `Purge`, `Recover`, `Restore`, `Sign`, `UnwrapKey`, `Update`, `Verify`, `WrapKey`, `Release`, `Rotate`, `GetRotationPolicy` and `SetRotationPolicy`.
        """
        return pulumi.get(self, "key_permissions")

    @key_permissions.setter
    def key_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "key_permissions", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the id of the Key Vault resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID of a service principal can be fetched from `azuread_service_principal.object_id`. The object ID must be unique for the list of access policies. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="secretPermissions")
    def secret_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of secret permissions, must be one or more from the following: `Backup`, `Delete`, `Get`, `List`, `Purge`, `Recover`, `Restore` and `Set`.
        """
        return pulumi.get(self, "secret_permissions")

    @secret_permissions.setter
    def secret_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "secret_permissions", value)

    @_builtins.property
    @pulumi.getter(name="storagePermissions")
    def storage_permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of storage permissions, must be one or more from the following: `Backup`, `Delete`, `DeleteSAS`, `Get`, `GetSAS`, `List`, `ListSAS`, `Purge`, `Recover`, `RegenerateKey`, `Restore`, `Set`, `SetSAS` and `Update`.
        """
        return pulumi.get(self, "storage_permissions")

    @storage_permissions.setter
    def storage_permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "storage_permissions", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("azure:keyvault/accessPolicy:AccessPolicy")
class AccessPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Key Vault Access Policy.

        > **NOTE:** It's possible to define Key Vault Access Policies both within the `keyvault.KeyVault` resource via the `access_policy` block and by using the `keyvault.AccessPolicy` resource. However it's not possible to use both methods to manage Access Policies within a KeyVault, since there'll be conflicts.

        > **NOTE:** Azure permits a maximum of 1024 Access Policies per Key Vault - [more information can be found in this document](https://docs.microsoft.com/azure/key-vault/key-vault-secure-your-key-vault#data-plane-access-control).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        current = azure.core.get_client_config()
        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            tenant_id=current.tenant_id,
            sku_name="premium")
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=["Get"],
            secret_permissions=["Get"])
        example = azuread.get_service_principal(display_name="example-app")
        example_principal = azure.keyvault.AccessPolicy("example-principal",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=example.object_id,
            key_permissions=[
                "Get",
                "List",
                "Encrypt",
                "Decrypt",
            ])
        ```

        ## Import

        Key Vault Access Policies can be imported using the Resource ID of the Key Vault, plus some additional metadata.

        If both an `object_id` and `application_id` are specified, then the Access Policy can be imported using the following code:

        ```sh
        $ pulumi import azure:keyvault/accessPolicy:AccessPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.KeyVault/vaults/test-vault/objectId/11111111-1111-1111-1111-111111111111/applicationId/22222222-2222-2222-2222-222222222222
        ```

        where `11111111-1111-1111-1111-111111111111` is the `object_id` and `22222222-2222-2222-2222-222222222222` is the `application_id`.

        ***

        Access Policies with an `object_id` but no `application_id` can be imported using the following command:

        ```sh
        $ pulumi import azure:keyvault/accessPolicy:AccessPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.KeyVault/vaults/test-vault/objectId/11111111-1111-1111-1111-111111111111
        ```

        where `11111111-1111-1111-1111-111111111111` is the `object_id`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: The object ID of an Application in Azure Active Directory. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_permissions: List of certificate permissions, must be one or more from the following: `Backup`, `Create`, `Delete`, `DeleteIssuers`, `Get`, `GetIssuers`, `Import`, `List`, `ListIssuers`, `ManageContacts`, `ManageIssuers`, `Purge`, `Recover`, `Restore`, `SetIssuers` and `Update`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_permissions: List of key permissions, must be one or more from the following: `Backup`, `Create`, `Decrypt`, `Delete`, `Encrypt`, `Get`, `Import`, `List`, `Purge`, `Recover`, `Restore`, `Sign`, `UnwrapKey`, `Update`, `Verify`, `WrapKey`, `Release`, `Rotate`, `GetRotationPolicy` and `SetRotationPolicy`.
        :param pulumi.Input[_builtins.str] key_vault_id: Specifies the id of the Key Vault resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] object_id: The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID of a service principal can be fetched from `azuread_service_principal.object_id`. The object ID must be unique for the list of access policies. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secret_permissions: List of secret permissions, must be one or more from the following: `Backup`, `Delete`, `Get`, `List`, `Purge`, `Recover`, `Restore` and `Set`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_permissions: List of storage permissions, must be one or more from the following: `Backup`, `Delete`, `DeleteSAS`, `Get`, `GetSAS`, `List`, `ListSAS`, `Purge`, `Recover`, `RegenerateKey`, `Restore`, `Set`, `SetSAS` and `Update`.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Key Vault Access Policy.

        > **NOTE:** It's possible to define Key Vault Access Policies both within the `keyvault.KeyVault` resource via the `access_policy` block and by using the `keyvault.AccessPolicy` resource. However it's not possible to use both methods to manage Access Policies within a KeyVault, since there'll be conflicts.

        > **NOTE:** Azure permits a maximum of 1024 Access Policies per Key Vault - [more information can be found in this document](https://docs.microsoft.com/azure/key-vault/key-vault-secure-your-key-vault#data-plane-access-control).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        current = azure.core.get_client_config()
        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="examplekeyvault",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            tenant_id=current.tenant_id,
            sku_name="premium")
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=["Get"],
            secret_permissions=["Get"])
        example = azuread.get_service_principal(display_name="example-app")
        example_principal = azure.keyvault.AccessPolicy("example-principal",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=example.object_id,
            key_permissions=[
                "Get",
                "List",
                "Encrypt",
                "Decrypt",
            ])
        ```

        ## Import

        Key Vault Access Policies can be imported using the Resource ID of the Key Vault, plus some additional metadata.

        If both an `object_id` and `application_id` are specified, then the Access Policy can be imported using the following code:

        ```sh
        $ pulumi import azure:keyvault/accessPolicy:AccessPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.KeyVault/vaults/test-vault/objectId/11111111-1111-1111-1111-111111111111/applicationId/22222222-2222-2222-2222-222222222222
        ```

        where `11111111-1111-1111-1111-111111111111` is the `object_id` and `22222222-2222-2222-2222-222222222222` is the `application_id`.

        ***

        Access Policies with an `object_id` but no `application_id` can be imported using the following command:

        ```sh
        $ pulumi import azure:keyvault/accessPolicy:AccessPolicy example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.KeyVault/vaults/test-vault/objectId/11111111-1111-1111-1111-111111111111
        ```

        where `11111111-1111-1111-1111-111111111111` is the `object_id`.

        :param str resource_name: The name of the resource.
        :param AccessPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 certificate_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 storage_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessPolicyArgs.__new__(AccessPolicyArgs)

            __props__.__dict__["application_id"] = application_id
            __props__.__dict__["certificate_permissions"] = certificate_permissions
            __props__.__dict__["key_permissions"] = key_permissions
            if key_vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_vault_id'")
            __props__.__dict__["key_vault_id"] = key_vault_id
            if object_id is None and not opts.urn:
                raise TypeError("Missing required property 'object_id'")
            __props__.__dict__["object_id"] = object_id
            __props__.__dict__["secret_permissions"] = secret_permissions
            __props__.__dict__["storage_permissions"] = storage_permissions
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        super(AccessPolicy, __self__).__init__(
            'azure:keyvault/accessPolicy:AccessPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_id: Optional[pulumi.Input[_builtins.str]] = None,
            certificate_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            key_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            object_id: Optional[pulumi.Input[_builtins.str]] = None,
            secret_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            storage_permissions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccessPolicy':
        """
        Get an existing AccessPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_id: The object ID of an Application in Azure Active Directory. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] certificate_permissions: List of certificate permissions, must be one or more from the following: `Backup`, `Create`, `Delete`, `DeleteIssuers`, `Get`, `GetIssuers`, `Import`, `List`, `ListIssuers`, `ManageContacts`, `ManageIssuers`, `Purge`, `Recover`, `Restore`, `SetIssuers` and `Update`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] key_permissions: List of key permissions, must be one or more from the following: `Backup`, `Create`, `Decrypt`, `Delete`, `Encrypt`, `Get`, `Import`, `List`, `Purge`, `Recover`, `Restore`, `Sign`, `UnwrapKey`, `Update`, `Verify`, `WrapKey`, `Release`, `Rotate`, `GetRotationPolicy` and `SetRotationPolicy`.
        :param pulumi.Input[_builtins.str] key_vault_id: Specifies the id of the Key Vault resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] object_id: The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID of a service principal can be fetched from `azuread_service_principal.object_id`. The object ID must be unique for the list of access policies. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] secret_permissions: List of secret permissions, must be one or more from the following: `Backup`, `Delete`, `Get`, `List`, `Purge`, `Recover`, `Restore` and `Set`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] storage_permissions: List of storage permissions, must be one or more from the following: `Backup`, `Delete`, `DeleteSAS`, `Get`, `GetSAS`, `List`, `ListSAS`, `Purge`, `Recover`, `RegenerateKey`, `Restore`, `Set`, `SetSAS` and `Update`.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessPolicyState.__new__(_AccessPolicyState)

        __props__.__dict__["application_id"] = application_id
        __props__.__dict__["certificate_permissions"] = certificate_permissions
        __props__.__dict__["key_permissions"] = key_permissions
        __props__.__dict__["key_vault_id"] = key_vault_id
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["secret_permissions"] = secret_permissions
        __props__.__dict__["storage_permissions"] = storage_permissions
        __props__.__dict__["tenant_id"] = tenant_id
        return AccessPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The object ID of an Application in Azure Active Directory. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_id")

    @_builtins.property
    @pulumi.getter(name="certificatePermissions")
    def certificate_permissions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of certificate permissions, must be one or more from the following: `Backup`, `Create`, `Delete`, `DeleteIssuers`, `Get`, `GetIssuers`, `Import`, `List`, `ListIssuers`, `ManageContacts`, `ManageIssuers`, `Purge`, `Recover`, `Restore`, `SetIssuers` and `Update`.
        """
        return pulumi.get(self, "certificate_permissions")

    @_builtins.property
    @pulumi.getter(name="keyPermissions")
    def key_permissions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of key permissions, must be one or more from the following: `Backup`, `Create`, `Decrypt`, `Delete`, `Encrypt`, `Get`, `Import`, `List`, `Purge`, `Recover`, `Restore`, `Sign`, `UnwrapKey`, `Update`, `Verify`, `WrapKey`, `Release`, `Rotate`, `GetRotationPolicy` and `SetRotationPolicy`.
        """
        return pulumi.get(self, "key_permissions")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the id of the Key Vault resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.str]:
        """
        The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault. The object ID of a service principal can be fetched from `azuread_service_principal.object_id`. The object ID must be unique for the list of access policies. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="secretPermissions")
    def secret_permissions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of secret permissions, must be one or more from the following: `Backup`, `Delete`, `Get`, `List`, `Purge`, `Recover`, `Restore` and `Set`.
        """
        return pulumi.get(self, "secret_permissions")

    @_builtins.property
    @pulumi.getter(name="storagePermissions")
    def storage_permissions(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of storage permissions, must be one or more from the following: `Backup`, `Delete`, `DeleteSAS`, `Get`, `GetSAS`, `List`, `ListSAS`, `Purge`, `Recover`, `RegenerateKey`, `Restore`, `Set`, `SetSAS` and `Update`.
        """
        return pulumi.get(self, "storage_permissions")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tenant_id")

