# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagedStorageAccountSasTokenDefinitionArgs', 'ManagedStorageAccountSasTokenDefinition']

@pulumi.input_type
class ManagedStorageAccountSasTokenDefinitionArgs:
    def __init__(__self__, *,
                 managed_storage_account_id: pulumi.Input[_builtins.str],
                 sas_template_uri: pulumi.Input[_builtins.str],
                 sas_type: pulumi.Input[_builtins.str],
                 validity_period: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ManagedStorageAccountSasTokenDefinition resource.
        :param pulumi.Input[_builtins.str] managed_storage_account_id: The ID of the Managed Storage Account.
        :param pulumi.Input[_builtins.str] sas_template_uri: The SAS definition token template signed with an arbitrary key. Tokens created according to the SAS definition will have the same properties as the template, but regenerated with a new validity period.
        :param pulumi.Input[_builtins.str] sas_type: The type of SAS token the SAS definition will create. Possible values are `account` and `service`.
        :param pulumi.Input[_builtins.str] validity_period: Validity period of SAS token. Value needs to be in [ISO 8601 duration format](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        :param pulumi.Input[_builtins.str] name: The name which should be used for this SAS Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the SAS Definition. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "managed_storage_account_id", managed_storage_account_id)
        pulumi.set(__self__, "sas_template_uri", sas_template_uri)
        pulumi.set(__self__, "sas_type", sas_type)
        pulumi.set(__self__, "validity_period", validity_period)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="managedStorageAccountId")
    def managed_storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Managed Storage Account.
        """
        return pulumi.get(self, "managed_storage_account_id")

    @managed_storage_account_id.setter
    def managed_storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "managed_storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="sasTemplateUri")
    def sas_template_uri(self) -> pulumi.Input[_builtins.str]:
        """
        The SAS definition token template signed with an arbitrary key. Tokens created according to the SAS definition will have the same properties as the template, but regenerated with a new validity period.
        """
        return pulumi.get(self, "sas_template_uri")

    @sas_template_uri.setter
    def sas_template_uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sas_template_uri", value)

    @_builtins.property
    @pulumi.getter(name="sasType")
    def sas_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of SAS token the SAS definition will create. Possible values are `account` and `service`.
        """
        return pulumi.get(self, "sas_type")

    @sas_type.setter
    def sas_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sas_type", value)

    @_builtins.property
    @pulumi.getter(name="validityPeriod")
    def validity_period(self) -> pulumi.Input[_builtins.str]:
        """
        Validity period of SAS token. Value needs to be in [ISO 8601 duration format](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        return pulumi.get(self, "validity_period")

    @validity_period.setter
    def validity_period(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "validity_period", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this SAS Definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the SAS Definition. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ManagedStorageAccountSasTokenDefinitionState:
    def __init__(__self__, *,
                 managed_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_template_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_type: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validity_period: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedStorageAccountSasTokenDefinition resources.
        :param pulumi.Input[_builtins.str] managed_storage_account_id: The ID of the Managed Storage Account.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this SAS Definition.
        :param pulumi.Input[_builtins.str] sas_template_uri: The SAS definition token template signed with an arbitrary key. Tokens created according to the SAS definition will have the same properties as the template, but regenerated with a new validity period.
        :param pulumi.Input[_builtins.str] sas_type: The type of SAS token the SAS definition will create. Possible values are `account` and `service`.
        :param pulumi.Input[_builtins.str] secret_id: The ID of the Secret that is created by Managed Storage Account SAS Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the SAS Definition. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] validity_period: Validity period of SAS token. Value needs to be in [ISO 8601 duration format](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        if managed_storage_account_id is not None:
            pulumi.set(__self__, "managed_storage_account_id", managed_storage_account_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sas_template_uri is not None:
            pulumi.set(__self__, "sas_template_uri", sas_template_uri)
        if sas_type is not None:
            pulumi.set(__self__, "sas_type", sas_type)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if validity_period is not None:
            pulumi.set(__self__, "validity_period", validity_period)

    @_builtins.property
    @pulumi.getter(name="managedStorageAccountId")
    def managed_storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Managed Storage Account.
        """
        return pulumi.get(self, "managed_storage_account_id")

    @managed_storage_account_id.setter
    def managed_storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_storage_account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this SAS Definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="sasTemplateUri")
    def sas_template_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SAS definition token template signed with an arbitrary key. Tokens created according to the SAS definition will have the same properties as the template, but regenerated with a new validity period.
        """
        return pulumi.get(self, "sas_template_uri")

    @sas_template_uri.setter
    def sas_template_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_template_uri", value)

    @_builtins.property
    @pulumi.getter(name="sasType")
    def sas_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of SAS token the SAS definition will create. Possible values are `account` and `service`.
        """
        return pulumi.get(self, "sas_type")

    @sas_type.setter
    def sas_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_type", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Secret that is created by Managed Storage Account SAS Definition.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the SAS Definition. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="validityPeriod")
    def validity_period(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Validity period of SAS token. Value needs to be in [ISO 8601 duration format](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        return pulumi.get(self, "validity_period")

    @validity_period.setter
    def validity_period(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "validity_period", value)


@pulumi.type_token("azure:keyvault/managedStorageAccountSasTokenDefinition:ManagedStorageAccountSasTokenDefinition")
class ManagedStorageAccountSasTokenDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_template_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validity_period: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Key Vault Managed Storage Account SAS Definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.get_client_config()
        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_get_account_sas = azure.storage.get_account_sas_output(connection_string=example_account.primary_connection_string,
            https_only=True,
            resource_types={
                "service": True,
                "container": False,
                "object": False,
            },
            services={
                "blob": True,
                "queue": False,
                "table": False,
                "file": False,
            },
            start="2021-04-30T00:00:00Z",
            expiry="2023-04-30T00:00:00Z",
            permissions={
                "read": True,
                "write": True,
                "delete": False,
                "list": False,
                "add": True,
                "create": True,
                "update": False,
                "process": False,
                "tag": False,
                "filter": False,
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-keyvault",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            tenant_id=example.tenant_id,
            sku_name="standard",
            access_policies=[{
                "tenant_id": example.tenant_id,
                "object_id": example.object_id,
                "secret_permissions": [
                    "Get",
                    "Delete",
                ],
                "storage_permissions": [
                    "Get",
                    "List",
                    "Set",
                    "SetSAS",
                    "GetSAS",
                    "DeleteSAS",
                    "Update",
                    "RegenerateKey",
                ],
            }])
        example_managed_storage_account = azure.keyvault.ManagedStorageAccount("example",
            name="examplemanagedstorage",
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            storage_account_key="key1",
            regenerate_key_automatically=False,
            regeneration_period="P1D")
        example_managed_storage_account_sas_token_definition = azure.keyvault.ManagedStorageAccountSasTokenDefinition("example",
            name="examplesasdefinition",
            validity_period="P1D",
            managed_storage_account_id=example_managed_storage_account.id,
            sas_template_uri=example_get_account_sas.sas,
            sas_type="account")
        ```

        ## Import

        Key Vaults can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/managedStorageAccountSasTokenDefinition:ManagedStorageAccountSasTokenDefinition example https://example-keyvault.vault.azure.net/storage/exampleStorageAcc01/sas/exampleSasDefinition01
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] managed_storage_account_id: The ID of the Managed Storage Account.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this SAS Definition.
        :param pulumi.Input[_builtins.str] sas_template_uri: The SAS definition token template signed with an arbitrary key. Tokens created according to the SAS definition will have the same properties as the template, but regenerated with a new validity period.
        :param pulumi.Input[_builtins.str] sas_type: The type of SAS token the SAS definition will create. Possible values are `account` and `service`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the SAS Definition. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] validity_period: Validity period of SAS token. Value needs to be in [ISO 8601 duration format](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedStorageAccountSasTokenDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Key Vault Managed Storage Account SAS Definition.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.get_client_config()
        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="storageaccountname",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_get_account_sas = azure.storage.get_account_sas_output(connection_string=example_account.primary_connection_string,
            https_only=True,
            resource_types={
                "service": True,
                "container": False,
                "object": False,
            },
            services={
                "blob": True,
                "queue": False,
                "table": False,
                "file": False,
            },
            start="2021-04-30T00:00:00Z",
            expiry="2023-04-30T00:00:00Z",
            permissions={
                "read": True,
                "write": True,
                "delete": False,
                "list": False,
                "add": True,
                "create": True,
                "update": False,
                "process": False,
                "tag": False,
                "filter": False,
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-keyvault",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            tenant_id=example.tenant_id,
            sku_name="standard",
            access_policies=[{
                "tenant_id": example.tenant_id,
                "object_id": example.object_id,
                "secret_permissions": [
                    "Get",
                    "Delete",
                ],
                "storage_permissions": [
                    "Get",
                    "List",
                    "Set",
                    "SetSAS",
                    "GetSAS",
                    "DeleteSAS",
                    "Update",
                    "RegenerateKey",
                ],
            }])
        example_managed_storage_account = azure.keyvault.ManagedStorageAccount("example",
            name="examplemanagedstorage",
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            storage_account_key="key1",
            regenerate_key_automatically=False,
            regeneration_period="P1D")
        example_managed_storage_account_sas_token_definition = azure.keyvault.ManagedStorageAccountSasTokenDefinition("example",
            name="examplesasdefinition",
            validity_period="P1D",
            managed_storage_account_id=example_managed_storage_account.id,
            sas_template_uri=example_get_account_sas.sas,
            sas_type="account")
        ```

        ## Import

        Key Vaults can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:keyvault/managedStorageAccountSasTokenDefinition:ManagedStorageAccountSasTokenDefinition example https://example-keyvault.vault.azure.net/storage/exampleStorageAcc01/sas/exampleSasDefinition01
        ```

        :param str resource_name: The name of the resource.
        :param ManagedStorageAccountSasTokenDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedStorageAccountSasTokenDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_template_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 sas_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validity_period: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedStorageAccountSasTokenDefinitionArgs.__new__(ManagedStorageAccountSasTokenDefinitionArgs)

            if managed_storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_storage_account_id'")
            __props__.__dict__["managed_storage_account_id"] = managed_storage_account_id
            __props__.__dict__["name"] = name
            if sas_template_uri is None and not opts.urn:
                raise TypeError("Missing required property 'sas_template_uri'")
            __props__.__dict__["sas_template_uri"] = sas_template_uri
            if sas_type is None and not opts.urn:
                raise TypeError("Missing required property 'sas_type'")
            __props__.__dict__["sas_type"] = sas_type
            __props__.__dict__["tags"] = tags
            if validity_period is None and not opts.urn:
                raise TypeError("Missing required property 'validity_period'")
            __props__.__dict__["validity_period"] = validity_period
            __props__.__dict__["secret_id"] = None
        super(ManagedStorageAccountSasTokenDefinition, __self__).__init__(
            'azure:keyvault/managedStorageAccountSasTokenDefinition:ManagedStorageAccountSasTokenDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            sas_template_uri: Optional[pulumi.Input[_builtins.str]] = None,
            sas_type: Optional[pulumi.Input[_builtins.str]] = None,
            secret_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            validity_period: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedStorageAccountSasTokenDefinition':
        """
        Get an existing ManagedStorageAccountSasTokenDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] managed_storage_account_id: The ID of the Managed Storage Account.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this SAS Definition.
        :param pulumi.Input[_builtins.str] sas_template_uri: The SAS definition token template signed with an arbitrary key. Tokens created according to the SAS definition will have the same properties as the template, but regenerated with a new validity period.
        :param pulumi.Input[_builtins.str] sas_type: The type of SAS token the SAS definition will create. Possible values are `account` and `service`.
        :param pulumi.Input[_builtins.str] secret_id: The ID of the Secret that is created by Managed Storage Account SAS Definition.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the SAS Definition. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] validity_period: Validity period of SAS token. Value needs to be in [ISO 8601 duration format](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedStorageAccountSasTokenDefinitionState.__new__(_ManagedStorageAccountSasTokenDefinitionState)

        __props__.__dict__["managed_storage_account_id"] = managed_storage_account_id
        __props__.__dict__["name"] = name
        __props__.__dict__["sas_template_uri"] = sas_template_uri
        __props__.__dict__["sas_type"] = sas_type
        __props__.__dict__["secret_id"] = secret_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["validity_period"] = validity_period
        return ManagedStorageAccountSasTokenDefinition(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="managedStorageAccountId")
    def managed_storage_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Managed Storage Account.
        """
        return pulumi.get(self, "managed_storage_account_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this SAS Definition.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sasTemplateUri")
    def sas_template_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The SAS definition token template signed with an arbitrary key. Tokens created according to the SAS definition will have the same properties as the template, but regenerated with a new validity period.
        """
        return pulumi.get(self, "sas_template_uri")

    @_builtins.property
    @pulumi.getter(name="sasType")
    def sas_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of SAS token the SAS definition will create. Possible values are `account` and `service`.
        """
        return pulumi.get(self, "sas_type")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Secret that is created by Managed Storage Account SAS Definition.
        """
        return pulumi.get(self, "secret_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the SAS Definition. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="validityPeriod")
    def validity_period(self) -> pulumi.Output[_builtins.str]:
        """
        Validity period of SAS token. Value needs to be in [ISO 8601 duration format](https://en.wikipedia.org/wiki/ISO_8601#Durations).
        """
        return pulumi.get(self, "validity_period")

