# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProbeArgs', 'Probe']

@pulumi.input_type
class ProbeArgs:
    def __init__(__self__, *,
                 loadbalancer_id: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int],
                 interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_probes: Optional[pulumi.Input[_builtins.int]] = None,
                 probe_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 request_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Probe resource.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the LoadBalancer in which to create the Probe. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] port: Port on which the Probe queries the backend endpoint. Possible values range from 1 to 65535, inclusive.
        :param pulumi.Input[_builtins.int] interval_in_seconds: The interval, in seconds between probes to the backend endpoint for health status. The default value is 15, the minimum value is 5.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Probe. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] number_of_probes: The number of failed probe attempts after which the backend endpoint is removed from rotation. Default to `2`. NumberOfProbes multiplied by intervalInSeconds value must be greater or equal to 10.Endpoints are returned to rotation when at least one probe is successful.
        :param pulumi.Input[_builtins.int] probe_threshold: The number of consecutive successful or failed probes that allow or deny traffic to this endpoint. Possible values range from `1` to `100`. The default value is `1`.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol of the end point. Possible values are `Http`, `Https` or `Tcp`. If TCP is specified, a received ACK is required for the probe to be successful. If HTTP is specified, a 200 OK response from the specified URI is required for the probe to be successful. Defaults to `Tcp`.
        :param pulumi.Input[_builtins.str] request_path: The URI used for requesting health status from the backend endpoint. Required if protocol is set to `Http` or `Https`. Otherwise, it is not allowed.
        """
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "port", port)
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_probes is not None:
            pulumi.set(__self__, "number_of_probes", number_of_probes)
        if probe_threshold is not None:
            pulumi.set(__self__, "probe_threshold", probe_threshold)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the LoadBalancer in which to create the Probe. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        Port on which the Probe queries the backend endpoint. Possible values range from 1 to 65535, inclusive.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The interval, in seconds between probes to the backend endpoint for health status. The default value is 15, the minimum value is 5.
        """
        return pulumi.get(self, "interval_in_seconds")

    @interval_in_seconds.setter
    def interval_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Probe. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfProbes")
    def number_of_probes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of failed probe attempts after which the backend endpoint is removed from rotation. Default to `2`. NumberOfProbes multiplied by intervalInSeconds value must be greater or equal to 10.Endpoints are returned to rotation when at least one probe is successful.
        """
        return pulumi.get(self, "number_of_probes")

    @number_of_probes.setter
    def number_of_probes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_probes", value)

    @_builtins.property
    @pulumi.getter(name="probeThreshold")
    def probe_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive successful or failed probes that allow or deny traffic to this endpoint. Possible values range from `1` to `100`. The default value is `1`.
        """
        return pulumi.get(self, "probe_threshold")

    @probe_threshold.setter
    def probe_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "probe_threshold", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol of the end point. Possible values are `Http`, `Https` or `Tcp`. If TCP is specified, a received ACK is required for the probe to be successful. If HTTP is specified, a 200 OK response from the specified URI is required for the probe to be successful. Defaults to `Tcp`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI used for requesting health status from the backend endpoint. Required if protocol is set to `Http` or `Https`. Otherwise, it is not allowed.
        """
        return pulumi.get(self, "request_path")

    @request_path.setter
    def request_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_path", value)


@pulumi.input_type
class _ProbeState:
    def __init__(__self__, *,
                 interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 load_balancer_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_probes: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 probe_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 request_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Probe resources.
        :param pulumi.Input[_builtins.int] interval_in_seconds: The interval, in seconds between probes to the backend endpoint for health status. The default value is 15, the minimum value is 5.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the LoadBalancer in which to create the Probe. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Probe. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] number_of_probes: The number of failed probe attempts after which the backend endpoint is removed from rotation. Default to `2`. NumberOfProbes multiplied by intervalInSeconds value must be greater or equal to 10.Endpoints are returned to rotation when at least one probe is successful.
        :param pulumi.Input[_builtins.int] port: Port on which the Probe queries the backend endpoint. Possible values range from 1 to 65535, inclusive.
        :param pulumi.Input[_builtins.int] probe_threshold: The number of consecutive successful or failed probes that allow or deny traffic to this endpoint. Possible values range from `1` to `100`. The default value is `1`.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol of the end point. Possible values are `Http`, `Https` or `Tcp`. If TCP is specified, a received ACK is required for the probe to be successful. If HTTP is specified, a 200 OK response from the specified URI is required for the probe to be successful. Defaults to `Tcp`.
        :param pulumi.Input[_builtins.str] request_path: The URI used for requesting health status from the backend endpoint. Required if protocol is set to `Http` or `Https`. Otherwise, it is not allowed.
        """
        if interval_in_seconds is not None:
            pulumi.set(__self__, "interval_in_seconds", interval_in_seconds)
        if load_balancer_rules is not None:
            pulumi.set(__self__, "load_balancer_rules", load_balancer_rules)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_probes is not None:
            pulumi.set(__self__, "number_of_probes", number_of_probes)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if probe_threshold is not None:
            pulumi.set(__self__, "probe_threshold", probe_threshold)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)

    @_builtins.property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The interval, in seconds between probes to the backend endpoint for health status. The default value is 15, the minimum value is 5.
        """
        return pulumi.get(self, "interval_in_seconds")

    @interval_in_seconds.setter
    def interval_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "interval_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerRules")
    def load_balancer_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "load_balancer_rules")

    @load_balancer_rules.setter
    def load_balancer_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "load_balancer_rules", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the LoadBalancer in which to create the Probe. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Probe. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfProbes")
    def number_of_probes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of failed probe attempts after which the backend endpoint is removed from rotation. Default to `2`. NumberOfProbes multiplied by intervalInSeconds value must be greater or equal to 10.Endpoints are returned to rotation when at least one probe is successful.
        """
        return pulumi.get(self, "number_of_probes")

    @number_of_probes.setter
    def number_of_probes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_probes", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Port on which the Probe queries the backend endpoint. Possible values range from 1 to 65535, inclusive.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="probeThreshold")
    def probe_threshold(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of consecutive successful or failed probes that allow or deny traffic to this endpoint. Possible values range from `1` to `100`. The default value is `1`.
        """
        return pulumi.get(self, "probe_threshold")

    @probe_threshold.setter
    def probe_threshold(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "probe_threshold", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the protocol of the end point. Possible values are `Http`, `Https` or `Tcp`. If TCP is specified, a received ACK is required for the probe to be successful. If HTTP is specified, a 200 OK response from the specified URI is required for the probe to be successful. Defaults to `Tcp`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI used for requesting health status from the backend endpoint. Required if protocol is set to `Http` or `Https`. Otherwise, it is not allowed.
        """
        return pulumi.get(self, "request_path")

    @request_path.setter
    def request_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_path", value)


@pulumi.type_token("azure:lb/probe:Probe")
class Probe(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_probes: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 probe_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 request_path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a LoadBalancer Probe Resource.

        > **Note:** When using this resource, the Load Balancer needs to have a FrontEnd IP Configuration Attached

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="LoadBalancerRG",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="PublicIPForLB",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="TestLoadBalancer",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        example_probe = azure.lb.Probe("example",
            loadbalancer_id=example_load_balancer.id,
            name="ssh-running-probe",
            port=22)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2023-09-01

        ## Import

        Load Balancer Probes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/probe:Probe example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/lb1/probes/probe1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] interval_in_seconds: The interval, in seconds between probes to the backend endpoint for health status. The default value is 15, the minimum value is 5.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the LoadBalancer in which to create the Probe. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Probe. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] number_of_probes: The number of failed probe attempts after which the backend endpoint is removed from rotation. Default to `2`. NumberOfProbes multiplied by intervalInSeconds value must be greater or equal to 10.Endpoints are returned to rotation when at least one probe is successful.
        :param pulumi.Input[_builtins.int] port: Port on which the Probe queries the backend endpoint. Possible values range from 1 to 65535, inclusive.
        :param pulumi.Input[_builtins.int] probe_threshold: The number of consecutive successful or failed probes that allow or deny traffic to this endpoint. Possible values range from `1` to `100`. The default value is `1`.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol of the end point. Possible values are `Http`, `Https` or `Tcp`. If TCP is specified, a received ACK is required for the probe to be successful. If HTTP is specified, a 200 OK response from the specified URI is required for the probe to be successful. Defaults to `Tcp`.
        :param pulumi.Input[_builtins.str] request_path: The URI used for requesting health status from the backend endpoint. Required if protocol is set to `Http` or `Https`. Otherwise, it is not allowed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProbeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a LoadBalancer Probe Resource.

        > **Note:** When using this resource, the Load Balancer needs to have a FrontEnd IP Configuration Attached

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="LoadBalancerRG",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="PublicIPForLB",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="TestLoadBalancer",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        example_probe = azure.lb.Probe("example",
            loadbalancer_id=example_load_balancer.id,
            name="ssh-running-probe",
            port=22)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network`: 2023-09-01

        ## Import

        Load Balancer Probes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/probe:Probe example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/lb1/probes/probe1
        ```

        :param str resource_name: The name of the resource.
        :param ProbeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProbeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_probes: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 probe_threshold: Optional[pulumi.Input[_builtins.int]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 request_path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProbeArgs.__new__(ProbeArgs)

            __props__.__dict__["interval_in_seconds"] = interval_in_seconds
            if loadbalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'loadbalancer_id'")
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            __props__.__dict__["name"] = name
            __props__.__dict__["number_of_probes"] = number_of_probes
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            __props__.__dict__["probe_threshold"] = probe_threshold
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["request_path"] = request_path
            __props__.__dict__["load_balancer_rules"] = None
        super(Probe, __self__).__init__(
            'azure:lb/probe:Probe',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            load_balancer_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            number_of_probes: Optional[pulumi.Input[_builtins.int]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            probe_threshold: Optional[pulumi.Input[_builtins.int]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            request_path: Optional[pulumi.Input[_builtins.str]] = None) -> 'Probe':
        """
        Get an existing Probe resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] interval_in_seconds: The interval, in seconds between probes to the backend endpoint for health status. The default value is 15, the minimum value is 5.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the LoadBalancer in which to create the Probe. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Probe. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] number_of_probes: The number of failed probe attempts after which the backend endpoint is removed from rotation. Default to `2`. NumberOfProbes multiplied by intervalInSeconds value must be greater or equal to 10.Endpoints are returned to rotation when at least one probe is successful.
        :param pulumi.Input[_builtins.int] port: Port on which the Probe queries the backend endpoint. Possible values range from 1 to 65535, inclusive.
        :param pulumi.Input[_builtins.int] probe_threshold: The number of consecutive successful or failed probes that allow or deny traffic to this endpoint. Possible values range from `1` to `100`. The default value is `1`.
        :param pulumi.Input[_builtins.str] protocol: Specifies the protocol of the end point. Possible values are `Http`, `Https` or `Tcp`. If TCP is specified, a received ACK is required for the probe to be successful. If HTTP is specified, a 200 OK response from the specified URI is required for the probe to be successful. Defaults to `Tcp`.
        :param pulumi.Input[_builtins.str] request_path: The URI used for requesting health status from the backend endpoint. Required if protocol is set to `Http` or `Https`. Otherwise, it is not allowed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProbeState.__new__(_ProbeState)

        __props__.__dict__["interval_in_seconds"] = interval_in_seconds
        __props__.__dict__["load_balancer_rules"] = load_balancer_rules
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_probes"] = number_of_probes
        __props__.__dict__["port"] = port
        __props__.__dict__["probe_threshold"] = probe_threshold
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["request_path"] = request_path
        return Probe(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The interval, in seconds between probes to the backend endpoint for health status. The default value is 15, the minimum value is 5.
        """
        return pulumi.get(self, "interval_in_seconds")

    @_builtins.property
    @pulumi.getter(name="loadBalancerRules")
    def load_balancer_rules(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "load_balancer_rules")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the LoadBalancer in which to create the Probe. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Probe. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numberOfProbes")
    def number_of_probes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of failed probe attempts after which the backend endpoint is removed from rotation. Default to `2`. NumberOfProbes multiplied by intervalInSeconds value must be greater or equal to 10.Endpoints are returned to rotation when at least one probe is successful.
        """
        return pulumi.get(self, "number_of_probes")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        Port on which the Probe queries the backend endpoint. Possible values range from 1 to 65535, inclusive.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="probeThreshold")
    def probe_threshold(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of consecutive successful or failed probes that allow or deny traffic to this endpoint. Possible values range from `1` to `100`. The default value is `1`.
        """
        return pulumi.get(self, "probe_threshold")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the protocol of the end point. Possible values are `Http`, `Https` or `Tcp`. If TCP is specified, a received ACK is required for the probe to be successful. If HTTP is specified, a 200 OK response from the specified URI is required for the probe to be successful. Defaults to `Tcp`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URI used for requesting health status from the backend endpoint. Required if protocol is set to `Http` or `Https`. Otherwise, it is not allowed.
        """
        return pulumi.get(self, "request_path")

