# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SavedSearchArgs', 'SavedSearch']

@pulumi.input_type
class SavedSearchArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[_builtins.str],
                 display_name: pulumi.Input[_builtins.str],
                 log_analytics_workspace_id: pulumi.Input[_builtins.str],
                 query: pulumi.Input[_builtins.str],
                 function_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 function_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a SavedSearch resource.
        :param pulumi.Input[_builtins.str] category: The category that the Saved Search will be listed under. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] display_name: The name that Saved Search will be displayed as. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: Specifies the ID of the Log Analytics Workspace that the Saved Search will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query: The query expression for the saved search. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] function_alias: The function alias if the query serves as a function. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] function_parameters: The function parameters if the query serves as a function. Changing this forces a new resource to be created. For more examples and proper syntax please refer to [this document](https://learn.microsoft.com/en-us/azure/data-explorer/kusto/query/functions/user-defined-functions).
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Log Analytics Saved Search. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Logs Analytics Saved Search. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        pulumi.set(__self__, "query", query)
        if function_alias is not None:
            pulumi.set(__self__, "function_alias", function_alias)
        if function_parameters is not None:
            pulumi.set(__self__, "function_parameters", function_parameters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Input[_builtins.str]:
        """
        The category that the Saved Search will be listed under. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name that Saved Search will be displayed as. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Log Analytics Workspace that the Saved Search will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Input[_builtins.str]:
        """
        The query expression for the saved search. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter(name="functionAlias")
    def function_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The function alias if the query serves as a function. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_alias")

    @function_alias.setter
    def function_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_alias", value)

    @_builtins.property
    @pulumi.getter(name="functionParameters")
    def function_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The function parameters if the query serves as a function. Changing this forces a new resource to be created. For more examples and proper syntax please refer to [this document](https://learn.microsoft.com/en-us/azure/data-explorer/kusto/query/functions/user-defined-functions).
        """
        return pulumi.get(self, "function_parameters")

    @function_parameters.setter
    def function_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "function_parameters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Log Analytics Saved Search. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Logs Analytics Saved Search. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _SavedSearchState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 function_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 function_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering SavedSearch resources.
        :param pulumi.Input[_builtins.str] category: The category that the Saved Search will be listed under. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] display_name: The name that Saved Search will be displayed as. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] function_alias: The function alias if the query serves as a function. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] function_parameters: The function parameters if the query serves as a function. Changing this forces a new resource to be created. For more examples and proper syntax please refer to [this document](https://learn.microsoft.com/en-us/azure/data-explorer/kusto/query/functions/user-defined-functions).
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: Specifies the ID of the Log Analytics Workspace that the Saved Search will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Log Analytics Saved Search. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query: The query expression for the saved search. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Logs Analytics Saved Search. Changing this forces a new resource to be created.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if function_alias is not None:
            pulumi.set(__self__, "function_alias", function_alias)
        if function_parameters is not None:
            pulumi.set(__self__, "function_parameters", function_parameters)
        if log_analytics_workspace_id is not None:
            pulumi.set(__self__, "log_analytics_workspace_id", log_analytics_workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The category that the Saved Search will be listed under. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "category", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name that Saved Search will be displayed as. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="functionAlias")
    def function_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The function alias if the query serves as a function. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_alias")

    @function_alias.setter
    def function_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_alias", value)

    @_builtins.property
    @pulumi.getter(name="functionParameters")
    def function_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The function parameters if the query serves as a function. Changing this forces a new resource to be created. For more examples and proper syntax please refer to [this document](https://learn.microsoft.com/en-us/azure/data-explorer/kusto/query/functions/user-defined-functions).
        """
        return pulumi.get(self, "function_parameters")

    @function_parameters.setter
    def function_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "function_parameters", value)

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Log Analytics Workspace that the Saved Search will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @log_analytics_workspace_id.setter
    def log_analytics_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_analytics_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Log Analytics Saved Search. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The query expression for the saved search. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Logs Analytics Saved Search. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:loganalytics/savedSearch:SavedSearch")
class SavedSearch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 function_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 function_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Log Analytics (formally Operational Insights) Saved Search.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="acctest-01",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_saved_search = azure.loganalytics.SavedSearch("example",
            name="exampleSavedSearch",
            log_analytics_workspace_id=example_analytics_workspace.id,
            category="exampleCategory",
            display_name="exampleDisplayName",
            query="exampleQuery")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2020-08-01

        ## Import

        Log Analytics Saved Searches can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:loganalytics/savedSearch:SavedSearch search1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1/savedSearches/search1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: The category that the Saved Search will be listed under. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] display_name: The name that Saved Search will be displayed as. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] function_alias: The function alias if the query serves as a function. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] function_parameters: The function parameters if the query serves as a function. Changing this forces a new resource to be created. For more examples and proper syntax please refer to [this document](https://learn.microsoft.com/en-us/azure/data-explorer/kusto/query/functions/user-defined-functions).
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: Specifies the ID of the Log Analytics Workspace that the Saved Search will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Log Analytics Saved Search. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query: The query expression for the saved search. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Logs Analytics Saved Search. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SavedSearchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Log Analytics (formally Operational Insights) Saved Search.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="acctest-01",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_saved_search = azure.loganalytics.SavedSearch("example",
            name="exampleSavedSearch",
            log_analytics_workspace_id=example_analytics_workspace.id,
            category="exampleCategory",
            display_name="exampleDisplayName",
            query="exampleQuery")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2020-08-01

        ## Import

        Log Analytics Saved Searches can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:loganalytics/savedSearch:SavedSearch search1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1/savedSearches/search1
        ```

        :param str resource_name: The name of the resource.
        :param SavedSearchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SavedSearchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 function_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 function_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SavedSearchArgs.__new__(SavedSearchArgs)

            if category is None and not opts.urn:
                raise TypeError("Missing required property 'category'")
            __props__.__dict__["category"] = category
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["function_alias"] = function_alias
            __props__.__dict__["function_parameters"] = function_parameters
            if log_analytics_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'log_analytics_workspace_id'")
            __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
            __props__.__dict__["name"] = name
            if query is None and not opts.urn:
                raise TypeError("Missing required property 'query'")
            __props__.__dict__["query"] = query
            __props__.__dict__["tags"] = tags
        super(SavedSearch, __self__).__init__(
            'azure:loganalytics/savedSearch:SavedSearch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            function_alias: Optional[pulumi.Input[_builtins.str]] = None,
            function_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            log_analytics_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'SavedSearch':
        """
        Get an existing SavedSearch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] category: The category that the Saved Search will be listed under. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] display_name: The name that Saved Search will be displayed as. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] function_alias: The function alias if the query serves as a function. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] function_parameters: The function parameters if the query serves as a function. Changing this forces a new resource to be created. For more examples and proper syntax please refer to [this document](https://learn.microsoft.com/en-us/azure/data-explorer/kusto/query/functions/user-defined-functions).
        :param pulumi.Input[_builtins.str] log_analytics_workspace_id: Specifies the ID of the Log Analytics Workspace that the Saved Search will be associated with. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Log Analytics Saved Search. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query: The query expression for the saved search. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Logs Analytics Saved Search. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SavedSearchState.__new__(_SavedSearchState)

        __props__.__dict__["category"] = category
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["function_alias"] = function_alias
        __props__.__dict__["function_parameters"] = function_parameters
        __props__.__dict__["log_analytics_workspace_id"] = log_analytics_workspace_id
        __props__.__dict__["name"] = name
        __props__.__dict__["query"] = query
        __props__.__dict__["tags"] = tags
        return SavedSearch(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def category(self) -> pulumi.Output[_builtins.str]:
        """
        The category that the Saved Search will be listed under. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "category")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name that Saved Search will be displayed as. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="functionAlias")
    def function_alias(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The function alias if the query serves as a function. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "function_alias")

    @_builtins.property
    @pulumi.getter(name="functionParameters")
    def function_parameters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The function parameters if the query serves as a function. Changing this forces a new resource to be created. For more examples and proper syntax please refer to [this document](https://learn.microsoft.com/en-us/azure/data-explorer/kusto/query/functions/user-defined-functions).
        """
        return pulumi.get(self, "function_parameters")

    @_builtins.property
    @pulumi.getter(name="logAnalyticsWorkspaceId")
    def log_analytics_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Log Analytics Workspace that the Saved Search will be associated with. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "log_analytics_workspace_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Log Analytics Saved Search. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def query(self) -> pulumi.Output[_builtins.str]:
        """
        The query expression for the saved search. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "query")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Logs Analytics Saved Search. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

