# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkflowArgs', 'Workflow']

@pulumi.input_type
class WorkflowArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 access_control: Optional[pulumi.Input['WorkflowAccessControlArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['WorkflowIdentityArgs']] = None,
                 integration_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logic_app_integration_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workflow_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workflow_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 workflow_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Workflow resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Logic App Workflow should be created. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkflowAccessControlArgs'] access_control: A `access_control` block as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the Logic App Workflow enabled? Defaults to `true`.
        :param pulumi.Input['WorkflowIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] integration_service_environment_id: The ID of the Integration Service Environment to which this Logic App Workflow belongs. Changing this forces a new Logic App Workflow to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Logic App Workflow exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] logic_app_integration_account_id: The ID of the integration account linked by this Logic App Workflow.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of Key-Value pairs.
               
               > **Note:** Any parameters specified must exist in the Schema defined in `workflow_parameters`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] workflow_parameters: Specifies a map of Key-Value pairs of the Parameter Definitions to use for this Logic App Workflow. The key is the parameter name, and the value is a JSON encoded string of the parameter definition (see: <https://docs.microsoft.com/azure/logic-apps/logic-apps-workflow-definition-language#parameters>).
        :param pulumi.Input[_builtins.str] workflow_schema: Specifies the Schema to use for this Logic App Workflow. Defaults to `https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workflow_version: Specifies the version of the Schema used for this Logic App Workflow. Defaults to `1.0.0.0`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if integration_service_environment_id is not None:
            pulumi.set(__self__, "integration_service_environment_id", integration_service_environment_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logic_app_integration_account_id is not None:
            pulumi.set(__self__, "logic_app_integration_account_id", logic_app_integration_account_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workflow_parameters is not None:
            pulumi.set(__self__, "workflow_parameters", workflow_parameters)
        if workflow_schema is not None:
            pulumi.set(__self__, "workflow_schema", workflow_schema)
        if workflow_version is not None:
            pulumi.set(__self__, "workflow_version", workflow_version)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the Logic App Workflow should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional[pulumi.Input['WorkflowAccessControlArgs']]:
        """
        A `access_control` block as defined below.
        """
        return pulumi.get(self, "access_control")

    @access_control.setter
    def access_control(self, value: Optional[pulumi.Input['WorkflowAccessControlArgs']]):
        pulumi.set(self, "access_control", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Logic App Workflow enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['WorkflowIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['WorkflowIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="integrationServiceEnvironmentId")
    def integration_service_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Integration Service Environment to which this Logic App Workflow belongs. Changing this forces a new Logic App Workflow to be created.
        """
        return pulumi.get(self, "integration_service_environment_id")

    @integration_service_environment_id.setter
    def integration_service_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_service_environment_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Logic App Workflow exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logicAppIntegrationAccountId")
    def logic_app_integration_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the integration account linked by this Logic App Workflow.
        """
        return pulumi.get(self, "logic_app_integration_account_id")

    @logic_app_integration_account_id.setter
    def logic_app_integration_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logic_app_integration_account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of Key-Value pairs.

        > **Note:** Any parameters specified must exist in the Schema defined in `workflow_parameters`.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workflowParameters")
    def workflow_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a map of Key-Value pairs of the Parameter Definitions to use for this Logic App Workflow. The key is the parameter name, and the value is a JSON encoded string of the parameter definition (see: <https://docs.microsoft.com/azure/logic-apps/logic-apps-workflow-definition-language#parameters>).
        """
        return pulumi.get(self, "workflow_parameters")

    @workflow_parameters.setter
    def workflow_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "workflow_parameters", value)

    @_builtins.property
    @pulumi.getter(name="workflowSchema")
    def workflow_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Schema to use for this Logic App Workflow. Defaults to `https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workflow_schema")

    @workflow_schema.setter
    def workflow_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workflow_schema", value)

    @_builtins.property
    @pulumi.getter(name="workflowVersion")
    def workflow_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the Schema used for this Logic App Workflow. Defaults to `1.0.0.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workflow_version")

    @workflow_version.setter
    def workflow_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workflow_version", value)


@pulumi.input_type
class _WorkflowState:
    def __init__(__self__, *,
                 access_control: Optional[pulumi.Input['WorkflowAccessControlArgs']] = None,
                 access_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_endpoint_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 connector_outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['WorkflowIdentityArgs']] = None,
                 integration_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logic_app_integration_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workflow_endpoint_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 workflow_outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 workflow_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workflow_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 workflow_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Workflow resources.
        :param pulumi.Input['WorkflowAccessControlArgs'] access_control: A `access_control` block as defined below.
        :param pulumi.Input[_builtins.str] access_endpoint: The Access Endpoint for the Logic App Workflow.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connector_endpoint_ip_addresses: The list of access endpoint IP addresses of connector.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connector_outbound_ip_addresses: The list of outgoing IP addresses of connector.
        :param pulumi.Input[_builtins.bool] enabled: Is the Logic App Workflow enabled? Defaults to `true`.
        :param pulumi.Input['WorkflowIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] integration_service_environment_id: The ID of the Integration Service Environment to which this Logic App Workflow belongs. Changing this forces a new Logic App Workflow to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Logic App Workflow exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] logic_app_integration_account_id: The ID of the integration account linked by this Logic App Workflow.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of Key-Value pairs.
               
               > **Note:** Any parameters specified must exist in the Schema defined in `workflow_parameters`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Logic App Workflow should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] workflow_endpoint_ip_addresses: The list of access endpoint IP addresses of workflow.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] workflow_outbound_ip_addresses: The list of outgoing IP addresses of workflow.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] workflow_parameters: Specifies a map of Key-Value pairs of the Parameter Definitions to use for this Logic App Workflow. The key is the parameter name, and the value is a JSON encoded string of the parameter definition (see: <https://docs.microsoft.com/azure/logic-apps/logic-apps-workflow-definition-language#parameters>).
        :param pulumi.Input[_builtins.str] workflow_schema: Specifies the Schema to use for this Logic App Workflow. Defaults to `https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workflow_version: Specifies the version of the Schema used for this Logic App Workflow. Defaults to `1.0.0.0`. Changing this forces a new resource to be created.
        """
        if access_control is not None:
            pulumi.set(__self__, "access_control", access_control)
        if access_endpoint is not None:
            pulumi.set(__self__, "access_endpoint", access_endpoint)
        if connector_endpoint_ip_addresses is not None:
            pulumi.set(__self__, "connector_endpoint_ip_addresses", connector_endpoint_ip_addresses)
        if connector_outbound_ip_addresses is not None:
            pulumi.set(__self__, "connector_outbound_ip_addresses", connector_outbound_ip_addresses)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if integration_service_environment_id is not None:
            pulumi.set(__self__, "integration_service_environment_id", integration_service_environment_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logic_app_integration_account_id is not None:
            pulumi.set(__self__, "logic_app_integration_account_id", logic_app_integration_account_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workflow_endpoint_ip_addresses is not None:
            pulumi.set(__self__, "workflow_endpoint_ip_addresses", workflow_endpoint_ip_addresses)
        if workflow_outbound_ip_addresses is not None:
            pulumi.set(__self__, "workflow_outbound_ip_addresses", workflow_outbound_ip_addresses)
        if workflow_parameters is not None:
            pulumi.set(__self__, "workflow_parameters", workflow_parameters)
        if workflow_schema is not None:
            pulumi.set(__self__, "workflow_schema", workflow_schema)
        if workflow_version is not None:
            pulumi.set(__self__, "workflow_version", workflow_version)

    @_builtins.property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> Optional[pulumi.Input['WorkflowAccessControlArgs']]:
        """
        A `access_control` block as defined below.
        """
        return pulumi.get(self, "access_control")

    @access_control.setter
    def access_control(self, value: Optional[pulumi.Input['WorkflowAccessControlArgs']]):
        pulumi.set(self, "access_control", value)

    @_builtins.property
    @pulumi.getter(name="accessEndpoint")
    def access_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Access Endpoint for the Logic App Workflow.
        """
        return pulumi.get(self, "access_endpoint")

    @access_endpoint.setter
    def access_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="connectorEndpointIpAddresses")
    def connector_endpoint_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of access endpoint IP addresses of connector.
        """
        return pulumi.get(self, "connector_endpoint_ip_addresses")

    @connector_endpoint_ip_addresses.setter
    def connector_endpoint_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connector_endpoint_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="connectorOutboundIpAddresses")
    def connector_outbound_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of outgoing IP addresses of connector.
        """
        return pulumi.get(self, "connector_outbound_ip_addresses")

    @connector_outbound_ip_addresses.setter
    def connector_outbound_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connector_outbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Logic App Workflow enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['WorkflowIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['WorkflowIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="integrationServiceEnvironmentId")
    def integration_service_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Integration Service Environment to which this Logic App Workflow belongs. Changing this forces a new Logic App Workflow to be created.
        """
        return pulumi.get(self, "integration_service_environment_id")

    @integration_service_environment_id.setter
    def integration_service_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_service_environment_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Logic App Workflow exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logicAppIntegrationAccountId")
    def logic_app_integration_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the integration account linked by this Logic App Workflow.
        """
        return pulumi.get(self, "logic_app_integration_account_id")

    @logic_app_integration_account_id.setter
    def logic_app_integration_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logic_app_integration_account_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of Key-Value pairs.

        > **Note:** Any parameters specified must exist in the Schema defined in `workflow_parameters`.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the Logic App Workflow should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workflowEndpointIpAddresses")
    def workflow_endpoint_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of access endpoint IP addresses of workflow.
        """
        return pulumi.get(self, "workflow_endpoint_ip_addresses")

    @workflow_endpoint_ip_addresses.setter
    def workflow_endpoint_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "workflow_endpoint_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="workflowOutboundIpAddresses")
    def workflow_outbound_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of outgoing IP addresses of workflow.
        """
        return pulumi.get(self, "workflow_outbound_ip_addresses")

    @workflow_outbound_ip_addresses.setter
    def workflow_outbound_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "workflow_outbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="workflowParameters")
    def workflow_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a map of Key-Value pairs of the Parameter Definitions to use for this Logic App Workflow. The key is the parameter name, and the value is a JSON encoded string of the parameter definition (see: <https://docs.microsoft.com/azure/logic-apps/logic-apps-workflow-definition-language#parameters>).
        """
        return pulumi.get(self, "workflow_parameters")

    @workflow_parameters.setter
    def workflow_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "workflow_parameters", value)

    @_builtins.property
    @pulumi.getter(name="workflowSchema")
    def workflow_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Schema to use for this Logic App Workflow. Defaults to `https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workflow_schema")

    @workflow_schema.setter
    def workflow_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workflow_schema", value)

    @_builtins.property
    @pulumi.getter(name="workflowVersion")
    def workflow_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the Schema used for this Logic App Workflow. Defaults to `1.0.0.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workflow_version")

    @workflow_version.setter
    def workflow_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workflow_version", value)


@pulumi.type_token("azure:logicapps/workflow:Workflow")
class Workflow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control: Optional[pulumi.Input[Union['WorkflowAccessControlArgs', 'WorkflowAccessControlArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['WorkflowIdentityArgs', 'WorkflowIdentityArgsDict']]] = None,
                 integration_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logic_app_integration_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workflow_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workflow_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 workflow_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Logic App Workflow.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="workflow-resources",
            location="West Europe")
        example_workflow = azure.logicapps.Workflow("example",
            name="workflow1",
            location=example.location,
            resource_group_name=example.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Logic`: 2019-05-01

        ## Import

        Logic App Workflows can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/workflow:Workflow workflow1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Logic/workflows/workflow1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WorkflowAccessControlArgs', 'WorkflowAccessControlArgsDict']] access_control: A `access_control` block as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the Logic App Workflow enabled? Defaults to `true`.
        :param pulumi.Input[Union['WorkflowIdentityArgs', 'WorkflowIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] integration_service_environment_id: The ID of the Integration Service Environment to which this Logic App Workflow belongs. Changing this forces a new Logic App Workflow to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Logic App Workflow exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] logic_app_integration_account_id: The ID of the integration account linked by this Logic App Workflow.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of Key-Value pairs.
               
               > **Note:** Any parameters specified must exist in the Schema defined in `workflow_parameters`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Logic App Workflow should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] workflow_parameters: Specifies a map of Key-Value pairs of the Parameter Definitions to use for this Logic App Workflow. The key is the parameter name, and the value is a JSON encoded string of the parameter definition (see: <https://docs.microsoft.com/azure/logic-apps/logic-apps-workflow-definition-language#parameters>).
        :param pulumi.Input[_builtins.str] workflow_schema: Specifies the Schema to use for this Logic App Workflow. Defaults to `https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workflow_version: Specifies the version of the Schema used for this Logic App Workflow. Defaults to `1.0.0.0`. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkflowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Logic App Workflow.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="workflow-resources",
            location="West Europe")
        example_workflow = azure.logicapps.Workflow("example",
            name="workflow1",
            location=example.location,
            resource_group_name=example.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Logic`: 2019-05-01

        ## Import

        Logic App Workflows can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/workflow:Workflow workflow1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Logic/workflows/workflow1
        ```

        :param str resource_name: The name of the resource.
        :param WorkflowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkflowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control: Optional[pulumi.Input[Union['WorkflowAccessControlArgs', 'WorkflowAccessControlArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['WorkflowIdentityArgs', 'WorkflowIdentityArgsDict']]] = None,
                 integration_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logic_app_integration_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workflow_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workflow_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 workflow_version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkflowArgs.__new__(WorkflowArgs)

            __props__.__dict__["access_control"] = access_control
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["identity"] = identity
            __props__.__dict__["integration_service_environment_id"] = integration_service_environment_id
            __props__.__dict__["location"] = location
            __props__.__dict__["logic_app_integration_account_id"] = logic_app_integration_account_id
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["workflow_parameters"] = workflow_parameters
            __props__.__dict__["workflow_schema"] = workflow_schema
            __props__.__dict__["workflow_version"] = workflow_version
            __props__.__dict__["access_endpoint"] = None
            __props__.__dict__["connector_endpoint_ip_addresses"] = None
            __props__.__dict__["connector_outbound_ip_addresses"] = None
            __props__.__dict__["workflow_endpoint_ip_addresses"] = None
            __props__.__dict__["workflow_outbound_ip_addresses"] = None
        super(Workflow, __self__).__init__(
            'azure:logicapps/workflow:Workflow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_control: Optional[pulumi.Input[Union['WorkflowAccessControlArgs', 'WorkflowAccessControlArgsDict']]] = None,
            access_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            connector_endpoint_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            connector_outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['WorkflowIdentityArgs', 'WorkflowIdentityArgsDict']]] = None,
            integration_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            logic_app_integration_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            workflow_endpoint_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            workflow_outbound_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            workflow_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            workflow_schema: Optional[pulumi.Input[_builtins.str]] = None,
            workflow_version: Optional[pulumi.Input[_builtins.str]] = None) -> 'Workflow':
        """
        Get an existing Workflow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WorkflowAccessControlArgs', 'WorkflowAccessControlArgsDict']] access_control: A `access_control` block as defined below.
        :param pulumi.Input[_builtins.str] access_endpoint: The Access Endpoint for the Logic App Workflow.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connector_endpoint_ip_addresses: The list of access endpoint IP addresses of connector.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connector_outbound_ip_addresses: The list of outgoing IP addresses of connector.
        :param pulumi.Input[_builtins.bool] enabled: Is the Logic App Workflow enabled? Defaults to `true`.
        :param pulumi.Input[Union['WorkflowIdentityArgs', 'WorkflowIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] integration_service_environment_id: The ID of the Integration Service Environment to which this Logic App Workflow belongs. Changing this forces a new Logic App Workflow to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Logic App Workflow exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] logic_app_integration_account_id: The ID of the integration account linked by this Logic App Workflow.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Logic App Workflow. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of Key-Value pairs.
               
               > **Note:** Any parameters specified must exist in the Schema defined in `workflow_parameters`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Logic App Workflow should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] workflow_endpoint_ip_addresses: The list of access endpoint IP addresses of workflow.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] workflow_outbound_ip_addresses: The list of outgoing IP addresses of workflow.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] workflow_parameters: Specifies a map of Key-Value pairs of the Parameter Definitions to use for this Logic App Workflow. The key is the parameter name, and the value is a JSON encoded string of the parameter definition (see: <https://docs.microsoft.com/azure/logic-apps/logic-apps-workflow-definition-language#parameters>).
        :param pulumi.Input[_builtins.str] workflow_schema: Specifies the Schema to use for this Logic App Workflow. Defaults to `https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] workflow_version: Specifies the version of the Schema used for this Logic App Workflow. Defaults to `1.0.0.0`. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkflowState.__new__(_WorkflowState)

        __props__.__dict__["access_control"] = access_control
        __props__.__dict__["access_endpoint"] = access_endpoint
        __props__.__dict__["connector_endpoint_ip_addresses"] = connector_endpoint_ip_addresses
        __props__.__dict__["connector_outbound_ip_addresses"] = connector_outbound_ip_addresses
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["identity"] = identity
        __props__.__dict__["integration_service_environment_id"] = integration_service_environment_id
        __props__.__dict__["location"] = location
        __props__.__dict__["logic_app_integration_account_id"] = logic_app_integration_account_id
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["workflow_endpoint_ip_addresses"] = workflow_endpoint_ip_addresses
        __props__.__dict__["workflow_outbound_ip_addresses"] = workflow_outbound_ip_addresses
        __props__.__dict__["workflow_parameters"] = workflow_parameters
        __props__.__dict__["workflow_schema"] = workflow_schema
        __props__.__dict__["workflow_version"] = workflow_version
        return Workflow(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessControl")
    def access_control(self) -> pulumi.Output[Optional['outputs.WorkflowAccessControl']]:
        """
        A `access_control` block as defined below.
        """
        return pulumi.get(self, "access_control")

    @_builtins.property
    @pulumi.getter(name="accessEndpoint")
    def access_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The Access Endpoint for the Logic App Workflow.
        """
        return pulumi.get(self, "access_endpoint")

    @_builtins.property
    @pulumi.getter(name="connectorEndpointIpAddresses")
    def connector_endpoint_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of access endpoint IP addresses of connector.
        """
        return pulumi.get(self, "connector_endpoint_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="connectorOutboundIpAddresses")
    def connector_outbound_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of outgoing IP addresses of connector.
        """
        return pulumi.get(self, "connector_outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the Logic App Workflow enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.WorkflowIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="integrationServiceEnvironmentId")
    def integration_service_environment_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Integration Service Environment to which this Logic App Workflow belongs. Changing this forces a new Logic App Workflow to be created.
        """
        return pulumi.get(self, "integration_service_environment_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the Logic App Workflow exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="logicAppIntegrationAccountId")
    def logic_app_integration_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the integration account linked by this Logic App Workflow.
        """
        return pulumi.get(self, "logic_app_integration_account_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Logic App Workflow. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of Key-Value pairs.

        > **Note:** Any parameters specified must exist in the Schema defined in `workflow_parameters`.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the Logic App Workflow should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workflowEndpointIpAddresses")
    def workflow_endpoint_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of access endpoint IP addresses of workflow.
        """
        return pulumi.get(self, "workflow_endpoint_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="workflowOutboundIpAddresses")
    def workflow_outbound_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of outgoing IP addresses of workflow.
        """
        return pulumi.get(self, "workflow_outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="workflowParameters")
    def workflow_parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies a map of Key-Value pairs of the Parameter Definitions to use for this Logic App Workflow. The key is the parameter name, and the value is a JSON encoded string of the parameter definition (see: <https://docs.microsoft.com/azure/logic-apps/logic-apps-workflow-definition-language#parameters>).
        """
        return pulumi.get(self, "workflow_parameters")

    @_builtins.property
    @pulumi.getter(name="workflowSchema")
    def workflow_schema(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Schema to use for this Logic App Workflow. Defaults to `https://schema.management.azure.com/providers/Microsoft.Logic/schemas/2016-06-01/workflowdefinition.json#`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workflow_schema")

    @_builtins.property
    @pulumi.getter(name="workflowVersion")
    def workflow_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the version of the Schema used for this Logic App Workflow. Defaults to `1.0.0.0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "workflow_version")

