# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ComputeClusterIdentity',
    'ComputeClusterScaleSettings',
    'ComputeClusterSsh',
    'ComputeInstanceAssignToUser',
    'ComputeInstanceIdentity',
    'ComputeInstanceSsh',
    'InferenceClusterIdentity',
    'InferenceClusterSsl',
    'SynapseSparkIdentity',
    'WorkspaceEncryption',
    'WorkspaceFeatureStore',
    'WorkspaceIdentity',
    'WorkspaceManagedNetwork',
    'WorkspaceServerlessCompute',
    'GetWorkspaceIdentityResult',
]

@pulumi.output_type
class ComputeClusterIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeClusterIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeClusterIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeClusterIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Machine Learning Compute Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Compute Cluster. Changing this forces a new resource to be created.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Cluster.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Cluster.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Compute Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Compute Cluster. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Cluster.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Cluster.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ComputeClusterScaleSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNodeCount":
            suggest = "max_node_count"
        elif key == "minNodeCount":
            suggest = "min_node_count"
        elif key == "scaleDownNodesAfterIdleDuration":
            suggest = "scale_down_nodes_after_idle_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeClusterScaleSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeClusterScaleSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeClusterScaleSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_node_count: _builtins.int,
                 min_node_count: _builtins.int,
                 scale_down_nodes_after_idle_duration: _builtins.str):
        """
        :param _builtins.int max_node_count: Maximum node count. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param _builtins.int min_node_count: Minimal node count. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param _builtins.str scale_down_nodes_after_idle_duration: Node Idle Time Before Scale Down: defines the time until the compute is shutdown when it has gone into Idle state. Is defined according to W3C XML schema standard for duration. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        pulumi.set(__self__, "max_node_count", max_node_count)
        pulumi.set(__self__, "min_node_count", min_node_count)
        pulumi.set(__self__, "scale_down_nodes_after_idle_duration", scale_down_nodes_after_idle_duration)

    @_builtins.property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> _builtins.int:
        """
        Maximum node count. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "max_node_count")

    @_builtins.property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> _builtins.int:
        """
        Minimal node count. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "min_node_count")

    @_builtins.property
    @pulumi.getter(name="scaleDownNodesAfterIdleDuration")
    def scale_down_nodes_after_idle_duration(self) -> _builtins.str:
        """
        Node Idle Time Before Scale Down: defines the time until the compute is shutdown when it has gone into Idle state. Is defined according to W3C XML schema standard for duration. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "scale_down_nodes_after_idle_duration")


@pulumi.output_type
class ComputeClusterSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUsername":
            suggest = "admin_username"
        elif key == "adminPassword":
            suggest = "admin_password"
        elif key == "keyValue":
            suggest = "key_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeClusterSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeClusterSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeClusterSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_username: _builtins.str,
                 admin_password: Optional[_builtins.str] = None,
                 key_value: Optional[_builtins.str] = None):
        """
        :param _builtins.str admin_username: Name of the administrator user account which can be used to SSH to nodes. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param _builtins.str admin_password: Password of the administrator user account. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param _builtins.str key_value: SSH public key of the administrator user account. Changing this forces a new Machine Learning Compute Cluster to be created.
               
               > **Note:** At least one of `admin_password` and `key_value` shoud be specified.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if key_value is not None:
            pulumi.set(__self__, "key_value", key_value)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> _builtins.str:
        """
        Name of the administrator user account which can be used to SSH to nodes. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[_builtins.str]:
        """
        Password of the administrator user account. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="keyValue")
    def key_value(self) -> Optional[_builtins.str]:
        """
        SSH public key of the administrator user account. Changing this forces a new Machine Learning Compute Cluster to be created.

        > **Note:** At least one of `admin_password` and `key_value` shoud be specified.
        """
        return pulumi.get(self, "key_value")


@pulumi.output_type
class ComputeInstanceAssignToUser(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectId":
            suggest = "object_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceAssignToUser. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceAssignToUser.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceAssignToUser.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str object_id: User’s AAD Object Id.
        :param _builtins.str tenant_id: User’s AAD Tenant Id.
        """
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[_builtins.str]:
        """
        User’s AAD Object Id.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        User’s AAD Tenant Id.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ComputeInstanceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Machine Learning Compute Instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Compute Instance. Changing this forces a new resource to be created.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Instance.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Instance.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Compute Instance. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Compute Instance. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Instance.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Compute Instance.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ComputeInstanceSsh(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComputeInstanceSsh. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComputeInstanceSsh.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComputeInstanceSsh.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key: _builtins.str,
                 port: Optional[_builtins.int] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        :param _builtins.int port: Describes the port for connecting through SSH.
        :param _builtins.str username: The admin username of this Machine Learning Compute Instance.
        """
        pulumi.set(__self__, "public_key", public_key)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        Describes the port for connecting through SSH.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The admin username of this Machine Learning Compute Instance.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class InferenceClusterIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceClusterIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceClusterIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceClusterIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Machine Learning Inference Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Inference Cluster. Changing this forces a new resource to be created.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Inference Cluster.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Inference Cluster.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Inference Cluster. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Inference Cluster. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Inference Cluster.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Inference Cluster.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class InferenceClusterSsl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "leafDomainLabel":
            suggest = "leaf_domain_label"
        elif key == "overwriteExistingDomain":
            suggest = "overwrite_existing_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InferenceClusterSsl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InferenceClusterSsl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InferenceClusterSsl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert: Optional[_builtins.str] = None,
                 cname: Optional[_builtins.str] = None,
                 key: Optional[_builtins.str] = None,
                 leaf_domain_label: Optional[_builtins.str] = None,
                 overwrite_existing_domain: Optional[_builtins.bool] = None):
        """
        :param _builtins.str cert: The certificate for the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        :param _builtins.str cname: The cname of the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        :param _builtins.str key: The key content for the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        :param _builtins.str leaf_domain_label: The leaf domain label for the SSL configuration. Conflicts with `ssl[0].cert`,`ssl[0].key`,`ssl[0].cname`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        :param _builtins.bool overwrite_existing_domain: Whether or not to overwrite existing leaf domain. Conflicts with `ssl[0].cert`,`ssl[0].key`,`ssl[0].cname` Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cname is not None:
            pulumi.set(__self__, "cname", cname)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if leaf_domain_label is not None:
            pulumi.set(__self__, "leaf_domain_label", leaf_domain_label)
        if overwrite_existing_domain is not None:
            pulumi.set(__self__, "overwrite_existing_domain", overwrite_existing_domain)

    @_builtins.property
    @pulumi.getter
    def cert(self) -> Optional[_builtins.str]:
        """
        The certificate for the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        return pulumi.get(self, "cert")

    @_builtins.property
    @pulumi.getter
    def cname(self) -> Optional[_builtins.str]:
        """
        The cname of the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        return pulumi.get(self, "cname")

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[_builtins.str]:
        """
        The key content for the SSL configuration.Conflicts with `ssl[0].leaf_domain_label`,`ssl[0].overwrite_existing_domain`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter(name="leafDomainLabel")
    def leaf_domain_label(self) -> Optional[_builtins.str]:
        """
        The leaf domain label for the SSL configuration. Conflicts with `ssl[0].cert`,`ssl[0].key`,`ssl[0].cname`. Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        return pulumi.get(self, "leaf_domain_label")

    @_builtins.property
    @pulumi.getter(name="overwriteExistingDomain")
    def overwrite_existing_domain(self) -> Optional[_builtins.bool]:
        """
        Whether or not to overwrite existing leaf domain. Conflicts with `ssl[0].cert`,`ssl[0].key`,`ssl[0].cname` Changing this forces a new Machine Learning Inference Cluster to be created. Defaults to `""`.
        """
        return pulumi.get(self, "overwrite_existing_domain")


@pulumi.output_type
class SynapseSparkIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SynapseSparkIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SynapseSparkIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SynapseSparkIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Machine Learning Synapse Spark. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Synapse Spark. Changing this forces a new resource to be created.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Synapse Spark.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Synapse Spark.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Synapse Spark. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Synapse Spark. Changing this forces a new resource to be created.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Synapse Spark.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Machine Learning Synapse Spark.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class WorkspaceEncryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "userAssignedIdentityId":
            suggest = "user_assigned_identity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceEncryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceEncryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceEncryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: _builtins.str,
                 key_vault_id: _builtins.str,
                 user_assigned_identity_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_id: The Key Vault URI to access the encryption key.
        :param _builtins.str key_vault_id: The ID of the keyVault where the customer owned encryption key is present.
        :param _builtins.str user_assigned_identity_id: The Key Vault URI to access the encryption key.
               
               > **Note:** `user_assigned_identity_id` must set when`identity.type` is `UserAssigned` or service won't be able to find the assigned permissions.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        """
        The Key Vault URI to access the encryption key.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> _builtins.str:
        """
        The ID of the keyVault where the customer owned encryption key is present.
        """
        return pulumi.get(self, "key_vault_id")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[_builtins.str]:
        """
        The Key Vault URI to access the encryption key.

        > **Note:** `user_assigned_identity_id` must set when`identity.type` is `UserAssigned` or service won't be able to find the assigned permissions.
        """
        return pulumi.get(self, "user_assigned_identity_id")


@pulumi.output_type
class WorkspaceFeatureStore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computerSparkRuntimeVersion":
            suggest = "computer_spark_runtime_version"
        elif key == "offlineConnectionName":
            suggest = "offline_connection_name"
        elif key == "onlineConnectionName":
            suggest = "online_connection_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceFeatureStore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceFeatureStore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceFeatureStore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 computer_spark_runtime_version: Optional[_builtins.str] = None,
                 offline_connection_name: Optional[_builtins.str] = None,
                 online_connection_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str computer_spark_runtime_version: The version of Spark runtime.
        :param _builtins.str offline_connection_name: The name of offline store connection.
        :param _builtins.str online_connection_name: The name of online store connection.
               
               > **Note:** `feature_store` must be set when`kind` is `FeatureStore`
        """
        if computer_spark_runtime_version is not None:
            pulumi.set(__self__, "computer_spark_runtime_version", computer_spark_runtime_version)
        if offline_connection_name is not None:
            pulumi.set(__self__, "offline_connection_name", offline_connection_name)
        if online_connection_name is not None:
            pulumi.set(__self__, "online_connection_name", online_connection_name)

    @_builtins.property
    @pulumi.getter(name="computerSparkRuntimeVersion")
    def computer_spark_runtime_version(self) -> Optional[_builtins.str]:
        """
        The version of Spark runtime.
        """
        return pulumi.get(self, "computer_spark_runtime_version")

    @_builtins.property
    @pulumi.getter(name="offlineConnectionName")
    def offline_connection_name(self) -> Optional[_builtins.str]:
        """
        The name of offline store connection.
        """
        return pulumi.get(self, "offline_connection_name")

    @_builtins.property
    @pulumi.getter(name="onlineConnectionName")
    def online_connection_name(self) -> Optional[_builtins.str]:
        """
        The name of online store connection.

        > **Note:** `feature_store` must be set when`kind` is `FeatureStore`
        """
        return pulumi.get(self, "online_connection_name")


@pulumi.output_type
class WorkspaceIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Machine Learning Workspace. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Workspace.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Machine Learning Workspace. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Machine Learning Workspace.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class WorkspaceManagedNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isolationMode":
            suggest = "isolation_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceManagedNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceManagedNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceManagedNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 isolation_mode: Optional[_builtins.str] = None):
        """
        :param _builtins.str isolation_mode: The isolation mode of the Machine Learning Workspace. Possible values are `Disabled`, `AllowOnlyApprovedOutbound`, and `AllowInternetOutbound`
        """
        if isolation_mode is not None:
            pulumi.set(__self__, "isolation_mode", isolation_mode)

    @_builtins.property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> Optional[_builtins.str]:
        """
        The isolation mode of the Machine Learning Workspace. Possible values are `Disabled`, `AllowOnlyApprovedOutbound`, and `AllowInternetOutbound`
        """
        return pulumi.get(self, "isolation_mode")


@pulumi.output_type
class WorkspaceServerlessCompute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIpEnabled":
            suggest = "public_ip_enabled"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkspaceServerlessCompute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkspaceServerlessCompute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkspaceServerlessCompute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_ip_enabled: Optional[_builtins.bool] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.bool public_ip_enabled: Should serverless compute nodes deployed in a custom Virtual Network have public IP addresses enabled for a workspace with private endpoint? Defaults to `false`.
               
               > **Note:** `public_ip_enabled` cannot be updated from `true` to `false` when `subnet_id` is not set. `public_ip_enabled` must be set to `true` if `subnet_id` is not set and when `public_network_access_enabled` is `false`.
        :param _builtins.str subnet_id: The ID of an existing Virtual Network Subnet in which the serverless compute nodes should be deployed to.
        """
        if public_ip_enabled is not None:
            pulumi.set(__self__, "public_ip_enabled", public_ip_enabled)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="publicIpEnabled")
    def public_ip_enabled(self) -> Optional[_builtins.bool]:
        """
        Should serverless compute nodes deployed in a custom Virtual Network have public IP addresses enabled for a workspace with private endpoint? Defaults to `false`.

        > **Note:** `public_ip_enabled` cannot be updated from `true` to `false` when `subnet_id` is not set. `public_ip_enabled` must be set to `true` if `subnet_id` is not set and when `public_network_access_enabled` is `false`.
        """
        return pulumi.get(self, "public_ip_enabled")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The ID of an existing Virtual Network Subnet in which the serverless compute nodes should be deployed to.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetWorkspaceIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: A list of User Assigned Identity IDs assigned to this Machine Learning Workspace.
        :param _builtins.str principal_id: The Principal ID of the System Assigned Managed Identity assigned to this Machine Learning Workspace.
        :param _builtins.str tenant_id: The Tenant ID of the System Assigned Managed Identity assigned to this Machine Learning Workspace.
        :param _builtins.str type: The Type of Managed Identity assigned to this Machine Learning Workspace.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        A list of User Assigned Identity IDs assigned to this Machine Learning Workspace.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID of the System Assigned Managed Identity assigned to this Machine Learning Workspace.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID of the System Assigned Managed Identity assigned to this Machine Learning Workspace.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of Managed Identity assigned to this Machine Learning Workspace.
        """
        return pulumi.get(self, "type")


