# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigurationArgs', 'Configuration']

@pulumi.input_type
class ConfigurationArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 scope: pulumi.Input[_builtins.str],
                 in_guest_user_patch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 install_patches: Optional[pulumi.Input['ConfigurationInstallPatchesArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 window: Optional[pulumi.Input['ConfigurationWindowArgs']] = None):
        """
        The set of arguments for constructing a Configuration resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Maintenance Configuration should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope: The scope of the Maintenance Configuration. Possible values are `Extension`, `Host`, `InGuestPatch`, `OSImage`, `SQLDB` or `SQLManagedInstance`.
        :param pulumi.Input[_builtins.str] in_guest_user_patch_mode: The in guest user patch mode. Possible values are `Platform` or `User`. Must be specified when `scope` is `InGuestPatch`.
        :param pulumi.Input['ConfigurationInstallPatchesArgs'] install_patches: An `install_patches` block as defined below.
               
               > **Note:** `install_patches` must be specified when `scope` is `InGuestPatch`.
        :param pulumi.Input[_builtins.str] location: Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Maintenance Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A mapping of properties to assign to the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. The key could not contain upper case letter.
        :param pulumi.Input[_builtins.str] visibility: The visibility of the Maintenance Configuration. The only allowable value is `Custom`. Defaults to `Custom`.
        :param pulumi.Input['ConfigurationWindowArgs'] window: A `window` block as defined below.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "scope", scope)
        if in_guest_user_patch_mode is not None:
            pulumi.set(__self__, "in_guest_user_patch_mode", in_guest_user_patch_mode)
        if install_patches is not None:
            pulumi.set(__self__, "install_patches", install_patches)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Maintenance Configuration should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Input[_builtins.str]:
        """
        The scope of the Maintenance Configuration. Possible values are `Extension`, `Host`, `InGuestPatch`, `OSImage`, `SQLDB` or `SQLManagedInstance`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter(name="inGuestUserPatchMode")
    def in_guest_user_patch_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The in guest user patch mode. Possible values are `Platform` or `User`. Must be specified when `scope` is `InGuestPatch`.
        """
        return pulumi.get(self, "in_guest_user_patch_mode")

    @in_guest_user_patch_mode.setter
    def in_guest_user_patch_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "in_guest_user_patch_mode", value)

    @_builtins.property
    @pulumi.getter(name="installPatches")
    def install_patches(self) -> Optional[pulumi.Input['ConfigurationInstallPatchesArgs']]:
        """
        An `install_patches` block as defined below.

        > **Note:** `install_patches` must be specified when `scope` is `InGuestPatch`.
        """
        return pulumi.get(self, "install_patches")

    @install_patches.setter
    def install_patches(self, value: Optional[pulumi.Input['ConfigurationInstallPatchesArgs']]):
        pulumi.set(self, "install_patches", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Maintenance Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of properties to assign to the resource.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. The key could not contain upper case letter.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The visibility of the Maintenance Configuration. The only allowable value is `Custom`. Defaults to `Custom`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)

    @_builtins.property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input['ConfigurationWindowArgs']]:
        """
        A `window` block as defined below.
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input['ConfigurationWindowArgs']]):
        pulumi.set(self, "window", value)


@pulumi.input_type
class _ConfigurationState:
    def __init__(__self__, *,
                 in_guest_user_patch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 install_patches: Optional[pulumi.Input['ConfigurationInstallPatchesArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 window: Optional[pulumi.Input['ConfigurationWindowArgs']] = None):
        """
        Input properties used for looking up and filtering Configuration resources.
        :param pulumi.Input[_builtins.str] in_guest_user_patch_mode: The in guest user patch mode. Possible values are `Platform` or `User`. Must be specified when `scope` is `InGuestPatch`.
        :param pulumi.Input['ConfigurationInstallPatchesArgs'] install_patches: An `install_patches` block as defined below.
               
               > **Note:** `install_patches` must be specified when `scope` is `InGuestPatch`.
        :param pulumi.Input[_builtins.str] location: Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Maintenance Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A mapping of properties to assign to the resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Maintenance Configuration should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope: The scope of the Maintenance Configuration. Possible values are `Extension`, `Host`, `InGuestPatch`, `OSImage`, `SQLDB` or `SQLManagedInstance`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. The key could not contain upper case letter.
        :param pulumi.Input[_builtins.str] visibility: The visibility of the Maintenance Configuration. The only allowable value is `Custom`. Defaults to `Custom`.
        :param pulumi.Input['ConfigurationWindowArgs'] window: A `window` block as defined below.
        """
        if in_guest_user_patch_mode is not None:
            pulumi.set(__self__, "in_guest_user_patch_mode", in_guest_user_patch_mode)
        if install_patches is not None:
            pulumi.set(__self__, "install_patches", install_patches)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @_builtins.property
    @pulumi.getter(name="inGuestUserPatchMode")
    def in_guest_user_patch_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The in guest user patch mode. Possible values are `Platform` or `User`. Must be specified when `scope` is `InGuestPatch`.
        """
        return pulumi.get(self, "in_guest_user_patch_mode")

    @in_guest_user_patch_mode.setter
    def in_guest_user_patch_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "in_guest_user_patch_mode", value)

    @_builtins.property
    @pulumi.getter(name="installPatches")
    def install_patches(self) -> Optional[pulumi.Input['ConfigurationInstallPatchesArgs']]:
        """
        An `install_patches` block as defined below.

        > **Note:** `install_patches` must be specified when `scope` is `InGuestPatch`.
        """
        return pulumi.get(self, "install_patches")

    @install_patches.setter
    def install_patches(self, value: Optional[pulumi.Input['ConfigurationInstallPatchesArgs']]):
        pulumi.set(self, "install_patches", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Maintenance Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of properties to assign to the resource.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Maintenance Configuration should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The scope of the Maintenance Configuration. Possible values are `Extension`, `Host`, `InGuestPatch`, `OSImage`, `SQLDB` or `SQLManagedInstance`.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource. The key could not contain upper case letter.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The visibility of the Maintenance Configuration. The only allowable value is `Custom`. Defaults to `Custom`.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)

    @_builtins.property
    @pulumi.getter
    def window(self) -> Optional[pulumi.Input['ConfigurationWindowArgs']]:
        """
        A `window` block as defined below.
        """
        return pulumi.get(self, "window")

    @window.setter
    def window(self, value: Optional[pulumi.Input['ConfigurationWindowArgs']]):
        pulumi.set(self, "window", value)


@pulumi.type_token("azure:maintenance/configuration:Configuration")
class Configuration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 in_guest_user_patch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 install_patches: Optional[pulumi.Input[Union['ConfigurationInstallPatchesArgs', 'ConfigurationInstallPatchesArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 window: Optional[pulumi.Input[Union['ConfigurationWindowArgs', 'ConfigurationWindowArgsDict']]] = None,
                 __props__=None):
        """
        Manages a maintenance configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_configuration = azure.maintenance.Configuration("example",
            name="example-mc",
            resource_group_name=example.name,
            location=example.location,
            scope="SQLDB",
            tags={
                "Env": "prod",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Maintenance`: 2023-04-01

        ## Import

        Maintenance Configuration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:maintenance/configuration:Configuration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Maintenance/maintenanceConfigurations/example-mc
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] in_guest_user_patch_mode: The in guest user patch mode. Possible values are `Platform` or `User`. Must be specified when `scope` is `InGuestPatch`.
        :param pulumi.Input[Union['ConfigurationInstallPatchesArgs', 'ConfigurationInstallPatchesArgsDict']] install_patches: An `install_patches` block as defined below.
               
               > **Note:** `install_patches` must be specified when `scope` is `InGuestPatch`.
        :param pulumi.Input[_builtins.str] location: Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Maintenance Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A mapping of properties to assign to the resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Maintenance Configuration should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope: The scope of the Maintenance Configuration. Possible values are `Extension`, `Host`, `InGuestPatch`, `OSImage`, `SQLDB` or `SQLManagedInstance`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. The key could not contain upper case letter.
        :param pulumi.Input[_builtins.str] visibility: The visibility of the Maintenance Configuration. The only allowable value is `Custom`. Defaults to `Custom`.
        :param pulumi.Input[Union['ConfigurationWindowArgs', 'ConfigurationWindowArgsDict']] window: A `window` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a maintenance configuration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_configuration = azure.maintenance.Configuration("example",
            name="example-mc",
            resource_group_name=example.name,
            location=example.location,
            scope="SQLDB",
            tags={
                "Env": "prod",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Maintenance`: 2023-04-01

        ## Import

        Maintenance Configuration can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:maintenance/configuration:Configuration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Maintenance/maintenanceConfigurations/example-mc
        ```

        :param str resource_name: The name of the resource.
        :param ConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 in_guest_user_patch_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 install_patches: Optional[pulumi.Input[Union['ConfigurationInstallPatchesArgs', 'ConfigurationInstallPatchesArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 window: Optional[pulumi.Input[Union['ConfigurationWindowArgs', 'ConfigurationWindowArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationArgs.__new__(ConfigurationArgs)

            __props__.__dict__["in_guest_user_patch_mode"] = in_guest_user_patch_mode
            __props__.__dict__["install_patches"] = install_patches
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["properties"] = properties
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["tags"] = tags
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["window"] = window
        super(Configuration, __self__).__init__(
            'azure:maintenance/configuration:Configuration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            in_guest_user_patch_mode: Optional[pulumi.Input[_builtins.str]] = None,
            install_patches: Optional[pulumi.Input[Union['ConfigurationInstallPatchesArgs', 'ConfigurationInstallPatchesArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            visibility: Optional[pulumi.Input[_builtins.str]] = None,
            window: Optional[pulumi.Input[Union['ConfigurationWindowArgs', 'ConfigurationWindowArgsDict']]] = None) -> 'Configuration':
        """
        Get an existing Configuration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] in_guest_user_patch_mode: The in guest user patch mode. Possible values are `Platform` or `User`. Must be specified when `scope` is `InGuestPatch`.
        :param pulumi.Input[Union['ConfigurationInstallPatchesArgs', 'ConfigurationInstallPatchesArgsDict']] install_patches: An `install_patches` block as defined below.
               
               > **Note:** `install_patches` must be specified when `scope` is `InGuestPatch`.
        :param pulumi.Input[_builtins.str] location: Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Maintenance Configuration. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A mapping of properties to assign to the resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Maintenance Configuration should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope: The scope of the Maintenance Configuration. Possible values are `Extension`, `Host`, `InGuestPatch`, `OSImage`, `SQLDB` or `SQLManagedInstance`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource. The key could not contain upper case letter.
        :param pulumi.Input[_builtins.str] visibility: The visibility of the Maintenance Configuration. The only allowable value is `Custom`. Defaults to `Custom`.
        :param pulumi.Input[Union['ConfigurationWindowArgs', 'ConfigurationWindowArgsDict']] window: A `window` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigurationState.__new__(_ConfigurationState)

        __props__.__dict__["in_guest_user_patch_mode"] = in_guest_user_patch_mode
        __props__.__dict__["install_patches"] = install_patches
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["properties"] = properties
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["scope"] = scope
        __props__.__dict__["tags"] = tags
        __props__.__dict__["visibility"] = visibility
        __props__.__dict__["window"] = window
        return Configuration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="inGuestUserPatchMode")
    def in_guest_user_patch_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The in guest user patch mode. Possible values are `Platform` or `User`. Must be specified when `scope` is `InGuestPatch`.
        """
        return pulumi.get(self, "in_guest_user_patch_mode")

    @_builtins.property
    @pulumi.getter(name="installPatches")
    def install_patches(self) -> pulumi.Output[Optional['outputs.ConfigurationInstallPatches']]:
        """
        An `install_patches` block as defined below.

        > **Note:** `install_patches` must be specified when `scope` is `InGuestPatch`.
        """
        return pulumi.get(self, "install_patches")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Maintenance Configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of properties to assign to the resource.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Maintenance Configuration should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        The scope of the Maintenance Configuration. Possible values are `Extension`, `Host`, `InGuestPatch`, `OSImage`, `SQLDB` or `SQLManagedInstance`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource. The key could not contain upper case letter.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The visibility of the Maintenance Configuration. The only allowable value is `Custom`. Defaults to `Custom`.
        """
        return pulumi.get(self, "visibility")

    @_builtins.property
    @pulumi.getter
    def window(self) -> pulumi.Output[Optional['outputs.ConfigurationWindow']]:
        """
        A `window` block as defined below.
        """
        return pulumi.get(self, "window")

