# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetPublicConfigurationsResult',
    'AwaitableGetPublicConfigurationsResult',
    'get_public_configurations',
    'get_public_configurations_output',
]

@pulumi.output_type
class GetPublicConfigurationsResult:
    """
    A collection of values returned by getPublicConfigurations.
    """
    def __init__(__self__, configs=None, id=None, location=None, recur_every=None, scope=None):
        if configs and not isinstance(configs, list):
            raise TypeError("Expected argument 'configs' to be a list")
        pulumi.set(__self__, "configs", configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if recur_every and not isinstance(recur_every, str):
            raise TypeError("Expected argument 'recur_every' to be a str")
        pulumi.set(__self__, "recur_every", recur_every)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Sequence['outputs.GetPublicConfigurationsConfigResult']:
        """
        A `configs` block as defined below.
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[_builtins.str]:
        """
        The Azure location of the Public Maintenance Configuration.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="recurEvery")
    def recur_every(self) -> Optional[_builtins.str]:
        """
        The rate at which a maintenance window is expected to recur.
        """
        return pulumi.get(self, "recur_every")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "scope")


class AwaitableGetPublicConfigurationsResult(GetPublicConfigurationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicConfigurationsResult(
            configs=self.configs,
            id=self.id,
            location=self.location,
            recur_every=self.recur_every,
            scope=self.scope)


def get_public_configurations(location: Optional[_builtins.str] = None,
                              recur_every: Optional[_builtins.str] = None,
                              scope: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicConfigurationsResult:
    """
    Use this data source to access information about existing Public Maintenance Configurations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    existing = azure.maintenance.get_public_configurations(location="West Europe",
        scope="SQLManagedInstance",
        recur_every="Monday-Thursday")
    pulumi.export("name", existing.configs[0].name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Maintenance`: 2023-04-01


    :param _builtins.str location: The Azure location to filter the list of Public Maintenance Configurations against.
    :param _builtins.str recur_every: The recurring window to filter the list of Public Maintenance Configurations against. Possible values are `Monday-Thursday` and `Friday-Sunday`
    :param _builtins.str scope: The scope to filter the list of Public Maintenance Configurations against. Possible values are `Extension`, `Host`, `InGuestPatch`, `OSImage`, `SQLDB` and `SQLManagedInstance`.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['recurEvery'] = recur_every
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:maintenance/getPublicConfigurations:getPublicConfigurations', __args__, opts=opts, typ=GetPublicConfigurationsResult).value

    return AwaitableGetPublicConfigurationsResult(
        configs=pulumi.get(__ret__, 'configs'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        recur_every=pulumi.get(__ret__, 'recur_every'),
        scope=pulumi.get(__ret__, 'scope'))
def get_public_configurations_output(location: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     recur_every: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     scope: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPublicConfigurationsResult]:
    """
    Use this data source to access information about existing Public Maintenance Configurations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    existing = azure.maintenance.get_public_configurations(location="West Europe",
        scope="SQLManagedInstance",
        recur_every="Monday-Thursday")
    pulumi.export("name", existing.configs[0].name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Maintenance`: 2023-04-01


    :param _builtins.str location: The Azure location to filter the list of Public Maintenance Configurations against.
    :param _builtins.str recur_every: The recurring window to filter the list of Public Maintenance Configurations against. Possible values are `Monday-Thursday` and `Friday-Sunday`
    :param _builtins.str scope: The scope to filter the list of Public Maintenance Configurations against. Possible values are `Extension`, `Host`, `InGuestPatch`, `OSImage`, `SQLDB` and `SQLManagedInstance`.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['recurEvery'] = recur_every
    __args__['scope'] = scope
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:maintenance/getPublicConfigurations:getPublicConfigurations', __args__, opts=opts, typ=GetPublicConfigurationsResult)
    return __ret__.apply(lambda __response__: GetPublicConfigurationsResult(
        configs=pulumi.get(__response__, 'configs'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        recur_every=pulumi.get(__response__, 'recur_every'),
        scope=pulumi.get(__response__, 'scope')))
