# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs',
    'NetworkAttachedDataNetworkNetworkAddressPortTranslationArgsDict',
    'NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgs',
    'NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgsDict',
    'NetworkPacketCoreControlPlaneIdentityArgs',
    'NetworkPacketCoreControlPlaneIdentityArgsDict',
    'NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs',
    'NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgsDict',
    'NetworkPacketCoreControlPlanePlatformArgs',
    'NetworkPacketCoreControlPlanePlatformArgsDict',
    'NetworkServicePccRuleArgs',
    'NetworkServicePccRuleArgsDict',
    'NetworkServicePccRuleQosPolicyArgs',
    'NetworkServicePccRuleQosPolicyArgsDict',
    'NetworkServicePccRuleQosPolicyGuaranteedBitRateArgs',
    'NetworkServicePccRuleQosPolicyGuaranteedBitRateArgsDict',
    'NetworkServicePccRuleQosPolicyMaximumBitRateArgs',
    'NetworkServicePccRuleQosPolicyMaximumBitRateArgsDict',
    'NetworkServicePccRuleServiceDataFlowTemplateArgs',
    'NetworkServicePccRuleServiceDataFlowTemplateArgsDict',
    'NetworkServiceServiceQosPolicyArgs',
    'NetworkServiceServiceQosPolicyArgsDict',
    'NetworkServiceServiceQosPolicyMaximumBitRateArgs',
    'NetworkServiceServiceQosPolicyMaximumBitRateArgsDict',
    'NetworkSimGroupIdentityArgs',
    'NetworkSimGroupIdentityArgsDict',
    'NetworkSimPolicySliceArgs',
    'NetworkSimPolicySliceArgsDict',
    'NetworkSimPolicySliceDataNetworkArgs',
    'NetworkSimPolicySliceDataNetworkArgsDict',
    'NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgs',
    'NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgsDict',
    'NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs',
    'NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgsDict',
    'NetworkSimStaticIpConfigurationArgs',
    'NetworkSimStaticIpConfigurationArgsDict',
    'NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgs',
    'NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgsDict',
]

MYPY = False

if not MYPY:
    class NetworkAttachedDataNetworkNetworkAddressPortTranslationArgsDict(TypedDict):
        icmp_pinhole_timeout_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        Pinhole timeout for ICMP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        """
        pinhole_maximum_number: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface. Must be between 1 and 65536.
        """
        port_range: NotRequired[pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgsDict']]
        """
        A `port_range` block as defined below.
        """
        tcp_pinhole_timeout_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        Pinhole timeout for TCP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        """
        tcp_port_reuse_minimum_hold_time_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Defaults to `120`.
        """
        udp_pinhole_timeout_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        Pinhole timeout for UDP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        """
        udp_port_reuse_minimum_hold_time_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Defaults to `60`.
        """
elif False:
    NetworkAttachedDataNetworkNetworkAddressPortTranslationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkAttachedDataNetworkNetworkAddressPortTranslationArgs:
    def __init__(__self__, *,
                 icmp_pinhole_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 pinhole_maximum_number: Optional[pulumi.Input[_builtins.int]] = None,
                 port_range: Optional[pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgs']] = None,
                 tcp_pinhole_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 tcp_port_reuse_minimum_hold_time_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 udp_pinhole_timeout_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 udp_port_reuse_minimum_hold_time_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] icmp_pinhole_timeout_in_seconds: Pinhole timeout for ICMP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        :param pulumi.Input[_builtins.int] pinhole_maximum_number: Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface. Must be between 1 and 65536.
        :param pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgs'] port_range: A `port_range` block as defined below.
        :param pulumi.Input[_builtins.int] tcp_pinhole_timeout_in_seconds: Pinhole timeout for TCP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        :param pulumi.Input[_builtins.int] tcp_port_reuse_minimum_hold_time_in_seconds: Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Defaults to `120`.
        :param pulumi.Input[_builtins.int] udp_pinhole_timeout_in_seconds: Pinhole timeout for UDP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        :param pulumi.Input[_builtins.int] udp_port_reuse_minimum_hold_time_in_seconds: Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Defaults to `60`.
        """
        if icmp_pinhole_timeout_in_seconds is not None:
            pulumi.set(__self__, "icmp_pinhole_timeout_in_seconds", icmp_pinhole_timeout_in_seconds)
        if pinhole_maximum_number is not None:
            pulumi.set(__self__, "pinhole_maximum_number", pinhole_maximum_number)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if tcp_pinhole_timeout_in_seconds is not None:
            pulumi.set(__self__, "tcp_pinhole_timeout_in_seconds", tcp_pinhole_timeout_in_seconds)
        if tcp_port_reuse_minimum_hold_time_in_seconds is not None:
            pulumi.set(__self__, "tcp_port_reuse_minimum_hold_time_in_seconds", tcp_port_reuse_minimum_hold_time_in_seconds)
        if udp_pinhole_timeout_in_seconds is not None:
            pulumi.set(__self__, "udp_pinhole_timeout_in_seconds", udp_pinhole_timeout_in_seconds)
        if udp_port_reuse_minimum_hold_time_in_seconds is not None:
            pulumi.set(__self__, "udp_port_reuse_minimum_hold_time_in_seconds", udp_port_reuse_minimum_hold_time_in_seconds)

    @_builtins.property
    @pulumi.getter(name="icmpPinholeTimeoutInSeconds")
    def icmp_pinhole_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Pinhole timeout for ICMP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        """
        return pulumi.get(self, "icmp_pinhole_timeout_in_seconds")

    @icmp_pinhole_timeout_in_seconds.setter
    def icmp_pinhole_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "icmp_pinhole_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="pinholeMaximumNumber")
    def pinhole_maximum_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of UDP and TCP pinholes that can be open simultaneously on the core interface. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi interface. Must be between 1 and 65536.
        """
        return pulumi.get(self, "pinhole_maximum_number")

    @pinhole_maximum_number.setter
    def pinhole_maximum_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "pinhole_maximum_number", value)

    @_builtins.property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgs']]:
        """
        A `port_range` block as defined below.
        """
        return pulumi.get(self, "port_range")

    @port_range.setter
    def port_range(self, value: Optional[pulumi.Input['NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgs']]):
        pulumi.set(self, "port_range", value)

    @_builtins.property
    @pulumi.getter(name="tcpPinholeTimeoutInSeconds")
    def tcp_pinhole_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Pinhole timeout for TCP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        """
        return pulumi.get(self, "tcp_pinhole_timeout_in_seconds")

    @tcp_pinhole_timeout_in_seconds.setter
    def tcp_pinhole_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_pinhole_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="tcpPortReuseMinimumHoldTimeInSeconds")
    def tcp_port_reuse_minimum_hold_time_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum time in seconds that will pass before a TCP port that was used by a closed pinhole can be reused. Defaults to `120`.
        """
        return pulumi.get(self, "tcp_port_reuse_minimum_hold_time_in_seconds")

    @tcp_port_reuse_minimum_hold_time_in_seconds.setter
    def tcp_port_reuse_minimum_hold_time_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "tcp_port_reuse_minimum_hold_time_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="udpPinholeTimeoutInSeconds")
    def udp_pinhole_timeout_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Pinhole timeout for UDP pinholes in seconds. Must between `1` to `180`, Default to `180`.
        """
        return pulumi.get(self, "udp_pinhole_timeout_in_seconds")

    @udp_pinhole_timeout_in_seconds.setter
    def udp_pinhole_timeout_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_pinhole_timeout_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="udpPortReuseMinimumHoldTimeInSeconds")
    def udp_port_reuse_minimum_hold_time_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum time in seconds that will pass before a UDP port that was used by a closed pinhole can be reused. Defaults to `60`.
        """
        return pulumi.get(self, "udp_port_reuse_minimum_hold_time_in_seconds")

    @udp_port_reuse_minimum_hold_time_in_seconds.setter
    def udp_port_reuse_minimum_hold_time_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "udp_port_reuse_minimum_hold_time_in_seconds", value)


if not MYPY:
    class NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgsDict(TypedDict):
        maximum: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the maximum port number.
        """
        minimum: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the minimum port number.
        """
elif False:
    NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkAttachedDataNetworkNetworkAddressPortTranslationPortRangeArgs:
    def __init__(__self__, *,
                 maximum: Optional[pulumi.Input[_builtins.int]] = None,
                 minimum: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] maximum: Specifies the maximum port number.
        :param pulumi.Input[_builtins.int] minimum: Specifies the minimum port number.
        """
        if maximum is not None:
            pulumi.set(__self__, "maximum", maximum)
        if minimum is not None:
            pulumi.set(__self__, "minimum", minimum)

    @_builtins.property
    @pulumi.getter
    def maximum(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum port number.
        """
        return pulumi.get(self, "maximum")

    @maximum.setter
    def maximum(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum", value)

    @_builtins.property
    @pulumi.getter
    def minimum(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the minimum port number.
        """
        return pulumi.get(self, "minimum")

    @minimum.setter
    def minimum(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "minimum", value)


if not MYPY:
    class NetworkPacketCoreControlPlaneIdentityArgsDict(TypedDict):
        identity_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        A list of the IDs for User Assigned Managed Identity resources to be assigned.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
elif False:
    NetworkPacketCoreControlPlaneIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkPacketCoreControlPlaneIdentityArgs:
    def __init__(__self__, *,
                 identity_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of the IDs for User Assigned Managed Identity resources to be assigned.
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of the IDs for User Assigned Managed Identity resources to be assigned.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgsDict(TypedDict):
        authentication_type: pulumi.Input[_builtins.str]
        """
        How to authenticate users to access local diagnostics APIs. Possible values are `AAD` and `Password`.
        """
        https_server_certificate_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        The versionless certificate URL used to secure local access to packet core diagnostics over local APIs by the Kubernetes ingress.
        """
elif False:
    NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs:
    def __init__(__self__, *,
                 authentication_type: pulumi.Input[_builtins.str],
                 https_server_certificate_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] authentication_type: How to authenticate users to access local diagnostics APIs. Possible values are `AAD` and `Password`.
        :param pulumi.Input[_builtins.str] https_server_certificate_url: The versionless certificate URL used to secure local access to packet core diagnostics over local APIs by the Kubernetes ingress.
        """
        pulumi.set(__self__, "authentication_type", authentication_type)
        if https_server_certificate_url is not None:
            pulumi.set(__self__, "https_server_certificate_url", https_server_certificate_url)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> pulumi.Input[_builtins.str]:
        """
        How to authenticate users to access local diagnostics APIs. Possible values are `AAD` and `Password`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="httpsServerCertificateUrl")
    def https_server_certificate_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The versionless certificate URL used to secure local access to packet core diagnostics over local APIs by the Kubernetes ingress.
        """
        return pulumi.get(self, "https_server_certificate_url")

    @https_server_certificate_url.setter
    def https_server_certificate_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "https_server_certificate_url", value)


if not MYPY:
    class NetworkPacketCoreControlPlanePlatformArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the platform type where the packet core is deployed. Possible values are `AKS-HCI`, `3P-AZURE-STACK-HCI` and `BaseVM`.
        """
        arc_kubernetes_cluster_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Azure Arc connected cluster where the packet core is deployed.
        """
        custom_location_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Azure Arc custom location where the packet core is deployed.

        > **Note:** At least one of `edge_device_id`, `arc_kubernetes_cluster_id`, `stack_hci_cluster_id` and `custom_location_id` should be specified. If multiple are set, they must be consistent with each other.
        """
        edge_device_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Azure Stack Edge device where the packet core is deployed. If the device is part of a fault-tolerant pair, either device in the pair can be specified.
        """
        stack_hci_cluster_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Azure Stack HCI cluster where the packet core is deployed.
        """
elif False:
    NetworkPacketCoreControlPlanePlatformArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkPacketCoreControlPlanePlatformArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 arc_kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 edge_device_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stack_hci_cluster_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the platform type where the packet core is deployed. Possible values are `AKS-HCI`, `3P-AZURE-STACK-HCI` and `BaseVM`.
        :param pulumi.Input[_builtins.str] arc_kubernetes_cluster_id: The ID of the Azure Arc connected cluster where the packet core is deployed.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of the Azure Arc custom location where the packet core is deployed.
               
               > **Note:** At least one of `edge_device_id`, `arc_kubernetes_cluster_id`, `stack_hci_cluster_id` and `custom_location_id` should be specified. If multiple are set, they must be consistent with each other.
        :param pulumi.Input[_builtins.str] edge_device_id: The ID of the Azure Stack Edge device where the packet core is deployed. If the device is part of a fault-tolerant pair, either device in the pair can be specified.
        :param pulumi.Input[_builtins.str] stack_hci_cluster_id: The ID of the Azure Stack HCI cluster where the packet core is deployed.
        """
        pulumi.set(__self__, "type", type)
        if arc_kubernetes_cluster_id is not None:
            pulumi.set(__self__, "arc_kubernetes_cluster_id", arc_kubernetes_cluster_id)
        if custom_location_id is not None:
            pulumi.set(__self__, "custom_location_id", custom_location_id)
        if edge_device_id is not None:
            pulumi.set(__self__, "edge_device_id", edge_device_id)
        if stack_hci_cluster_id is not None:
            pulumi.set(__self__, "stack_hci_cluster_id", stack_hci_cluster_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the platform type where the packet core is deployed. Possible values are `AKS-HCI`, `3P-AZURE-STACK-HCI` and `BaseVM`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="arcKubernetesClusterId")
    def arc_kubernetes_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Arc connected cluster where the packet core is deployed.
        """
        return pulumi.get(self, "arc_kubernetes_cluster_id")

    @arc_kubernetes_cluster_id.setter
    def arc_kubernetes_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arc_kubernetes_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Arc custom location where the packet core is deployed.

        > **Note:** At least one of `edge_device_id`, `arc_kubernetes_cluster_id`, `stack_hci_cluster_id` and `custom_location_id` should be specified. If multiple are set, they must be consistent with each other.
        """
        return pulumi.get(self, "custom_location_id")

    @custom_location_id.setter
    def custom_location_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_location_id", value)

    @_builtins.property
    @pulumi.getter(name="edgeDeviceId")
    def edge_device_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Stack Edge device where the packet core is deployed. If the device is part of a fault-tolerant pair, either device in the pair can be specified.
        """
        return pulumi.get(self, "edge_device_id")

    @edge_device_id.setter
    def edge_device_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_device_id", value)

    @_builtins.property
    @pulumi.getter(name="stackHciClusterId")
    def stack_hci_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Stack HCI cluster where the packet core is deployed.
        """
        return pulumi.get(self, "stack_hci_cluster_id")

    @stack_hci_cluster_id.setter
    def stack_hci_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stack_hci_cluster_id", value)


if not MYPY:
    class NetworkServicePccRuleArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the rule. This must be unique within the parent service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        """
        precedence: pulumi.Input[_builtins.int]
        """
        A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all data flow policy rules configured in the mobile network. Must be between `0` and `255`.
        """
        service_data_flow_templates: pulumi.Input[Sequence[pulumi.Input['NetworkServicePccRuleServiceDataFlowTemplateArgsDict']]]
        """
        A `service_data_flow_template` block as defined below. The set of service data flow templates to use for this PCC rule.
        """
        qos_policy: NotRequired[pulumi.Input['NetworkServicePccRuleQosPolicyArgsDict']]
        """
        A `qos_policy` block as defined below. The QoS policy to use for packets matching this rule. If this field is not specified then the Service will define the QoS settings.
        """
        traffic_control_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Determines whether flows that match this data flow policy rule are permitted. Defaults to `true`.
        """
elif False:
    NetworkServicePccRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkServicePccRuleArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 precedence: pulumi.Input[_builtins.int],
                 service_data_flow_templates: pulumi.Input[Sequence[pulumi.Input['NetworkServicePccRuleServiceDataFlowTemplateArgs']]],
                 qos_policy: Optional[pulumi.Input['NetworkServicePccRuleQosPolicyArgs']] = None,
                 traffic_control_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the name of the rule. This must be unique within the parent service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        :param pulumi.Input[_builtins.int] precedence: A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all data flow policy rules configured in the mobile network. Must be between `0` and `255`.
        :param pulumi.Input[Sequence[pulumi.Input['NetworkServicePccRuleServiceDataFlowTemplateArgs']]] service_data_flow_templates: A `service_data_flow_template` block as defined below. The set of service data flow templates to use for this PCC rule.
        :param pulumi.Input['NetworkServicePccRuleQosPolicyArgs'] qos_policy: A `qos_policy` block as defined below. The QoS policy to use for packets matching this rule. If this field is not specified then the Service will define the QoS settings.
        :param pulumi.Input[_builtins.bool] traffic_control_enabled: Determines whether flows that match this data flow policy rule are permitted. Defaults to `true`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "precedence", precedence)
        pulumi.set(__self__, "service_data_flow_templates", service_data_flow_templates)
        if qos_policy is not None:
            pulumi.set(__self__, "qos_policy", qos_policy)
        if traffic_control_enabled is not None:
            pulumi.set(__self__, "traffic_control_enabled", traffic_control_enabled)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the rule. This must be unique within the parent service. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def precedence(self) -> pulumi.Input[_builtins.int]:
        """
        A precedence value that is used to decide between data flow policy rules when identifying the QoS values to use for a particular SIM. A lower value means a higher priority. This value should be unique among all data flow policy rules configured in the mobile network. Must be between `0` and `255`.
        """
        return pulumi.get(self, "precedence")

    @precedence.setter
    def precedence(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "precedence", value)

    @_builtins.property
    @pulumi.getter(name="serviceDataFlowTemplates")
    def service_data_flow_templates(self) -> pulumi.Input[Sequence[pulumi.Input['NetworkServicePccRuleServiceDataFlowTemplateArgs']]]:
        """
        A `service_data_flow_template` block as defined below. The set of service data flow templates to use for this PCC rule.
        """
        return pulumi.get(self, "service_data_flow_templates")

    @service_data_flow_templates.setter
    def service_data_flow_templates(self, value: pulumi.Input[Sequence[pulumi.Input['NetworkServicePccRuleServiceDataFlowTemplateArgs']]]):
        pulumi.set(self, "service_data_flow_templates", value)

    @_builtins.property
    @pulumi.getter(name="qosPolicy")
    def qos_policy(self) -> Optional[pulumi.Input['NetworkServicePccRuleQosPolicyArgs']]:
        """
        A `qos_policy` block as defined below. The QoS policy to use for packets matching this rule. If this field is not specified then the Service will define the QoS settings.
        """
        return pulumi.get(self, "qos_policy")

    @qos_policy.setter
    def qos_policy(self, value: Optional[pulumi.Input['NetworkServicePccRuleQosPolicyArgs']]):
        pulumi.set(self, "qos_policy", value)

    @_builtins.property
    @pulumi.getter(name="trafficControlEnabled")
    def traffic_control_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether flows that match this data flow policy rule are permitted. Defaults to `true`.
        """
        return pulumi.get(self, "traffic_control_enabled")

    @traffic_control_enabled.setter
    def traffic_control_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "traffic_control_enabled", value)


if not MYPY:
    class NetworkServicePccRuleQosPolicyArgsDict(TypedDict):
        maximum_bit_rate: pulumi.Input['NetworkServicePccRuleQosPolicyMaximumBitRateArgsDict']
        """
        A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        qos_indicator: pulumi.Input[_builtins.int]
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        """
        allocation_and_retention_priority_level: NotRequired[pulumi.Input[_builtins.int]]
        """
        QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        guaranteed_bit_rate: NotRequired[pulumi.Input['NetworkServicePccRuleQosPolicyGuaranteedBitRateArgsDict']]
        """
        A `guaranteed_bit_rate` block as defined below. The Guaranteed Bit Rate (GBR) for all service data flows that use this PCC Rule. If it's not specified, there will be no GBR set for the PCC Rule that uses this QoS definition.
        """
        preemption_capability: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`, Defaults to `NotPreempt`.
        """
        preemption_vulnerability: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`. Defaults to `Preemptable`.
        """
elif False:
    NetworkServicePccRuleQosPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkServicePccRuleQosPolicyArgs:
    def __init__(__self__, *,
                 maximum_bit_rate: pulumi.Input['NetworkServicePccRuleQosPolicyMaximumBitRateArgs'],
                 qos_indicator: pulumi.Input[_builtins.int],
                 allocation_and_retention_priority_level: Optional[pulumi.Input[_builtins.int]] = None,
                 guaranteed_bit_rate: Optional[pulumi.Input['NetworkServicePccRuleQosPolicyGuaranteedBitRateArgs']] = None,
                 preemption_capability: Optional[pulumi.Input[_builtins.str]] = None,
                 preemption_vulnerability: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input['NetworkServicePccRuleQosPolicyMaximumBitRateArgs'] maximum_bit_rate: A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        :param pulumi.Input[_builtins.int] qos_indicator: The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        :param pulumi.Input[_builtins.int] allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param pulumi.Input['NetworkServicePccRuleQosPolicyGuaranteedBitRateArgs'] guaranteed_bit_rate: A `guaranteed_bit_rate` block as defined below. The Guaranteed Bit Rate (GBR) for all service data flows that use this PCC Rule. If it's not specified, there will be no GBR set for the PCC Rule that uses this QoS definition.
        :param pulumi.Input[_builtins.str] preemption_capability: The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`, Defaults to `NotPreempt`.
        :param pulumi.Input[_builtins.str] preemption_vulnerability: The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`. Defaults to `Preemptable`.
        """
        pulumi.set(__self__, "maximum_bit_rate", maximum_bit_rate)
        pulumi.set(__self__, "qos_indicator", qos_indicator)
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if guaranteed_bit_rate is not None:
            pulumi.set(__self__, "guaranteed_bit_rate", guaranteed_bit_rate)
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)

    @_builtins.property
    @pulumi.getter(name="maximumBitRate")
    def maximum_bit_rate(self) -> pulumi.Input['NetworkServicePccRuleQosPolicyMaximumBitRateArgs']:
        """
        A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        return pulumi.get(self, "maximum_bit_rate")

    @maximum_bit_rate.setter
    def maximum_bit_rate(self, value: pulumi.Input['NetworkServicePccRuleQosPolicyMaximumBitRateArgs']):
        pulumi.set(self, "maximum_bit_rate", value)

    @_builtins.property
    @pulumi.getter(name="qosIndicator")
    def qos_indicator(self) -> pulumi.Input[_builtins.int]:
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        """
        return pulumi.get(self, "qos_indicator")

    @qos_indicator.setter
    def qos_indicator(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "qos_indicator", value)

    @_builtins.property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @allocation_and_retention_priority_level.setter
    def allocation_and_retention_priority_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocation_and_retention_priority_level", value)

    @_builtins.property
    @pulumi.getter(name="guaranteedBitRate")
    def guaranteed_bit_rate(self) -> Optional[pulumi.Input['NetworkServicePccRuleQosPolicyGuaranteedBitRateArgs']]:
        """
        A `guaranteed_bit_rate` block as defined below. The Guaranteed Bit Rate (GBR) for all service data flows that use this PCC Rule. If it's not specified, there will be no GBR set for the PCC Rule that uses this QoS definition.
        """
        return pulumi.get(self, "guaranteed_bit_rate")

    @guaranteed_bit_rate.setter
    def guaranteed_bit_rate(self, value: Optional[pulumi.Input['NetworkServicePccRuleQosPolicyGuaranteedBitRateArgs']]):
        pulumi.set(self, "guaranteed_bit_rate", value)

    @_builtins.property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`, Defaults to `NotPreempt`.
        """
        return pulumi.get(self, "preemption_capability")

    @preemption_capability.setter
    def preemption_capability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preemption_capability", value)

    @_builtins.property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`. Defaults to `Preemptable`.
        """
        return pulumi.get(self, "preemption_vulnerability")

    @preemption_vulnerability.setter
    def preemption_vulnerability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preemption_vulnerability", value)


if not MYPY:
    class NetworkServicePccRuleQosPolicyGuaranteedBitRateArgsDict(TypedDict):
        downlink: pulumi.Input[_builtins.str]
        """
        Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        uplink: pulumi.Input[_builtins.str]
        """
        Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
elif False:
    NetworkServicePccRuleQosPolicyGuaranteedBitRateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkServicePccRuleQosPolicyGuaranteedBitRateArgs:
    def __init__(__self__, *,
                 downlink: pulumi.Input[_builtins.str],
                 uplink: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] downlink: Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        :param pulumi.Input[_builtins.str] uplink: Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @_builtins.property
    @pulumi.getter
    def downlink(self) -> pulumi.Input[_builtins.str]:
        """
        Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "downlink")

    @downlink.setter
    def downlink(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "downlink", value)

    @_builtins.property
    @pulumi.getter
    def uplink(self) -> pulumi.Input[_builtins.str]:
        """
        Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "uplink")

    @uplink.setter
    def uplink(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uplink", value)


if not MYPY:
    class NetworkServicePccRuleQosPolicyMaximumBitRateArgsDict(TypedDict):
        downlink: pulumi.Input[_builtins.str]
        """
        Downlink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        uplink: pulumi.Input[_builtins.str]
        """
        Uplink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
elif False:
    NetworkServicePccRuleQosPolicyMaximumBitRateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkServicePccRuleQosPolicyMaximumBitRateArgs:
    def __init__(__self__, *,
                 downlink: pulumi.Input[_builtins.str],
                 uplink: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] downlink: Downlink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        :param pulumi.Input[_builtins.str] uplink: Uplink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @_builtins.property
    @pulumi.getter
    def downlink(self) -> pulumi.Input[_builtins.str]:
        """
        Downlink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "downlink")

    @downlink.setter
    def downlink(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "downlink", value)

    @_builtins.property
    @pulumi.getter
    def uplink(self) -> pulumi.Input[_builtins.str]:
        """
        Uplink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "uplink")

    @uplink.setter
    def uplink(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uplink", value)


if not MYPY:
    class NetworkServicePccRuleServiceDataFlowTemplateArgsDict(TypedDict):
        direction: pulumi.Input[_builtins.str]
        """
        Specifies the direction of this flow. Possible values are `Uplink`, `Downlink` and `Bidirectional`.
        """
        name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the data flow template. This must be unique within the parent data flow policy rule. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        """
        protocols: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
        """
        remote_ip_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Specifies the remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, `192.0.2.54/24`).
        """
        ports: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. If it is not specified then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
        """
elif False:
    NetworkServicePccRuleServiceDataFlowTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkServicePccRuleServiceDataFlowTemplateArgs:
    def __init__(__self__, *,
                 direction: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 protocols: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 remote_ip_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[_builtins.str] direction: Specifies the direction of this flow. Possible values are `Uplink`, `Downlink` and `Bidirectional`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the data flow template. This must be unique within the parent data flow policy rule. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] remote_ip_lists: Specifies the remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, `192.0.2.54/24`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ports: The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. If it is not specified then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocols", protocols)
        pulumi.set(__self__, "remote_ip_lists", remote_ip_lists)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the direction of this flow. Possible values are `Uplink`, `Downlink` and `Bidirectional`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the data flow template. This must be unique within the parent data flow policy rule. You must not use any of the following reserved strings - `default`, `requested` or `service`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of the allowed protocol(s) for this flow. If you want this flow to be able to use any protocol within the internet protocol suite, use the value `ip`. If you only want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet Protocol Number for each protocol, as described in https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP, you must use 17. If you use the value `ip` then you must leave the field `port` unspecified.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter(name="remoteIpLists")
    def remote_ip_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the remote IP address(es) to which UEs will connect for this flow. If you want to allow connections on any IP address, use the value `any`. Otherwise, you must provide each of the remote IP addresses to which the packet core instance will connect for this flow. You must provide each IP address in CIDR notation, including the netmask (for example, `192.0.2.54/24`).
        """
        return pulumi.get(self, "remote_ip_lists")

    @remote_ip_lists.setter
    def remote_ip_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "remote_ip_lists", value)

    @_builtins.property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The port(s) to which UEs will connect for this flow. You can specify zero or more ports or port ranges. If you specify one or more ports or port ranges then you must specify a value other than `ip` in the `protocol` field. If it is not specified then connections will be allowed on all ports. Port ranges must be specified as <FirstPort>-<LastPort>. For example: [`8080`, `8082-8085`].
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ports", value)


if not MYPY:
    class NetworkServiceServiceQosPolicyArgsDict(TypedDict):
        maximum_bit_rate: pulumi.Input['NetworkServiceServiceQosPolicyMaximumBitRateArgsDict']
        """
        A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        allocation_and_retention_priority_level: NotRequired[pulumi.Input[_builtins.int]]
        """
        QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. Defaults to `9`. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        preemption_capability: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`,.
        """
        preemption_vulnerability: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`.
        """
        qos_indicator: NotRequired[pulumi.Input[_builtins.int]]
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        """
elif False:
    NetworkServiceServiceQosPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkServiceServiceQosPolicyArgs:
    def __init__(__self__, *,
                 maximum_bit_rate: pulumi.Input['NetworkServiceServiceQosPolicyMaximumBitRateArgs'],
                 allocation_and_retention_priority_level: Optional[pulumi.Input[_builtins.int]] = None,
                 preemption_capability: Optional[pulumi.Input[_builtins.str]] = None,
                 preemption_vulnerability: Optional[pulumi.Input[_builtins.str]] = None,
                 qos_indicator: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input['NetworkServiceServiceQosPolicyMaximumBitRateArgs'] maximum_bit_rate: A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        :param pulumi.Input[_builtins.int] allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. Defaults to `9`. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param pulumi.Input[_builtins.str] preemption_capability: The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`,.
        :param pulumi.Input[_builtins.str] preemption_vulnerability: The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`.
        :param pulumi.Input[_builtins.int] qos_indicator: The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        """
        pulumi.set(__self__, "maximum_bit_rate", maximum_bit_rate)
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)
        if qos_indicator is not None:
            pulumi.set(__self__, "qos_indicator", qos_indicator)

    @_builtins.property
    @pulumi.getter(name="maximumBitRate")
    def maximum_bit_rate(self) -> pulumi.Input['NetworkServiceServiceQosPolicyMaximumBitRateArgs']:
        """
        A `maximum_bit_rate` block as defined below. The Maximum Bit Rate (MBR) for all service data flows that use this PCC Rule or Service.
        """
        return pulumi.get(self, "maximum_bit_rate")

    @maximum_bit_rate.setter
    def maximum_bit_rate(self, value: pulumi.Input['NetworkServiceServiceQosPolicyMaximumBitRateArgs']):
        pulumi.set(self, "maximum_bit_rate", value)

    @_builtins.property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. 1 is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. Defaults to `9`. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @allocation_and_retention_priority_level.setter
    def allocation_and_retention_priority_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocation_and_retention_priority_level", value)

    @_builtins.property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Preemption Capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`,.
        """
        return pulumi.get(self, "preemption_capability")

    @preemption_capability.setter
    def preemption_capability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preemption_capability", value)

    @_builtins.property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Preemption Vulnerability of a QoS Flow controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`.
        """
        return pulumi.get(self, "preemption_vulnerability")

    @preemption_vulnerability.setter
    def preemption_vulnerability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preemption_vulnerability", value)

    @_builtins.property
    @pulumi.getter(name="qosIndicator")
    def qos_indicator(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics that control QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        """
        return pulumi.get(self, "qos_indicator")

    @qos_indicator.setter
    def qos_indicator(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "qos_indicator", value)


if not MYPY:
    class NetworkServiceServiceQosPolicyMaximumBitRateArgsDict(TypedDict):
        downlink: pulumi.Input[_builtins.str]
        """
        Downlink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        uplink: pulumi.Input[_builtins.str]
        """
        Uplink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
elif False:
    NetworkServiceServiceQosPolicyMaximumBitRateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkServiceServiceQosPolicyMaximumBitRateArgs:
    def __init__(__self__, *,
                 downlink: pulumi.Input[_builtins.str],
                 uplink: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] downlink: Downlink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        :param pulumi.Input[_builtins.str] uplink: Uplink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @_builtins.property
    @pulumi.getter
    def downlink(self) -> pulumi.Input[_builtins.str]:
        """
        Downlink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "downlink")

    @downlink.setter
    def downlink(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "downlink", value)

    @_builtins.property
    @pulumi.getter
    def uplink(self) -> pulumi.Input[_builtins.str]:
        """
        Uplink bit rate. Must be a number followed by `bps`, `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "uplink")

    @uplink.setter
    def uplink(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uplink", value)


if not MYPY:
    class NetworkSimGroupIdentityArgsDict(TypedDict):
        identity_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        A list of IDs for User Assigned Managed Identity resources to be assigned.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity. Possible value is `UserAssigned`.
        """
elif False:
    NetworkSimGroupIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkSimGroupIdentityArgs:
    def __init__(__self__, *,
                 identity_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of IDs for User Assigned Managed Identity resources to be assigned.
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity. Possible value is `UserAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of IDs for User Assigned Managed Identity resources to be assigned.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity. Possible value is `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class NetworkSimPolicySliceArgsDict(TypedDict):
        data_networks: pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceDataNetworkArgsDict']]]
        """
        An array of `data_network` block as defined below.
        """
        default_data_network_id: pulumi.Input[_builtins.str]
        """
        The ID of default data network to use if the user equipment does not explicitly specify it. Configuration for this object must exist in the `data_network` block.
        """
        slice_id: pulumi.Input[_builtins.str]
        """
        The ID of the slice that these settings apply to.
        """
elif False:
    NetworkSimPolicySliceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkSimPolicySliceArgs:
    def __init__(__self__, *,
                 data_networks: pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceDataNetworkArgs']]],
                 default_data_network_id: pulumi.Input[_builtins.str],
                 slice_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceDataNetworkArgs']]] data_networks: An array of `data_network` block as defined below.
        :param pulumi.Input[_builtins.str] default_data_network_id: The ID of default data network to use if the user equipment does not explicitly specify it. Configuration for this object must exist in the `data_network` block.
        :param pulumi.Input[_builtins.str] slice_id: The ID of the slice that these settings apply to.
        """
        pulumi.set(__self__, "data_networks", data_networks)
        pulumi.set(__self__, "default_data_network_id", default_data_network_id)
        pulumi.set(__self__, "slice_id", slice_id)

    @_builtins.property
    @pulumi.getter(name="dataNetworks")
    def data_networks(self) -> pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceDataNetworkArgs']]]:
        """
        An array of `data_network` block as defined below.
        """
        return pulumi.get(self, "data_networks")

    @data_networks.setter
    def data_networks(self, value: pulumi.Input[Sequence[pulumi.Input['NetworkSimPolicySliceDataNetworkArgs']]]):
        pulumi.set(self, "data_networks", value)

    @_builtins.property
    @pulumi.getter(name="defaultDataNetworkId")
    def default_data_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of default data network to use if the user equipment does not explicitly specify it. Configuration for this object must exist in the `data_network` block.
        """
        return pulumi.get(self, "default_data_network_id")

    @default_data_network_id.setter
    def default_data_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_data_network_id", value)

    @_builtins.property
    @pulumi.getter(name="sliceId")
    def slice_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the slice that these settings apply to.
        """
        return pulumi.get(self, "slice_id")

    @slice_id.setter
    def slice_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "slice_id", value)


if not MYPY:
    class NetworkSimPolicySliceDataNetworkArgsDict(TypedDict):
        allowed_services_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        An array of IDs of services that can be used as part of this SIM policy. The array must not contain duplicate items and must contain at least one item.
        """
        data_network_id: pulumi.Input[_builtins.str]
        """
        The ID of Mobile Network Data Network which these settings apply to.
        """
        qos_indicator: pulumi.Input[_builtins.int]
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics, it controls QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        """
        session_aggregate_maximum_bit_rate: pulumi.Input['NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgsDict']
        """
        A `session_aggregate_maximum_bit_rate` block as defined below.
        """
        additional_allowed_session_types: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Allowed session types in addition to the default session type. Must not duplicate the default session type. Possible values are `IPv4` and `IPv6`.
        """
        allocation_and_retention_priority_level: NotRequired[pulumi.Input[_builtins.int]]
        """
        Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. `1` is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        default_session_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The default PDU session type, which is used if the user equipment does not request a specific session type. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`.
        """
        max_buffered_packets: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering. Defaults to `10`, Must be at least `0`, See 3GPP TS29.272 v15.10.0 section 7.3.188 for a full description. This maximum is not guaranteed because there is a internal limit on buffered packets across all PDU sessions.
        """
        preemption_capability: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Preemption Capability of a QoS Flow, it controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`, Defaults to `NotPreempt`.
        """
        preemption_vulnerability: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Preemption Vulnerability of a QoS Flow, it controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`. Defaults to `NotPreemptable`.
        """
elif False:
    NetworkSimPolicySliceDataNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkSimPolicySliceDataNetworkArgs:
    def __init__(__self__, *,
                 allowed_services_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 data_network_id: pulumi.Input[_builtins.str],
                 qos_indicator: pulumi.Input[_builtins.int],
                 session_aggregate_maximum_bit_rate: pulumi.Input['NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgs'],
                 additional_allowed_session_types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 allocation_and_retention_priority_level: Optional[pulumi.Input[_builtins.int]] = None,
                 default_session_type: Optional[pulumi.Input[_builtins.str]] = None,
                 max_buffered_packets: Optional[pulumi.Input[_builtins.int]] = None,
                 preemption_capability: Optional[pulumi.Input[_builtins.str]] = None,
                 preemption_vulnerability: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] allowed_services_ids: An array of IDs of services that can be used as part of this SIM policy. The array must not contain duplicate items and must contain at least one item.
        :param pulumi.Input[_builtins.str] data_network_id: The ID of Mobile Network Data Network which these settings apply to.
        :param pulumi.Input[_builtins.int] qos_indicator: The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics, it controls QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        :param pulumi.Input['NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgs'] session_aggregate_maximum_bit_rate: A `session_aggregate_maximum_bit_rate` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] additional_allowed_session_types: Allowed session types in addition to the default session type. Must not duplicate the default session type. Possible values are `IPv4` and `IPv6`.
        :param pulumi.Input[_builtins.int] allocation_and_retention_priority_level: Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. `1` is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :param pulumi.Input[_builtins.str] default_session_type: The default PDU session type, which is used if the user equipment does not request a specific session type. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`.
        :param pulumi.Input[_builtins.int] max_buffered_packets: The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering. Defaults to `10`, Must be at least `0`, See 3GPP TS29.272 v15.10.0 section 7.3.188 for a full description. This maximum is not guaranteed because there is a internal limit on buffered packets across all PDU sessions.
        :param pulumi.Input[_builtins.str] preemption_capability: The Preemption Capability of a QoS Flow, it controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`, Defaults to `NotPreempt`.
        :param pulumi.Input[_builtins.str] preemption_vulnerability: The Preemption Vulnerability of a QoS Flow, it controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`. Defaults to `NotPreemptable`.
        """
        pulumi.set(__self__, "allowed_services_ids", allowed_services_ids)
        pulumi.set(__self__, "data_network_id", data_network_id)
        pulumi.set(__self__, "qos_indicator", qos_indicator)
        pulumi.set(__self__, "session_aggregate_maximum_bit_rate", session_aggregate_maximum_bit_rate)
        if additional_allowed_session_types is not None:
            pulumi.set(__self__, "additional_allowed_session_types", additional_allowed_session_types)
        if allocation_and_retention_priority_level is not None:
            pulumi.set(__self__, "allocation_and_retention_priority_level", allocation_and_retention_priority_level)
        if default_session_type is not None:
            pulumi.set(__self__, "default_session_type", default_session_type)
        if max_buffered_packets is not None:
            pulumi.set(__self__, "max_buffered_packets", max_buffered_packets)
        if preemption_capability is not None:
            pulumi.set(__self__, "preemption_capability", preemption_capability)
        if preemption_vulnerability is not None:
            pulumi.set(__self__, "preemption_vulnerability", preemption_vulnerability)

    @_builtins.property
    @pulumi.getter(name="allowedServicesIds")
    def allowed_services_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        An array of IDs of services that can be used as part of this SIM policy. The array must not contain duplicate items and must contain at least one item.
        """
        return pulumi.get(self, "allowed_services_ids")

    @allowed_services_ids.setter
    def allowed_services_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "allowed_services_ids", value)

    @_builtins.property
    @pulumi.getter(name="dataNetworkId")
    def data_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of Mobile Network Data Network which these settings apply to.
        """
        return pulumi.get(self, "data_network_id")

    @data_network_id.setter
    def data_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_network_id", value)

    @_builtins.property
    @pulumi.getter(name="qosIndicator")
    def qos_indicator(self) -> pulumi.Input[_builtins.int]:
        """
        The QoS Indicator (5QI for 5G network /QCI for 4G net work) value identifies a set of QoS characteristics, it controls QoS forwarding treatment for QoS flows or EPS bearers. Recommended values: 5-9; 69-70; 79-80. Must be between `1` and `127`.
        """
        return pulumi.get(self, "qos_indicator")

    @qos_indicator.setter
    def qos_indicator(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "qos_indicator", value)

    @_builtins.property
    @pulumi.getter(name="sessionAggregateMaximumBitRate")
    def session_aggregate_maximum_bit_rate(self) -> pulumi.Input['NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgs']:
        """
        A `session_aggregate_maximum_bit_rate` block as defined below.
        """
        return pulumi.get(self, "session_aggregate_maximum_bit_rate")

    @session_aggregate_maximum_bit_rate.setter
    def session_aggregate_maximum_bit_rate(self, value: pulumi.Input['NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgs']):
        pulumi.set(self, "session_aggregate_maximum_bit_rate", value)

    @_builtins.property
    @pulumi.getter(name="additionalAllowedSessionTypes")
    def additional_allowed_session_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Allowed session types in addition to the default session type. Must not duplicate the default session type. Possible values are `IPv4` and `IPv6`.
        """
        return pulumi.get(self, "additional_allowed_session_types")

    @additional_allowed_session_types.setter
    def additional_allowed_session_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_allowed_session_types", value)

    @_builtins.property
    @pulumi.getter(name="allocationAndRetentionPriorityLevel")
    def allocation_and_retention_priority_level(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Default QoS Flow allocation and retention priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of `preemption_capability` and `preemption_vulnerability` allow it. `1` is the highest level of priority. If this field is not specified then `qos_indicator` is used to derive the ARP value. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        """
        return pulumi.get(self, "allocation_and_retention_priority_level")

    @allocation_and_retention_priority_level.setter
    def allocation_and_retention_priority_level(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocation_and_retention_priority_level", value)

    @_builtins.property
    @pulumi.getter(name="defaultSessionType")
    def default_session_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default PDU session type, which is used if the user equipment does not request a specific session type. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`.
        """
        return pulumi.get(self, "default_session_type")

    @default_session_type.setter
    def default_session_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_session_type", value)

    @_builtins.property
    @pulumi.getter(name="maxBufferedPackets")
    def max_buffered_packets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of downlink packets to buffer at the user plane for High Latency Communication - Extended Buffering. Defaults to `10`, Must be at least `0`, See 3GPP TS29.272 v15.10.0 section 7.3.188 for a full description. This maximum is not guaranteed because there is a internal limit on buffered packets across all PDU sessions.
        """
        return pulumi.get(self, "max_buffered_packets")

    @max_buffered_packets.setter
    def max_buffered_packets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_buffered_packets", value)

    @_builtins.property
    @pulumi.getter(name="preemptionCapability")
    def preemption_capability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Preemption Capability of a QoS Flow, it controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreempt` and `MayPreempt`, Defaults to `NotPreempt`.
        """
        return pulumi.get(self, "preemption_capability")

    @preemption_capability.setter
    def preemption_capability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preemption_capability", value)

    @_builtins.property
    @pulumi.getter(name="preemptionVulnerability")
    def preemption_vulnerability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Preemption Vulnerability of a QoS Flow, it controls whether it can be preempted by QoS Flow with a higher priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Possible values are `NotPreemptable` and `Preemptable`. Defaults to `NotPreemptable`.
        """
        return pulumi.get(self, "preemption_vulnerability")

    @preemption_vulnerability.setter
    def preemption_vulnerability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preemption_vulnerability", value)


if not MYPY:
    class NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgsDict(TypedDict):
        downlink: pulumi.Input[_builtins.str]
        """
        Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        uplink: pulumi.Input[_builtins.str]
        """
        Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
elif False:
    NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkSimPolicySliceDataNetworkSessionAggregateMaximumBitRateArgs:
    def __init__(__self__, *,
                 downlink: pulumi.Input[_builtins.str],
                 uplink: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] downlink: Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        :param pulumi.Input[_builtins.str] uplink: Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @_builtins.property
    @pulumi.getter
    def downlink(self) -> pulumi.Input[_builtins.str]:
        """
        Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "downlink")

    @downlink.setter
    def downlink(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "downlink", value)

    @_builtins.property
    @pulumi.getter
    def uplink(self) -> pulumi.Input[_builtins.str]:
        """
        Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "uplink")

    @uplink.setter
    def uplink(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uplink", value)


if not MYPY:
    class NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgsDict(TypedDict):
        downlink: pulumi.Input[_builtins.str]
        """
        Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        uplink: pulumi.Input[_builtins.str]
        """
        Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
elif False:
    NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkSimPolicyUserEquipmentAggregateMaximumBitRateArgs:
    def __init__(__self__, *,
                 downlink: pulumi.Input[_builtins.str],
                 uplink: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] downlink: Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        :param pulumi.Input[_builtins.str] uplink: Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        pulumi.set(__self__, "downlink", downlink)
        pulumi.set(__self__, "uplink", uplink)

    @_builtins.property
    @pulumi.getter
    def downlink(self) -> pulumi.Input[_builtins.str]:
        """
        Downlink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "downlink")

    @downlink.setter
    def downlink(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "downlink", value)

    @_builtins.property
    @pulumi.getter
    def uplink(self) -> pulumi.Input[_builtins.str]:
        """
        Uplink bit rate. Must be a number followed by `Kbps`, `Mbps`, `Gbps` or `Tbps`.
        """
        return pulumi.get(self, "uplink")

    @uplink.setter
    def uplink(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "uplink", value)


if not MYPY:
    class NetworkSimStaticIpConfigurationArgsDict(TypedDict):
        attached_data_network_id: pulumi.Input[_builtins.str]
        """
        The ID of attached data network on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address.
        """
        slice_id: pulumi.Input[_builtins.str]
        """
        The ID of network slice on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address.
        """
        static_ipv4_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
        """
elif False:
    NetworkSimStaticIpConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkSimStaticIpConfigurationArgs:
    def __init__(__self__, *,
                 attached_data_network_id: pulumi.Input[_builtins.str],
                 slice_id: pulumi.Input[_builtins.str],
                 static_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] attached_data_network_id: The ID of attached data network on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address.
        :param pulumi.Input[_builtins.str] slice_id: The ID of network slice on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address.
        :param pulumi.Input[_builtins.str] static_ipv4_address: The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
        """
        pulumi.set(__self__, "attached_data_network_id", attached_data_network_id)
        pulumi.set(__self__, "slice_id", slice_id)
        if static_ipv4_address is not None:
            pulumi.set(__self__, "static_ipv4_address", static_ipv4_address)

    @_builtins.property
    @pulumi.getter(name="attachedDataNetworkId")
    def attached_data_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of attached data network on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address.
        """
        return pulumi.get(self, "attached_data_network_id")

    @attached_data_network_id.setter
    def attached_data_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "attached_data_network_id", value)

    @_builtins.property
    @pulumi.getter(name="sliceId")
    def slice_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of network slice on which the static IP address will be used. The combination of attached data network and slice defines the network scope of the IP address.
        """
        return pulumi.get(self, "slice_id")

    @slice_id.setter
    def slice_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "slice_id", value)

    @_builtins.property
    @pulumi.getter(name="staticIpv4Address")
    def static_ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address assigned to the SIM at this network scope. This address must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
        """
        return pulumi.get(self, "static_ipv4_address")

    @static_ipv4_address.setter
    def static_ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "static_ipv4_address", value)


if not MYPY:
    class NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgsDict(TypedDict):
        slice_service_type: pulumi.Input[_builtins.int]
        """
        Slice/service type (SST). Must be between `0` and `255`.
        """
        slice_differentiator: NotRequired[pulumi.Input[_builtins.str]]
        """
        Slice differentiator (SD). Must be a 6 digit hex string.
        """
elif False:
    NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgs:
    def __init__(__self__, *,
                 slice_service_type: pulumi.Input[_builtins.int],
                 slice_differentiator: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] slice_service_type: Slice/service type (SST). Must be between `0` and `255`.
        :param pulumi.Input[_builtins.str] slice_differentiator: Slice differentiator (SD). Must be a 6 digit hex string.
        """
        pulumi.set(__self__, "slice_service_type", slice_service_type)
        if slice_differentiator is not None:
            pulumi.set(__self__, "slice_differentiator", slice_differentiator)

    @_builtins.property
    @pulumi.getter(name="sliceServiceType")
    def slice_service_type(self) -> pulumi.Input[_builtins.int]:
        """
        Slice/service type (SST). Must be between `0` and `255`.
        """
        return pulumi.get(self, "slice_service_type")

    @slice_service_type.setter
    def slice_service_type(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "slice_service_type", value)

    @_builtins.property
    @pulumi.getter(name="sliceDifferentiator")
    def slice_differentiator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Slice differentiator (SD). Must be a 6 digit hex string.
        """
        return pulumi.get(self, "slice_differentiator")

    @slice_differentiator.setter
    def slice_differentiator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slice_differentiator", value)


