# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataCollectionRuleArgs', 'DataCollectionRule']

@pulumi.input_type
class DataCollectionRuleArgs:
    def __init__(__self__, *,
                 data_flows: pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleDataFlowArgs']]],
                 destinations: pulumi.Input['DataCollectionRuleDestinationsArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 data_collection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_sources: Optional[pulumi.Input['DataCollectionRuleDataSourcesArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['DataCollectionRuleIdentityArgs']] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_declarations: Optional[pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleStreamDeclarationArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DataCollectionRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleDataFlowArgs']]] data_flows: One or more `data_flow` blocks as defined below.
        :param pulumi.Input['DataCollectionRuleDestinationsArgs'] destinations: A `destinations` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] data_collection_endpoint_id: The resource ID of the Data Collection Endpoint that this rule can be used with.
        :param pulumi.Input['DataCollectionRuleDataSourcesArgs'] data_sources: A `data_sources` block as defined below. This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        :param pulumi.Input[_builtins.str] description: The description of the Data Collection Rule.
        :param pulumi.Input['DataCollectionRuleIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] kind: The kind of the Data Collection Rule. Possible values are `Linux`, `Windows`, `AgentDirectToStore` and `WorkspaceTransforms`. A rule of kind `Linux` does not allow for `windows_event_log` data sources. And a rule of kind `Windows` does not allow for `syslog` data sources. If kind is not specified, all kinds of data sources are allowed.
               
               > **Note:** Once `kind` has been set, changing it forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Collection Rule. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleStreamDeclarationArgs']]] stream_declarations: A `stream_declaration` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Data Collection Rule.
        """
        pulumi.set(__self__, "data_flows", data_flows)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if data_collection_endpoint_id is not None:
            pulumi.set(__self__, "data_collection_endpoint_id", data_collection_endpoint_id)
        if data_sources is not None:
            pulumi.set(__self__, "data_sources", data_sources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if stream_declarations is not None:
            pulumi.set(__self__, "stream_declarations", stream_declarations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="dataFlows")
    def data_flows(self) -> pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleDataFlowArgs']]]:
        """
        One or more `data_flow` blocks as defined below.
        """
        return pulumi.get(self, "data_flows")

    @data_flows.setter
    def data_flows(self, value: pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleDataFlowArgs']]]):
        pulumi.set(self, "data_flows", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Input['DataCollectionRuleDestinationsArgs']:
        """
        A `destinations` block as defined below.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input['DataCollectionRuleDestinationsArgs']):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionEndpointId")
    def data_collection_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Data Collection Endpoint that this rule can be used with.
        """
        return pulumi.get(self, "data_collection_endpoint_id")

    @data_collection_endpoint_id.setter
    def data_collection_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_collection_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Optional[pulumi.Input['DataCollectionRuleDataSourcesArgs']]:
        """
        A `data_sources` block as defined below. This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        """
        return pulumi.get(self, "data_sources")

    @data_sources.setter
    def data_sources(self, value: Optional[pulumi.Input['DataCollectionRuleDataSourcesArgs']]):
        pulumi.set(self, "data_sources", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Data Collection Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['DataCollectionRuleIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['DataCollectionRuleIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kind of the Data Collection Rule. Possible values are `Linux`, `Windows`, `AgentDirectToStore` and `WorkspaceTransforms`. A rule of kind `Linux` does not allow for `windows_event_log` data sources. And a rule of kind `Windows` does not allow for `syslog` data sources. If kind is not specified, all kinds of data sources are allowed.

        > **Note:** Once `kind` has been set, changing it forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Data Collection Rule. Changing this forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="streamDeclarations")
    def stream_declarations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleStreamDeclarationArgs']]]]:
        """
        A `stream_declaration` block as defined below.
        """
        return pulumi.get(self, "stream_declarations")

    @stream_declarations.setter
    def stream_declarations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleStreamDeclarationArgs']]]]):
        pulumi.set(self, "stream_declarations", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Data Collection Rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DataCollectionRuleState:
    def __init__(__self__, *,
                 data_collection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_flows: Optional[pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleDataFlowArgs']]]] = None,
                 data_sources: Optional[pulumi.Input['DataCollectionRuleDataSourcesArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input['DataCollectionRuleDestinationsArgs']] = None,
                 identity: Optional[pulumi.Input['DataCollectionRuleIdentityArgs']] = None,
                 immutable_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_declarations: Optional[pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleStreamDeclarationArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering DataCollectionRule resources.
        :param pulumi.Input[_builtins.str] data_collection_endpoint_id: The resource ID of the Data Collection Endpoint that this rule can be used with.
        :param pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleDataFlowArgs']]] data_flows: One or more `data_flow` blocks as defined below.
        :param pulumi.Input['DataCollectionRuleDataSourcesArgs'] data_sources: A `data_sources` block as defined below. This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        :param pulumi.Input[_builtins.str] description: The description of the Data Collection Rule.
        :param pulumi.Input['DataCollectionRuleDestinationsArgs'] destinations: A `destinations` block as defined below.
        :param pulumi.Input['DataCollectionRuleIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] immutable_id: The immutable ID of the Data Collection Rule.
        :param pulumi.Input[_builtins.str] kind: The kind of the Data Collection Rule. Possible values are `Linux`, `Windows`, `AgentDirectToStore` and `WorkspaceTransforms`. A rule of kind `Linux` does not allow for `windows_event_log` data sources. And a rule of kind `Windows` does not allow for `syslog` data sources. If kind is not specified, all kinds of data sources are allowed.
               
               > **Note:** Once `kind` has been set, changing it forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Collection Rule. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleStreamDeclarationArgs']]] stream_declarations: A `stream_declaration` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Data Collection Rule.
        """
        if data_collection_endpoint_id is not None:
            pulumi.set(__self__, "data_collection_endpoint_id", data_collection_endpoint_id)
        if data_flows is not None:
            pulumi.set(__self__, "data_flows", data_flows)
        if data_sources is not None:
            pulumi.set(__self__, "data_sources", data_sources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if immutable_id is not None:
            pulumi.set(__self__, "immutable_id", immutable_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if stream_declarations is not None:
            pulumi.set(__self__, "stream_declarations", stream_declarations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="dataCollectionEndpointId")
    def data_collection_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Data Collection Endpoint that this rule can be used with.
        """
        return pulumi.get(self, "data_collection_endpoint_id")

    @data_collection_endpoint_id.setter
    def data_collection_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_collection_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="dataFlows")
    def data_flows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleDataFlowArgs']]]]:
        """
        One or more `data_flow` blocks as defined below.
        """
        return pulumi.get(self, "data_flows")

    @data_flows.setter
    def data_flows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleDataFlowArgs']]]]):
        pulumi.set(self, "data_flows", value)

    @_builtins.property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> Optional[pulumi.Input['DataCollectionRuleDataSourcesArgs']]:
        """
        A `data_sources` block as defined below. This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        """
        return pulumi.get(self, "data_sources")

    @data_sources.setter
    def data_sources(self, value: Optional[pulumi.Input['DataCollectionRuleDataSourcesArgs']]):
        pulumi.set(self, "data_sources", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Data Collection Rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input['DataCollectionRuleDestinationsArgs']]:
        """
        A `destinations` block as defined below.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input['DataCollectionRuleDestinationsArgs']]):
        pulumi.set(self, "destinations", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['DataCollectionRuleIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['DataCollectionRuleIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="immutableId")
    def immutable_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The immutable ID of the Data Collection Rule.
        """
        return pulumi.get(self, "immutable_id")

    @immutable_id.setter
    def immutable_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "immutable_id", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The kind of the Data Collection Rule. Possible values are `Linux`, `Windows`, `AgentDirectToStore` and `WorkspaceTransforms`. A rule of kind `Linux` does not allow for `windows_event_log` data sources. And a rule of kind `Windows` does not allow for `syslog` data sources. If kind is not specified, all kinds of data sources are allowed.

        > **Note:** Once `kind` has been set, changing it forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Data Collection Rule. Changing this forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="streamDeclarations")
    def stream_declarations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleStreamDeclarationArgs']]]]:
        """
        A `stream_declaration` block as defined below.
        """
        return pulumi.get(self, "stream_declarations")

    @stream_declarations.setter
    def stream_declarations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataCollectionRuleStreamDeclarationArgs']]]]):
        pulumi.set(self, "stream_declarations", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Data Collection Rule.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:monitoring/dataCollectionRule:DataCollectionRule")
class DataCollectionRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_collection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_flows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataCollectionRuleDataFlowArgs', 'DataCollectionRuleDataFlowArgsDict']]]]] = None,
                 data_sources: Optional[pulumi.Input[Union['DataCollectionRuleDataSourcesArgs', 'DataCollectionRuleDataSourcesArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Union['DataCollectionRuleDestinationsArgs', 'DataCollectionRuleDestinationsArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['DataCollectionRuleIdentityArgs', 'DataCollectionRuleIdentityArgsDict']]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_declarations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataCollectionRuleStreamDeclarationArgs', 'DataCollectionRuleStreamDeclarationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Data Collection Rule.

        ## Import

        Data Collection Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/dataCollectionRule:DataCollectionRule example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Insights/dataCollectionRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_collection_endpoint_id: The resource ID of the Data Collection Endpoint that this rule can be used with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataCollectionRuleDataFlowArgs', 'DataCollectionRuleDataFlowArgsDict']]]] data_flows: One or more `data_flow` blocks as defined below.
        :param pulumi.Input[Union['DataCollectionRuleDataSourcesArgs', 'DataCollectionRuleDataSourcesArgsDict']] data_sources: A `data_sources` block as defined below. This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        :param pulumi.Input[_builtins.str] description: The description of the Data Collection Rule.
        :param pulumi.Input[Union['DataCollectionRuleDestinationsArgs', 'DataCollectionRuleDestinationsArgsDict']] destinations: A `destinations` block as defined below.
        :param pulumi.Input[Union['DataCollectionRuleIdentityArgs', 'DataCollectionRuleIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] kind: The kind of the Data Collection Rule. Possible values are `Linux`, `Windows`, `AgentDirectToStore` and `WorkspaceTransforms`. A rule of kind `Linux` does not allow for `windows_event_log` data sources. And a rule of kind `Windows` does not allow for `syslog` data sources. If kind is not specified, all kinds of data sources are allowed.
               
               > **Note:** Once `kind` has been set, changing it forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Collection Rule. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataCollectionRuleStreamDeclarationArgs', 'DataCollectionRuleStreamDeclarationArgsDict']]]] stream_declarations: A `stream_declaration` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Data Collection Rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataCollectionRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Data Collection Rule.

        ## Import

        Data Collection Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/dataCollectionRule:DataCollectionRule example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Insights/dataCollectionRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param DataCollectionRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataCollectionRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_collection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_flows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataCollectionRuleDataFlowArgs', 'DataCollectionRuleDataFlowArgsDict']]]]] = None,
                 data_sources: Optional[pulumi.Input[Union['DataCollectionRuleDataSourcesArgs', 'DataCollectionRuleDataSourcesArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Union['DataCollectionRuleDestinationsArgs', 'DataCollectionRuleDestinationsArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['DataCollectionRuleIdentityArgs', 'DataCollectionRuleIdentityArgsDict']]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_declarations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataCollectionRuleStreamDeclarationArgs', 'DataCollectionRuleStreamDeclarationArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataCollectionRuleArgs.__new__(DataCollectionRuleArgs)

            __props__.__dict__["data_collection_endpoint_id"] = data_collection_endpoint_id
            if data_flows is None and not opts.urn:
                raise TypeError("Missing required property 'data_flows'")
            __props__.__dict__["data_flows"] = data_flows
            __props__.__dict__["data_sources"] = data_sources
            __props__.__dict__["description"] = description
            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            __props__.__dict__["identity"] = identity
            __props__.__dict__["kind"] = kind
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["stream_declarations"] = stream_declarations
            __props__.__dict__["tags"] = tags
            __props__.__dict__["immutable_id"] = None
        super(DataCollectionRule, __self__).__init__(
            'azure:monitoring/dataCollectionRule:DataCollectionRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_collection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_flows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataCollectionRuleDataFlowArgs', 'DataCollectionRuleDataFlowArgsDict']]]]] = None,
            data_sources: Optional[pulumi.Input[Union['DataCollectionRuleDataSourcesArgs', 'DataCollectionRuleDataSourcesArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destinations: Optional[pulumi.Input[Union['DataCollectionRuleDestinationsArgs', 'DataCollectionRuleDestinationsArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['DataCollectionRuleIdentityArgs', 'DataCollectionRuleIdentityArgsDict']]] = None,
            immutable_id: Optional[pulumi.Input[_builtins.str]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            stream_declarations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataCollectionRuleStreamDeclarationArgs', 'DataCollectionRuleStreamDeclarationArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'DataCollectionRule':
        """
        Get an existing DataCollectionRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_collection_endpoint_id: The resource ID of the Data Collection Endpoint that this rule can be used with.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataCollectionRuleDataFlowArgs', 'DataCollectionRuleDataFlowArgsDict']]]] data_flows: One or more `data_flow` blocks as defined below.
        :param pulumi.Input[Union['DataCollectionRuleDataSourcesArgs', 'DataCollectionRuleDataSourcesArgsDict']] data_sources: A `data_sources` block as defined below. This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        :param pulumi.Input[_builtins.str] description: The description of the Data Collection Rule.
        :param pulumi.Input[Union['DataCollectionRuleDestinationsArgs', 'DataCollectionRuleDestinationsArgsDict']] destinations: A `destinations` block as defined below.
        :param pulumi.Input[Union['DataCollectionRuleIdentityArgs', 'DataCollectionRuleIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] immutable_id: The immutable ID of the Data Collection Rule.
        :param pulumi.Input[_builtins.str] kind: The kind of the Data Collection Rule. Possible values are `Linux`, `Windows`, `AgentDirectToStore` and `WorkspaceTransforms`. A rule of kind `Linux` does not allow for `windows_event_log` data sources. And a rule of kind `Windows` does not allow for `syslog` data sources. If kind is not specified, all kinds of data sources are allowed.
               
               > **Note:** Once `kind` has been set, changing it forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Collection Rule. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataCollectionRuleStreamDeclarationArgs', 'DataCollectionRuleStreamDeclarationArgsDict']]]] stream_declarations: A `stream_declaration` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Data Collection Rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataCollectionRuleState.__new__(_DataCollectionRuleState)

        __props__.__dict__["data_collection_endpoint_id"] = data_collection_endpoint_id
        __props__.__dict__["data_flows"] = data_flows
        __props__.__dict__["data_sources"] = data_sources
        __props__.__dict__["description"] = description
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["identity"] = identity
        __props__.__dict__["immutable_id"] = immutable_id
        __props__.__dict__["kind"] = kind
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["stream_declarations"] = stream_declarations
        __props__.__dict__["tags"] = tags
        return DataCollectionRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataCollectionEndpointId")
    def data_collection_endpoint_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource ID of the Data Collection Endpoint that this rule can be used with.
        """
        return pulumi.get(self, "data_collection_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="dataFlows")
    def data_flows(self) -> pulumi.Output[Sequence['outputs.DataCollectionRuleDataFlow']]:
        """
        One or more `data_flow` blocks as defined below.
        """
        return pulumi.get(self, "data_flows")

    @_builtins.property
    @pulumi.getter(name="dataSources")
    def data_sources(self) -> pulumi.Output[Optional['outputs.DataCollectionRuleDataSources']]:
        """
        A `data_sources` block as defined below. This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        """
        return pulumi.get(self, "data_sources")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Data Collection Rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def destinations(self) -> pulumi.Output['outputs.DataCollectionRuleDestinations']:
        """
        A `destinations` block as defined below.
        """
        return pulumi.get(self, "destinations")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.DataCollectionRuleIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="immutableId")
    def immutable_id(self) -> pulumi.Output[_builtins.str]:
        """
        The immutable ID of the Data Collection Rule.
        """
        return pulumi.get(self, "immutable_id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The kind of the Data Collection Rule. Possible values are `Linux`, `Windows`, `AgentDirectToStore` and `WorkspaceTransforms`. A rule of kind `Linux` does not allow for `windows_event_log` data sources. And a rule of kind `Windows` does not allow for `syslog` data sources. If kind is not specified, all kinds of data sources are allowed.

        > **Note:** Once `kind` has been set, changing it forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Data Collection Rule. Changing this forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Data Collection Rule should exist. Changing this forces a new Data Collection Rule to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="streamDeclarations")
    def stream_declarations(self) -> pulumi.Output[Optional[Sequence['outputs.DataCollectionRuleStreamDeclaration']]]:
        """
        A `stream_declaration` block as defined below.
        """
        return pulumi.get(self, "stream_declarations")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Data Collection Rule.
        """
        return pulumi.get(self, "tags")

