# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerVulnerabilityAssessmentArgs', 'ServerVulnerabilityAssessment']

@pulumi.input_type
class ServerVulnerabilityAssessmentArgs:
    def __init__(__self__, *,
                 server_security_alert_policy_id: pulumi.Input[_builtins.str],
                 storage_container_path: pulumi.Input[_builtins.str],
                 recurring_scans: Optional[pulumi.Input['ServerVulnerabilityAssessmentRecurringScansArgs']] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServerVulnerabilityAssessment resource.
        :param pulumi.Input[_builtins.str] server_security_alert_policy_id: The id of the security alert policy of the MS SQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_container_path: Specifies the blob storage container path that will hold the scan results (e.g., <https://example.blob.core.windows.net/example/>).
        :param pulumi.Input['ServerVulnerabilityAssessmentRecurringScansArgs'] recurring_scans: A `recurring_scans` block as defined below.
               
               > **Note:** To reset the `recurring_scans` code block to it's default values you must explicitly define an empty `recurring_scans` code block (e.g., `recurring_scans {}`) in your configuration file.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the primary access key of the blob storage endpoint.
               
               > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.
               
               > **Note:** If the `storage_account_access_key` property is not defined the `storage_container_sas_key` property is required.
        :param pulumi.Input[_builtins.str] storage_container_sas_key: Specifies the shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` property.
               
               > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.
               
               > **Note:** If the `storage_container_sas_key` property is not defined the `storage_account_access_key` property is required.
        """
        pulumi.set(__self__, "server_security_alert_policy_id", server_security_alert_policy_id)
        pulumi.set(__self__, "storage_container_path", storage_container_path)
        if recurring_scans is not None:
            pulumi.set(__self__, "recurring_scans", recurring_scans)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_container_sas_key is not None:
            pulumi.set(__self__, "storage_container_sas_key", storage_container_sas_key)

    @_builtins.property
    @pulumi.getter(name="serverSecurityAlertPolicyId")
    def server_security_alert_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the security alert policy of the MS SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_security_alert_policy_id")

    @server_security_alert_policy_id.setter
    def server_security_alert_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_security_alert_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerPath")
    def storage_container_path(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the blob storage container path that will hold the scan results (e.g., <https://example.blob.core.windows.net/example/>).
        """
        return pulumi.get(self, "storage_container_path")

    @storage_container_path.setter
    def storage_container_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_container_path", value)

    @_builtins.property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> Optional[pulumi.Input['ServerVulnerabilityAssessmentRecurringScansArgs']]:
        """
        A `recurring_scans` block as defined below.

        > **Note:** To reset the `recurring_scans` code block to it's default values you must explicitly define an empty `recurring_scans` code block (e.g., `recurring_scans {}`) in your configuration file.
        """
        return pulumi.get(self, "recurring_scans")

    @recurring_scans.setter
    def recurring_scans(self, value: Optional[pulumi.Input['ServerVulnerabilityAssessmentRecurringScansArgs']]):
        pulumi.set(self, "recurring_scans", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the primary access key of the blob storage endpoint.

        > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.

        > **Note:** If the `storage_account_access_key` property is not defined the `storage_container_sas_key` property is required.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerSasKey")
    def storage_container_sas_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` property.

        > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.

        > **Note:** If the `storage_container_sas_key` property is not defined the `storage_account_access_key` property is required.
        """
        return pulumi.get(self, "storage_container_sas_key")

    @storage_container_sas_key.setter
    def storage_container_sas_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_sas_key", value)


@pulumi.input_type
class _ServerVulnerabilityAssessmentState:
    def __init__(__self__, *,
                 recurring_scans: Optional[pulumi.Input['ServerVulnerabilityAssessmentRecurringScansArgs']] = None,
                 server_security_alert_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServerVulnerabilityAssessment resources.
        :param pulumi.Input['ServerVulnerabilityAssessmentRecurringScansArgs'] recurring_scans: A `recurring_scans` block as defined below.
               
               > **Note:** To reset the `recurring_scans` code block to it's default values you must explicitly define an empty `recurring_scans` code block (e.g., `recurring_scans {}`) in your configuration file.
        :param pulumi.Input[_builtins.str] server_security_alert_policy_id: The id of the security alert policy of the MS SQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the primary access key of the blob storage endpoint.
               
               > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.
               
               > **Note:** If the `storage_account_access_key` property is not defined the `storage_container_sas_key` property is required.
        :param pulumi.Input[_builtins.str] storage_container_path: Specifies the blob storage container path that will hold the scan results (e.g., <https://example.blob.core.windows.net/example/>).
        :param pulumi.Input[_builtins.str] storage_container_sas_key: Specifies the shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` property.
               
               > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.
               
               > **Note:** If the `storage_container_sas_key` property is not defined the `storage_account_access_key` property is required.
        """
        if recurring_scans is not None:
            pulumi.set(__self__, "recurring_scans", recurring_scans)
        if server_security_alert_policy_id is not None:
            pulumi.set(__self__, "server_security_alert_policy_id", server_security_alert_policy_id)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_container_path is not None:
            pulumi.set(__self__, "storage_container_path", storage_container_path)
        if storage_container_sas_key is not None:
            pulumi.set(__self__, "storage_container_sas_key", storage_container_sas_key)

    @_builtins.property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> Optional[pulumi.Input['ServerVulnerabilityAssessmentRecurringScansArgs']]:
        """
        A `recurring_scans` block as defined below.

        > **Note:** To reset the `recurring_scans` code block to it's default values you must explicitly define an empty `recurring_scans` code block (e.g., `recurring_scans {}`) in your configuration file.
        """
        return pulumi.get(self, "recurring_scans")

    @recurring_scans.setter
    def recurring_scans(self, value: Optional[pulumi.Input['ServerVulnerabilityAssessmentRecurringScansArgs']]):
        pulumi.set(self, "recurring_scans", value)

    @_builtins.property
    @pulumi.getter(name="serverSecurityAlertPolicyId")
    def server_security_alert_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the security alert policy of the MS SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_security_alert_policy_id")

    @server_security_alert_policy_id.setter
    def server_security_alert_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_security_alert_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the primary access key of the blob storage endpoint.

        > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.

        > **Note:** If the `storage_account_access_key` property is not defined the `storage_container_sas_key` property is required.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerPath")
    def storage_container_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the blob storage container path that will hold the scan results (e.g., <https://example.blob.core.windows.net/example/>).
        """
        return pulumi.get(self, "storage_container_path")

    @storage_container_path.setter
    def storage_container_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_path", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerSasKey")
    def storage_container_sas_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` property.

        > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.

        > **Note:** If the `storage_container_sas_key` property is not defined the `storage_account_access_key` property is required.
        """
        return pulumi.get(self, "storage_container_sas_key")

    @storage_container_sas_key.setter
    def storage_container_sas_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_sas_key", value)


@pulumi.type_token("azure:mssql/serverVulnerabilityAssessment:ServerVulnerabilityAssessment")
class ServerVulnerabilityAssessment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 recurring_scans: Optional[pulumi.Input[Union['ServerVulnerabilityAssessmentRecurringScansArgs', 'ServerVulnerabilityAssessmentRecurringScansArgsDict']]] = None,
                 server_security_alert_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages the Vulnerability Assessment for an MS SQL Server.

        > **Note:** Vulnerability Assessment is currently only available for MS SQL databases.

        > **Note:** This resource cannot be used to enable the Express SQL Vulnerability Assessment configuration, to enable the express configuration, use `express_vulnerability_assessment_enabled` in the `mssql.Server` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_server = azure.mssql.Server("example",
            name="mysqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_server_security_alert_policy = azure.mssql.ServerSecurityAlertPolicy("example",
            resource_group_name=example.name,
            server_name=example_server.name,
            state="Enabled")
        example_server_vulnerability_assessment = azure.mssql.ServerVulnerabilityAssessment("example",
            server_security_alert_policy_id=example_server_security_alert_policy.id,
            storage_container_path=pulumi.Output.all(
                primary_blob_endpoint=example_account.primary_blob_endpoint,
                name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}/")
        ,
            storage_account_access_key=example_account.primary_access_key,
            recurring_scans={
                "enabled": True,
                "email_subscription_admins": True,
                "emails": [
                    "email@example1.com",
                    "email@example2.com",
                ],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        MS SQL Server Vulnerability Assessment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/serverVulnerabilityAssessment:ServerVulnerabilityAssessment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/acceptanceTestResourceGroup1/providers/Microsoft.Sql/servers/mssqlserver/vulnerabilityAssessments/Default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServerVulnerabilityAssessmentRecurringScansArgs', 'ServerVulnerabilityAssessmentRecurringScansArgsDict']] recurring_scans: A `recurring_scans` block as defined below.
               
               > **Note:** To reset the `recurring_scans` code block to it's default values you must explicitly define an empty `recurring_scans` code block (e.g., `recurring_scans {}`) in your configuration file.
        :param pulumi.Input[_builtins.str] server_security_alert_policy_id: The id of the security alert policy of the MS SQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the primary access key of the blob storage endpoint.
               
               > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.
               
               > **Note:** If the `storage_account_access_key` property is not defined the `storage_container_sas_key` property is required.
        :param pulumi.Input[_builtins.str] storage_container_path: Specifies the blob storage container path that will hold the scan results (e.g., <https://example.blob.core.windows.net/example/>).
        :param pulumi.Input[_builtins.str] storage_container_sas_key: Specifies the shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` property.
               
               > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.
               
               > **Note:** If the `storage_container_sas_key` property is not defined the `storage_account_access_key` property is required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerVulnerabilityAssessmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the Vulnerability Assessment for an MS SQL Server.

        > **Note:** Vulnerability Assessment is currently only available for MS SQL databases.

        > **Note:** This resource cannot be used to enable the Express SQL Vulnerability Assessment configuration, to enable the express configuration, use `express_vulnerability_assessment_enabled` in the `mssql.Server` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_server = azure.mssql.Server("example",
            name="mysqlserver",
            resource_group_name=example.name,
            location=example.location,
            version="12.0",
            administrator_login="4dm1n157r470r",
            administrator_login_password="4-v3ry-53cr37-p455w0rd")
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="GRS")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_server_security_alert_policy = azure.mssql.ServerSecurityAlertPolicy("example",
            resource_group_name=example.name,
            server_name=example_server.name,
            state="Enabled")
        example_server_vulnerability_assessment = azure.mssql.ServerVulnerabilityAssessment("example",
            server_security_alert_policy_id=example_server_security_alert_policy.id,
            storage_container_path=pulumi.Output.all(
                primary_blob_endpoint=example_account.primary_blob_endpoint,
                name=example_container.name
        ).apply(lambda resolved_outputs: f"{resolved_outputs['primary_blob_endpoint']}{resolved_outputs['name']}/")
        ,
            storage_account_access_key=example_account.primary_access_key,
            recurring_scans={
                "enabled": True,
                "email_subscription_admins": True,
                "emails": [
                    "email@example1.com",
                    "email@example2.com",
                ],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql`: 2023-08-01-preview

        ## Import

        MS SQL Server Vulnerability Assessment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/serverVulnerabilityAssessment:ServerVulnerabilityAssessment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/acceptanceTestResourceGroup1/providers/Microsoft.Sql/servers/mssqlserver/vulnerabilityAssessments/Default
        ```

        :param str resource_name: The name of the resource.
        :param ServerVulnerabilityAssessmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerVulnerabilityAssessmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 recurring_scans: Optional[pulumi.Input[Union['ServerVulnerabilityAssessmentRecurringScansArgs', 'ServerVulnerabilityAssessmentRecurringScansArgsDict']]] = None,
                 server_security_alert_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerVulnerabilityAssessmentArgs.__new__(ServerVulnerabilityAssessmentArgs)

            __props__.__dict__["recurring_scans"] = recurring_scans
            if server_security_alert_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_security_alert_policy_id'")
            __props__.__dict__["server_security_alert_policy_id"] = server_security_alert_policy_id
            __props__.__dict__["storage_account_access_key"] = None if storage_account_access_key is None else pulumi.Output.secret(storage_account_access_key)
            if storage_container_path is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_path'")
            __props__.__dict__["storage_container_path"] = storage_container_path
            __props__.__dict__["storage_container_sas_key"] = None if storage_container_sas_key is None else pulumi.Output.secret(storage_container_sas_key)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["storageAccountAccessKey", "storageContainerSasKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServerVulnerabilityAssessment, __self__).__init__(
            'azure:mssql/serverVulnerabilityAssessment:ServerVulnerabilityAssessment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            recurring_scans: Optional[pulumi.Input[Union['ServerVulnerabilityAssessmentRecurringScansArgs', 'ServerVulnerabilityAssessmentRecurringScansArgsDict']]] = None,
            server_security_alert_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_container_path: Optional[pulumi.Input[_builtins.str]] = None,
            storage_container_sas_key: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServerVulnerabilityAssessment':
        """
        Get an existing ServerVulnerabilityAssessment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServerVulnerabilityAssessmentRecurringScansArgs', 'ServerVulnerabilityAssessmentRecurringScansArgsDict']] recurring_scans: A `recurring_scans` block as defined below.
               
               > **Note:** To reset the `recurring_scans` code block to it's default values you must explicitly define an empty `recurring_scans` code block (e.g., `recurring_scans {}`) in your configuration file.
        :param pulumi.Input[_builtins.str] server_security_alert_policy_id: The id of the security alert policy of the MS SQL Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_access_key: Specifies the primary access key of the blob storage endpoint.
               
               > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.
               
               > **Note:** If the `storage_account_access_key` property is not defined the `storage_container_sas_key` property is required.
        :param pulumi.Input[_builtins.str] storage_container_path: Specifies the blob storage container path that will hold the scan results (e.g., <https://example.blob.core.windows.net/example/>).
        :param pulumi.Input[_builtins.str] storage_container_sas_key: Specifies the shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` property.
               
               > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.
               
               > **Note:** If the `storage_container_sas_key` property is not defined the `storage_account_access_key` property is required.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerVulnerabilityAssessmentState.__new__(_ServerVulnerabilityAssessmentState)

        __props__.__dict__["recurring_scans"] = recurring_scans
        __props__.__dict__["server_security_alert_policy_id"] = server_security_alert_policy_id
        __props__.__dict__["storage_account_access_key"] = storage_account_access_key
        __props__.__dict__["storage_container_path"] = storage_container_path
        __props__.__dict__["storage_container_sas_key"] = storage_container_sas_key
        return ServerVulnerabilityAssessment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="recurringScans")
    def recurring_scans(self) -> pulumi.Output['outputs.ServerVulnerabilityAssessmentRecurringScans']:
        """
        A `recurring_scans` block as defined below.

        > **Note:** To reset the `recurring_scans` code block to it's default values you must explicitly define an empty `recurring_scans` code block (e.g., `recurring_scans {}`) in your configuration file.
        """
        return pulumi.get(self, "recurring_scans")

    @_builtins.property
    @pulumi.getter(name="serverSecurityAlertPolicyId")
    def server_security_alert_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the security alert policy of the MS SQL Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_security_alert_policy_id")

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the primary access key of the blob storage endpoint.

        > **Note:** The `storage_account_access_key` only applies if the storage account is not behind a virtual network or a firewall.

        > **Note:** If the `storage_account_access_key` property is not defined the `storage_container_sas_key` property is required.
        """
        return pulumi.get(self, "storage_account_access_key")

    @_builtins.property
    @pulumi.getter(name="storageContainerPath")
    def storage_container_path(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the blob storage container path that will hold the scan results (e.g., <https://example.blob.core.windows.net/example/>).
        """
        return pulumi.get(self, "storage_container_path")

    @_builtins.property
    @pulumi.getter(name="storageContainerSasKey")
    def storage_container_sas_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the shared access signature (SAS Key) that has write access to the blob container specified in `storage_container_path` property.

        > **Note:** The `storage_container_sas_key` only applies if the storage account is not behind a virtual network or a firewall.

        > **Note:** If the `storage_container_sas_key` property is not defined the `storage_account_access_key` property is required.
        """
        return pulumi.get(self, "storage_container_sas_key")

