# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FlexibleServerActiveDirectoryAdministratoryArgs', 'FlexibleServerActiveDirectoryAdministratory']

@pulumi.input_type
class FlexibleServerActiveDirectoryAdministratoryArgs:
    def __init__(__self__, *,
                 identity_id: pulumi.Input[_builtins.str],
                 login: pulumi.Input[_builtins.str],
                 object_id: pulumi.Input[_builtins.str],
                 server_id: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a FlexibleServerActiveDirectoryAdministratory resource.
        :param pulumi.Input[_builtins.str] identity_id: The resource ID of the identity used for AAD Authentication.
        :param pulumi.Input[_builtins.str] login: The login name of the principal to set as the server administrator
        :param pulumi.Input[_builtins.str] object_id: The ID of the principal to set as the server administrator. For a managed identity this should be the Client ID of the identity.
        :param pulumi.Input[_builtins.str] server_id: The resource ID of the MySQL Flexible Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Tenant ID.
        """
        pulumi.set(__self__, "identity_id", identity_id)
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the identity used for AAD Authentication.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Input[_builtins.str]:
        """
        The login name of the principal to set as the server administrator
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the principal to set as the server administrator. For a managed identity this should be the Client ID of the identity.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the MySQL Flexible Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Azure Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _FlexibleServerActiveDirectoryAdministratoryState:
    def __init__(__self__, *,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlexibleServerActiveDirectoryAdministratory resources.
        :param pulumi.Input[_builtins.str] identity_id: The resource ID of the identity used for AAD Authentication.
        :param pulumi.Input[_builtins.str] login: The login name of the principal to set as the server administrator
        :param pulumi.Input[_builtins.str] object_id: The ID of the principal to set as the server administrator. For a managed identity this should be the Client ID of the identity.
        :param pulumi.Input[_builtins.str] server_id: The resource ID of the MySQL Flexible Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Tenant ID.
        """
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if server_id is not None:
            pulumi.set(__self__, "server_id", server_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the identity used for AAD Authentication.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The login name of the principal to set as the server administrator
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the principal to set as the server administrator. For a managed identity this should be the Client ID of the identity.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the MySQL Flexible Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

    @server_id.setter
    def server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "server_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("azure:mysql/flexibleServerActiveDirectoryAdministratory:FlexibleServerActiveDirectoryAdministratory")
class FlexibleServerActiveDirectoryAdministratory(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Active Directory administrator on a MySQL Flexible Server

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="exampleUAI",
            resource_group_name=example.name,
            location=example.location)
        example_flexible_server = azure.mysql.FlexibleServer("example",
            name="example-mysqlfs",
            resource_group_name=example.name,
            location=example.location,
            administrator_login="_admin_Terraform_892123456789312",
            administrator_password="QAZwsx123",
            sku_name="B_Standard_B1ms",
            zone="2",
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            })
        example_flexible_server_active_directory_administratory = azure.mysql.FlexibleServerActiveDirectoryAdministratory("example",
            server_id=example_flexible_server.id,
            identity_id=example_user_assigned_identity.id,
            login="sqladmin",
            object_id=current.client_id,
            tenant_id=current.tenant_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforMySQL`: 2023-12-30

        ## Import

        A MySQL Flexible Server Active Directory Administrator can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mysql/flexibleServerActiveDirectoryAdministratory:FlexibleServerActiveDirectoryAdministratory example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.DBforMySQL/flexibleServers/server1/administrators/ActiveDirectory
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identity_id: The resource ID of the identity used for AAD Authentication.
        :param pulumi.Input[_builtins.str] login: The login name of the principal to set as the server administrator
        :param pulumi.Input[_builtins.str] object_id: The ID of the principal to set as the server administrator. For a managed identity this should be the Client ID of the identity.
        :param pulumi.Input[_builtins.str] server_id: The resource ID of the MySQL Flexible Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Tenant ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlexibleServerActiveDirectoryAdministratoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Active Directory administrator on a MySQL Flexible Server

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="exampleUAI",
            resource_group_name=example.name,
            location=example.location)
        example_flexible_server = azure.mysql.FlexibleServer("example",
            name="example-mysqlfs",
            resource_group_name=example.name,
            location=example.location,
            administrator_login="_admin_Terraform_892123456789312",
            administrator_password="QAZwsx123",
            sku_name="B_Standard_B1ms",
            zone="2",
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            })
        example_flexible_server_active_directory_administratory = azure.mysql.FlexibleServerActiveDirectoryAdministratory("example",
            server_id=example_flexible_server.id,
            identity_id=example_user_assigned_identity.id,
            login="sqladmin",
            object_id=current.client_id,
            tenant_id=current.tenant_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforMySQL`: 2023-12-30

        ## Import

        A MySQL Flexible Server Active Directory Administrator can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mysql/flexibleServerActiveDirectoryAdministratory:FlexibleServerActiveDirectoryAdministratory example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.DBforMySQL/flexibleServers/server1/administrators/ActiveDirectory
        ```

        :param str resource_name: The name of the resource.
        :param FlexibleServerActiveDirectoryAdministratoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlexibleServerActiveDirectoryAdministratoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 login: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlexibleServerActiveDirectoryAdministratoryArgs.__new__(FlexibleServerActiveDirectoryAdministratoryArgs)

            if identity_id is None and not opts.urn:
                raise TypeError("Missing required property 'identity_id'")
            __props__.__dict__["identity_id"] = identity_id
            if login is None and not opts.urn:
                raise TypeError("Missing required property 'login'")
            __props__.__dict__["login"] = login
            if object_id is None and not opts.urn:
                raise TypeError("Missing required property 'object_id'")
            __props__.__dict__["object_id"] = object_id
            if server_id is None and not opts.urn:
                raise TypeError("Missing required property 'server_id'")
            __props__.__dict__["server_id"] = server_id
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:mysql/flexibleServerActiveDirectoryAdministrator:FlexibleServerActiveDirectoryAdministrator")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(FlexibleServerActiveDirectoryAdministratory, __self__).__init__(
            'azure:mysql/flexibleServerActiveDirectoryAdministratory:FlexibleServerActiveDirectoryAdministratory',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            identity_id: Optional[pulumi.Input[_builtins.str]] = None,
            login: Optional[pulumi.Input[_builtins.str]] = None,
            object_id: Optional[pulumi.Input[_builtins.str]] = None,
            server_id: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlexibleServerActiveDirectoryAdministratory':
        """
        Get an existing FlexibleServerActiveDirectoryAdministratory resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] identity_id: The resource ID of the identity used for AAD Authentication.
        :param pulumi.Input[_builtins.str] login: The login name of the principal to set as the server administrator
        :param pulumi.Input[_builtins.str] object_id: The ID of the principal to set as the server administrator. For a managed identity this should be the Client ID of the identity.
        :param pulumi.Input[_builtins.str] server_id: The resource ID of the MySQL Flexible Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Tenant ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlexibleServerActiveDirectoryAdministratoryState.__new__(_FlexibleServerActiveDirectoryAdministratoryState)

        __props__.__dict__["identity_id"] = identity_id
        __props__.__dict__["login"] = login
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["server_id"] = server_id
        __props__.__dict__["tenant_id"] = tenant_id
        return FlexibleServerActiveDirectoryAdministratory(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the identity used for AAD Authentication.
        """
        return pulumi.get(self, "identity_id")

    @_builtins.property
    @pulumi.getter
    def login(self) -> pulumi.Output[_builtins.str]:
        """
        The login name of the principal to set as the server administrator
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the principal to set as the server administrator. For a managed identity this should be the Client ID of the identity.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the MySQL Flexible Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "server_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

