# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCertificateResult',
    'AwaitableGetCertificateResult',
    'get_certificate',
    'get_certificate_output',
]

@pulumi.output_type
class GetCertificateResult:
    """
    A collection of values returned by getCertificate.
    """
    def __init__(__self__, certificate_virtual_path=None, error_code=None, error_message=None, id=None, key_vault_secret_creation_date=None, key_vault_secret_id=None, key_vault_secret_version=None, key_virtual_path=None, name=None, nginx_deployment_id=None, sha1_thumbprint=None):
        if certificate_virtual_path and not isinstance(certificate_virtual_path, str):
            raise TypeError("Expected argument 'certificate_virtual_path' to be a str")
        pulumi.set(__self__, "certificate_virtual_path", certificate_virtual_path)
        if error_code and not isinstance(error_code, str):
            raise TypeError("Expected argument 'error_code' to be a str")
        pulumi.set(__self__, "error_code", error_code)
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        pulumi.set(__self__, "error_message", error_message)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_vault_secret_creation_date and not isinstance(key_vault_secret_creation_date, str):
            raise TypeError("Expected argument 'key_vault_secret_creation_date' to be a str")
        pulumi.set(__self__, "key_vault_secret_creation_date", key_vault_secret_creation_date)
        if key_vault_secret_id and not isinstance(key_vault_secret_id, str):
            raise TypeError("Expected argument 'key_vault_secret_id' to be a str")
        pulumi.set(__self__, "key_vault_secret_id", key_vault_secret_id)
        if key_vault_secret_version and not isinstance(key_vault_secret_version, str):
            raise TypeError("Expected argument 'key_vault_secret_version' to be a str")
        pulumi.set(__self__, "key_vault_secret_version", key_vault_secret_version)
        if key_virtual_path and not isinstance(key_virtual_path, str):
            raise TypeError("Expected argument 'key_virtual_path' to be a str")
        pulumi.set(__self__, "key_virtual_path", key_virtual_path)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if nginx_deployment_id and not isinstance(nginx_deployment_id, str):
            raise TypeError("Expected argument 'nginx_deployment_id' to be a str")
        pulumi.set(__self__, "nginx_deployment_id", nginx_deployment_id)
        if sha1_thumbprint and not isinstance(sha1_thumbprint, str):
            raise TypeError("Expected argument 'sha1_thumbprint' to be a str")
        pulumi.set(__self__, "sha1_thumbprint", sha1_thumbprint)

    @_builtins.property
    @pulumi.getter(name="certificateVirtualPath")
    def certificate_virtual_path(self) -> _builtins.str:
        """
        The path to the certificate file of the certificate.
        """
        return pulumi.get(self, "certificate_virtual_path")

    @_builtins.property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> _builtins.str:
        """
        The error code of the certificate error, if any.
        """
        return pulumi.get(self, "error_code")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> _builtins.str:
        """
        The error message of the certificate error, if any.
        """
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretCreationDate")
    def key_vault_secret_creation_date(self) -> _builtins.str:
        """
        The date/time the certificate was created in Azure Key Vault.
        """
        return pulumi.get(self, "key_vault_secret_creation_date")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretId")
    def key_vault_secret_id(self) -> _builtins.str:
        """
        The ID of the Key Vault Secret for the certificate.
        """
        return pulumi.get(self, "key_vault_secret_id")

    @_builtins.property
    @pulumi.getter(name="keyVaultSecretVersion")
    def key_vault_secret_version(self) -> _builtins.str:
        """
        The version of the certificate.
        """
        return pulumi.get(self, "key_vault_secret_version")

    @_builtins.property
    @pulumi.getter(name="keyVirtualPath")
    def key_virtual_path(self) -> _builtins.str:
        """
        The path to the key file of the certificate.
        """
        return pulumi.get(self, "key_virtual_path")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nginxDeploymentId")
    def nginx_deployment_id(self) -> _builtins.str:
        return pulumi.get(self, "nginx_deployment_id")

    @_builtins.property
    @pulumi.getter(name="sha1Thumbprint")
    def sha1_thumbprint(self) -> _builtins.str:
        """
        The SHA-1 thumbprint of the certificate.
        """
        return pulumi.get(self, "sha1_thumbprint")


class AwaitableGetCertificateResult(GetCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateResult(
            certificate_virtual_path=self.certificate_virtual_path,
            error_code=self.error_code,
            error_message=self.error_message,
            id=self.id,
            key_vault_secret_creation_date=self.key_vault_secret_creation_date,
            key_vault_secret_id=self.key_vault_secret_id,
            key_vault_secret_version=self.key_vault_secret_version,
            key_virtual_path=self.key_virtual_path,
            name=self.name,
            nginx_deployment_id=self.nginx_deployment_id,
            sha1_thumbprint=self.sha1_thumbprint)


def get_certificate(name: Optional[_builtins.str] = None,
                    nginx_deployment_id: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateResult:
    """
    Use this data source to access information about an existing NGINX Certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.nginx.get_certificate(name="existing",
        nginx_deployment_id=example_azurerm_nginx_deployment["id"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Nginx.NginxPlus`: 2024-11-01-preview


    :param _builtins.str name: The name of the NGINX Certificate.
    :param _builtins.str nginx_deployment_id: The ID of the NGINX Deployment that the certificate is associated with.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['nginxDeploymentId'] = nginx_deployment_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:nginx/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult).value

    return AwaitableGetCertificateResult(
        certificate_virtual_path=pulumi.get(__ret__, 'certificate_virtual_path'),
        error_code=pulumi.get(__ret__, 'error_code'),
        error_message=pulumi.get(__ret__, 'error_message'),
        id=pulumi.get(__ret__, 'id'),
        key_vault_secret_creation_date=pulumi.get(__ret__, 'key_vault_secret_creation_date'),
        key_vault_secret_id=pulumi.get(__ret__, 'key_vault_secret_id'),
        key_vault_secret_version=pulumi.get(__ret__, 'key_vault_secret_version'),
        key_virtual_path=pulumi.get(__ret__, 'key_virtual_path'),
        name=pulumi.get(__ret__, 'name'),
        nginx_deployment_id=pulumi.get(__ret__, 'nginx_deployment_id'),
        sha1_thumbprint=pulumi.get(__ret__, 'sha1_thumbprint'))
def get_certificate_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                           nginx_deployment_id: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateResult]:
    """
    Use this data source to access information about an existing NGINX Certificate.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.nginx.get_certificate(name="existing",
        nginx_deployment_id=example_azurerm_nginx_deployment["id"])
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Nginx.NginxPlus`: 2024-11-01-preview


    :param _builtins.str name: The name of the NGINX Certificate.
    :param _builtins.str nginx_deployment_id: The ID of the NGINX Deployment that the certificate is associated with.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['nginxDeploymentId'] = nginx_deployment_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:nginx/getCertificate:getCertificate', __args__, opts=opts, typ=GetCertificateResult)
    return __ret__.apply(lambda __response__: GetCertificateResult(
        certificate_virtual_path=pulumi.get(__response__, 'certificate_virtual_path'),
        error_code=pulumi.get(__response__, 'error_code'),
        error_message=pulumi.get(__response__, 'error_message'),
        id=pulumi.get(__response__, 'id'),
        key_vault_secret_creation_date=pulumi.get(__response__, 'key_vault_secret_creation_date'),
        key_vault_secret_id=pulumi.get(__response__, 'key_vault_secret_id'),
        key_vault_secret_version=pulumi.get(__response__, 'key_vault_secret_version'),
        key_virtual_path=pulumi.get(__response__, 'key_virtual_path'),
        name=pulumi.get(__response__, 'name'),
        nginx_deployment_id=pulumi.get(__response__, 'nginx_deployment_id'),
        sha1_thumbprint=pulumi.get(__response__, 'sha1_thumbprint')))
