# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AnalyticsWorkspaceArgs', 'AnalyticsWorkspace']

@pulumi.input_type
class AnalyticsWorkspaceArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 allow_resource_only_permissions: Optional[pulumi.Input[_builtins.bool]] = None,
                 cmk_for_query_forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 daily_quota_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 data_collection_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['AnalyticsWorkspaceIdentityArgs']] = None,
                 immediate_data_purge_on30_days_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_ingestion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_query_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_capacity_in_gb_per_day: Optional[pulumi.Input[_builtins.int]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AnalyticsWorkspace resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] allow_resource_only_permissions: Specifies if the log Analytics Workspace allow users accessing to data associated with resources they have permission to view, without permission to workspace. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] cmk_for_query_forced: Is Customer Managed Storage mandatory for query management?
        :param pulumi.Input[_builtins.float] daily_quota_gb: The workspace daily quota for ingestion in GB. Defaults to `-1` (unlimited) if omitted.
        :param pulumi.Input[_builtins.str] data_collection_rule_id: The ID of the Data Collection Rule to use for this workspace.
        :param pulumi.Input['AnalyticsWorkspaceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] immediate_data_purge_on30_days_enabled: Whether to remove the data in the Log Analytics Workspace immediately after 30 days.
        :param pulumi.Input[_builtins.bool] internet_ingestion_enabled: Should the Log Analytics Workspace support ingestion over the Public Internet? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] internet_query_enabled: Should the Log Analytics Workspace support querying over the Public Internet? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] local_authentication_disabled: Specifies if the log Analytics workspace should enforce authentication using Azure AD. Defaults to `false`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] reservation_capacity_in_gb_per_day: The capacity reservation level in GB for this workspace. Possible values are `100`, `200`, `300`, `400`, `500`, `1000`, `2000` and `5000`.
               
               > **Note:** `reservation_capacity_in_gb_per_day` can only be used when the `sku` is set to `CapacityReservation`.
        :param pulumi.Input[_builtins.int] retention_in_days: The workspace data retention in days. Possible values are between `30` and `730`.
        :param pulumi.Input[_builtins.str] sku: Specifies the SKU of the Log Analytics Workspace. Possible values are `PerNode`, `Premium`, `Standard`, `Standalone`, `Unlimited`, `CapacityReservation`, `PerGB2018`, and `LACluster`. Defaults to `PerGB2018`.
               
               > **Note:** `sku` should only be set to `LACluster` when the Log Analytics Workspace is linked to a Log Analytics Cluster. Additionally, `sku` cannot be modified while linked.
               
               > **Note:** Changing `sku` forces a new Log Analytics Workspace to be created, except when changing between `PerGB2018` and `CapacityReservation`. Changing `sku` to `CapacityReservation` or changing `reservation_capacity_in_gb_per_day` to a higher tier will lead to a 31-days commitment period, during which the SKU cannot be changed to a lower one. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/cost-logs#commitment-tiers) for further information.
               
               > **Note:** A new pricing model took effect on `2018-04-03`, which requires the SKU `PerGB2018`. If you've provisioned resources before this date you have the option of remaining with the previous Pricing SKU and using the other SKUs defined above. More information about [the Pricing SKUs is available at the following URI](https://aka.ms/PricingTierWarning).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if allow_resource_only_permissions is not None:
            pulumi.set(__self__, "allow_resource_only_permissions", allow_resource_only_permissions)
        if cmk_for_query_forced is not None:
            pulumi.set(__self__, "cmk_for_query_forced", cmk_for_query_forced)
        if daily_quota_gb is not None:
            pulumi.set(__self__, "daily_quota_gb", daily_quota_gb)
        if data_collection_rule_id is not None:
            pulumi.set(__self__, "data_collection_rule_id", data_collection_rule_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if immediate_data_purge_on30_days_enabled is not None:
            pulumi.set(__self__, "immediate_data_purge_on30_days_enabled", immediate_data_purge_on30_days_enabled)
        if internet_ingestion_enabled is not None:
            pulumi.set(__self__, "internet_ingestion_enabled", internet_ingestion_enabled)
        if internet_query_enabled is not None:
            pulumi.set(__self__, "internet_query_enabled", internet_query_enabled)
        if local_authentication_disabled is not None:
            pulumi.set(__self__, "local_authentication_disabled", local_authentication_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reservation_capacity_in_gb_per_day is not None:
            pulumi.set(__self__, "reservation_capacity_in_gb_per_day", reservation_capacity_in_gb_per_day)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="allowResourceOnlyPermissions")
    def allow_resource_only_permissions(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the log Analytics Workspace allow users accessing to data associated with resources they have permission to view, without permission to workspace. Defaults to `true`.
        """
        return pulumi.get(self, "allow_resource_only_permissions")

    @allow_resource_only_permissions.setter
    def allow_resource_only_permissions(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_resource_only_permissions", value)

    @_builtins.property
    @pulumi.getter(name="cmkForQueryForced")
    def cmk_for_query_forced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Customer Managed Storage mandatory for query management?
        """
        return pulumi.get(self, "cmk_for_query_forced")

    @cmk_for_query_forced.setter
    def cmk_for_query_forced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cmk_for_query_forced", value)

    @_builtins.property
    @pulumi.getter(name="dailyQuotaGb")
    def daily_quota_gb(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The workspace daily quota for ingestion in GB. Defaults to `-1` (unlimited) if omitted.
        """
        return pulumi.get(self, "daily_quota_gb")

    @daily_quota_gb.setter
    def daily_quota_gb(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "daily_quota_gb", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionRuleId")
    def data_collection_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Data Collection Rule to use for this workspace.
        """
        return pulumi.get(self, "data_collection_rule_id")

    @data_collection_rule_id.setter
    def data_collection_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_collection_rule_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AnalyticsWorkspaceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AnalyticsWorkspaceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="immediateDataPurgeOn30DaysEnabled")
    def immediate_data_purge_on30_days_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to remove the data in the Log Analytics Workspace immediately after 30 days.
        """
        return pulumi.get(self, "immediate_data_purge_on30_days_enabled")

    @immediate_data_purge_on30_days_enabled.setter
    def immediate_data_purge_on30_days_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "immediate_data_purge_on30_days_enabled", value)

    @_builtins.property
    @pulumi.getter(name="internetIngestionEnabled")
    def internet_ingestion_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Log Analytics Workspace support ingestion over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_ingestion_enabled")

    @internet_ingestion_enabled.setter
    def internet_ingestion_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_ingestion_enabled", value)

    @_builtins.property
    @pulumi.getter(name="internetQueryEnabled")
    def internet_query_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Log Analytics Workspace support querying over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_query_enabled")

    @internet_query_enabled.setter
    def internet_query_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_query_enabled", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationDisabled")
    def local_authentication_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the log Analytics workspace should enforce authentication using Azure AD. Defaults to `false`.
        """
        return pulumi.get(self, "local_authentication_disabled")

    @local_authentication_disabled.setter
    def local_authentication_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_disabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="reservationCapacityInGbPerDay")
    def reservation_capacity_in_gb_per_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The capacity reservation level in GB for this workspace. Possible values are `100`, `200`, `300`, `400`, `500`, `1000`, `2000` and `5000`.

        > **Note:** `reservation_capacity_in_gb_per_day` can only be used when the `sku` is set to `CapacityReservation`.
        """
        return pulumi.get(self, "reservation_capacity_in_gb_per_day")

    @reservation_capacity_in_gb_per_day.setter
    def reservation_capacity_in_gb_per_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reservation_capacity_in_gb_per_day", value)

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The workspace data retention in days. Possible values are between `30` and `730`.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU of the Log Analytics Workspace. Possible values are `PerNode`, `Premium`, `Standard`, `Standalone`, `Unlimited`, `CapacityReservation`, `PerGB2018`, and `LACluster`. Defaults to `PerGB2018`.

        > **Note:** `sku` should only be set to `LACluster` when the Log Analytics Workspace is linked to a Log Analytics Cluster. Additionally, `sku` cannot be modified while linked.

        > **Note:** Changing `sku` forces a new Log Analytics Workspace to be created, except when changing between `PerGB2018` and `CapacityReservation`. Changing `sku` to `CapacityReservation` or changing `reservation_capacity_in_gb_per_day` to a higher tier will lead to a 31-days commitment period, during which the SKU cannot be changed to a lower one. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/cost-logs#commitment-tiers) for further information.

        > **Note:** A new pricing model took effect on `2018-04-03`, which requires the SKU `PerGB2018`. If you've provisioned resources before this date you have the option of remaining with the previous Pricing SKU and using the other SKUs defined above. More information about [the Pricing SKUs is available at the following URI](https://aka.ms/PricingTierWarning).
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AnalyticsWorkspaceState:
    def __init__(__self__, *,
                 allow_resource_only_permissions: Optional[pulumi.Input[_builtins.bool]] = None,
                 cmk_for_query_forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 daily_quota_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 data_collection_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['AnalyticsWorkspaceIdentityArgs']] = None,
                 immediate_data_purge_on30_days_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_ingestion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_query_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_shared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_capacity_in_gb_per_day: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 secondary_shared_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AnalyticsWorkspace resources.
        :param pulumi.Input[_builtins.bool] allow_resource_only_permissions: Specifies if the log Analytics Workspace allow users accessing to data associated with resources they have permission to view, without permission to workspace. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] cmk_for_query_forced: Is Customer Managed Storage mandatory for query management?
        :param pulumi.Input[_builtins.float] daily_quota_gb: The workspace daily quota for ingestion in GB. Defaults to `-1` (unlimited) if omitted.
        :param pulumi.Input[_builtins.str] data_collection_rule_id: The ID of the Data Collection Rule to use for this workspace.
        :param pulumi.Input['AnalyticsWorkspaceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] immediate_data_purge_on30_days_enabled: Whether to remove the data in the Log Analytics Workspace immediately after 30 days.
        :param pulumi.Input[_builtins.bool] internet_ingestion_enabled: Should the Log Analytics Workspace support ingestion over the Public Internet? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] internet_query_enabled: Should the Log Analytics Workspace support querying over the Public Internet? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] local_authentication_disabled: Specifies if the log Analytics workspace should enforce authentication using Azure AD. Defaults to `false`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] primary_shared_key: The Primary shared key for the Log Analytics Workspace.
        :param pulumi.Input[_builtins.int] reservation_capacity_in_gb_per_day: The capacity reservation level in GB for this workspace. Possible values are `100`, `200`, `300`, `400`, `500`, `1000`, `2000` and `5000`.
               
               > **Note:** `reservation_capacity_in_gb_per_day` can only be used when the `sku` is set to `CapacityReservation`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_in_days: The workspace data retention in days. Possible values are between `30` and `730`.
        :param pulumi.Input[_builtins.str] secondary_shared_key: The Secondary shared key for the Log Analytics Workspace.
        :param pulumi.Input[_builtins.str] sku: Specifies the SKU of the Log Analytics Workspace. Possible values are `PerNode`, `Premium`, `Standard`, `Standalone`, `Unlimited`, `CapacityReservation`, `PerGB2018`, and `LACluster`. Defaults to `PerGB2018`.
               
               > **Note:** `sku` should only be set to `LACluster` when the Log Analytics Workspace is linked to a Log Analytics Cluster. Additionally, `sku` cannot be modified while linked.
               
               > **Note:** Changing `sku` forces a new Log Analytics Workspace to be created, except when changing between `PerGB2018` and `CapacityReservation`. Changing `sku` to `CapacityReservation` or changing `reservation_capacity_in_gb_per_day` to a higher tier will lead to a 31-days commitment period, during which the SKU cannot be changed to a lower one. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/cost-logs#commitment-tiers) for further information.
               
               > **Note:** A new pricing model took effect on `2018-04-03`, which requires the SKU `PerGB2018`. If you've provisioned resources before this date you have the option of remaining with the previous Pricing SKU and using the other SKUs defined above. More information about [the Pricing SKUs is available at the following URI](https://aka.ms/PricingTierWarning).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] workspace_id: The Workspace (or Customer) ID for the Log Analytics Workspace.
        """
        if allow_resource_only_permissions is not None:
            pulumi.set(__self__, "allow_resource_only_permissions", allow_resource_only_permissions)
        if cmk_for_query_forced is not None:
            pulumi.set(__self__, "cmk_for_query_forced", cmk_for_query_forced)
        if daily_quota_gb is not None:
            pulumi.set(__self__, "daily_quota_gb", daily_quota_gb)
        if data_collection_rule_id is not None:
            pulumi.set(__self__, "data_collection_rule_id", data_collection_rule_id)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if immediate_data_purge_on30_days_enabled is not None:
            pulumi.set(__self__, "immediate_data_purge_on30_days_enabled", immediate_data_purge_on30_days_enabled)
        if internet_ingestion_enabled is not None:
            pulumi.set(__self__, "internet_ingestion_enabled", internet_ingestion_enabled)
        if internet_query_enabled is not None:
            pulumi.set(__self__, "internet_query_enabled", internet_query_enabled)
        if local_authentication_disabled is not None:
            pulumi.set(__self__, "local_authentication_disabled", local_authentication_disabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_shared_key is not None:
            pulumi.set(__self__, "primary_shared_key", primary_shared_key)
        if reservation_capacity_in_gb_per_day is not None:
            pulumi.set(__self__, "reservation_capacity_in_gb_per_day", reservation_capacity_in_gb_per_day)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if retention_in_days is not None:
            pulumi.set(__self__, "retention_in_days", retention_in_days)
        if secondary_shared_key is not None:
            pulumi.set(__self__, "secondary_shared_key", secondary_shared_key)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="allowResourceOnlyPermissions")
    def allow_resource_only_permissions(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the log Analytics Workspace allow users accessing to data associated with resources they have permission to view, without permission to workspace. Defaults to `true`.
        """
        return pulumi.get(self, "allow_resource_only_permissions")

    @allow_resource_only_permissions.setter
    def allow_resource_only_permissions(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_resource_only_permissions", value)

    @_builtins.property
    @pulumi.getter(name="cmkForQueryForced")
    def cmk_for_query_forced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Customer Managed Storage mandatory for query management?
        """
        return pulumi.get(self, "cmk_for_query_forced")

    @cmk_for_query_forced.setter
    def cmk_for_query_forced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cmk_for_query_forced", value)

    @_builtins.property
    @pulumi.getter(name="dailyQuotaGb")
    def daily_quota_gb(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        The workspace daily quota for ingestion in GB. Defaults to `-1` (unlimited) if omitted.
        """
        return pulumi.get(self, "daily_quota_gb")

    @daily_quota_gb.setter
    def daily_quota_gb(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "daily_quota_gb", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionRuleId")
    def data_collection_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Data Collection Rule to use for this workspace.
        """
        return pulumi.get(self, "data_collection_rule_id")

    @data_collection_rule_id.setter
    def data_collection_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_collection_rule_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AnalyticsWorkspaceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AnalyticsWorkspaceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="immediateDataPurgeOn30DaysEnabled")
    def immediate_data_purge_on30_days_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to remove the data in the Log Analytics Workspace immediately after 30 days.
        """
        return pulumi.get(self, "immediate_data_purge_on30_days_enabled")

    @immediate_data_purge_on30_days_enabled.setter
    def immediate_data_purge_on30_days_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "immediate_data_purge_on30_days_enabled", value)

    @_builtins.property
    @pulumi.getter(name="internetIngestionEnabled")
    def internet_ingestion_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Log Analytics Workspace support ingestion over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_ingestion_enabled")

    @internet_ingestion_enabled.setter
    def internet_ingestion_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_ingestion_enabled", value)

    @_builtins.property
    @pulumi.getter(name="internetQueryEnabled")
    def internet_query_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Log Analytics Workspace support querying over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_query_enabled")

    @internet_query_enabled.setter
    def internet_query_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "internet_query_enabled", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationDisabled")
    def local_authentication_disabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the log Analytics workspace should enforce authentication using Azure AD. Defaults to `false`.
        """
        return pulumi.get(self, "local_authentication_disabled")

    @local_authentication_disabled.setter
    def local_authentication_disabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_disabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primarySharedKey")
    def primary_shared_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Primary shared key for the Log Analytics Workspace.
        """
        return pulumi.get(self, "primary_shared_key")

    @primary_shared_key.setter
    def primary_shared_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_shared_key", value)

    @_builtins.property
    @pulumi.getter(name="reservationCapacityInGbPerDay")
    def reservation_capacity_in_gb_per_day(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The capacity reservation level in GB for this workspace. Possible values are `100`, `200`, `300`, `400`, `500`, `1000`, `2000` and `5000`.

        > **Note:** `reservation_capacity_in_gb_per_day` can only be used when the `sku` is set to `CapacityReservation`.
        """
        return pulumi.get(self, "reservation_capacity_in_gb_per_day")

    @reservation_capacity_in_gb_per_day.setter
    def reservation_capacity_in_gb_per_day(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "reservation_capacity_in_gb_per_day", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The workspace data retention in days. Possible values are between `30` and `730`.
        """
        return pulumi.get(self, "retention_in_days")

    @retention_in_days.setter
    def retention_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_in_days", value)

    @_builtins.property
    @pulumi.getter(name="secondarySharedKey")
    def secondary_shared_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Secondary shared key for the Log Analytics Workspace.
        """
        return pulumi.get(self, "secondary_shared_key")

    @secondary_shared_key.setter
    def secondary_shared_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_shared_key", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU of the Log Analytics Workspace. Possible values are `PerNode`, `Premium`, `Standard`, `Standalone`, `Unlimited`, `CapacityReservation`, `PerGB2018`, and `LACluster`. Defaults to `PerGB2018`.

        > **Note:** `sku` should only be set to `LACluster` when the Log Analytics Workspace is linked to a Log Analytics Cluster. Additionally, `sku` cannot be modified while linked.

        > **Note:** Changing `sku` forces a new Log Analytics Workspace to be created, except when changing between `PerGB2018` and `CapacityReservation`. Changing `sku` to `CapacityReservation` or changing `reservation_capacity_in_gb_per_day` to a higher tier will lead to a 31-days commitment period, during which the SKU cannot be changed to a lower one. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/cost-logs#commitment-tiers) for further information.

        > **Note:** A new pricing model took effect on `2018-04-03`, which requires the SKU `PerGB2018`. If you've provisioned resources before this date you have the option of remaining with the previous Pricing SKU and using the other SKUs defined above. More information about [the Pricing SKUs is available at the following URI](https://aka.ms/PricingTierWarning).
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Workspace (or Customer) ID for the Log Analytics Workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:operationalinsights/analyticsWorkspace:AnalyticsWorkspace")
class AnalyticsWorkspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_resource_only_permissions: Optional[pulumi.Input[_builtins.bool]] = None,
                 cmk_for_query_forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 daily_quota_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 data_collection_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['AnalyticsWorkspaceIdentityArgs', 'AnalyticsWorkspaceIdentityArgsDict']]] = None,
                 immediate_data_purge_on30_days_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_ingestion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_query_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_capacity_in_gb_per_day: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Log Analytics (formally Operational Insights) Workspace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2022-10-01, 2020-08-01

        ## Import

        Log Analytics Workspaces can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:operationalinsights/analyticsWorkspace:AnalyticsWorkspace workspace1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_resource_only_permissions: Specifies if the log Analytics Workspace allow users accessing to data associated with resources they have permission to view, without permission to workspace. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] cmk_for_query_forced: Is Customer Managed Storage mandatory for query management?
        :param pulumi.Input[_builtins.float] daily_quota_gb: The workspace daily quota for ingestion in GB. Defaults to `-1` (unlimited) if omitted.
        :param pulumi.Input[_builtins.str] data_collection_rule_id: The ID of the Data Collection Rule to use for this workspace.
        :param pulumi.Input[Union['AnalyticsWorkspaceIdentityArgs', 'AnalyticsWorkspaceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] immediate_data_purge_on30_days_enabled: Whether to remove the data in the Log Analytics Workspace immediately after 30 days.
        :param pulumi.Input[_builtins.bool] internet_ingestion_enabled: Should the Log Analytics Workspace support ingestion over the Public Internet? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] internet_query_enabled: Should the Log Analytics Workspace support querying over the Public Internet? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] local_authentication_disabled: Specifies if the log Analytics workspace should enforce authentication using Azure AD. Defaults to `false`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] reservation_capacity_in_gb_per_day: The capacity reservation level in GB for this workspace. Possible values are `100`, `200`, `300`, `400`, `500`, `1000`, `2000` and `5000`.
               
               > **Note:** `reservation_capacity_in_gb_per_day` can only be used when the `sku` is set to `CapacityReservation`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_in_days: The workspace data retention in days. Possible values are between `30` and `730`.
        :param pulumi.Input[_builtins.str] sku: Specifies the SKU of the Log Analytics Workspace. Possible values are `PerNode`, `Premium`, `Standard`, `Standalone`, `Unlimited`, `CapacityReservation`, `PerGB2018`, and `LACluster`. Defaults to `PerGB2018`.
               
               > **Note:** `sku` should only be set to `LACluster` when the Log Analytics Workspace is linked to a Log Analytics Cluster. Additionally, `sku` cannot be modified while linked.
               
               > **Note:** Changing `sku` forces a new Log Analytics Workspace to be created, except when changing between `PerGB2018` and `CapacityReservation`. Changing `sku` to `CapacityReservation` or changing `reservation_capacity_in_gb_per_day` to a higher tier will lead to a 31-days commitment period, during which the SKU cannot be changed to a lower one. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/cost-logs#commitment-tiers) for further information.
               
               > **Note:** A new pricing model took effect on `2018-04-03`, which requires the SKU `PerGB2018`. If you've provisioned resources before this date you have the option of remaining with the previous Pricing SKU and using the other SKUs defined above. More information about [the Pricing SKUs is available at the following URI](https://aka.ms/PricingTierWarning).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnalyticsWorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Log Analytics (formally Operational Insights) Workspace.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.OperationalInsights`: 2022-10-01, 2020-08-01

        ## Import

        Log Analytics Workspaces can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:operationalinsights/analyticsWorkspace:AnalyticsWorkspace workspace1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.OperationalInsights/workspaces/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param AnalyticsWorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalyticsWorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_resource_only_permissions: Optional[pulumi.Input[_builtins.bool]] = None,
                 cmk_for_query_forced: Optional[pulumi.Input[_builtins.bool]] = None,
                 daily_quota_gb: Optional[pulumi.Input[_builtins.float]] = None,
                 data_collection_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['AnalyticsWorkspaceIdentityArgs', 'AnalyticsWorkspaceIdentityArgsDict']]] = None,
                 immediate_data_purge_on30_days_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_ingestion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 internet_query_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 local_authentication_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reservation_capacity_in_gb_per_day: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalyticsWorkspaceArgs.__new__(AnalyticsWorkspaceArgs)

            __props__.__dict__["allow_resource_only_permissions"] = allow_resource_only_permissions
            __props__.__dict__["cmk_for_query_forced"] = cmk_for_query_forced
            __props__.__dict__["daily_quota_gb"] = daily_quota_gb
            __props__.__dict__["data_collection_rule_id"] = data_collection_rule_id
            __props__.__dict__["identity"] = identity
            __props__.__dict__["immediate_data_purge_on30_days_enabled"] = immediate_data_purge_on30_days_enabled
            __props__.__dict__["internet_ingestion_enabled"] = internet_ingestion_enabled
            __props__.__dict__["internet_query_enabled"] = internet_query_enabled
            __props__.__dict__["local_authentication_disabled"] = local_authentication_disabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["reservation_capacity_in_gb_per_day"] = reservation_capacity_in_gb_per_day
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["retention_in_days"] = retention_in_days
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["primary_shared_key"] = None
            __props__.__dict__["secondary_shared_key"] = None
            __props__.__dict__["workspace_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primarySharedKey", "secondarySharedKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AnalyticsWorkspace, __self__).__init__(
            'azure:operationalinsights/analyticsWorkspace:AnalyticsWorkspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_resource_only_permissions: Optional[pulumi.Input[_builtins.bool]] = None,
            cmk_for_query_forced: Optional[pulumi.Input[_builtins.bool]] = None,
            daily_quota_gb: Optional[pulumi.Input[_builtins.float]] = None,
            data_collection_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['AnalyticsWorkspaceIdentityArgs', 'AnalyticsWorkspaceIdentityArgsDict']]] = None,
            immediate_data_purge_on30_days_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            internet_ingestion_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            internet_query_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            local_authentication_disabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_shared_key: Optional[pulumi.Input[_builtins.str]] = None,
            reservation_capacity_in_gb_per_day: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            retention_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            secondary_shared_key: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AnalyticsWorkspace':
        """
        Get an existing AnalyticsWorkspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_resource_only_permissions: Specifies if the log Analytics Workspace allow users accessing to data associated with resources they have permission to view, without permission to workspace. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] cmk_for_query_forced: Is Customer Managed Storage mandatory for query management?
        :param pulumi.Input[_builtins.float] daily_quota_gb: The workspace daily quota for ingestion in GB. Defaults to `-1` (unlimited) if omitted.
        :param pulumi.Input[_builtins.str] data_collection_rule_id: The ID of the Data Collection Rule to use for this workspace.
        :param pulumi.Input[Union['AnalyticsWorkspaceIdentityArgs', 'AnalyticsWorkspaceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] immediate_data_purge_on30_days_enabled: Whether to remove the data in the Log Analytics Workspace immediately after 30 days.
        :param pulumi.Input[_builtins.bool] internet_ingestion_enabled: Should the Log Analytics Workspace support ingestion over the Public Internet? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] internet_query_enabled: Should the Log Analytics Workspace support querying over the Public Internet? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] local_authentication_disabled: Specifies if the log Analytics workspace should enforce authentication using Azure AD. Defaults to `false`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] primary_shared_key: The Primary shared key for the Log Analytics Workspace.
        :param pulumi.Input[_builtins.int] reservation_capacity_in_gb_per_day: The capacity reservation level in GB for this workspace. Possible values are `100`, `200`, `300`, `400`, `500`, `1000`, `2000` and `5000`.
               
               > **Note:** `reservation_capacity_in_gb_per_day` can only be used when the `sku` is set to `CapacityReservation`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_in_days: The workspace data retention in days. Possible values are between `30` and `730`.
        :param pulumi.Input[_builtins.str] secondary_shared_key: The Secondary shared key for the Log Analytics Workspace.
        :param pulumi.Input[_builtins.str] sku: Specifies the SKU of the Log Analytics Workspace. Possible values are `PerNode`, `Premium`, `Standard`, `Standalone`, `Unlimited`, `CapacityReservation`, `PerGB2018`, and `LACluster`. Defaults to `PerGB2018`.
               
               > **Note:** `sku` should only be set to `LACluster` when the Log Analytics Workspace is linked to a Log Analytics Cluster. Additionally, `sku` cannot be modified while linked.
               
               > **Note:** Changing `sku` forces a new Log Analytics Workspace to be created, except when changing between `PerGB2018` and `CapacityReservation`. Changing `sku` to `CapacityReservation` or changing `reservation_capacity_in_gb_per_day` to a higher tier will lead to a 31-days commitment period, during which the SKU cannot be changed to a lower one. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/cost-logs#commitment-tiers) for further information.
               
               > **Note:** A new pricing model took effect on `2018-04-03`, which requires the SKU `PerGB2018`. If you've provisioned resources before this date you have the option of remaining with the previous Pricing SKU and using the other SKUs defined above. More information about [the Pricing SKUs is available at the following URI](https://aka.ms/PricingTierWarning).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] workspace_id: The Workspace (or Customer) ID for the Log Analytics Workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnalyticsWorkspaceState.__new__(_AnalyticsWorkspaceState)

        __props__.__dict__["allow_resource_only_permissions"] = allow_resource_only_permissions
        __props__.__dict__["cmk_for_query_forced"] = cmk_for_query_forced
        __props__.__dict__["daily_quota_gb"] = daily_quota_gb
        __props__.__dict__["data_collection_rule_id"] = data_collection_rule_id
        __props__.__dict__["identity"] = identity
        __props__.__dict__["immediate_data_purge_on30_days_enabled"] = immediate_data_purge_on30_days_enabled
        __props__.__dict__["internet_ingestion_enabled"] = internet_ingestion_enabled
        __props__.__dict__["internet_query_enabled"] = internet_query_enabled
        __props__.__dict__["local_authentication_disabled"] = local_authentication_disabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_shared_key"] = primary_shared_key
        __props__.__dict__["reservation_capacity_in_gb_per_day"] = reservation_capacity_in_gb_per_day
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["retention_in_days"] = retention_in_days
        __props__.__dict__["secondary_shared_key"] = secondary_shared_key
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["workspace_id"] = workspace_id
        return AnalyticsWorkspace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowResourceOnlyPermissions")
    def allow_resource_only_permissions(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the log Analytics Workspace allow users accessing to data associated with resources they have permission to view, without permission to workspace. Defaults to `true`.
        """
        return pulumi.get(self, "allow_resource_only_permissions")

    @_builtins.property
    @pulumi.getter(name="cmkForQueryForced")
    def cmk_for_query_forced(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is Customer Managed Storage mandatory for query management?
        """
        return pulumi.get(self, "cmk_for_query_forced")

    @_builtins.property
    @pulumi.getter(name="dailyQuotaGb")
    def daily_quota_gb(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        The workspace daily quota for ingestion in GB. Defaults to `-1` (unlimited) if omitted.
        """
        return pulumi.get(self, "daily_quota_gb")

    @_builtins.property
    @pulumi.getter(name="dataCollectionRuleId")
    def data_collection_rule_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Data Collection Rule to use for this workspace.
        """
        return pulumi.get(self, "data_collection_rule_id")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.AnalyticsWorkspaceIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="immediateDataPurgeOn30DaysEnabled")
    def immediate_data_purge_on30_days_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to remove the data in the Log Analytics Workspace immediately after 30 days.
        """
        return pulumi.get(self, "immediate_data_purge_on30_days_enabled")

    @_builtins.property
    @pulumi.getter(name="internetIngestionEnabled")
    def internet_ingestion_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Log Analytics Workspace support ingestion over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_ingestion_enabled")

    @_builtins.property
    @pulumi.getter(name="internetQueryEnabled")
    def internet_query_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Log Analytics Workspace support querying over the Public Internet? Defaults to `true`.
        """
        return pulumi.get(self, "internet_query_enabled")

    @_builtins.property
    @pulumi.getter(name="localAuthenticationDisabled")
    def local_authentication_disabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the log Analytics workspace should enforce authentication using Azure AD. Defaults to `false`.
        """
        return pulumi.get(self, "local_authentication_disabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Log Analytics Workspace. Workspace name should include 4-63 letters, digits or '-'. The '-' shouldn't be the first or the last symbol. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primarySharedKey")
    def primary_shared_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Primary shared key for the Log Analytics Workspace.
        """
        return pulumi.get(self, "primary_shared_key")

    @_builtins.property
    @pulumi.getter(name="reservationCapacityInGbPerDay")
    def reservation_capacity_in_gb_per_day(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The capacity reservation level in GB for this workspace. Possible values are `100`, `200`, `300`, `400`, `500`, `1000`, `2000` and `5000`.

        > **Note:** `reservation_capacity_in_gb_per_day` can only be used when the `sku` is set to `CapacityReservation`.
        """
        return pulumi.get(self, "reservation_capacity_in_gb_per_day")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Log Analytics workspace is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="retentionInDays")
    def retention_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        The workspace data retention in days. Possible values are between `30` and `730`.
        """
        return pulumi.get(self, "retention_in_days")

    @_builtins.property
    @pulumi.getter(name="secondarySharedKey")
    def secondary_shared_key(self) -> pulumi.Output[_builtins.str]:
        """
        The Secondary shared key for the Log Analytics Workspace.
        """
        return pulumi.get(self, "secondary_shared_key")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SKU of the Log Analytics Workspace. Possible values are `PerNode`, `Premium`, `Standard`, `Standalone`, `Unlimited`, `CapacityReservation`, `PerGB2018`, and `LACluster`. Defaults to `PerGB2018`.

        > **Note:** `sku` should only be set to `LACluster` when the Log Analytics Workspace is linked to a Log Analytics Cluster. Additionally, `sku` cannot be modified while linked.

        > **Note:** Changing `sku` forces a new Log Analytics Workspace to be created, except when changing between `PerGB2018` and `CapacityReservation`. Changing `sku` to `CapacityReservation` or changing `reservation_capacity_in_gb_per_day` to a higher tier will lead to a 31-days commitment period, during which the SKU cannot be changed to a lower one. Please refer to [official documentation](https://learn.microsoft.com/en-us/azure/azure-monitor/logs/cost-logs#commitment-tiers) for further information.

        > **Note:** A new pricing model took effect on `2018-04-03`, which requires the SKU `PerGB2018`. If you've provisioned resources before this date you have the option of remaining with the previous Pricing SKU and using the other SKUs defined above. More information about [the Pricing SKUs is available at the following URI](https://aka.ms/PricingTierWarning).
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Workspace (or Customer) ID for the Log Analytics Workspace.
        """
        return pulumi.get(self, "workspace_id")

