# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountArgs', 'Account']

@pulumi.input_type
class AccountArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input['AccountIdentityArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Account resource.
        :param pulumi.Input['AccountIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[_builtins.str] managed_resource_group_name: The name which should be used for the new Resource Group where Purview Account creates the managed resources. Changing this forces a new Purview Account to be created.
               
               > **Note:** `managed_resource_group_name` must be a new Resource Group.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Purview Account. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[_builtins.bool] public_network_enabled: Should the Purview Account be visible to the public network? Defaults to `true`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Purview Account.
        """
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_resource_group_name is not None:
            pulumi.set(__self__, "managed_resource_group_name", managed_resource_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_enabled is not None:
            pulumi.set(__self__, "public_network_enabled", public_network_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input['AccountIdentityArgs']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['AccountIdentityArgs']):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedResourceGroupName")
    def managed_resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for the new Resource Group where Purview Account creates the managed resources. Changing this forces a new Purview Account to be created.

        > **Note:** `managed_resource_group_name` must be a new Resource Group.
        """
        return pulumi.get(self, "managed_resource_group_name")

    @managed_resource_group_name.setter
    def managed_resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Purview Account. Changing this forces a new Purview Account to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkEnabled")
    def public_network_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Purview Account be visible to the public network? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_enabled")

    @public_network_enabled.setter
    def public_network_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Purview Account.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AccountState:
    def __init__(__self__, *,
                 atlas_kafka_endpoint_primary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 atlas_kafka_endpoint_secondary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 catalog_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 guardian_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['AccountIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_resources: Optional[pulumi.Input[Sequence[pulumi.Input['AccountManagedResourceArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scan_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Account resources.
        :param pulumi.Input[_builtins.str] atlas_kafka_endpoint_primary_connection_string: Atlas Kafka endpoint primary connection string.
        :param pulumi.Input[_builtins.str] atlas_kafka_endpoint_secondary_connection_string: Atlas Kafka endpoint secondary connection string.
        :param pulumi.Input[_builtins.str] catalog_endpoint: Catalog endpoint.
        :param pulumi.Input[_builtins.str] guardian_endpoint: Guardian endpoint.
        :param pulumi.Input['AccountIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[_builtins.str] managed_resource_group_name: The name which should be used for the new Resource Group where Purview Account creates the managed resources. Changing this forces a new Purview Account to be created.
               
               > **Note:** `managed_resource_group_name` must be a new Resource Group.
        :param pulumi.Input[Sequence[pulumi.Input['AccountManagedResourceArgs']]] managed_resources: A `managed_resources` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Purview Account. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[_builtins.bool] public_network_enabled: Should the Purview Account be visible to the public network? Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[_builtins.str] scan_endpoint: Scan endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Purview Account.
        """
        if atlas_kafka_endpoint_primary_connection_string is not None:
            pulumi.set(__self__, "atlas_kafka_endpoint_primary_connection_string", atlas_kafka_endpoint_primary_connection_string)
        if atlas_kafka_endpoint_secondary_connection_string is not None:
            pulumi.set(__self__, "atlas_kafka_endpoint_secondary_connection_string", atlas_kafka_endpoint_secondary_connection_string)
        if catalog_endpoint is not None:
            pulumi.set(__self__, "catalog_endpoint", catalog_endpoint)
        if guardian_endpoint is not None:
            pulumi.set(__self__, "guardian_endpoint", guardian_endpoint)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_resource_group_name is not None:
            pulumi.set(__self__, "managed_resource_group_name", managed_resource_group_name)
        if managed_resources is not None:
            pulumi.set(__self__, "managed_resources", managed_resources)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_enabled is not None:
            pulumi.set(__self__, "public_network_enabled", public_network_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scan_endpoint is not None:
            pulumi.set(__self__, "scan_endpoint", scan_endpoint)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="atlasKafkaEndpointPrimaryConnectionString")
    def atlas_kafka_endpoint_primary_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Atlas Kafka endpoint primary connection string.
        """
        return pulumi.get(self, "atlas_kafka_endpoint_primary_connection_string")

    @atlas_kafka_endpoint_primary_connection_string.setter
    def atlas_kafka_endpoint_primary_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "atlas_kafka_endpoint_primary_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="atlasKafkaEndpointSecondaryConnectionString")
    def atlas_kafka_endpoint_secondary_connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Atlas Kafka endpoint secondary connection string.
        """
        return pulumi.get(self, "atlas_kafka_endpoint_secondary_connection_string")

    @atlas_kafka_endpoint_secondary_connection_string.setter
    def atlas_kafka_endpoint_secondary_connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "atlas_kafka_endpoint_secondary_connection_string", value)

    @_builtins.property
    @pulumi.getter(name="catalogEndpoint")
    def catalog_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Catalog endpoint.
        """
        return pulumi.get(self, "catalog_endpoint")

    @catalog_endpoint.setter
    def catalog_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "catalog_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="guardianEndpoint")
    def guardian_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Guardian endpoint.
        """
        return pulumi.get(self, "guardian_endpoint")

    @guardian_endpoint.setter
    def guardian_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "guardian_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AccountIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AccountIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedResourceGroupName")
    def managed_resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for the new Resource Group where Purview Account creates the managed resources. Changing this forces a new Purview Account to be created.

        > **Note:** `managed_resource_group_name` must be a new Resource Group.
        """
        return pulumi.get(self, "managed_resource_group_name")

    @managed_resource_group_name.setter
    def managed_resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="managedResources")
    def managed_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountManagedResourceArgs']]]]:
        """
        A `managed_resources` block as defined below.
        """
        return pulumi.get(self, "managed_resources")

    @managed_resources.setter
    def managed_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountManagedResourceArgs']]]]):
        pulumi.set(self, "managed_resources", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Purview Account. Changing this forces a new Purview Account to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkEnabled")
    def public_network_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Purview Account be visible to the public network? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_enabled")

    @public_network_enabled.setter
    def public_network_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scanEndpoint")
    def scan_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scan endpoint.
        """
        return pulumi.get(self, "scan_endpoint")

    @scan_endpoint.setter
    def scan_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scan_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Purview Account.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:purview/account:Account")
class Account(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Purview Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.purview.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Purview`: 2021-07-01

        ## Import

        Purview Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:purview/account:Account example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Purview/accounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[_builtins.str] managed_resource_group_name: The name which should be used for the new Resource Group where Purview Account creates the managed resources. Changing this forces a new Purview Account to be created.
               
               > **Note:** `managed_resource_group_name` must be a new Resource Group.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Purview Account. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[_builtins.bool] public_network_enabled: Should the Purview Account be visible to the public network? Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Purview Account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Purview Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.purview.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Purview`: 2021-07-01

        ## Import

        Purview Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:purview/account:Account example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Purview/accounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param AccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountArgs.__new__(AccountArgs)

            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_resource_group_name"] = managed_resource_group_name
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_enabled"] = public_network_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["atlas_kafka_endpoint_primary_connection_string"] = None
            __props__.__dict__["atlas_kafka_endpoint_secondary_connection_string"] = None
            __props__.__dict__["catalog_endpoint"] = None
            __props__.__dict__["guardian_endpoint"] = None
            __props__.__dict__["managed_resources"] = None
            __props__.__dict__["scan_endpoint"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["atlasKafkaEndpointPrimaryConnectionString", "atlasKafkaEndpointSecondaryConnectionString"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Account, __self__).__init__(
            'azure:purview/account:Account',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            atlas_kafka_endpoint_primary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            atlas_kafka_endpoint_secondary_connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            catalog_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            guardian_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            managed_resources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AccountManagedResourceArgs', 'AccountManagedResourceArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scan_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Account':
        """
        Get an existing Account resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] atlas_kafka_endpoint_primary_connection_string: Atlas Kafka endpoint primary connection string.
        :param pulumi.Input[_builtins.str] atlas_kafka_endpoint_secondary_connection_string: Atlas Kafka endpoint secondary connection string.
        :param pulumi.Input[_builtins.str] catalog_endpoint: Catalog endpoint.
        :param pulumi.Input[_builtins.str] guardian_endpoint: Guardian endpoint.
        :param pulumi.Input[Union['AccountIdentityArgs', 'AccountIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[_builtins.str] managed_resource_group_name: The name which should be used for the new Resource Group where Purview Account creates the managed resources. Changing this forces a new Purview Account to be created.
               
               > **Note:** `managed_resource_group_name` must be a new Resource Group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AccountManagedResourceArgs', 'AccountManagedResourceArgsDict']]]] managed_resources: A `managed_resources` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Purview Account. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[_builtins.bool] public_network_enabled: Should the Purview Account be visible to the public network? Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        :param pulumi.Input[_builtins.str] scan_endpoint: Scan endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Purview Account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountState.__new__(_AccountState)

        __props__.__dict__["atlas_kafka_endpoint_primary_connection_string"] = atlas_kafka_endpoint_primary_connection_string
        __props__.__dict__["atlas_kafka_endpoint_secondary_connection_string"] = atlas_kafka_endpoint_secondary_connection_string
        __props__.__dict__["catalog_endpoint"] = catalog_endpoint
        __props__.__dict__["guardian_endpoint"] = guardian_endpoint
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_resource_group_name"] = managed_resource_group_name
        __props__.__dict__["managed_resources"] = managed_resources
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_enabled"] = public_network_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["scan_endpoint"] = scan_endpoint
        __props__.__dict__["tags"] = tags
        return Account(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="atlasKafkaEndpointPrimaryConnectionString")
    def atlas_kafka_endpoint_primary_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        Atlas Kafka endpoint primary connection string.
        """
        return pulumi.get(self, "atlas_kafka_endpoint_primary_connection_string")

    @_builtins.property
    @pulumi.getter(name="atlasKafkaEndpointSecondaryConnectionString")
    def atlas_kafka_endpoint_secondary_connection_string(self) -> pulumi.Output[_builtins.str]:
        """
        Atlas Kafka endpoint secondary connection string.
        """
        return pulumi.get(self, "atlas_kafka_endpoint_secondary_connection_string")

    @_builtins.property
    @pulumi.getter(name="catalogEndpoint")
    def catalog_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Catalog endpoint.
        """
        return pulumi.get(self, "catalog_endpoint")

    @_builtins.property
    @pulumi.getter(name="guardianEndpoint")
    def guardian_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Guardian endpoint.
        """
        return pulumi.get(self, "guardian_endpoint")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.AccountIdentity']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedResourceGroupName")
    def managed_resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for the new Resource Group where Purview Account creates the managed resources. Changing this forces a new Purview Account to be created.

        > **Note:** `managed_resource_group_name` must be a new Resource Group.
        """
        return pulumi.get(self, "managed_resource_group_name")

    @_builtins.property
    @pulumi.getter(name="managedResources")
    def managed_resources(self) -> pulumi.Output[Sequence['outputs.AccountManagedResource']]:
        """
        A `managed_resources` block as defined below.
        """
        return pulumi.get(self, "managed_resources")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Purview Account. Changing this forces a new Purview Account to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicNetworkEnabled")
    def public_network_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Purview Account be visible to the public network? Defaults to `true`.
        """
        return pulumi.get(self, "public_network_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Purview Account should exist. Changing this forces a new Purview Account to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scanEndpoint")
    def scan_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Scan endpoint.
        """
        return pulumi.get(self, "scan_endpoint")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Purview Account.
        """
        return pulumi.get(self, "tags")

