# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    """
    A collection of values returned by getService.
    """
    def __init__(__self__, customer_managed_key_encryption_compliance_status=None, id=None, identities=None, name=None, partition_count=None, primary_key=None, public_network_access_enabled=None, query_keys=None, replica_count=None, resource_group_name=None, secondary_key=None, tags=None):
        if customer_managed_key_encryption_compliance_status and not isinstance(customer_managed_key_encryption_compliance_status, str):
            raise TypeError("Expected argument 'customer_managed_key_encryption_compliance_status' to be a str")
        pulumi.set(__self__, "customer_managed_key_encryption_compliance_status", customer_managed_key_encryption_compliance_status)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if partition_count and not isinstance(partition_count, int):
            raise TypeError("Expected argument 'partition_count' to be a int")
        pulumi.set(__self__, "partition_count", partition_count)
        if primary_key and not isinstance(primary_key, str):
            raise TypeError("Expected argument 'primary_key' to be a str")
        pulumi.set(__self__, "primary_key", primary_key)
        if public_network_access_enabled and not isinstance(public_network_access_enabled, bool):
            raise TypeError("Expected argument 'public_network_access_enabled' to be a bool")
        pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if query_keys and not isinstance(query_keys, list):
            raise TypeError("Expected argument 'query_keys' to be a list")
        pulumi.set(__self__, "query_keys", query_keys)
        if replica_count and not isinstance(replica_count, int):
            raise TypeError("Expected argument 'replica_count' to be a int")
        pulumi.set(__self__, "replica_count", replica_count)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_key and not isinstance(secondary_key, str):
            raise TypeError("Expected argument 'secondary_key' to be a str")
        pulumi.set(__self__, "secondary_key", secondary_key)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customerManagedKeyEncryptionComplianceStatus")
    def customer_managed_key_encryption_compliance_status(self) -> _builtins.str:
        """
        Describes whether the search service is compliant or not with respect to having non-customer encrypted resources. If a service has more than one non-customer encrypted resource and `Enforcement` is `enabled` then the service will be marked as `NonCompliant`. If all the resources are customer encrypted, then the service will be marked as `Compliant`.
        """
        return pulumi.get(self, "customer_managed_key_encryption_compliance_status")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetServiceIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Query Key.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="partitionCount")
    def partition_count(self) -> _builtins.int:
        """
        The number of partitions which have been created.
        """
        return pulumi.get(self, "partition_count")

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> _builtins.str:
        """
        The Primary Key used for Search Service Administration.
        """
        return pulumi.get(self, "primary_key")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> _builtins.bool:
        """
        Whether or not public network access is enabled for this resource.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="queryKeys")
    def query_keys(self) -> Sequence['outputs.GetServiceQueryKeyResult']:
        """
        A `query_keys` block as defined below.
        """
        return pulumi.get(self, "query_keys")

    @_builtins.property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> _builtins.int:
        """
        The number of replica's which have been created.
        """
        return pulumi.get(self, "replica_count")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> _builtins.str:
        """
        The Secondary Key used for Search Service Administration.
        """
        return pulumi.get(self, "secondary_key")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            customer_managed_key_encryption_compliance_status=self.customer_managed_key_encryption_compliance_status,
            id=self.id,
            identities=self.identities,
            name=self.name,
            partition_count=self.partition_count,
            primary_key=self.primary_key,
            public_network_access_enabled=self.public_network_access_enabled,
            query_keys=self.query_keys,
            replica_count=self.replica_count,
            resource_group_name=self.resource_group_name,
            secondary_key=self.secondary_key,
            tags=self.tags)


def get_service(name: Optional[_builtins.str] = None,
                resource_group_name: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    Manages a Search Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="example-resources",
        location="West Europe")
    example = azure.search.get_service_output(name="example-search-service",
        resource_group_name=example_resource_group.name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Search`: 2024-06-01-preview


    :param _builtins.str name: The Name of the Search Service.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Search Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:search/getService:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        customer_managed_key_encryption_compliance_status=pulumi.get(__ret__, 'customer_managed_key_encryption_compliance_status'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        name=pulumi.get(__ret__, 'name'),
        partition_count=pulumi.get(__ret__, 'partition_count'),
        primary_key=pulumi.get(__ret__, 'primary_key'),
        public_network_access_enabled=pulumi.get(__ret__, 'public_network_access_enabled'),
        query_keys=pulumi.get(__ret__, 'query_keys'),
        replica_count=pulumi.get(__ret__, 'replica_count'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        secondary_key=pulumi.get(__ret__, 'secondary_key'),
        tags=pulumi.get(__ret__, 'tags'))
def get_service_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                       resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    Manages a Search Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="example-resources",
        location="West Europe")
    example = azure.search.get_service_output(name="example-search-service",
        resource_group_name=example_resource_group.name)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Search`: 2024-06-01-preview


    :param _builtins.str name: The Name of the Search Service.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Search Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:search/getService:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        customer_managed_key_encryption_compliance_status=pulumi.get(__response__, 'customer_managed_key_encryption_compliance_status'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        name=pulumi.get(__response__, 'name'),
        partition_count=pulumi.get(__response__, 'partition_count'),
        primary_key=pulumi.get(__response__, 'primary_key'),
        public_network_access_enabled=pulumi.get(__response__, 'public_network_access_enabled'),
        query_keys=pulumi.get(__response__, 'query_keys'),
        replica_count=pulumi.get(__response__, 'replica_count'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        secondary_key=pulumi.get(__response__, 'secondary_key'),
        tags=pulumi.get(__response__, 'tags')))
