# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceCustomDomainArgs', 'ServiceCustomDomain']

@pulumi.input_type
class ServiceCustomDomainArgs:
    def __init__(__self__, *,
                 domain_name: pulumi.Input[_builtins.str],
                 signalr_custom_certificate_id: pulumi.Input[_builtins.str],
                 signalr_service_id: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceCustomDomain resource.
        :param pulumi.Input[_builtins.str] domain_name: Specifies the custom domain name of the SignalR Custom Domain. Changing this forces a new resource to be created.
               
               > **Note:** Please ensure the custom domain name is included in the Subject Alternative Names of the selected SignalR Custom Certificate.
        :param pulumi.Input[_builtins.str] signalr_custom_certificate_id: Specifies the SignalR Custom Certificate ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signalr_service_id: Specifies the SignalR ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "signalr_custom_certificate_id", signalr_custom_certificate_id)
        pulumi.set(__self__, "signalr_service_id", signalr_service_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the custom domain name of the SignalR Custom Domain. Changing this forces a new resource to be created.

        > **Note:** Please ensure the custom domain name is included in the Subject Alternative Names of the selected SignalR Custom Certificate.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="signalrCustomCertificateId")
    def signalr_custom_certificate_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the SignalR Custom Certificate ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "signalr_custom_certificate_id")

    @signalr_custom_certificate_id.setter
    def signalr_custom_certificate_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "signalr_custom_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="signalrServiceId")
    def signalr_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the SignalR ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "signalr_service_id")

    @signalr_service_id.setter
    def signalr_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "signalr_service_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ServiceCustomDomainState:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signalr_custom_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 signalr_service_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceCustomDomain resources.
        :param pulumi.Input[_builtins.str] domain_name: Specifies the custom domain name of the SignalR Custom Domain. Changing this forces a new resource to be created.
               
               > **Note:** Please ensure the custom domain name is included in the Subject Alternative Names of the selected SignalR Custom Certificate.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the SignalR Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signalr_custom_certificate_id: Specifies the SignalR Custom Certificate ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signalr_service_id: Specifies the SignalR ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if signalr_custom_certificate_id is not None:
            pulumi.set(__self__, "signalr_custom_certificate_id", signalr_custom_certificate_id)
        if signalr_service_id is not None:
            pulumi.set(__self__, "signalr_service_id", signalr_service_id)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the custom domain name of the SignalR Custom Domain. Changing this forces a new resource to be created.

        > **Note:** Please ensure the custom domain name is included in the Subject Alternative Names of the selected SignalR Custom Certificate.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="signalrCustomCertificateId")
    def signalr_custom_certificate_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SignalR Custom Certificate ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "signalr_custom_certificate_id")

    @signalr_custom_certificate_id.setter
    def signalr_custom_certificate_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signalr_custom_certificate_id", value)

    @_builtins.property
    @pulumi.getter(name="signalrServiceId")
    def signalr_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SignalR ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "signalr_service_id")

    @signalr_service_id.setter
    def signalr_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "signalr_service_id", value)


@pulumi.type_token("azure:signalr/serviceCustomDomain:ServiceCustomDomain")
class ServiceCustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signalr_custom_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 signalr_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure SignalR Custom Domain.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.signalr.Service("example",
            name="example-signalr",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            sku={
                "name": "Premium_P1",
                "capacity": 1,
            },
            identity={
                "type": "SystemAssigned",
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-keyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "certificate_permissions": [
                        "Create",
                        "Get",
                        "List",
                    ],
                    "secret_permissions": [
                        "Get",
                        "List",
                    ],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": test_azurerm_signalr_service["identity"][0]["principalId"],
                    "certificate_permissions": [
                        "Create",
                        "Get",
                        "List",
                    ],
                    "secret_permissions": [
                        "Get",
                        "List",
                    ],
                },
            ])
        example_certificate = azure.keyvault.Certificate("example",
            name="imported-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="certificate-to-import.pfx").result,
                "password": "",
            })
        test = azure.signalr.ServiceCustomCertificate("test",
            name="example-cert",
            signalr_service_id=example_service.id,
            custom_certificate_id=example_certificate.id,
            opts = pulumi.ResourceOptions(depends_on=[example_azurerm_key_vault_access_policy]))
        test_service_custom_domain = azure.signalr.ServiceCustomDomain("test",
            name="example-domain",
            signalr_service_id=test_azurerm_signalr_service["id"],
            domain_name="tftest.com",
            signalr_custom_certificate_id=test.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService`: 2024-03-01

        ## Import

        Custom Domain for a SignalR service can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:signalr/serviceCustomDomain:ServiceCustomDomain example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/signalR/signalr1/customDomains/customDomain1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_name: Specifies the custom domain name of the SignalR Custom Domain. Changing this forces a new resource to be created.
               
               > **Note:** Please ensure the custom domain name is included in the Subject Alternative Names of the selected SignalR Custom Certificate.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the SignalR Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signalr_custom_certificate_id: Specifies the SignalR Custom Certificate ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signalr_service_id: Specifies the SignalR ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceCustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure SignalR Custom Domain.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.signalr.Service("example",
            name="example-signalr",
            location=test_azurerm_resource_group["location"],
            resource_group_name=test_azurerm_resource_group["name"],
            sku={
                "name": "Premium_P1",
                "capacity": 1,
            },
            identity={
                "type": "SystemAssigned",
            })
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-keyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            access_policies=[
                {
                    "tenant_id": current.tenant_id,
                    "object_id": current.object_id,
                    "certificate_permissions": [
                        "Create",
                        "Get",
                        "List",
                    ],
                    "secret_permissions": [
                        "Get",
                        "List",
                    ],
                },
                {
                    "tenant_id": current.tenant_id,
                    "object_id": test_azurerm_signalr_service["identity"][0]["principalId"],
                    "certificate_permissions": [
                        "Create",
                        "Get",
                        "List",
                    ],
                    "secret_permissions": [
                        "Get",
                        "List",
                    ],
                },
            ])
        example_certificate = azure.keyvault.Certificate("example",
            name="imported-cert",
            key_vault_id=example_key_vault.id,
            certificate={
                "contents": std.filebase64(input="certificate-to-import.pfx").result,
                "password": "",
            })
        test = azure.signalr.ServiceCustomCertificate("test",
            name="example-cert",
            signalr_service_id=example_service.id,
            custom_certificate_id=example_certificate.id,
            opts = pulumi.ResourceOptions(depends_on=[example_azurerm_key_vault_access_policy]))
        test_service_custom_domain = azure.signalr.ServiceCustomDomain("test",
            name="example-domain",
            signalr_service_id=test_azurerm_signalr_service["id"],
            domain_name="tftest.com",
            signalr_custom_certificate_id=test.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.SignalRService`: 2024-03-01

        ## Import

        Custom Domain for a SignalR service can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:signalr/serviceCustomDomain:ServiceCustomDomain example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.SignalRService/signalR/signalr1/customDomains/customDomain1
        ```

        :param str resource_name: The name of the resource.
        :param ServiceCustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceCustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 signalr_custom_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
                 signalr_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceCustomDomainArgs.__new__(ServiceCustomDomainArgs)

            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["name"] = name
            if signalr_custom_certificate_id is None and not opts.urn:
                raise TypeError("Missing required property 'signalr_custom_certificate_id'")
            __props__.__dict__["signalr_custom_certificate_id"] = signalr_custom_certificate_id
            if signalr_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'signalr_service_id'")
            __props__.__dict__["signalr_service_id"] = signalr_service_id
        super(ServiceCustomDomain, __self__).__init__(
            'azure:signalr/serviceCustomDomain:ServiceCustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            signalr_custom_certificate_id: Optional[pulumi.Input[_builtins.str]] = None,
            signalr_service_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServiceCustomDomain':
        """
        Get an existing ServiceCustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] domain_name: Specifies the custom domain name of the SignalR Custom Domain. Changing this forces a new resource to be created.
               
               > **Note:** Please ensure the custom domain name is included in the Subject Alternative Names of the selected SignalR Custom Certificate.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the SignalR Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signalr_custom_certificate_id: Specifies the SignalR Custom Certificate ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] signalr_service_id: Specifies the SignalR ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceCustomDomainState.__new__(_ServiceCustomDomainState)

        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["name"] = name
        __props__.__dict__["signalr_custom_certificate_id"] = signalr_custom_certificate_id
        __props__.__dict__["signalr_service_id"] = signalr_service_id
        return ServiceCustomDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the custom domain name of the SignalR Custom Domain. Changing this forces a new resource to be created.

        > **Note:** Please ensure the custom domain name is included in the Subject Alternative Names of the selected SignalR Custom Certificate.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="signalrCustomCertificateId")
    def signalr_custom_certificate_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SignalR Custom Certificate ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "signalr_custom_certificate_id")

    @_builtins.property
    @pulumi.getter(name="signalrServiceId")
    def signalr_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SignalR ID of the SignalR Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "signalr_service_id")

