# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ProtectionContainerMappingAutomaticUpdateArgs',
    'ProtectionContainerMappingAutomaticUpdateArgsDict',
    'ReplicatedVMManagedDiskArgs',
    'ReplicatedVMManagedDiskArgsDict',
    'ReplicatedVMManagedDiskTargetDiskEncryptionArgs',
    'ReplicatedVMManagedDiskTargetDiskEncryptionArgsDict',
    'ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKeyArgs',
    'ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKeyArgsDict',
    'ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKeyArgs',
    'ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKeyArgsDict',
    'ReplicatedVMNetworkInterfaceArgs',
    'ReplicatedVMNetworkInterfaceArgsDict',
    'ReplicatedVMUnmanagedDiskArgs',
    'ReplicatedVMUnmanagedDiskArgsDict',
    'ReplicationRecoveryPlanAzureToAzureSettingsArgs',
    'ReplicationRecoveryPlanAzureToAzureSettingsArgsDict',
    'ReplicationRecoveryPlanBootRecoveryGroupArgs',
    'ReplicationRecoveryPlanBootRecoveryGroupArgsDict',
    'ReplicationRecoveryPlanBootRecoveryGroupPostActionArgs',
    'ReplicationRecoveryPlanBootRecoveryGroupPostActionArgsDict',
    'ReplicationRecoveryPlanBootRecoveryGroupPreActionArgs',
    'ReplicationRecoveryPlanBootRecoveryGroupPreActionArgsDict',
    'ReplicationRecoveryPlanFailoverRecoveryGroupArgs',
    'ReplicationRecoveryPlanFailoverRecoveryGroupArgsDict',
    'ReplicationRecoveryPlanFailoverRecoveryGroupPostActionArgs',
    'ReplicationRecoveryPlanFailoverRecoveryGroupPostActionArgsDict',
    'ReplicationRecoveryPlanFailoverRecoveryGroupPreActionArgs',
    'ReplicationRecoveryPlanFailoverRecoveryGroupPreActionArgsDict',
    'ReplicationRecoveryPlanShutdownRecoveryGroupArgs',
    'ReplicationRecoveryPlanShutdownRecoveryGroupArgsDict',
    'ReplicationRecoveryPlanShutdownRecoveryGroupPostActionArgs',
    'ReplicationRecoveryPlanShutdownRecoveryGroupPostActionArgsDict',
    'ReplicationRecoveryPlanShutdownRecoveryGroupPreActionArgs',
    'ReplicationRecoveryPlanShutdownRecoveryGroupPreActionArgsDict',
    'VmwareReplicatedVmManagedDiskArgs',
    'VmwareReplicatedVmManagedDiskArgsDict',
    'VmwareReplicatedVmNetworkInterfaceArgs',
    'VmwareReplicatedVmNetworkInterfaceArgsDict',
]

MYPY = False

if not MYPY:
    class ProtectionContainerMappingAutomaticUpdateArgsDict(TypedDict):
        authentication_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The authentication type used for automation account. Possible values are `RunAsAccount` and `SystemAssignedIdentity`. Defaults to `SystemAssignedIdentity`.

        > **Note:** `RunAsAccount` of `authentication_type` is deprecated and will retire on September 30, 2023. Details could be found [here](https://learn.microsoft.com/en-us/azure/automation/whats-new#support-for-run-as-accounts).
        """
        automation_account_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The automation account ID which holds the automatic update runbook and authenticates to Azure resources.

        > **Note:** `automation_account_id` is required when `enabled` is specified.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Should the Mobility service installed on Azure virtual machines be automatically updated. Defaults to `false`.

        > **Note:** The setting applies to all Azure VMs protected in the same container. For more details see [this document](https://learn.microsoft.com/en-us/azure/site-recovery/azure-to-azure-autoupdate#enable-automatic-updates)
        """
elif False:
    ProtectionContainerMappingAutomaticUpdateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ProtectionContainerMappingAutomaticUpdateArgs:
    def __init__(__self__, *,
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 automation_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] authentication_type: The authentication type used for automation account. Possible values are `RunAsAccount` and `SystemAssignedIdentity`. Defaults to `SystemAssignedIdentity`.
               
               > **Note:** `RunAsAccount` of `authentication_type` is deprecated and will retire on September 30, 2023. Details could be found [here](https://learn.microsoft.com/en-us/azure/automation/whats-new#support-for-run-as-accounts).
        :param pulumi.Input[_builtins.str] automation_account_id: The automation account ID which holds the automatic update runbook and authenticates to Azure resources.
               
               > **Note:** `automation_account_id` is required when `enabled` is specified.
        :param pulumi.Input[_builtins.bool] enabled: Should the Mobility service installed on Azure virtual machines be automatically updated. Defaults to `false`.
               
               > **Note:** The setting applies to all Azure VMs protected in the same container. For more details see [this document](https://learn.microsoft.com/en-us/azure/site-recovery/azure-to-azure-autoupdate#enable-automatic-updates)
        """
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if automation_account_id is not None:
            pulumi.set(__self__, "automation_account_id", automation_account_id)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication type used for automation account. Possible values are `RunAsAccount` and `SystemAssignedIdentity`. Defaults to `SystemAssignedIdentity`.

        > **Note:** `RunAsAccount` of `authentication_type` is deprecated and will retire on September 30, 2023. Details could be found [here](https://learn.microsoft.com/en-us/azure/automation/whats-new#support-for-run-as-accounts).
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The automation account ID which holds the automatic update runbook and authenticates to Azure resources.

        > **Note:** `automation_account_id` is required when `enabled` is specified.
        """
        return pulumi.get(self, "automation_account_id")

    @automation_account_id.setter
    def automation_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automation_account_id", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Mobility service installed on Azure virtual machines be automatically updated. Defaults to `false`.

        > **Note:** The setting applies to all Azure VMs protected in the same container. For more details see [this document](https://learn.microsoft.com/en-us/azure/site-recovery/azure-to-azure-autoupdate#enable-automatic-updates)
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)


if not MYPY:
    class ReplicatedVMManagedDiskArgsDict(TypedDict):
        disk_id: pulumi.Input[_builtins.str]
        """
        Id of disk that should be replicated. Changing this forces a new resource to be created.
        """
        staging_storage_account_id: pulumi.Input[_builtins.str]
        """
        Storage account that should be used for caching. Changing this forces a new resource to be created.
        """
        target_disk_type: pulumi.Input[_builtins.str]
        """
        What type should the disk be when a failover is done. Possible values are `Standard_LRS`, `Premium_LRS`, `StandardSSD_LRS` and `UltraSSD_LRS`. Changing this forces a new resource to be created.
        """
        target_replica_disk_type: pulumi.Input[_builtins.str]
        """
        What type should the disk be that holds the replication data. Possible values are `Standard_LRS`, `Premium_LRS`, `StandardSSD_LRS` and `UltraSSD_LRS`. Changing this forces a new resource to be created.
        """
        target_resource_group_id: pulumi.Input[_builtins.str]
        """
        Resource group disk should belong to when a failover is done. Changing this forces a new resource to be created.
        """
        target_disk_encryption: NotRequired[pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionArgsDict']]
        """
        A `target_disk_encryption` block as defined below.
        """
        target_disk_encryption_set_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Disk Encryption Set that the Managed Disk will be associated with. Changing this forces a new resource to be created.

        > **Note:** Creating replicated vm with `target_disk_encryption_set_id` wil take more time (up to 5 hours), please extend the `timeout` for `create`.
        """
elif False:
    ReplicatedVMManagedDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatedVMManagedDiskArgs:
    def __init__(__self__, *,
                 disk_id: pulumi.Input[_builtins.str],
                 staging_storage_account_id: pulumi.Input[_builtins.str],
                 target_disk_type: pulumi.Input[_builtins.str],
                 target_replica_disk_type: pulumi.Input[_builtins.str],
                 target_resource_group_id: pulumi.Input[_builtins.str],
                 target_disk_encryption: Optional[pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionArgs']] = None,
                 target_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] disk_id: Id of disk that should be replicated. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] staging_storage_account_id: Storage account that should be used for caching. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_disk_type: What type should the disk be when a failover is done. Possible values are `Standard_LRS`, `Premium_LRS`, `StandardSSD_LRS` and `UltraSSD_LRS`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_replica_disk_type: What type should the disk be that holds the replication data. Possible values are `Standard_LRS`, `Premium_LRS`, `StandardSSD_LRS` and `UltraSSD_LRS`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_resource_group_id: Resource group disk should belong to when a failover is done. Changing this forces a new resource to be created.
        :param pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionArgs'] target_disk_encryption: A `target_disk_encryption` block as defined below.
        :param pulumi.Input[_builtins.str] target_disk_encryption_set_id: The Disk Encryption Set that the Managed Disk will be associated with. Changing this forces a new resource to be created.
               
               > **Note:** Creating replicated vm with `target_disk_encryption_set_id` wil take more time (up to 5 hours), please extend the `timeout` for `create`.
        """
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "staging_storage_account_id", staging_storage_account_id)
        pulumi.set(__self__, "target_disk_type", target_disk_type)
        pulumi.set(__self__, "target_replica_disk_type", target_replica_disk_type)
        pulumi.set(__self__, "target_resource_group_id", target_resource_group_id)
        if target_disk_encryption is not None:
            pulumi.set(__self__, "target_disk_encryption", target_disk_encryption)
        if target_disk_encryption_set_id is not None:
            pulumi.set(__self__, "target_disk_encryption_set_id", target_disk_encryption_set_id)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of disk that should be replicated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "disk_id", value)

    @_builtins.property
    @pulumi.getter(name="stagingStorageAccountId")
    def staging_storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Storage account that should be used for caching. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "staging_storage_account_id")

    @staging_storage_account_id.setter
    def staging_storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "staging_storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="targetDiskType")
    def target_disk_type(self) -> pulumi.Input[_builtins.str]:
        """
        What type should the disk be when a failover is done. Possible values are `Standard_LRS`, `Premium_LRS`, `StandardSSD_LRS` and `UltraSSD_LRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_disk_type")

    @target_disk_type.setter
    def target_disk_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="targetReplicaDiskType")
    def target_replica_disk_type(self) -> pulumi.Input[_builtins.str]:
        """
        What type should the disk be that holds the replication data. Possible values are `Standard_LRS`, `Premium_LRS`, `StandardSSD_LRS` and `UltraSSD_LRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_replica_disk_type")

    @target_replica_disk_type.setter
    def target_replica_disk_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_replica_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceGroupId")
    def target_resource_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Resource group disk should belong to when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_group_id")

    @target_resource_group_id.setter
    def target_resource_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_group_id", value)

    @_builtins.property
    @pulumi.getter(name="targetDiskEncryption")
    def target_disk_encryption(self) -> Optional[pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionArgs']]:
        """
        A `target_disk_encryption` block as defined below.
        """
        return pulumi.get(self, "target_disk_encryption")

    @target_disk_encryption.setter
    def target_disk_encryption(self, value: Optional[pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionArgs']]):
        pulumi.set(self, "target_disk_encryption", value)

    @_builtins.property
    @pulumi.getter(name="targetDiskEncryptionSetId")
    def target_disk_encryption_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Disk Encryption Set that the Managed Disk will be associated with. Changing this forces a new resource to be created.

        > **Note:** Creating replicated vm with `target_disk_encryption_set_id` wil take more time (up to 5 hours), please extend the `timeout` for `create`.
        """
        return pulumi.get(self, "target_disk_encryption_set_id")

    @target_disk_encryption_set_id.setter
    def target_disk_encryption_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_disk_encryption_set_id", value)


if not MYPY:
    class ReplicatedVMManagedDiskTargetDiskEncryptionArgsDict(TypedDict):
        disk_encryption_key: pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKeyArgsDict']
        """
        A `disk_encryption_key` block as defined below.
        """
        key_encryption_key: NotRequired[pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKeyArgsDict']]
        """
        A `key_encryption_key` block as defined below.
        """
elif False:
    ReplicatedVMManagedDiskTargetDiskEncryptionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatedVMManagedDiskTargetDiskEncryptionArgs:
    def __init__(__self__, *,
                 disk_encryption_key: pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKeyArgs'],
                 key_encryption_key: Optional[pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKeyArgs']] = None):
        """
        :param pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKeyArgs'] disk_encryption_key: A `disk_encryption_key` block as defined below.
        :param pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKeyArgs'] key_encryption_key: A `key_encryption_key` block as defined below.
        """
        pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKeyArgs']:
        """
        A `disk_encryption_key` block as defined below.
        """
        return pulumi.get(self, "disk_encryption_key")

    @disk_encryption_key.setter
    def disk_encryption_key(self, value: pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKeyArgs']):
        pulumi.set(self, "disk_encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional[pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKeyArgs']]:
        """
        A `key_encryption_key` block as defined below.
        """
        return pulumi.get(self, "key_encryption_key")

    @key_encryption_key.setter
    def key_encryption_key(self, value: Optional[pulumi.Input['ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKeyArgs']]):
        pulumi.set(self, "key_encryption_key", value)


if not MYPY:
    class ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKeyArgsDict(TypedDict):
        secret_url: pulumi.Input[_builtins.str]
        """
        The URL to the Key Vault Secret used as the Disk Encryption Key that the Managed Disk will be associated with. This can be found as `id` on the `keyvault.Secret` resource. Changing this forces a new resource to be created.
        """
        vault_id: pulumi.Input[_builtins.str]
        """
        The ID of the Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource. Changing this forces a new resource to be created.
        """
elif False:
    ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatedVMManagedDiskTargetDiskEncryptionDiskEncryptionKeyArgs:
    def __init__(__self__, *,
                 secret_url: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] secret_url: The URL to the Key Vault Secret used as the Disk Encryption Key that the Managed Disk will be associated with. This can be found as `id` on the `keyvault.Secret` resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL to the Key Vault Secret used as the Disk Encryption Key that the Managed Disk will be associated with. This can be found as `id` on the `keyvault.Secret` resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "secret_url")

    @secret_url.setter
    def secret_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_url", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)


if not MYPY:
    class ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKeyArgsDict(TypedDict):
        key_url: pulumi.Input[_builtins.str]
        """
        The URL to the Key Vault Key used as the Key Encryption Key that the Managed Disk will be associated with. This can be found as `id` on the `keyvault.Key` resource. Changing this forces a new resource to be created.
        """
        vault_id: pulumi.Input[_builtins.str]
        """
        The ID of the Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource. Changing this forces a new resource to be created.
        """
elif False:
    ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatedVMManagedDiskTargetDiskEncryptionKeyEncryptionKeyArgs:
    def __init__(__self__, *,
                 key_url: pulumi.Input[_builtins.str],
                 vault_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] key_url: The URL to the Key Vault Key used as the Key Encryption Key that the Managed Disk will be associated with. This can be found as `id` on the `keyvault.Key` resource. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vault_id: The ID of the Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "vault_id", vault_id)

    @_builtins.property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL to the Key Vault Key used as the Key Encryption Key that the Managed Disk will be associated with. This can be found as `id` on the `keyvault.Key` resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_url")

    @key_url.setter
    def key_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_url", value)

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vault_id", value)


if not MYPY:
    class ReplicatedVMNetworkInterfaceArgsDict(TypedDict):
        failover_test_public_ip_address_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Id of the public IP object to use when a test failover is done.
        """
        failover_test_static_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Static IP to assign when a test failover is done.
        """
        failover_test_subnet_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the subnet to use when a test failover is done.
        """
        recovery_load_balancer_backend_address_pool_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of IDs of Load Balancer Backend Address Pools to use when a failover is done.
        """
        recovery_public_ip_address_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Id of the public IP object to use when a failover is done.
        """
        source_network_interface_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Required if the network_interface block is specified) Id source network interface.
        """
        target_static_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Static IP to assign when a failover is done.
        """
        target_subnet_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the subnet to use when a failover is done.
        """
elif False:
    ReplicatedVMNetworkInterfaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatedVMNetworkInterfaceArgs:
    def __init__(__self__, *,
                 failover_test_public_ip_address_id: Optional[pulumi.Input[_builtins.str]] = None,
                 failover_test_static_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 failover_test_subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_load_balancer_backend_address_pool_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 recovery_public_ip_address_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_static_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 target_subnet_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] failover_test_public_ip_address_id: Id of the public IP object to use when a test failover is done.
        :param pulumi.Input[_builtins.str] failover_test_static_ip: Static IP to assign when a test failover is done.
        :param pulumi.Input[_builtins.str] failover_test_subnet_name: Name of the subnet to use when a test failover is done.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] recovery_load_balancer_backend_address_pool_ids: A list of IDs of Load Balancer Backend Address Pools to use when a failover is done.
        :param pulumi.Input[_builtins.str] recovery_public_ip_address_id: Id of the public IP object to use when a failover is done.
        :param pulumi.Input[_builtins.str] source_network_interface_id: (Required if the network_interface block is specified) Id source network interface.
        :param pulumi.Input[_builtins.str] target_static_ip: Static IP to assign when a failover is done.
        :param pulumi.Input[_builtins.str] target_subnet_name: Name of the subnet to use when a failover is done.
        """
        if failover_test_public_ip_address_id is not None:
            pulumi.set(__self__, "failover_test_public_ip_address_id", failover_test_public_ip_address_id)
        if failover_test_static_ip is not None:
            pulumi.set(__self__, "failover_test_static_ip", failover_test_static_ip)
        if failover_test_subnet_name is not None:
            pulumi.set(__self__, "failover_test_subnet_name", failover_test_subnet_name)
        if recovery_load_balancer_backend_address_pool_ids is not None:
            pulumi.set(__self__, "recovery_load_balancer_backend_address_pool_ids", recovery_load_balancer_backend_address_pool_ids)
        if recovery_public_ip_address_id is not None:
            pulumi.set(__self__, "recovery_public_ip_address_id", recovery_public_ip_address_id)
        if source_network_interface_id is not None:
            pulumi.set(__self__, "source_network_interface_id", source_network_interface_id)
        if target_static_ip is not None:
            pulumi.set(__self__, "target_static_ip", target_static_ip)
        if target_subnet_name is not None:
            pulumi.set(__self__, "target_subnet_name", target_subnet_name)

    @_builtins.property
    @pulumi.getter(name="failoverTestPublicIpAddressId")
    def failover_test_public_ip_address_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the public IP object to use when a test failover is done.
        """
        return pulumi.get(self, "failover_test_public_ip_address_id")

    @failover_test_public_ip_address_id.setter
    def failover_test_public_ip_address_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "failover_test_public_ip_address_id", value)

    @_builtins.property
    @pulumi.getter(name="failoverTestStaticIp")
    def failover_test_static_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Static IP to assign when a test failover is done.
        """
        return pulumi.get(self, "failover_test_static_ip")

    @failover_test_static_ip.setter
    def failover_test_static_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "failover_test_static_ip", value)

    @_builtins.property
    @pulumi.getter(name="failoverTestSubnetName")
    def failover_test_subnet_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the subnet to use when a test failover is done.
        """
        return pulumi.get(self, "failover_test_subnet_name")

    @failover_test_subnet_name.setter
    def failover_test_subnet_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "failover_test_subnet_name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryLoadBalancerBackendAddressPoolIds")
    def recovery_load_balancer_backend_address_pool_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IDs of Load Balancer Backend Address Pools to use when a failover is done.
        """
        return pulumi.get(self, "recovery_load_balancer_backend_address_pool_ids")

    @recovery_load_balancer_backend_address_pool_ids.setter
    def recovery_load_balancer_backend_address_pool_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "recovery_load_balancer_backend_address_pool_ids", value)

    @_builtins.property
    @pulumi.getter(name="recoveryPublicIpAddressId")
    def recovery_public_ip_address_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the public IP object to use when a failover is done.
        """
        return pulumi.get(self, "recovery_public_ip_address_id")

    @recovery_public_ip_address_id.setter
    def recovery_public_ip_address_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_public_ip_address_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceNetworkInterfaceId")
    def source_network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Required if the network_interface block is specified) Id source network interface.
        """
        return pulumi.get(self, "source_network_interface_id")

    @source_network_interface_id.setter
    def source_network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="targetStaticIp")
    def target_static_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Static IP to assign when a failover is done.
        """
        return pulumi.get(self, "target_static_ip")

    @target_static_ip.setter
    def target_static_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_static_ip", value)

    @_builtins.property
    @pulumi.getter(name="targetSubnetName")
    def target_subnet_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the subnet to use when a failover is done.
        """
        return pulumi.get(self, "target_subnet_name")

    @target_subnet_name.setter
    def target_subnet_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_subnet_name", value)


if not MYPY:
    class ReplicatedVMUnmanagedDiskArgsDict(TypedDict):
        disk_uri: pulumi.Input[_builtins.str]
        """
        Id of disk that should be replicated. Changing this forces a new resource to be created.
        """
        staging_storage_account_id: pulumi.Input[_builtins.str]
        """
        Storage account that should be used for caching. Changing this forces a new resource to be created.
        """
        target_storage_account_id: pulumi.Input[_builtins.str]
        """
        Storage account disk should belong to when a failover is done. Changing this forces a new resource to be created.
        """
elif False:
    ReplicatedVMUnmanagedDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicatedVMUnmanagedDiskArgs:
    def __init__(__self__, *,
                 disk_uri: pulumi.Input[_builtins.str],
                 staging_storage_account_id: pulumi.Input[_builtins.str],
                 target_storage_account_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] disk_uri: Id of disk that should be replicated. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] staging_storage_account_id: Storage account that should be used for caching. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] target_storage_account_id: Storage account disk should belong to when a failover is done. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "disk_uri", disk_uri)
        pulumi.set(__self__, "staging_storage_account_id", staging_storage_account_id)
        pulumi.set(__self__, "target_storage_account_id", target_storage_account_id)

    @_builtins.property
    @pulumi.getter(name="diskUri")
    def disk_uri(self) -> pulumi.Input[_builtins.str]:
        """
        Id of disk that should be replicated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_uri")

    @disk_uri.setter
    def disk_uri(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "disk_uri", value)

    @_builtins.property
    @pulumi.getter(name="stagingStorageAccountId")
    def staging_storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Storage account that should be used for caching. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "staging_storage_account_id")

    @staging_storage_account_id.setter
    def staging_storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "staging_storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="targetStorageAccountId")
    def target_storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Storage account disk should belong to when a failover is done. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_storage_account_id")

    @target_storage_account_id.setter
    def target_storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_storage_account_id", value)


if not MYPY:
    class ReplicationRecoveryPlanAzureToAzureSettingsArgsDict(TypedDict):
        primary_edge_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Edge Zone within the Azure Region where the VM exists. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
        """
        primary_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Availability Zone in which the VM is located. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
        """
        recovery_edge_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Edge Zone within the Azure Region where the VM is recovered. Changing this forces a new Site Recovery Replication Recovery Plan to be created.

        > **Note:** `primary_edge_zone` and `recovery_edge_zone` must be specified together.
        """
        recovery_zone: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Availability Zone in which the VM is recovered. Changing this forces a new Site Recovery Replication Recovery Plan to be created.

        > **Note:** `primary_zone` and `recovery_zone` must be specified together.
        """
elif False:
    ReplicationRecoveryPlanAzureToAzureSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationRecoveryPlanAzureToAzureSettingsArgs:
    def __init__(__self__, *,
                 primary_edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] primary_edge_zone: The Edge Zone within the Azure Region where the VM exists. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
        :param pulumi.Input[_builtins.str] primary_zone: The Availability Zone in which the VM is located. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
        :param pulumi.Input[_builtins.str] recovery_edge_zone: The Edge Zone within the Azure Region where the VM is recovered. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
               
               > **Note:** `primary_edge_zone` and `recovery_edge_zone` must be specified together.
        :param pulumi.Input[_builtins.str] recovery_zone: The Availability Zone in which the VM is recovered. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
               
               > **Note:** `primary_zone` and `recovery_zone` must be specified together.
        """
        if primary_edge_zone is not None:
            pulumi.set(__self__, "primary_edge_zone", primary_edge_zone)
        if primary_zone is not None:
            pulumi.set(__self__, "primary_zone", primary_zone)
        if recovery_edge_zone is not None:
            pulumi.set(__self__, "recovery_edge_zone", recovery_edge_zone)
        if recovery_zone is not None:
            pulumi.set(__self__, "recovery_zone", recovery_zone)

    @_builtins.property
    @pulumi.getter(name="primaryEdgeZone")
    def primary_edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Edge Zone within the Azure Region where the VM exists. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
        """
        return pulumi.get(self, "primary_edge_zone")

    @primary_edge_zone.setter
    def primary_edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="primaryZone")
    def primary_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Availability Zone in which the VM is located. Changing this forces a new Site Recovery Replication Recovery Plan to be created.
        """
        return pulumi.get(self, "primary_zone")

    @primary_zone.setter
    def primary_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_zone", value)

    @_builtins.property
    @pulumi.getter(name="recoveryEdgeZone")
    def recovery_edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Edge Zone within the Azure Region where the VM is recovered. Changing this forces a new Site Recovery Replication Recovery Plan to be created.

        > **Note:** `primary_edge_zone` and `recovery_edge_zone` must be specified together.
        """
        return pulumi.get(self, "recovery_edge_zone")

    @recovery_edge_zone.setter
    def recovery_edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="recoveryZone")
    def recovery_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Availability Zone in which the VM is recovered. Changing this forces a new Site Recovery Replication Recovery Plan to be created.

        > **Note:** `primary_zone` and `recovery_zone` must be specified together.
        """
        return pulumi.get(self, "recovery_zone")

    @recovery_zone.setter
    def recovery_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_zone", value)


if not MYPY:
    class ReplicationRecoveryPlanBootRecoveryGroupArgsDict(TypedDict):
        post_actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupPostActionArgsDict']]]]
        """
        one or more `action` block as defined below. which will be executed after the group recovery.
        """
        pre_actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupPreActionArgsDict']]]]
        """
        one or more `action` block as defined below. which will be executed before the group recovery.
        """
        replicated_protected_items: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        One or more protected VM IDs.
        """
elif False:
    ReplicationRecoveryPlanBootRecoveryGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationRecoveryPlanBootRecoveryGroupArgs:
    def __init__(__self__, *,
                 post_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupPostActionArgs']]]] = None,
                 pre_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupPreActionArgs']]]] = None,
                 replicated_protected_items: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupPostActionArgs']]] post_actions: one or more `action` block as defined below. which will be executed after the group recovery.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupPreActionArgs']]] pre_actions: one or more `action` block as defined below. which will be executed before the group recovery.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] replicated_protected_items: One or more protected VM IDs.
        """
        if post_actions is not None:
            pulumi.set(__self__, "post_actions", post_actions)
        if pre_actions is not None:
            pulumi.set(__self__, "pre_actions", pre_actions)
        if replicated_protected_items is not None:
            pulumi.set(__self__, "replicated_protected_items", replicated_protected_items)

    @_builtins.property
    @pulumi.getter(name="postActions")
    def post_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupPostActionArgs']]]]:
        """
        one or more `action` block as defined below. which will be executed after the group recovery.
        """
        return pulumi.get(self, "post_actions")

    @post_actions.setter
    def post_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupPostActionArgs']]]]):
        pulumi.set(self, "post_actions", value)

    @_builtins.property
    @pulumi.getter(name="preActions")
    def pre_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupPreActionArgs']]]]:
        """
        one or more `action` block as defined below. which will be executed before the group recovery.
        """
        return pulumi.get(self, "pre_actions")

    @pre_actions.setter
    def pre_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanBootRecoveryGroupPreActionArgs']]]]):
        pulumi.set(self, "pre_actions", value)

    @_builtins.property
    @pulumi.getter(name="replicatedProtectedItems")
    def replicated_protected_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more protected VM IDs.
        """
        return pulumi.get(self, "replicated_protected_items")

    @replicated_protected_items.setter
    def replicated_protected_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "replicated_protected_items", value)


if not MYPY:
    class ReplicationRecoveryPlanBootRecoveryGroupPostActionArgsDict(TypedDict):
        fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        fabric_location: NotRequired[pulumi.Input[_builtins.str]]
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        manual_action_instruction: NotRequired[pulumi.Input[_builtins.str]]
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        runbook_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        script_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
elif False:
    ReplicationRecoveryPlanBootRecoveryGroupPostActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationRecoveryPlanBootRecoveryGroupPostActionArgs:
    def __init__(__self__, *,
                 fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 fabric_location: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_action_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 script_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param pulumi.Input[_builtins.str] name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param pulumi.Input[_builtins.str] runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param pulumi.Input[_builtins.str] script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @fail_over_directions.setter
    def fail_over_directions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_directions", value)

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @fail_over_types.setter
    def fail_over_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_types", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @fabric_location.setter
    def fabric_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fabric_location", value)

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @manual_action_instruction.setter
    def manual_action_instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manual_action_instruction", value)

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @runbook_id.setter
    def runbook_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runbook_id", value)

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_path", value)


if not MYPY:
    class ReplicationRecoveryPlanBootRecoveryGroupPreActionArgsDict(TypedDict):
        fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        fabric_location: NotRequired[pulumi.Input[_builtins.str]]
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        manual_action_instruction: NotRequired[pulumi.Input[_builtins.str]]
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        runbook_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        script_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
elif False:
    ReplicationRecoveryPlanBootRecoveryGroupPreActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationRecoveryPlanBootRecoveryGroupPreActionArgs:
    def __init__(__self__, *,
                 fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 fabric_location: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_action_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 script_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param pulumi.Input[_builtins.str] name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param pulumi.Input[_builtins.str] runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param pulumi.Input[_builtins.str] script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @fail_over_directions.setter
    def fail_over_directions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_directions", value)

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @fail_over_types.setter
    def fail_over_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_types", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @fabric_location.setter
    def fabric_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fabric_location", value)

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @manual_action_instruction.setter
    def manual_action_instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manual_action_instruction", value)

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @runbook_id.setter
    def runbook_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runbook_id", value)

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_path", value)


if not MYPY:
    class ReplicationRecoveryPlanFailoverRecoveryGroupArgsDict(TypedDict):
        post_actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupPostActionArgsDict']]]]
        """
        one or more `action` block as defined below. which will be executed after the group recovery.
        """
        pre_actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupPreActionArgsDict']]]]
        """
        one or more `action` block as defined below. which will be executed before the group recovery.
        """
elif False:
    ReplicationRecoveryPlanFailoverRecoveryGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationRecoveryPlanFailoverRecoveryGroupArgs:
    def __init__(__self__, *,
                 post_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupPostActionArgs']]]] = None,
                 pre_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupPreActionArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupPostActionArgs']]] post_actions: one or more `action` block as defined below. which will be executed after the group recovery.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupPreActionArgs']]] pre_actions: one or more `action` block as defined below. which will be executed before the group recovery.
        """
        if post_actions is not None:
            pulumi.set(__self__, "post_actions", post_actions)
        if pre_actions is not None:
            pulumi.set(__self__, "pre_actions", pre_actions)

    @_builtins.property
    @pulumi.getter(name="postActions")
    def post_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupPostActionArgs']]]]:
        """
        one or more `action` block as defined below. which will be executed after the group recovery.
        """
        return pulumi.get(self, "post_actions")

    @post_actions.setter
    def post_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupPostActionArgs']]]]):
        pulumi.set(self, "post_actions", value)

    @_builtins.property
    @pulumi.getter(name="preActions")
    def pre_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupPreActionArgs']]]]:
        """
        one or more `action` block as defined below. which will be executed before the group recovery.
        """
        return pulumi.get(self, "pre_actions")

    @pre_actions.setter
    def pre_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanFailoverRecoveryGroupPreActionArgs']]]]):
        pulumi.set(self, "pre_actions", value)


if not MYPY:
    class ReplicationRecoveryPlanFailoverRecoveryGroupPostActionArgsDict(TypedDict):
        fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        fabric_location: NotRequired[pulumi.Input[_builtins.str]]
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        manual_action_instruction: NotRequired[pulumi.Input[_builtins.str]]
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        runbook_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        script_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
elif False:
    ReplicationRecoveryPlanFailoverRecoveryGroupPostActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationRecoveryPlanFailoverRecoveryGroupPostActionArgs:
    def __init__(__self__, *,
                 fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 fabric_location: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_action_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 script_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param pulumi.Input[_builtins.str] name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param pulumi.Input[_builtins.str] runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param pulumi.Input[_builtins.str] script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @fail_over_directions.setter
    def fail_over_directions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_directions", value)

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @fail_over_types.setter
    def fail_over_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_types", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @fabric_location.setter
    def fabric_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fabric_location", value)

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @manual_action_instruction.setter
    def manual_action_instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manual_action_instruction", value)

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @runbook_id.setter
    def runbook_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runbook_id", value)

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_path", value)


if not MYPY:
    class ReplicationRecoveryPlanFailoverRecoveryGroupPreActionArgsDict(TypedDict):
        fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        fabric_location: NotRequired[pulumi.Input[_builtins.str]]
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        manual_action_instruction: NotRequired[pulumi.Input[_builtins.str]]
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        runbook_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        script_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
elif False:
    ReplicationRecoveryPlanFailoverRecoveryGroupPreActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationRecoveryPlanFailoverRecoveryGroupPreActionArgs:
    def __init__(__self__, *,
                 fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 fabric_location: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_action_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 script_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param pulumi.Input[_builtins.str] name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param pulumi.Input[_builtins.str] runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param pulumi.Input[_builtins.str] script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @fail_over_directions.setter
    def fail_over_directions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_directions", value)

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @fail_over_types.setter
    def fail_over_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_types", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @fabric_location.setter
    def fabric_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fabric_location", value)

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @manual_action_instruction.setter
    def manual_action_instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manual_action_instruction", value)

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @runbook_id.setter
    def runbook_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runbook_id", value)

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_path", value)


if not MYPY:
    class ReplicationRecoveryPlanShutdownRecoveryGroupArgsDict(TypedDict):
        post_actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupPostActionArgsDict']]]]
        """
        one or more `action` block as defined below. which will be executed after the group recovery.
        """
        pre_actions: NotRequired[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupPreActionArgsDict']]]]
        """
        one or more `action` block as defined below. which will be executed before the group recovery.
        """
elif False:
    ReplicationRecoveryPlanShutdownRecoveryGroupArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationRecoveryPlanShutdownRecoveryGroupArgs:
    def __init__(__self__, *,
                 post_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupPostActionArgs']]]] = None,
                 pre_actions: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupPreActionArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupPostActionArgs']]] post_actions: one or more `action` block as defined below. which will be executed after the group recovery.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupPreActionArgs']]] pre_actions: one or more `action` block as defined below. which will be executed before the group recovery.
        """
        if post_actions is not None:
            pulumi.set(__self__, "post_actions", post_actions)
        if pre_actions is not None:
            pulumi.set(__self__, "pre_actions", pre_actions)

    @_builtins.property
    @pulumi.getter(name="postActions")
    def post_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupPostActionArgs']]]]:
        """
        one or more `action` block as defined below. which will be executed after the group recovery.
        """
        return pulumi.get(self, "post_actions")

    @post_actions.setter
    def post_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupPostActionArgs']]]]):
        pulumi.set(self, "post_actions", value)

    @_builtins.property
    @pulumi.getter(name="preActions")
    def pre_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupPreActionArgs']]]]:
        """
        one or more `action` block as defined below. which will be executed before the group recovery.
        """
        return pulumi.get(self, "pre_actions")

    @pre_actions.setter
    def pre_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationRecoveryPlanShutdownRecoveryGroupPreActionArgs']]]]):
        pulumi.set(self, "pre_actions", value)


if not MYPY:
    class ReplicationRecoveryPlanShutdownRecoveryGroupPostActionArgsDict(TypedDict):
        fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        fabric_location: NotRequired[pulumi.Input[_builtins.str]]
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        manual_action_instruction: NotRequired[pulumi.Input[_builtins.str]]
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        runbook_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        script_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
elif False:
    ReplicationRecoveryPlanShutdownRecoveryGroupPostActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationRecoveryPlanShutdownRecoveryGroupPostActionArgs:
    def __init__(__self__, *,
                 fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 fabric_location: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_action_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 script_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param pulumi.Input[_builtins.str] name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param pulumi.Input[_builtins.str] runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param pulumi.Input[_builtins.str] script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @fail_over_directions.setter
    def fail_over_directions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_directions", value)

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @fail_over_types.setter
    def fail_over_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_types", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @fabric_location.setter
    def fabric_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fabric_location", value)

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @manual_action_instruction.setter
    def manual_action_instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manual_action_instruction", value)

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @runbook_id.setter
    def runbook_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runbook_id", value)

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_path", value)


if not MYPY:
    class ReplicationRecoveryPlanShutdownRecoveryGroupPreActionArgsDict(TypedDict):
        fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        type: pulumi.Input[_builtins.str]
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        fabric_location: NotRequired[pulumi.Input[_builtins.str]]
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        manual_action_instruction: NotRequired[pulumi.Input[_builtins.str]]
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        runbook_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        script_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
elif False:
    ReplicationRecoveryPlanShutdownRecoveryGroupPreActionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ReplicationRecoveryPlanShutdownRecoveryGroupPreActionArgs:
    def __init__(__self__, *,
                 fail_over_directions: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 fail_over_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 fabric_location: Optional[pulumi.Input[_builtins.str]] = None,
                 manual_action_instruction: Optional[pulumi.Input[_builtins.str]] = None,
                 runbook_id: Optional[pulumi.Input[_builtins.str]] = None,
                 script_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_directions: Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fail_over_types: Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        :param pulumi.Input[_builtins.str] name: The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] fabric_location: The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.
               
               > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        :param pulumi.Input[_builtins.str] manual_action_instruction: Instructions of manual action.
               
               > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        :param pulumi.Input[_builtins.str] runbook_id: Id of runbook.
               
               > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        :param pulumi.Input[_builtins.str] script_path: Path of action script.
               
               > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        pulumi.set(__self__, "fail_over_directions", fail_over_directions)
        pulumi.set(__self__, "fail_over_types", fail_over_types)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if fabric_location is not None:
            pulumi.set(__self__, "fabric_location", fabric_location)
        if manual_action_instruction is not None:
            pulumi.set(__self__, "manual_action_instruction", manual_action_instruction)
        if runbook_id is not None:
            pulumi.set(__self__, "runbook_id", runbook_id)
        if script_path is not None:
            pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="failOverDirections")
    def fail_over_directions(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Directions of fail over. Possible values are `PrimaryToRecovery` and `RecoveryToPrimary`
        """
        return pulumi.get(self, "fail_over_directions")

    @fail_over_directions.setter
    def fail_over_directions(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_directions", value)

    @_builtins.property
    @pulumi.getter(name="failOverTypes")
    def fail_over_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Types of fail over. Possible values are `TestFailover`, `PlannedFailover` and `UnplannedFailover`
        """
        return pulumi.get(self, "fail_over_types")

    @fail_over_types.setter
    def fail_over_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "fail_over_types", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Replication Plan. The name can contain only letters, numbers, and hyphens. It should start with a letter and end with a letter or a number. Can be a maximum of 63 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of the action detail. Possible values are `AutomationRunbookActionDetails`, `ManualActionDetails` and `ScriptActionDetails`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="fabricLocation")
    def fabric_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fabric location of runbook or script. Possible values are `Primary` and `Recovery`. It must not be specified when `type` is `ManualActionDetails`.

        > **Note:** This is required when `type` is set to `AutomationRunbookActionDetails` or `ScriptActionDetails`.
        """
        return pulumi.get(self, "fabric_location")

    @fabric_location.setter
    def fabric_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fabric_location", value)

    @_builtins.property
    @pulumi.getter(name="manualActionInstruction")
    def manual_action_instruction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Instructions of manual action.

        > **Note:** This property is required when `type` is set to `ManualActionDetails`.
        """
        return pulumi.get(self, "manual_action_instruction")

    @manual_action_instruction.setter
    def manual_action_instruction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manual_action_instruction", value)

    @_builtins.property
    @pulumi.getter(name="runbookId")
    def runbook_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of runbook.

        > **Note:** This property is required when `type` is set to `AutomationRunbookActionDetails`.
        """
        return pulumi.get(self, "runbook_id")

    @runbook_id.setter
    def runbook_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "runbook_id", value)

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Path of action script.

        > **Note:** This property is required when `type` is set to `ScriptActionDetails`.
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_path", value)


if not MYPY:
    class VmwareReplicatedVmManagedDiskArgsDict(TypedDict):
        disk_id: pulumi.Input[_builtins.str]
        """
        The ID of the disk to be replicated.
        """
        target_disk_type: pulumi.Input[_builtins.str]
        """
        The disk type of the disk to be created when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.
        """
        log_storage_account_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the storage account that should be used for logging during replication.
        """
        target_disk_encryption_set_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Disk Encryption Set that should be used for the disks when a failover is done.
        """
elif False:
    VmwareReplicatedVmManagedDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VmwareReplicatedVmManagedDiskArgs:
    def __init__(__self__, *,
                 disk_id: pulumi.Input[_builtins.str],
                 target_disk_type: pulumi.Input[_builtins.str],
                 log_storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] disk_id: The ID of the disk to be replicated.
        :param pulumi.Input[_builtins.str] target_disk_type: The disk type of the disk to be created when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.
        :param pulumi.Input[_builtins.str] log_storage_account_id: The ID of the storage account that should be used for logging during replication.
        :param pulumi.Input[_builtins.str] target_disk_encryption_set_id: The ID of the Disk Encryption Set that should be used for the disks when a failover is done.
        """
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "target_disk_type", target_disk_type)
        if log_storage_account_id is not None:
            pulumi.set(__self__, "log_storage_account_id", log_storage_account_id)
        if target_disk_encryption_set_id is not None:
            pulumi.set(__self__, "target_disk_encryption_set_id", target_disk_encryption_set_id)

    @_builtins.property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the disk to be replicated.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "disk_id", value)

    @_builtins.property
    @pulumi.getter(name="targetDiskType")
    def target_disk_type(self) -> pulumi.Input[_builtins.str]:
        """
        The disk type of the disk to be created when a failover is done. Possible values are `Premium_LRS`, `Standard_LRS` and `StandardSSD_LRS`.
        """
        return pulumi.get(self, "target_disk_type")

    @target_disk_type.setter
    def target_disk_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_disk_type", value)

    @_builtins.property
    @pulumi.getter(name="logStorageAccountId")
    def log_storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the storage account that should be used for logging during replication.
        """
        return pulumi.get(self, "log_storage_account_id")

    @log_storage_account_id.setter
    def log_storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "log_storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="targetDiskEncryptionSetId")
    def target_disk_encryption_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Disk Encryption Set that should be used for the disks when a failover is done.
        """
        return pulumi.get(self, "target_disk_encryption_set_id")

    @target_disk_encryption_set_id.setter
    def target_disk_encryption_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_disk_encryption_set_id", value)


if not MYPY:
    class VmwareReplicatedVmNetworkInterfaceArgsDict(TypedDict):
        is_primary: pulumi.Input[_builtins.bool]
        """
        Whether this `network_interface` is primary for the replicated VM.
        """
        source_mac_address: pulumi.Input[_builtins.str]
        """
        Mac address of the network interface of source VM.
        """
        target_static_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        Static IP to assign when a failover is done.
        """
        target_subnet_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the subnet to use when a failover is done.
        """
        test_subnet_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the subnet to use when a test failover is done.
        """
elif False:
    VmwareReplicatedVmNetworkInterfaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class VmwareReplicatedVmNetworkInterfaceArgs:
    def __init__(__self__, *,
                 is_primary: pulumi.Input[_builtins.bool],
                 source_mac_address: pulumi.Input[_builtins.str],
                 target_static_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 target_subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 test_subnet_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] is_primary: Whether this `network_interface` is primary for the replicated VM.
        :param pulumi.Input[_builtins.str] source_mac_address: Mac address of the network interface of source VM.
        :param pulumi.Input[_builtins.str] target_static_ip: Static IP to assign when a failover is done.
        :param pulumi.Input[_builtins.str] target_subnet_name: Name of the subnet to use when a failover is done.
        :param pulumi.Input[_builtins.str] test_subnet_name: Name of the subnet to use when a test failover is done.
        """
        pulumi.set(__self__, "is_primary", is_primary)
        pulumi.set(__self__, "source_mac_address", source_mac_address)
        if target_static_ip is not None:
            pulumi.set(__self__, "target_static_ip", target_static_ip)
        if target_subnet_name is not None:
            pulumi.set(__self__, "target_subnet_name", target_subnet_name)
        if test_subnet_name is not None:
            pulumi.set(__self__, "test_subnet_name", test_subnet_name)

    @_builtins.property
    @pulumi.getter(name="isPrimary")
    def is_primary(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether this `network_interface` is primary for the replicated VM.
        """
        return pulumi.get(self, "is_primary")

    @is_primary.setter
    def is_primary(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "is_primary", value)

    @_builtins.property
    @pulumi.getter(name="sourceMacAddress")
    def source_mac_address(self) -> pulumi.Input[_builtins.str]:
        """
        Mac address of the network interface of source VM.
        """
        return pulumi.get(self, "source_mac_address")

    @source_mac_address.setter
    def source_mac_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_mac_address", value)

    @_builtins.property
    @pulumi.getter(name="targetStaticIp")
    def target_static_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Static IP to assign when a failover is done.
        """
        return pulumi.get(self, "target_static_ip")

    @target_static_ip.setter
    def target_static_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_static_ip", value)

    @_builtins.property
    @pulumi.getter(name="targetSubnetName")
    def target_subnet_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the subnet to use when a failover is done.
        """
        return pulumi.get(self, "target_subnet_name")

    @target_subnet_name.setter
    def target_subnet_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_subnet_name", value)

    @_builtins.property
    @pulumi.getter(name="testSubnetName")
    def test_subnet_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the subnet to use when a test failover is done.
        """
        return pulumi.get(self, "test_subnet_name")

    @test_subnet_name.setter
    def test_subnet_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "test_subnet_name", value)


