# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HyperVReplicationPolicyArgs', 'HyperVReplicationPolicy']

@pulumi.input_type
class HyperVReplicationPolicyArgs:
    def __init__(__self__, *,
                 application_consistent_snapshot_frequency_in_hours: pulumi.Input[_builtins.int],
                 recovery_point_retention_in_hours: pulumi.Input[_builtins.int],
                 recovery_vault_id: pulumi.Input[_builtins.str],
                 replication_interval_in_seconds: pulumi.Input[_builtins.int],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HyperVReplicationPolicy resource.
        :param pulumi.Input[_builtins.int] application_consistent_snapshot_frequency_in_hours: Specifies the frequency at which to create application consistent recovery points.
        :param pulumi.Input[_builtins.int] recovery_point_retention_in_hours: The duration in hours for which the recovery points need to be stored.
        :param pulumi.Input[_builtins.str] recovery_vault_id: The id of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] replication_interval_in_seconds: Specifies how frequently data should be synchronized between source and target locations. Possible values are `30` and `300`.
        :param pulumi.Input[_builtins.str] name: The name of the replication policy. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "application_consistent_snapshot_frequency_in_hours", application_consistent_snapshot_frequency_in_hours)
        pulumi.set(__self__, "recovery_point_retention_in_hours", recovery_point_retention_in_hours)
        pulumi.set(__self__, "recovery_vault_id", recovery_vault_id)
        pulumi.set(__self__, "replication_interval_in_seconds", replication_interval_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="applicationConsistentSnapshotFrequencyInHours")
    def application_consistent_snapshot_frequency_in_hours(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the frequency at which to create application consistent recovery points.
        """
        return pulumi.get(self, "application_consistent_snapshot_frequency_in_hours")

    @application_consistent_snapshot_frequency_in_hours.setter
    def application_consistent_snapshot_frequency_in_hours(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "application_consistent_snapshot_frequency_in_hours", value)

    @_builtins.property
    @pulumi.getter(name="recoveryPointRetentionInHours")
    def recovery_point_retention_in_hours(self) -> pulumi.Input[_builtins.int]:
        """
        The duration in hours for which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_retention_in_hours")

    @recovery_point_retention_in_hours.setter
    def recovery_point_retention_in_hours(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "recovery_point_retention_in_hours", value)

    @_builtins.property
    @pulumi.getter(name="recoveryVaultId")
    def recovery_vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_id")

    @recovery_vault_id.setter
    def recovery_vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recovery_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="replicationIntervalInSeconds")
    def replication_interval_in_seconds(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies how frequently data should be synchronized between source and target locations. Possible values are `30` and `300`.
        """
        return pulumi.get(self, "replication_interval_in_seconds")

    @replication_interval_in_seconds.setter
    def replication_interval_in_seconds(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "replication_interval_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the replication policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _HyperVReplicationPolicyState:
    def __init__(__self__, *,
                 application_consistent_snapshot_frequency_in_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_retention_in_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 recovery_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering HyperVReplicationPolicy resources.
        :param pulumi.Input[_builtins.int] application_consistent_snapshot_frequency_in_hours: Specifies the frequency at which to create application consistent recovery points.
        :param pulumi.Input[_builtins.str] name: The name of the replication policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] recovery_point_retention_in_hours: The duration in hours for which the recovery points need to be stored.
        :param pulumi.Input[_builtins.str] recovery_vault_id: The id of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] replication_interval_in_seconds: Specifies how frequently data should be synchronized between source and target locations. Possible values are `30` and `300`.
        """
        if application_consistent_snapshot_frequency_in_hours is not None:
            pulumi.set(__self__, "application_consistent_snapshot_frequency_in_hours", application_consistent_snapshot_frequency_in_hours)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recovery_point_retention_in_hours is not None:
            pulumi.set(__self__, "recovery_point_retention_in_hours", recovery_point_retention_in_hours)
        if recovery_vault_id is not None:
            pulumi.set(__self__, "recovery_vault_id", recovery_vault_id)
        if replication_interval_in_seconds is not None:
            pulumi.set(__self__, "replication_interval_in_seconds", replication_interval_in_seconds)

    @_builtins.property
    @pulumi.getter(name="applicationConsistentSnapshotFrequencyInHours")
    def application_consistent_snapshot_frequency_in_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the frequency at which to create application consistent recovery points.
        """
        return pulumi.get(self, "application_consistent_snapshot_frequency_in_hours")

    @application_consistent_snapshot_frequency_in_hours.setter
    def application_consistent_snapshot_frequency_in_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "application_consistent_snapshot_frequency_in_hours", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the replication policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryPointRetentionInHours")
    def recovery_point_retention_in_hours(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration in hours for which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_retention_in_hours")

    @recovery_point_retention_in_hours.setter
    def recovery_point_retention_in_hours(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "recovery_point_retention_in_hours", value)

    @_builtins.property
    @pulumi.getter(name="recoveryVaultId")
    def recovery_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_id")

    @recovery_vault_id.setter
    def recovery_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="replicationIntervalInSeconds")
    def replication_interval_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how frequently data should be synchronized between source and target locations. Possible values are `30` and `300`.
        """
        return pulumi.get(self, "replication_interval_in_seconds")

    @replication_interval_in_seconds.setter
    def replication_interval_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replication_interval_in_seconds", value)


@pulumi.type_token("azure:siterecovery/hyperVReplicationPolicy:HyperVReplicationPolicy")
class HyperVReplicationPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_consistent_snapshot_frequency_in_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_retention_in_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 recovery_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Azure Site Recovery replication policy for HyperV within a Recovery Vault. Replication policies define the frequency at which recovery points are created and how long they are stored.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="East US")
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        policy = azure.siterecovery.HyperVReplicationPolicy("policy",
            name="policy",
            recovery_vault_id=vault.id,
            recovery_point_retention_in_hours=2,
            application_consistent_snapshot_frequency_in_hours=1,
            replication_interval_in_seconds=300)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-04-01

        ## Import

        Site Recovery Replication Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/hyperVReplicationPolicy:HyperVReplicationPolicy mypolicy /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/replicationPolicies/policy-name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] application_consistent_snapshot_frequency_in_hours: Specifies the frequency at which to create application consistent recovery points.
        :param pulumi.Input[_builtins.str] name: The name of the replication policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] recovery_point_retention_in_hours: The duration in hours for which the recovery points need to be stored.
        :param pulumi.Input[_builtins.str] recovery_vault_id: The id of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] replication_interval_in_seconds: Specifies how frequently data should be synchronized between source and target locations. Possible values are `30` and `300`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HyperVReplicationPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Azure Site Recovery replication policy for HyperV within a Recovery Vault. Replication policies define the frequency at which recovery points are created and how long they are stored.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="East US")
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        policy = azure.siterecovery.HyperVReplicationPolicy("policy",
            name="policy",
            recovery_vault_id=vault.id,
            recovery_point_retention_in_hours=2,
            application_consistent_snapshot_frequency_in_hours=1,
            replication_interval_in_seconds=300)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-04-01

        ## Import

        Site Recovery Replication Policies can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/hyperVReplicationPolicy:HyperVReplicationPolicy mypolicy /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/replicationPolicies/policy-name
        ```

        :param str resource_name: The name of the resource.
        :param HyperVReplicationPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HyperVReplicationPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_consistent_snapshot_frequency_in_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_point_retention_in_hours: Optional[pulumi.Input[_builtins.int]] = None,
                 recovery_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HyperVReplicationPolicyArgs.__new__(HyperVReplicationPolicyArgs)

            if application_consistent_snapshot_frequency_in_hours is None and not opts.urn:
                raise TypeError("Missing required property 'application_consistent_snapshot_frequency_in_hours'")
            __props__.__dict__["application_consistent_snapshot_frequency_in_hours"] = application_consistent_snapshot_frequency_in_hours
            __props__.__dict__["name"] = name
            if recovery_point_retention_in_hours is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_point_retention_in_hours'")
            __props__.__dict__["recovery_point_retention_in_hours"] = recovery_point_retention_in_hours
            if recovery_vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_vault_id'")
            __props__.__dict__["recovery_vault_id"] = recovery_vault_id
            if replication_interval_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'replication_interval_in_seconds'")
            __props__.__dict__["replication_interval_in_seconds"] = replication_interval_in_seconds
        super(HyperVReplicationPolicy, __self__).__init__(
            'azure:siterecovery/hyperVReplicationPolicy:HyperVReplicationPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_consistent_snapshot_frequency_in_hours: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_point_retention_in_hours: Optional[pulumi.Input[_builtins.int]] = None,
            recovery_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            replication_interval_in_seconds: Optional[pulumi.Input[_builtins.int]] = None) -> 'HyperVReplicationPolicy':
        """
        Get an existing HyperVReplicationPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] application_consistent_snapshot_frequency_in_hours: Specifies the frequency at which to create application consistent recovery points.
        :param pulumi.Input[_builtins.str] name: The name of the replication policy. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] recovery_point_retention_in_hours: The duration in hours for which the recovery points need to be stored.
        :param pulumi.Input[_builtins.str] recovery_vault_id: The id of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] replication_interval_in_seconds: Specifies how frequently data should be synchronized between source and target locations. Possible values are `30` and `300`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HyperVReplicationPolicyState.__new__(_HyperVReplicationPolicyState)

        __props__.__dict__["application_consistent_snapshot_frequency_in_hours"] = application_consistent_snapshot_frequency_in_hours
        __props__.__dict__["name"] = name
        __props__.__dict__["recovery_point_retention_in_hours"] = recovery_point_retention_in_hours
        __props__.__dict__["recovery_vault_id"] = recovery_vault_id
        __props__.__dict__["replication_interval_in_seconds"] = replication_interval_in_seconds
        return HyperVReplicationPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationConsistentSnapshotFrequencyInHours")
    def application_consistent_snapshot_frequency_in_hours(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the frequency at which to create application consistent recovery points.
        """
        return pulumi.get(self, "application_consistent_snapshot_frequency_in_hours")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the replication policy. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recoveryPointRetentionInHours")
    def recovery_point_retention_in_hours(self) -> pulumi.Output[_builtins.int]:
        """
        The duration in hours for which the recovery points need to be stored.
        """
        return pulumi.get(self, "recovery_point_retention_in_hours")

    @_builtins.property
    @pulumi.getter(name="recoveryVaultId")
    def recovery_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_id")

    @_builtins.property
    @pulumi.getter(name="replicationIntervalInSeconds")
    def replication_interval_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies how frequently data should be synchronized between source and target locations. Possible values are `30` and `300`.
        """
        return pulumi.get(self, "replication_interval_in_seconds")

