# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProtectionContainerMappingArgs', 'ProtectionContainerMapping']

@pulumi.input_type
class ProtectionContainerMappingArgs:
    def __init__(__self__, *,
                 recovery_fabric_name: pulumi.Input[_builtins.str],
                 recovery_replication_policy_id: pulumi.Input[_builtins.str],
                 recovery_source_protection_container_name: pulumi.Input[_builtins.str],
                 recovery_target_protection_container_id: pulumi.Input[_builtins.str],
                 recovery_vault_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 automatic_update: Optional[pulumi.Input['ProtectionContainerMappingAutomaticUpdateArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ProtectionContainerMapping resource.
        :param pulumi.Input[_builtins.str] recovery_fabric_name: Name of fabric that should contains the protection container to map. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_replication_policy_id: Id of the policy to use for this mapping. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_source_protection_container_name: Name of the source protection container to map. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_target_protection_container_id: Id of target protection container to map to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        :param pulumi.Input['ProtectionContainerMappingAutomaticUpdateArgs'] automatic_update: a `automatic_update` block defined as below.
        :param pulumi.Input[_builtins.str] name: The name of the protection container mapping. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "recovery_fabric_name", recovery_fabric_name)
        pulumi.set(__self__, "recovery_replication_policy_id", recovery_replication_policy_id)
        pulumi.set(__self__, "recovery_source_protection_container_name", recovery_source_protection_container_name)
        pulumi.set(__self__, "recovery_target_protection_container_id", recovery_target_protection_container_id)
        pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if automatic_update is not None:
            pulumi.set(__self__, "automatic_update", automatic_update)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="recoveryFabricName")
    def recovery_fabric_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of fabric that should contains the protection container to map. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_fabric_name")

    @recovery_fabric_name.setter
    def recovery_fabric_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recovery_fabric_name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryReplicationPolicyId")
    def recovery_replication_policy_id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of the policy to use for this mapping. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_replication_policy_id")

    @recovery_replication_policy_id.setter
    def recovery_replication_policy_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recovery_replication_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="recoverySourceProtectionContainerName")
    def recovery_source_protection_container_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the source protection container to map. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_source_protection_container_name")

    @recovery_source_protection_container_name.setter
    def recovery_source_protection_container_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recovery_source_protection_container_name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryTargetProtectionContainerId")
    def recovery_target_protection_container_id(self) -> pulumi.Input[_builtins.str]:
        """
        Id of target protection container to map to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_target_protection_container_id")

    @recovery_target_protection_container_id.setter
    def recovery_target_protection_container_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recovery_target_protection_container_id", value)

    @_builtins.property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "recovery_vault_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="automaticUpdate")
    def automatic_update(self) -> Optional[pulumi.Input['ProtectionContainerMappingAutomaticUpdateArgs']]:
        """
        a `automatic_update` block defined as below.
        """
        return pulumi.get(self, "automatic_update")

    @automatic_update.setter
    def automatic_update(self, value: Optional[pulumi.Input['ProtectionContainerMappingAutomaticUpdateArgs']]):
        pulumi.set(self, "automatic_update", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the protection container mapping. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ProtectionContainerMappingState:
    def __init__(__self__, *,
                 automatic_update: Optional[pulumi.Input['ProtectionContainerMappingAutomaticUpdateArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_fabric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_replication_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_source_protection_container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_target_protection_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProtectionContainerMapping resources.
        :param pulumi.Input['ProtectionContainerMappingAutomaticUpdateArgs'] automatic_update: a `automatic_update` block defined as below.
        :param pulumi.Input[_builtins.str] name: The name of the protection container mapping. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_fabric_name: Name of fabric that should contains the protection container to map. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_replication_policy_id: Id of the policy to use for this mapping. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_source_protection_container_name: Name of the source protection container to map. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_target_protection_container_id: Id of target protection container to map to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        if automatic_update is not None:
            pulumi.set(__self__, "automatic_update", automatic_update)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if recovery_fabric_name is not None:
            pulumi.set(__self__, "recovery_fabric_name", recovery_fabric_name)
        if recovery_replication_policy_id is not None:
            pulumi.set(__self__, "recovery_replication_policy_id", recovery_replication_policy_id)
        if recovery_source_protection_container_name is not None:
            pulumi.set(__self__, "recovery_source_protection_container_name", recovery_source_protection_container_name)
        if recovery_target_protection_container_id is not None:
            pulumi.set(__self__, "recovery_target_protection_container_id", recovery_target_protection_container_id)
        if recovery_vault_name is not None:
            pulumi.set(__self__, "recovery_vault_name", recovery_vault_name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="automaticUpdate")
    def automatic_update(self) -> Optional[pulumi.Input['ProtectionContainerMappingAutomaticUpdateArgs']]:
        """
        a `automatic_update` block defined as below.
        """
        return pulumi.get(self, "automatic_update")

    @automatic_update.setter
    def automatic_update(self, value: Optional[pulumi.Input['ProtectionContainerMappingAutomaticUpdateArgs']]):
        pulumi.set(self, "automatic_update", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the protection container mapping. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryFabricName")
    def recovery_fabric_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of fabric that should contains the protection container to map. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_fabric_name")

    @recovery_fabric_name.setter
    def recovery_fabric_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_fabric_name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryReplicationPolicyId")
    def recovery_replication_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of the policy to use for this mapping. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_replication_policy_id")

    @recovery_replication_policy_id.setter
    def recovery_replication_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_replication_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="recoverySourceProtectionContainerName")
    def recovery_source_protection_container_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the source protection container to map. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_source_protection_container_name")

    @recovery_source_protection_container_name.setter
    def recovery_source_protection_container_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_source_protection_container_name", value)

    @_builtins.property
    @pulumi.getter(name="recoveryTargetProtectionContainerId")
    def recovery_target_protection_container_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Id of target protection container to map to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_target_protection_container_id")

    @recovery_target_protection_container_id.setter
    def recovery_target_protection_container_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_target_protection_container_id", value)

    @_builtins.property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @recovery_vault_name.setter
    def recovery_vault_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "recovery_vault_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:siterecovery/protectionContainerMapping:ProtectionContainerMapping")
class ProtectionContainerMapping(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_update: Optional[pulumi.Input[Union['ProtectionContainerMappingAutomaticUpdateArgs', 'ProtectionContainerMappingAutomaticUpdateArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_fabric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_replication_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_source_protection_container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_target_protection_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Azure recovery vault protection container mapping. A protection container mapping decides how to translate the protection container when a VM is migrated from one region to another.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.ResourceGroup("primary",
            name="tfex-network-mapping-primary",
            location="West US")
        secondary = azure.core.ResourceGroup("secondary",
            name="tfex-network-mapping-secondary",
            location="East US")
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Standard")
        primary_fabric = azure.siterecovery.Fabric("primary",
            name="primary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=primary.location)
        secondary_fabric = azure.siterecovery.Fabric("secondary",
            name="secondary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=secondary.location)
        primary_protection_container = azure.siterecovery.ProtectionContainer("primary",
            name="primary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name)
        secondary_protection_container = azure.siterecovery.ProtectionContainer("secondary",
            name="secondary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=secondary_fabric.name)
        policy = azure.siterecovery.ReplicationPolicy("policy",
            name="policy",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_point_retention_in_minutes=24 * 60,
            application_consistent_snapshot_frequency_in_minutes=4 * 60)
        container_mapping = azure.siterecovery.ProtectionContainerMapping("container-mapping",
            name="container-mapping",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name,
            recovery_source_protection_container_name=primary_protection_container.name,
            recovery_target_protection_container_id=secondary_protection_container.id,
            recovery_replication_policy_id=policy.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-04-01

        ## Import

        Site Recovery Protection Container Mappings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/protectionContainerMapping:ProtectionContainerMapping mymapping /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/replicationFabrics/fabric1/replicationProtectionContainers/container1/replicationProtectionContainerMappings/mapping1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProtectionContainerMappingAutomaticUpdateArgs', 'ProtectionContainerMappingAutomaticUpdateArgsDict']] automatic_update: a `automatic_update` block defined as below.
        :param pulumi.Input[_builtins.str] name: The name of the protection container mapping. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_fabric_name: Name of fabric that should contains the protection container to map. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_replication_policy_id: Id of the policy to use for this mapping. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_source_protection_container_name: Name of the source protection container to map. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_target_protection_container_id: Id of target protection container to map to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProtectionContainerMappingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Azure recovery vault protection container mapping. A protection container mapping decides how to translate the protection container when a VM is migrated from one region to another.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        primary = azure.core.ResourceGroup("primary",
            name="tfex-network-mapping-primary",
            location="West US")
        secondary = azure.core.ResourceGroup("secondary",
            name="tfex-network-mapping-secondary",
            location="East US")
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=secondary.location,
            resource_group_name=secondary.name,
            sku="Standard")
        primary_fabric = azure.siterecovery.Fabric("primary",
            name="primary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=primary.location)
        secondary_fabric = azure.siterecovery.Fabric("secondary",
            name="secondary-fabric",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            location=secondary.location)
        primary_protection_container = azure.siterecovery.ProtectionContainer("primary",
            name="primary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name)
        secondary_protection_container = azure.siterecovery.ProtectionContainer("secondary",
            name="secondary-protection-container",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=secondary_fabric.name)
        policy = azure.siterecovery.ReplicationPolicy("policy",
            name="policy",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_point_retention_in_minutes=24 * 60,
            application_consistent_snapshot_frequency_in_minutes=4 * 60)
        container_mapping = azure.siterecovery.ProtectionContainerMapping("container-mapping",
            name="container-mapping",
            resource_group_name=secondary.name,
            recovery_vault_name=vault.name,
            recovery_fabric_name=primary_fabric.name,
            recovery_source_protection_container_name=primary_protection_container.name,
            recovery_target_protection_container_id=secondary_protection_container.id,
            recovery_replication_policy_id=policy.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices`: 2024-04-01

        ## Import

        Site Recovery Protection Container Mappings can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:siterecovery/protectionContainerMapping:ProtectionContainerMapping mymapping /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resource-group-name/providers/Microsoft.RecoveryServices/vaults/recovery-vault-name/replicationFabrics/fabric1/replicationProtectionContainers/container1/replicationProtectionContainerMappings/mapping1
        ```

        :param str resource_name: The name of the resource.
        :param ProtectionContainerMappingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProtectionContainerMappingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automatic_update: Optional[pulumi.Input[Union['ProtectionContainerMappingAutomaticUpdateArgs', 'ProtectionContainerMappingAutomaticUpdateArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_fabric_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_replication_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_source_protection_container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_target_protection_container_id: Optional[pulumi.Input[_builtins.str]] = None,
                 recovery_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProtectionContainerMappingArgs.__new__(ProtectionContainerMappingArgs)

            __props__.__dict__["automatic_update"] = automatic_update
            __props__.__dict__["name"] = name
            if recovery_fabric_name is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_fabric_name'")
            __props__.__dict__["recovery_fabric_name"] = recovery_fabric_name
            if recovery_replication_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_replication_policy_id'")
            __props__.__dict__["recovery_replication_policy_id"] = recovery_replication_policy_id
            if recovery_source_protection_container_name is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_source_protection_container_name'")
            __props__.__dict__["recovery_source_protection_container_name"] = recovery_source_protection_container_name
            if recovery_target_protection_container_id is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_target_protection_container_id'")
            __props__.__dict__["recovery_target_protection_container_id"] = recovery_target_protection_container_id
            if recovery_vault_name is None and not opts.urn:
                raise TypeError("Missing required property 'recovery_vault_name'")
            __props__.__dict__["recovery_vault_name"] = recovery_vault_name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        super(ProtectionContainerMapping, __self__).__init__(
            'azure:siterecovery/protectionContainerMapping:ProtectionContainerMapping',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automatic_update: Optional[pulumi.Input[Union['ProtectionContainerMappingAutomaticUpdateArgs', 'ProtectionContainerMappingAutomaticUpdateArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_fabric_name: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_replication_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_source_protection_container_name: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_target_protection_container_id: Optional[pulumi.Input[_builtins.str]] = None,
            recovery_vault_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'ProtectionContainerMapping':
        """
        Get an existing ProtectionContainerMapping resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ProtectionContainerMappingAutomaticUpdateArgs', 'ProtectionContainerMappingAutomaticUpdateArgsDict']] automatic_update: a `automatic_update` block defined as below.
        :param pulumi.Input[_builtins.str] name: The name of the protection container mapping. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_fabric_name: Name of fabric that should contains the protection container to map. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_replication_policy_id: Id of the policy to use for this mapping. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_source_protection_container_name: Name of the source protection container to map. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_target_protection_container_id: Id of target protection container to map to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] recovery_vault_name: The name of the vault that should be updated. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProtectionContainerMappingState.__new__(_ProtectionContainerMappingState)

        __props__.__dict__["automatic_update"] = automatic_update
        __props__.__dict__["name"] = name
        __props__.__dict__["recovery_fabric_name"] = recovery_fabric_name
        __props__.__dict__["recovery_replication_policy_id"] = recovery_replication_policy_id
        __props__.__dict__["recovery_source_protection_container_name"] = recovery_source_protection_container_name
        __props__.__dict__["recovery_target_protection_container_id"] = recovery_target_protection_container_id
        __props__.__dict__["recovery_vault_name"] = recovery_vault_name
        __props__.__dict__["resource_group_name"] = resource_group_name
        return ProtectionContainerMapping(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automaticUpdate")
    def automatic_update(self) -> pulumi.Output['outputs.ProtectionContainerMappingAutomaticUpdate']:
        """
        a `automatic_update` block defined as below.
        """
        return pulumi.get(self, "automatic_update")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the protection container mapping. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="recoveryFabricName")
    def recovery_fabric_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of fabric that should contains the protection container to map. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_fabric_name")

    @_builtins.property
    @pulumi.getter(name="recoveryReplicationPolicyId")
    def recovery_replication_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of the policy to use for this mapping. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_replication_policy_id")

    @_builtins.property
    @pulumi.getter(name="recoverySourceProtectionContainerName")
    def recovery_source_protection_container_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the source protection container to map. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_source_protection_container_name")

    @_builtins.property
    @pulumi.getter(name="recoveryTargetProtectionContainerId")
    def recovery_target_protection_container_id(self) -> pulumi.Output[_builtins.str]:
        """
        Id of target protection container to map to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_target_protection_container_id")

    @_builtins.property
    @pulumi.getter(name="recoveryVaultName")
    def recovery_vault_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the vault that should be updated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "recovery_vault_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the resource group where the vault that should be updated is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

