# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetHciStoragePathResult',
    'AwaitableGetHciStoragePathResult',
    'get_hci_storage_path',
    'get_hci_storage_path_output',
]

@pulumi.output_type
class GetHciStoragePathResult:
    """
    A collection of values returned by getHciStoragePath.
    """
    def __init__(__self__, custom_location_id=None, id=None, location=None, name=None, path=None, resource_group_name=None, tags=None):
        if custom_location_id and not isinstance(custom_location_id, str):
            raise TypeError("Expected argument 'custom_location_id' to be a str")
        pulumi.set(__self__, "custom_location_id", custom_location_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> _builtins.str:
        """
        The ID of the Custom Location where the Stack HCI Storage Path exists.
        """
        return pulumi.get(self, "custom_location_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Stack HCI Storage Path exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The file path on the disk where the Stack HCI Storage Path was created.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Stack HCI Storage Path.
        """
        return pulumi.get(self, "tags")


class AwaitableGetHciStoragePathResult(GetHciStoragePathResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHciStoragePathResult(
            custom_location_id=self.custom_location_id,
            id=self.id,
            location=self.location,
            name=self.name,
            path=self.path,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_hci_storage_path(name: Optional[_builtins.str] = None,
                         resource_group_name: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHciStoragePathResult:
    """
    Use this data source to access information about an existing Stack HCI Storage Path.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.stack.get_hci_storage_path(name="example-hci-storage-path-name",
        resource_group_name="example-rg")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.AzureStackHCI`: 2024-01-01


    :param _builtins.str name: The name of this Stack HCI Storage Path.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Stack HCI Storage Path exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:stack/getHciStoragePath:getHciStoragePath', __args__, opts=opts, typ=GetHciStoragePathResult).value

    return AwaitableGetHciStoragePathResult(
        custom_location_id=pulumi.get(__ret__, 'custom_location_id'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        path=pulumi.get(__ret__, 'path'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_hci_storage_path_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetHciStoragePathResult]:
    """
    Use this data source to access information about an existing Stack HCI Storage Path.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.stack.get_hci_storage_path(name="example-hci-storage-path-name",
        resource_group_name="example-rg")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.AzureStackHCI`: 2024-01-01


    :param _builtins.str name: The name of this Stack HCI Storage Path.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Stack HCI Storage Path exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:stack/getHciStoragePath:getHciStoragePath', __args__, opts=opts, typ=GetHciStoragePathResult)
    return __ret__.apply(lambda __response__: GetHciStoragePathResult(
        custom_location_id=pulumi.get(__response__, 'custom_location_id'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        path=pulumi.get(__response__, 'path'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
