# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HciMarketplaceGalleryImageArgs', 'HciMarketplaceGalleryImage']

@pulumi.input_type
class HciMarketplaceGalleryImageArgs:
    def __init__(__self__, *,
                 custom_location_id: pulumi.Input[_builtins.str],
                 hyperv_generation: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input['HciMarketplaceGalleryImageIdentifierArgs'],
                 os_type: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 version: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_path_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a HciMarketplaceGalleryImage resource.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of the Custom Location where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyperv_generation: The hypervisor generation of the Azure Stack HCI Marketplace Gallery Image. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input['HciMarketplaceGalleryImageIdentifierArgs'] identifier: An `identifier` block as defined below. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] os_type: The Operating System type of the Azure Stack HCI Marketplace Gallery Image. Possible values are `Windows` and `Linux`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] version: The version of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] storage_path_id: The ID of the Azure Stack HCI Storage Path used for this Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Marketplace Gallery Image.
        """
        pulumi.set(__self__, "custom_location_id", custom_location_id)
        pulumi.set(__self__, "hyperv_generation", hyperv_generation)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "version", version)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_path_id is not None:
            pulumi.set(__self__, "storage_path_id", storage_path_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Custom Location where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @custom_location_id.setter
    def custom_location_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_location_id", value)

    @_builtins.property
    @pulumi.getter(name="hypervGeneration")
    def hyperv_generation(self) -> pulumi.Input[_builtins.str]:
        """
        The hypervisor generation of the Azure Stack HCI Marketplace Gallery Image. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "hyperv_generation")

    @hyperv_generation.setter
    def hyperv_generation(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "hyperv_generation", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input['HciMarketplaceGalleryImageIdentifierArgs']:
        """
        An `identifier` block as defined below. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input['HciMarketplaceGalleryImageIdentifierArgs']):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[_builtins.str]:
        """
        The Operating System type of the Azure Stack HCI Marketplace Gallery Image. Possible values are `Windows` and `Linux`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Input[_builtins.str]:
        """
        The version of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="storagePathId")
    def storage_path_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Stack HCI Storage Path used for this Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "storage_path_id")

    @storage_path_id.setter
    def storage_path_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_path_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Marketplace Gallery Image.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _HciMarketplaceGalleryImageState:
    def __init__(__self__, *,
                 custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input['HciMarketplaceGalleryImageIdentifierArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_path_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HciMarketplaceGalleryImage resources.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of the Custom Location where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyperv_generation: The hypervisor generation of the Azure Stack HCI Marketplace Gallery Image. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input['HciMarketplaceGalleryImageIdentifierArgs'] identifier: An `identifier` block as defined below. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] os_type: The Operating System type of the Azure Stack HCI Marketplace Gallery Image. Possible values are `Windows` and `Linux`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] storage_path_id: The ID of the Azure Stack HCI Storage Path used for this Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Marketplace Gallery Image.
        :param pulumi.Input[_builtins.str] version: The version of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        if custom_location_id is not None:
            pulumi.set(__self__, "custom_location_id", custom_location_id)
        if hyperv_generation is not None:
            pulumi.set(__self__, "hyperv_generation", hyperv_generation)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if storage_path_id is not None:
            pulumi.set(__self__, "storage_path_id", storage_path_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Custom Location where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @custom_location_id.setter
    def custom_location_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_location_id", value)

    @_builtins.property
    @pulumi.getter(name="hypervGeneration")
    def hyperv_generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hypervisor generation of the Azure Stack HCI Marketplace Gallery Image. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "hyperv_generation")

    @hyperv_generation.setter
    def hyperv_generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyperv_generation", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input['HciMarketplaceGalleryImageIdentifierArgs']]:
        """
        An `identifier` block as defined below. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input['HciMarketplaceGalleryImageIdentifierArgs']]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Operating System type of the Azure Stack HCI Marketplace Gallery Image. Possible values are `Windows` and `Linux`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storagePathId")
    def storage_path_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Stack HCI Storage Path used for this Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "storage_path_id")

    @storage_path_id.setter
    def storage_path_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_path_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Marketplace Gallery Image.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("azure:stack/hciMarketplaceGalleryImage:HciMarketplaceGalleryImage")
class HciMarketplaceGalleryImage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[Union['HciMarketplaceGalleryImageIdentifierArgs', 'HciMarketplaceGalleryImageIdentifierArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_path_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Stack HCI Marketplace Gallery Image.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example_resource_group = azure.core.ResourceGroup("example",
            name="examples",
            location="West Europe")
        example = azure.core.get_client_config()
        # service principal of 'Microsoft.AzureStackHCI Resource Provider'
        hci_rp = azuread.get_service_principal(client_id="1412d89f-b8a8-4111-b4fd-e82905cbd85d")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_resource_group.id,
            role_definition_name="Azure Connected Machine Resource Manager",
            principal_id=hci_rp.object_id)
        example_hci_marketplace_gallery_image = azure.stack.HciMarketplaceGalleryImage("example",
            name="example-mgi",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            custom_location_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cl1",
            hyperv_generation="V2",
            os_type="Windows",
            version="20348.2655.240905",
            identifier={
                "publisher": "MicrosoftWindowsServer",
                "offer": "WindowsServer",
                "sku": "2022-datacenter-azure-edition-core",
            },
            tags={
                "foo": "bar",
                "env": "example",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AzureStackHCI`: 2024-01-01

        ## Import

        Azure Stack HCI Marketplace Gallery Images can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:stack/hciMarketplaceGalleryImage:HciMarketplaceGalleryImage example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/image1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of the Custom Location where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyperv_generation: The hypervisor generation of the Azure Stack HCI Marketplace Gallery Image. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[Union['HciMarketplaceGalleryImageIdentifierArgs', 'HciMarketplaceGalleryImageIdentifierArgsDict']] identifier: An `identifier` block as defined below. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] os_type: The Operating System type of the Azure Stack HCI Marketplace Gallery Image. Possible values are `Windows` and `Linux`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] storage_path_id: The ID of the Azure Stack HCI Storage Path used for this Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Marketplace Gallery Image.
        :param pulumi.Input[_builtins.str] version: The version of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HciMarketplaceGalleryImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Stack HCI Marketplace Gallery Image.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example_resource_group = azure.core.ResourceGroup("example",
            name="examples",
            location="West Europe")
        example = azure.core.get_client_config()
        # service principal of 'Microsoft.AzureStackHCI Resource Provider'
        hci_rp = azuread.get_service_principal(client_id="1412d89f-b8a8-4111-b4fd-e82905cbd85d")
        example_assignment = azure.authorization.Assignment("example",
            scope=example_resource_group.id,
            role_definition_name="Azure Connected Machine Resource Manager",
            principal_id=hci_rp.object_id)
        example_hci_marketplace_gallery_image = azure.stack.HciMarketplaceGalleryImage("example",
            name="example-mgi",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            custom_location_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cl1",
            hyperv_generation="V2",
            os_type="Windows",
            version="20348.2655.240905",
            identifier={
                "publisher": "MicrosoftWindowsServer",
                "offer": "WindowsServer",
                "sku": "2022-datacenter-azure-edition-core",
            },
            tags={
                "foo": "bar",
                "env": "example",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AzureStackHCI`: 2024-01-01

        ## Import

        Azure Stack HCI Marketplace Gallery Images can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:stack/hciMarketplaceGalleryImage:HciMarketplaceGalleryImage example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/image1
        ```

        :param str resource_name: The name of the resource.
        :param HciMarketplaceGalleryImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HciMarketplaceGalleryImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hyperv_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[Union['HciMarketplaceGalleryImageIdentifierArgs', 'HciMarketplaceGalleryImageIdentifierArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_path_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HciMarketplaceGalleryImageArgs.__new__(HciMarketplaceGalleryImageArgs)

            if custom_location_id is None and not opts.urn:
                raise TypeError("Missing required property 'custom_location_id'")
            __props__.__dict__["custom_location_id"] = custom_location_id
            if hyperv_generation is None and not opts.urn:
                raise TypeError("Missing required property 'hyperv_generation'")
            __props__.__dict__["hyperv_generation"] = hyperv_generation
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if os_type is None and not opts.urn:
                raise TypeError("Missing required property 'os_type'")
            __props__.__dict__["os_type"] = os_type
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["storage_path_id"] = storage_path_id
            __props__.__dict__["tags"] = tags
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
        super(HciMarketplaceGalleryImage, __self__).__init__(
            'azure:stack/hciMarketplaceGalleryImage:HciMarketplaceGalleryImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
            hyperv_generation: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[Union['HciMarketplaceGalleryImageIdentifierArgs', 'HciMarketplaceGalleryImageIdentifierArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            os_type: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_path_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None) -> 'HciMarketplaceGalleryImage':
        """
        Get an existing HciMarketplaceGalleryImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of the Custom Location where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyperv_generation: The hypervisor generation of the Azure Stack HCI Marketplace Gallery Image. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[Union['HciMarketplaceGalleryImageIdentifierArgs', 'HciMarketplaceGalleryImageIdentifierArgsDict']] identifier: An `identifier` block as defined below. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] os_type: The Operating System type of the Azure Stack HCI Marketplace Gallery Image. Possible values are `Windows` and `Linux`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        :param pulumi.Input[_builtins.str] storage_path_id: The ID of the Azure Stack HCI Storage Path used for this Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Marketplace Gallery Image.
        :param pulumi.Input[_builtins.str] version: The version of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HciMarketplaceGalleryImageState.__new__(_HciMarketplaceGalleryImageState)

        __props__.__dict__["custom_location_id"] = custom_location_id
        __props__.__dict__["hyperv_generation"] = hyperv_generation
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["storage_path_id"] = storage_path_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        return HciMarketplaceGalleryImage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Custom Location where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @_builtins.property
    @pulumi.getter(name="hypervGeneration")
    def hyperv_generation(self) -> pulumi.Output[_builtins.str]:
        """
        The hypervisor generation of the Azure Stack HCI Marketplace Gallery Image. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "hyperv_generation")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output['outputs.HciMarketplaceGalleryImageIdentifier']:
        """
        An `identifier` block as defined below. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[_builtins.str]:
        """
        The Operating System type of the Azure Stack HCI Marketplace Gallery Image. Possible values are `Windows` and `Linux`. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Azure Stack HCI Marketplace Gallery Image should exist. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="storagePathId")
    def storage_path_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Azure Stack HCI Storage Path used for this Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "storage_path_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Marketplace Gallery Image.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the Azure Stack HCI Marketplace Gallery Image. Changing this forces a new Azure Stack HCI Marketplace Gallery Image to be created.
        """
        return pulumi.get(self, "version")

