# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['HciVirtualHardDiskArgs', 'HciVirtualHardDisk']

@pulumi.input_type
class HciVirtualHardDiskArgs:
    def __init__(__self__, *,
                 custom_location_id: pulumi.Input[_builtins.str],
                 disk_size_in_gb: pulumi.Input[_builtins.int],
                 resource_group_name: pulumi.Input[_builtins.str],
                 block_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_file_format: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hyperv_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_sector_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 physical_sector_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_path_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a HciVirtualHardDisk resource.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of the Custom Location where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] disk_size_in_gb: The size of the disk in GB. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] block_size_in_bytes: The block size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] disk_file_format: The format of the disk file. Possible values are `vhdx` and `vhd`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.bool] dynamic_enabled: Whether to enable dynamic sizing for the Azure Stack HCI Virtual Hard Disk. Defaults to `false`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] hyperv_generation: The hypervisor generation of the Azure Stack HCI Virtual Hard Disk. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] logical_sector_in_bytes: The logical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] physical_sector_in_bytes: The physical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] storage_path_id: The ID of the Azure Stack HCI Storage Path used for this Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
               
               > **Note:** If `storage_path_id` is not specified, the Virtual Hard Disk will be placed in a high availability Storage Path. If you experience a diff you may need to add this to `ignore_changes`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Virtual Hard Disk.
        """
        pulumi.set(__self__, "custom_location_id", custom_location_id)
        pulumi.set(__self__, "disk_size_in_gb", disk_size_in_gb)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if block_size_in_bytes is not None:
            pulumi.set(__self__, "block_size_in_bytes", block_size_in_bytes)
        if disk_file_format is not None:
            pulumi.set(__self__, "disk_file_format", disk_file_format)
        if dynamic_enabled is not None:
            pulumi.set(__self__, "dynamic_enabled", dynamic_enabled)
        if hyperv_generation is not None:
            pulumi.set(__self__, "hyperv_generation", hyperv_generation)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logical_sector_in_bytes is not None:
            pulumi.set(__self__, "logical_sector_in_bytes", logical_sector_in_bytes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if physical_sector_in_bytes is not None:
            pulumi.set(__self__, "physical_sector_in_bytes", physical_sector_in_bytes)
        if storage_path_id is not None:
            pulumi.set(__self__, "storage_path_id", storage_path_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Custom Location where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @custom_location_id.setter
    def custom_location_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "custom_location_id", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeInGb")
    def disk_size_in_gb(self) -> pulumi.Input[_builtins.int]:
        """
        The size of the disk in GB. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "disk_size_in_gb")

    @disk_size_in_gb.setter
    def disk_size_in_gb(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "disk_size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="blockSizeInBytes")
    def block_size_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The block size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "block_size_in_bytes")

    @block_size_in_bytes.setter
    def block_size_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "block_size_in_bytes", value)

    @_builtins.property
    @pulumi.getter(name="diskFileFormat")
    def disk_file_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of the disk file. Possible values are `vhdx` and `vhd`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "disk_file_format")

    @disk_file_format.setter
    def disk_file_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_file_format", value)

    @_builtins.property
    @pulumi.getter(name="dynamicEnabled")
    def dynamic_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable dynamic sizing for the Azure Stack HCI Virtual Hard Disk. Defaults to `false`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "dynamic_enabled")

    @dynamic_enabled.setter
    def dynamic_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dynamic_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hypervGeneration")
    def hyperv_generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hypervisor generation of the Azure Stack HCI Virtual Hard Disk. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "hyperv_generation")

    @hyperv_generation.setter
    def hyperv_generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyperv_generation", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logicalSectorInBytes")
    def logical_sector_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The logical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "logical_sector_in_bytes")

    @logical_sector_in_bytes.setter
    def logical_sector_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "logical_sector_in_bytes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Stack HCI Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="physicalSectorInBytes")
    def physical_sector_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The physical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "physical_sector_in_bytes")

    @physical_sector_in_bytes.setter
    def physical_sector_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "physical_sector_in_bytes", value)

    @_builtins.property
    @pulumi.getter(name="storagePathId")
    def storage_path_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Stack HCI Storage Path used for this Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.

        > **Note:** If `storage_path_id` is not specified, the Virtual Hard Disk will be placed in a high availability Storage Path. If you experience a diff you may need to add this to `ignore_changes`.
        """
        return pulumi.get(self, "storage_path_id")

    @storage_path_id.setter
    def storage_path_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_path_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Virtual Hard Disk.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _HciVirtualHardDiskState:
    def __init__(__self__, *,
                 block_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_file_format: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 dynamic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hyperv_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_sector_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 physical_sector_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_path_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering HciVirtualHardDisk resources.
        :param pulumi.Input[_builtins.int] block_size_in_bytes: The block size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of the Custom Location where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] disk_file_format: The format of the disk file. Possible values are `vhdx` and `vhd`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] disk_size_in_gb: The size of the disk in GB. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.bool] dynamic_enabled: Whether to enable dynamic sizing for the Azure Stack HCI Virtual Hard Disk. Defaults to `false`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] hyperv_generation: The hypervisor generation of the Azure Stack HCI Virtual Hard Disk. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] logical_sector_in_bytes: The logical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] physical_sector_in_bytes: The physical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] storage_path_id: The ID of the Azure Stack HCI Storage Path used for this Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
               
               > **Note:** If `storage_path_id` is not specified, the Virtual Hard Disk will be placed in a high availability Storage Path. If you experience a diff you may need to add this to `ignore_changes`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Virtual Hard Disk.
        """
        if block_size_in_bytes is not None:
            pulumi.set(__self__, "block_size_in_bytes", block_size_in_bytes)
        if custom_location_id is not None:
            pulumi.set(__self__, "custom_location_id", custom_location_id)
        if disk_file_format is not None:
            pulumi.set(__self__, "disk_file_format", disk_file_format)
        if disk_size_in_gb is not None:
            pulumi.set(__self__, "disk_size_in_gb", disk_size_in_gb)
        if dynamic_enabled is not None:
            pulumi.set(__self__, "dynamic_enabled", dynamic_enabled)
        if hyperv_generation is not None:
            pulumi.set(__self__, "hyperv_generation", hyperv_generation)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logical_sector_in_bytes is not None:
            pulumi.set(__self__, "logical_sector_in_bytes", logical_sector_in_bytes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if physical_sector_in_bytes is not None:
            pulumi.set(__self__, "physical_sector_in_bytes", physical_sector_in_bytes)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if storage_path_id is not None:
            pulumi.set(__self__, "storage_path_id", storage_path_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="blockSizeInBytes")
    def block_size_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The block size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "block_size_in_bytes")

    @block_size_in_bytes.setter
    def block_size_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "block_size_in_bytes", value)

    @_builtins.property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Custom Location where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @custom_location_id.setter
    def custom_location_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_location_id", value)

    @_builtins.property
    @pulumi.getter(name="diskFileFormat")
    def disk_file_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The format of the disk file. Possible values are `vhdx` and `vhd`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "disk_file_format")

    @disk_file_format.setter
    def disk_file_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_file_format", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeInGb")
    def disk_size_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The size of the disk in GB. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "disk_size_in_gb")

    @disk_size_in_gb.setter
    def disk_size_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="dynamicEnabled")
    def dynamic_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable dynamic sizing for the Azure Stack HCI Virtual Hard Disk. Defaults to `false`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "dynamic_enabled")

    @dynamic_enabled.setter
    def dynamic_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dynamic_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hypervGeneration")
    def hyperv_generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hypervisor generation of the Azure Stack HCI Virtual Hard Disk. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "hyperv_generation")

    @hyperv_generation.setter
    def hyperv_generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyperv_generation", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logicalSectorInBytes")
    def logical_sector_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The logical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "logical_sector_in_bytes")

    @logical_sector_in_bytes.setter
    def logical_sector_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "logical_sector_in_bytes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Azure Stack HCI Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="physicalSectorInBytes")
    def physical_sector_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The physical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "physical_sector_in_bytes")

    @physical_sector_in_bytes.setter
    def physical_sector_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "physical_sector_in_bytes", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storagePathId")
    def storage_path_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Stack HCI Storage Path used for this Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.

        > **Note:** If `storage_path_id` is not specified, the Virtual Hard Disk will be placed in a high availability Storage Path. If you experience a diff you may need to add this to `ignore_changes`.
        """
        return pulumi.get(self, "storage_path_id")

    @storage_path_id.setter
    def storage_path_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_path_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Virtual Hard Disk.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:stack/hciVirtualHardDisk:HciVirtualHardDisk")
class HciVirtualHardDisk(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_file_format: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 dynamic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hyperv_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_sector_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 physical_sector_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_path_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Stack HCI Virtual Hard Disk.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_hci_storage_path = azure.stack.HciStoragePath("example",
            name="example-sp",
            resource_group_name=example.name,
            location=example.location,
            custom_location_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cl1",
            path="C:\\\\ClusterStorage\\\\UserStorage_2\\\\sp-example",
            tags={
                "foo": "bar",
            })
        example_hci_virtual_hard_disk = azure.stack.HciVirtualHardDisk("example",
            name="example-vhd",
            resource_group_name=example.name,
            location=example.location,
            custom_location_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cl1",
            disk_size_in_gb=2,
            storage_path_id=example_hci_storage_path.id,
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AzureStackHCI`: 2024-01-01

        ## Import

        Azure Stack HCI Virtual Hard Disks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:stack/hciVirtualHardDisk:HciVirtualHardDisk example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.AzureStackHCI/virtualHardDisks/disk1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] block_size_in_bytes: The block size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of the Custom Location where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] disk_file_format: The format of the disk file. Possible values are `vhdx` and `vhd`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] disk_size_in_gb: The size of the disk in GB. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.bool] dynamic_enabled: Whether to enable dynamic sizing for the Azure Stack HCI Virtual Hard Disk. Defaults to `false`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] hyperv_generation: The hypervisor generation of the Azure Stack HCI Virtual Hard Disk. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] logical_sector_in_bytes: The logical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] physical_sector_in_bytes: The physical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] storage_path_id: The ID of the Azure Stack HCI Storage Path used for this Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
               
               > **Note:** If `storage_path_id` is not specified, the Virtual Hard Disk will be placed in a high availability Storage Path. If you experience a diff you may need to add this to `ignore_changes`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Virtual Hard Disk.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HciVirtualHardDiskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Stack HCI Virtual Hard Disk.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        example_hci_storage_path = azure.stack.HciStoragePath("example",
            name="example-sp",
            resource_group_name=example.name,
            location=example.location,
            custom_location_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cl1",
            path="C:\\\\ClusterStorage\\\\UserStorage_2\\\\sp-example",
            tags={
                "foo": "bar",
            })
        example_hci_virtual_hard_disk = azure.stack.HciVirtualHardDisk("example",
            name="example-vhd",
            resource_group_name=example.name,
            location=example.location,
            custom_location_id="/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.ExtendedLocation/customLocations/cl1",
            disk_size_in_gb=2,
            storage_path_id=example_hci_storage_path.id,
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AzureStackHCI`: 2024-01-01

        ## Import

        Azure Stack HCI Virtual Hard Disks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:stack/hciVirtualHardDisk:HciVirtualHardDisk example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.AzureStackHCI/virtualHardDisks/disk1
        ```

        :param str resource_name: The name of the resource.
        :param HciVirtualHardDiskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HciVirtualHardDiskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_file_format: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 dynamic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hyperv_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_sector_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 physical_sector_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_path_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HciVirtualHardDiskArgs.__new__(HciVirtualHardDiskArgs)

            __props__.__dict__["block_size_in_bytes"] = block_size_in_bytes
            if custom_location_id is None and not opts.urn:
                raise TypeError("Missing required property 'custom_location_id'")
            __props__.__dict__["custom_location_id"] = custom_location_id
            __props__.__dict__["disk_file_format"] = disk_file_format
            if disk_size_in_gb is None and not opts.urn:
                raise TypeError("Missing required property 'disk_size_in_gb'")
            __props__.__dict__["disk_size_in_gb"] = disk_size_in_gb
            __props__.__dict__["dynamic_enabled"] = dynamic_enabled
            __props__.__dict__["hyperv_generation"] = hyperv_generation
            __props__.__dict__["location"] = location
            __props__.__dict__["logical_sector_in_bytes"] = logical_sector_in_bytes
            __props__.__dict__["name"] = name
            __props__.__dict__["physical_sector_in_bytes"] = physical_sector_in_bytes
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["storage_path_id"] = storage_path_id
            __props__.__dict__["tags"] = tags
        super(HciVirtualHardDisk, __self__).__init__(
            'azure:stack/hciVirtualHardDisk:HciVirtualHardDisk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            block_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            custom_location_id: Optional[pulumi.Input[_builtins.str]] = None,
            disk_file_format: Optional[pulumi.Input[_builtins.str]] = None,
            disk_size_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
            dynamic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            hyperv_generation: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            logical_sector_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            physical_sector_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_path_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'HciVirtualHardDisk':
        """
        Get an existing HciVirtualHardDisk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] block_size_in_bytes: The block size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] custom_location_id: The ID of the Custom Location where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] disk_file_format: The format of the disk file. Possible values are `vhdx` and `vhd`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] disk_size_in_gb: The size of the disk in GB. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.bool] dynamic_enabled: Whether to enable dynamic sizing for the Azure Stack HCI Virtual Hard Disk. Defaults to `false`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] hyperv_generation: The hypervisor generation of the Azure Stack HCI Virtual Hard Disk. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] logical_sector_in_bytes: The logical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Azure Stack HCI Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.int] physical_sector_in_bytes: The physical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        :param pulumi.Input[_builtins.str] storage_path_id: The ID of the Azure Stack HCI Storage Path used for this Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
               
               > **Note:** If `storage_path_id` is not specified, the Virtual Hard Disk will be placed in a high availability Storage Path. If you experience a diff you may need to add this to `ignore_changes`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Stack HCI Virtual Hard Disk.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HciVirtualHardDiskState.__new__(_HciVirtualHardDiskState)

        __props__.__dict__["block_size_in_bytes"] = block_size_in_bytes
        __props__.__dict__["custom_location_id"] = custom_location_id
        __props__.__dict__["disk_file_format"] = disk_file_format
        __props__.__dict__["disk_size_in_gb"] = disk_size_in_gb
        __props__.__dict__["dynamic_enabled"] = dynamic_enabled
        __props__.__dict__["hyperv_generation"] = hyperv_generation
        __props__.__dict__["location"] = location
        __props__.__dict__["logical_sector_in_bytes"] = logical_sector_in_bytes
        __props__.__dict__["name"] = name
        __props__.__dict__["physical_sector_in_bytes"] = physical_sector_in_bytes
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["storage_path_id"] = storage_path_id
        __props__.__dict__["tags"] = tags
        return HciVirtualHardDisk(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="blockSizeInBytes")
    def block_size_in_bytes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The block size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "block_size_in_bytes")

    @_builtins.property
    @pulumi.getter(name="customLocationId")
    def custom_location_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Custom Location where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "custom_location_id")

    @_builtins.property
    @pulumi.getter(name="diskFileFormat")
    def disk_file_format(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The format of the disk file. Possible values are `vhdx` and `vhd`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "disk_file_format")

    @_builtins.property
    @pulumi.getter(name="diskSizeInGb")
    def disk_size_in_gb(self) -> pulumi.Output[_builtins.int]:
        """
        The size of the disk in GB. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "disk_size_in_gb")

    @_builtins.property
    @pulumi.getter(name="dynamicEnabled")
    def dynamic_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable dynamic sizing for the Azure Stack HCI Virtual Hard Disk. Defaults to `false`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "dynamic_enabled")

    @_builtins.property
    @pulumi.getter(name="hypervGeneration")
    def hyperv_generation(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The hypervisor generation of the Azure Stack HCI Virtual Hard Disk. Possible values are `V1` and `V2`. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "hyperv_generation")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="logicalSectorInBytes")
    def logical_sector_in_bytes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The logical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "logical_sector_in_bytes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Azure Stack HCI Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="physicalSectorInBytes")
    def physical_sector_in_bytes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The physical sector size of the disk in bytes. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "physical_sector_in_bytes")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Azure Stack HCI Virtual Hard Disk should exist. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="storagePathId")
    def storage_path_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Azure Stack HCI Storage Path used for this Virtual Hard Disk. Changing this forces a new Azure Stack HCI Virtual Hard Disk to be created.

        > **Note:** If `storage_path_id` is not specified, the Virtual Hard Disk will be placed in a high availability Storage Path. If you experience a diff you may need to add this to `ignore_changes`.
        """
        return pulumi.get(self, "storage_path_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Azure Stack HCI Virtual Hard Disk.
        """
        return pulumi.get(self, "tags")

