# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetShareResult',
    'AwaitableGetShareResult',
    'get_share',
    'get_share_output',
]

@pulumi.output_type
class GetShareResult:
    """
    A collection of values returned by getShare.
    """
    def __init__(__self__, acls=None, id=None, metadata=None, name=None, quota=None, resource_manager_id=None, storage_account_id=None, storage_account_name=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metadata and not isinstance(metadata, dict):
            raise TypeError("Expected argument 'metadata' to be a dict")
        pulumi.set(__self__, "metadata", metadata)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if quota and not isinstance(quota, int):
            raise TypeError("Expected argument 'quota' to be a int")
        pulumi.set(__self__, "quota", quota)
        if resource_manager_id and not isinstance(resource_manager_id, str):
            raise TypeError("Expected argument 'resource_manager_id' to be a str")
        pulumi.set(__self__, "resource_manager_id", resource_manager_id)
        if storage_account_id and not isinstance(storage_account_id, str):
            raise TypeError("Expected argument 'storage_account_id' to be a str")
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if storage_account_name and not isinstance(storage_account_name, str):
            raise TypeError("Expected argument 'storage_account_name' to be a str")
        pulumi.set(__self__, "storage_account_name", storage_account_name)

    @_builtins.property
    @pulumi.getter
    def acls(self) -> Optional[Sequence['outputs.GetShareAclResult']]:
        """
        One or more acl blocks as defined below.
        """
        return pulumi.get(self, "acls")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Mapping[str, _builtins.str]:
        """
        A map of custom file share metadata.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def quota(self) -> _builtins.int:
        """
        The quota of the File Share in GB.
        """
        return pulumi.get(self, "quota")

    @_builtins.property
    @pulumi.getter(name="resourceManagerId")
    @_utilities.deprecated("""this property has been deprecated in favour of `id` and will be removed in version 5.0 of the Provider.""")
    def resource_manager_id(self) -> _builtins.str:
        return pulumi.get(self, "resource_manager_id")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "storage_account_name")


class AwaitableGetShareResult(GetShareResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetShareResult(
            acls=self.acls,
            id=self.id,
            metadata=self.metadata,
            name=self.name,
            quota=self.quota,
            resource_manager_id=self.resource_manager_id,
            storage_account_id=self.storage_account_id,
            storage_account_name=self.storage_account_name)


def get_share(acls: Optional[Sequence[Union['GetShareAclArgs', 'GetShareAclArgsDict']]] = None,
              metadata: Optional[Mapping[str, _builtins.str]] = None,
              name: Optional[_builtins.str] = None,
              storage_account_id: Optional[_builtins.str] = None,
              storage_account_name: Optional[_builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetShareResult:
    """
    Use this data source to access information about an existing File Share.

    > **Note:** Shared Key authentication will always be used for this data source, as AzureAD authentication is not supported by the Storage API for files.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_account(name="exampleaccount",
        resource_group_name="examples")
    example_get_share = azure.storage.get_share(name="existing",
        storage_account_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Storage`: 2023-05-01


    :param Sequence[Union['GetShareAclArgs', 'GetShareAclArgsDict']] acls: One or more acl blocks as defined below.
    :param Mapping[str, _builtins.str] metadata: A map of custom file share metadata.
    :param _builtins.str name: The name of the share.
    :param _builtins.str storage_account_id: The ID of the storage account in which the share exists.
           
           > **Note:** One of `storage_account_name` or `storage_account_id` must be specified. When specifying `storage_account_id` the resource will use the Resource Manager API, rather than the Data Plane API.
    :param _builtins.str storage_account_name: The name of the storage account in which the share exists. This property is deprecated in favour of `storage_account_id`.
    """
    __args__ = dict()
    __args__['acls'] = acls
    __args__['metadata'] = metadata
    __args__['name'] = name
    __args__['storageAccountId'] = storage_account_id
    __args__['storageAccountName'] = storage_account_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:storage/getShare:getShare', __args__, opts=opts, typ=GetShareResult).value

    return AwaitableGetShareResult(
        acls=pulumi.get(__ret__, 'acls'),
        id=pulumi.get(__ret__, 'id'),
        metadata=pulumi.get(__ret__, 'metadata'),
        name=pulumi.get(__ret__, 'name'),
        quota=pulumi.get(__ret__, 'quota'),
        resource_manager_id=pulumi.get(__ret__, 'resource_manager_id'),
        storage_account_id=pulumi.get(__ret__, 'storage_account_id'),
        storage_account_name=pulumi.get(__ret__, 'storage_account_name'))
def get_share_output(acls: Optional[pulumi.Input[Optional[Sequence[Union['GetShareAclArgs', 'GetShareAclArgsDict']]]]] = None,
                     metadata: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                     name: Optional[pulumi.Input[_builtins.str]] = None,
                     storage_account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     storage_account_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetShareResult]:
    """
    Use this data source to access information about an existing File Share.

    > **Note:** Shared Key authentication will always be used for this data source, as AzureAD authentication is not supported by the Storage API for files.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_account(name="exampleaccount",
        resource_group_name="examples")
    example_get_share = azure.storage.get_share(name="existing",
        storage_account_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Storage`: 2023-05-01


    :param Sequence[Union['GetShareAclArgs', 'GetShareAclArgsDict']] acls: One or more acl blocks as defined below.
    :param Mapping[str, _builtins.str] metadata: A map of custom file share metadata.
    :param _builtins.str name: The name of the share.
    :param _builtins.str storage_account_id: The ID of the storage account in which the share exists.
           
           > **Note:** One of `storage_account_name` or `storage_account_id` must be specified. When specifying `storage_account_id` the resource will use the Resource Manager API, rather than the Data Plane API.
    :param _builtins.str storage_account_name: The name of the storage account in which the share exists. This property is deprecated in favour of `storage_account_id`.
    """
    __args__ = dict()
    __args__['acls'] = acls
    __args__['metadata'] = metadata
    __args__['name'] = name
    __args__['storageAccountId'] = storage_account_id
    __args__['storageAccountName'] = storage_account_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:storage/getShare:getShare', __args__, opts=opts, typ=GetShareResult)
    return __ret__.apply(lambda __response__: GetShareResult(
        acls=pulumi.get(__response__, 'acls'),
        id=pulumi.get(__response__, 'id'),
        metadata=pulumi.get(__response__, 'metadata'),
        name=pulumi.get(__response__, 'name'),
        quota=pulumi.get(__response__, 'quota'),
        resource_manager_id=pulumi.get(__response__, 'resource_manager_id'),
        storage_account_id=pulumi.get(__response__, 'storage_account_id'),
        storage_account_name=pulumi.get(__response__, 'storage_account_name')))
