# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTableEntityResult',
    'AwaitableGetTableEntityResult',
    'get_table_entity',
    'get_table_entity_output',
]

@pulumi.output_type
class GetTableEntityResult:
    """
    A collection of values returned by getTableEntity.
    """
    def __init__(__self__, entity=None, id=None, partition_key=None, row_key=None, storage_table_id=None):
        if entity and not isinstance(entity, dict):
            raise TypeError("Expected argument 'entity' to be a dict")
        pulumi.set(__self__, "entity", entity)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if partition_key and not isinstance(partition_key, str):
            raise TypeError("Expected argument 'partition_key' to be a str")
        pulumi.set(__self__, "partition_key", partition_key)
        if row_key and not isinstance(row_key, str):
            raise TypeError("Expected argument 'row_key' to be a str")
        pulumi.set(__self__, "row_key", row_key)
        if storage_table_id and not isinstance(storage_table_id, str):
            raise TypeError("Expected argument 'storage_table_id' to be a str")
        pulumi.set(__self__, "storage_table_id", storage_table_id)

    @_builtins.property
    @pulumi.getter
    def entity(self) -> Mapping[str, _builtins.str]:
        """
        A map of key/value pairs that describe the entity to be stored in the storage table.
        """
        return pulumi.get(self, "entity")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> _builtins.str:
        return pulumi.get(self, "partition_key")

    @_builtins.property
    @pulumi.getter(name="rowKey")
    def row_key(self) -> _builtins.str:
        return pulumi.get(self, "row_key")

    @_builtins.property
    @pulumi.getter(name="storageTableId")
    def storage_table_id(self) -> _builtins.str:
        return pulumi.get(self, "storage_table_id")


class AwaitableGetTableEntityResult(GetTableEntityResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTableEntityResult(
            entity=self.entity,
            id=self.id,
            partition_key=self.partition_key,
            row_key=self.row_key,
            storage_table_id=self.storage_table_id)


def get_table_entity(partition_key: Optional[_builtins.str] = None,
                     row_key: Optional[_builtins.str] = None,
                     storage_table_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTableEntityResult:
    """
    Use this data source to access information about an existing Storage Table Entity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_table_entity(storage_table_id=example_azurerm_storage_table["id"],
        partition_key="example-partition-key",
        row_key="example-row-key")
    ```


    :param _builtins.str partition_key: The key for the partition where the entity will be retrieved.
    :param _builtins.str row_key: The key for the row where the entity will be retrieved.
    :param _builtins.str storage_table_id: The Storage Table ID where the entity exists.
    """
    __args__ = dict()
    __args__['partitionKey'] = partition_key
    __args__['rowKey'] = row_key
    __args__['storageTableId'] = storage_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:storage/getTableEntity:getTableEntity', __args__, opts=opts, typ=GetTableEntityResult).value

    return AwaitableGetTableEntityResult(
        entity=pulumi.get(__ret__, 'entity'),
        id=pulumi.get(__ret__, 'id'),
        partition_key=pulumi.get(__ret__, 'partition_key'),
        row_key=pulumi.get(__ret__, 'row_key'),
        storage_table_id=pulumi.get(__ret__, 'storage_table_id'))
def get_table_entity_output(partition_key: Optional[pulumi.Input[_builtins.str]] = None,
                            row_key: Optional[pulumi.Input[_builtins.str]] = None,
                            storage_table_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTableEntityResult]:
    """
    Use this data source to access information about an existing Storage Table Entity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_table_entity(storage_table_id=example_azurerm_storage_table["id"],
        partition_key="example-partition-key",
        row_key="example-row-key")
    ```


    :param _builtins.str partition_key: The key for the partition where the entity will be retrieved.
    :param _builtins.str row_key: The key for the row where the entity will be retrieved.
    :param _builtins.str storage_table_id: The Storage Table ID where the entity exists.
    """
    __args__ = dict()
    __args__['partitionKey'] = partition_key
    __args__['rowKey'] = row_key
    __args__['storageTableId'] = storage_table_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:storage/getTableEntity:getTableEntity', __args__, opts=opts, typ=GetTableEntityResult)
    return __ret__.apply(lambda __response__: GetTableEntityResult(
        entity=pulumi.get(__response__, 'entity'),
        id=pulumi.get(__response__, 'id'),
        partition_key=pulumi.get(__response__, 'partition_key'),
        row_key=pulumi.get(__response__, 'row_key'),
        storage_table_id=pulumi.get(__response__, 'storage_table_id')))
