# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MoverAgentArgs', 'MoverAgent']

@pulumi.input_type
class MoverAgentArgs:
    def __init__(__self__, *,
                 arc_virtual_machine_id: pulumi.Input[_builtins.str],
                 arc_virtual_machine_uuid: pulumi.Input[_builtins.str],
                 storage_mover_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MoverAgent resource.
        :param pulumi.Input[_builtins.str] arc_virtual_machine_id: Specifies the fully qualified ID of the Hybrid Compute resource for the Storage Mover Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] arc_virtual_machine_uuid: Specifies the Hybrid Compute resource's unique SMBIOS ID. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the Storage Mover that this Agent should be connected to. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies a description for this Storage Mover Agent.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Agent. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "arc_virtual_machine_id", arc_virtual_machine_id)
        pulumi.set(__self__, "arc_virtual_machine_uuid", arc_virtual_machine_uuid)
        pulumi.set(__self__, "storage_mover_id", storage_mover_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="arcVirtualMachineId")
    def arc_virtual_machine_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the fully qualified ID of the Hybrid Compute resource for the Storage Mover Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "arc_virtual_machine_id")

    @arc_virtual_machine_id.setter
    def arc_virtual_machine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "arc_virtual_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="arcVirtualMachineUuid")
    def arc_virtual_machine_uuid(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Hybrid Compute resource's unique SMBIOS ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "arc_virtual_machine_uuid")

    @arc_virtual_machine_uuid.setter
    def arc_virtual_machine_uuid(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "arc_virtual_machine_uuid", value)

    @_builtins.property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Storage Mover that this Agent should be connected to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

    @storage_mover_id.setter
    def storage_mover_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_mover_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a description for this Storage Mover Agent.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Storage Mover Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MoverAgentState:
    def __init__(__self__, *,
                 arc_virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arc_virtual_machine_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MoverAgent resources.
        :param pulumi.Input[_builtins.str] arc_virtual_machine_id: Specifies the fully qualified ID of the Hybrid Compute resource for the Storage Mover Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] arc_virtual_machine_uuid: Specifies the Hybrid Compute resource's unique SMBIOS ID. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies a description for this Storage Mover Agent.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the Storage Mover that this Agent should be connected to. Changing this forces a new resource to be created.
        """
        if arc_virtual_machine_id is not None:
            pulumi.set(__self__, "arc_virtual_machine_id", arc_virtual_machine_id)
        if arc_virtual_machine_uuid is not None:
            pulumi.set(__self__, "arc_virtual_machine_uuid", arc_virtual_machine_uuid)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_mover_id is not None:
            pulumi.set(__self__, "storage_mover_id", storage_mover_id)

    @_builtins.property
    @pulumi.getter(name="arcVirtualMachineId")
    def arc_virtual_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the fully qualified ID of the Hybrid Compute resource for the Storage Mover Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "arc_virtual_machine_id")

    @arc_virtual_machine_id.setter
    def arc_virtual_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arc_virtual_machine_id", value)

    @_builtins.property
    @pulumi.getter(name="arcVirtualMachineUuid")
    def arc_virtual_machine_uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Hybrid Compute resource's unique SMBIOS ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "arc_virtual_machine_uuid")

    @arc_virtual_machine_uuid.setter
    def arc_virtual_machine_uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arc_virtual_machine_uuid", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a description for this Storage Mover Agent.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Storage Mover Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Storage Mover that this Agent should be connected to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

    @storage_mover_id.setter
    def storage_mover_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_mover_id", value)


@pulumi.type_token("azure:storage/moverAgent:MoverAgent")
class MoverAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arc_virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arc_virtual_machine_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Storage Mover Agent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_mover = azure.storage.Mover("example",
            name="example-ssm",
            resource_group_name=example.name)
        example_mover_agent = azure.storage.MoverAgent("example",
            name="example-sa",
            storage_mover_id=example_mover.id,
            arc_virtual_machine_id=example.id.apply(lambda id: f"{id}/providers/Microsoft.HybridCompute/machines/examples-hybridComputeName"),
            arc_virtual_machine_uuid="3bb2c024-eba9-4d18-9e7a-1d772fcc5fe9",
            description="Example Agent Description")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageMover`: 2023-03-01

        ## Import

        Storage Mover Agent can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/moverAgent:MoverAgent example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.StorageMover/storageMovers/storageMover1/agents/agent1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arc_virtual_machine_id: Specifies the fully qualified ID of the Hybrid Compute resource for the Storage Mover Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] arc_virtual_machine_uuid: Specifies the Hybrid Compute resource's unique SMBIOS ID. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies a description for this Storage Mover Agent.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the Storage Mover that this Agent should be connected to. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MoverAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Storage Mover Agent.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="East US")
        example_mover = azure.storage.Mover("example",
            name="example-ssm",
            resource_group_name=example.name)
        example_mover_agent = azure.storage.MoverAgent("example",
            name="example-sa",
            storage_mover_id=example_mover.id,
            arc_virtual_machine_id=example.id.apply(lambda id: f"{id}/providers/Microsoft.HybridCompute/machines/examples-hybridComputeName"),
            arc_virtual_machine_uuid="3bb2c024-eba9-4d18-9e7a-1d772fcc5fe9",
            description="Example Agent Description")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageMover`: 2023-03-01

        ## Import

        Storage Mover Agent can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/moverAgent:MoverAgent example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.StorageMover/storageMovers/storageMover1/agents/agent1
        ```

        :param str resource_name: The name of the resource.
        :param MoverAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MoverAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arc_virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 arc_virtual_machine_uuid: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MoverAgentArgs.__new__(MoverAgentArgs)

            if arc_virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'arc_virtual_machine_id'")
            __props__.__dict__["arc_virtual_machine_id"] = arc_virtual_machine_id
            if arc_virtual_machine_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'arc_virtual_machine_uuid'")
            __props__.__dict__["arc_virtual_machine_uuid"] = arc_virtual_machine_uuid
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if storage_mover_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_mover_id'")
            __props__.__dict__["storage_mover_id"] = storage_mover_id
        super(MoverAgent, __self__).__init__(
            'azure:storage/moverAgent:MoverAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arc_virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
            arc_virtual_machine_uuid: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'MoverAgent':
        """
        Get an existing MoverAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] arc_virtual_machine_id: Specifies the fully qualified ID of the Hybrid Compute resource for the Storage Mover Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] arc_virtual_machine_uuid: Specifies the Hybrid Compute resource's unique SMBIOS ID. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies a description for this Storage Mover Agent.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Agent. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the Storage Mover that this Agent should be connected to. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MoverAgentState.__new__(_MoverAgentState)

        __props__.__dict__["arc_virtual_machine_id"] = arc_virtual_machine_id
        __props__.__dict__["arc_virtual_machine_uuid"] = arc_virtual_machine_uuid
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["storage_mover_id"] = storage_mover_id
        return MoverAgent(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="arcVirtualMachineId")
    def arc_virtual_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the fully qualified ID of the Hybrid Compute resource for the Storage Mover Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "arc_virtual_machine_id")

    @_builtins.property
    @pulumi.getter(name="arcVirtualMachineUuid")
    def arc_virtual_machine_uuid(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Hybrid Compute resource's unique SMBIOS ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "arc_virtual_machine_uuid")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a description for this Storage Mover Agent.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Storage Mover Agent. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Storage Mover that this Agent should be connected to. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

