from multiprocessing import Pool, Manager
from typing import Optional, Tuple, List, Dict, Any

from pm4py.algo.discovery.inductive.dtypes.im_ds import IMDataStructureUVCL
from pm4py.algo.discovery.inductive.fall_through.flower import FlowerModelUVCL
from powl.objects.obj import OperatorPOWL
from pm4py.objects.process_tree.obj import Operator
from pm4py.util.compression import util as comut
from pm4py.util.compression.dtypes import UVCL


class POWLFlowerModelUVCL(FlowerModelUVCL):

    @classmethod
    def apply(cls, obj: IMDataStructureUVCL, pool: Pool = None, manager: Manager = None, parameters: Optional[Dict[str, Any]] = None) -> Optional[
        Tuple[OperatorPOWL, List[IMDataStructureUVCL]]]:
        log = obj.data_structure
        uvcl_do = UVCL()
        for a in comut.get_alphabet(log):
            uvcl_do[(a,)] = 1
        uvcl_redo = UVCL()
        im_uvcl_do = IMDataStructureUVCL(uvcl_do)
        im_uvcl_redo = IMDataStructureUVCL(uvcl_redo)
        return OperatorPOWL(Operator.LOOP, []), [im_uvcl_do, im_uvcl_redo]


