# Release 0.8.106

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines.

**Note:** These release notes cover the changes from `0.8.78` to `0.8.106`


## General
A bunch of naming changes from `sageworks` to `workbench`. Super... fun....


This release is an incremental release as part of the road map for `v.0.9.0`. Please see the full details of the planned changes here: [v0.9.0 Roadmap](../road_maps/0_9_0.md). 


## API Changes
All imports have changed! So you can pretty much do a global replace (mind the caps) of **sageworks** with **workbench**.

```
from sageworks.api import DataSource
<is now>
from workbench.api import DataSource
```

### AGTable Plugin Changes
The AGTable plugin now has 3 properties returned by `update_properties()`.

```
self.properties = [
            (self.component_id, "columnDefs"),
            (self.component_id, "rowData"),
            (self.component_id, "style"),   <-- This one is new
        ]
```

In general you should be using the 'magic loop' method and shouldn't even have to know what properties are set. Here's a 'magic loop' example:

```
def example_callbacks(self):
    @callback(
        [Output(component_id, prop) for component_id, prop in my_table.properties],
        [Input("whatever, "blah")],
        )
    def _example_callbacks(blah):
        """Callback to Populate the models table with data"""
        models = self.meta.models(details=True)
        return my_table.update_properties(models)
```
See our presentation on Plugins and the 'magic loop': [Workbench Plugins OverView](https://docs.google.com/presentation/d/1RjpMmJW1i9auPztn2xXYmYKXsZjsnG7vVaCQQ4FLIMM/edit?usp=sharing)

## Specific Code Changes
 
<a href="https://github.com/supercowpowers/workbench/compare/v0.8.78...v0.8.106" target="_blank">Code Diff v0.8.78 --> v0.8.106</a> 

Who doesn't like looking at code! Also +3 points for getting down this far! Here's a cow joke as a reward:

> ***What do you call that feeling like you’ve done this before?
              Deja-moo***

## Questions?
<img align="right" src="../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


