# Release 0.8.55

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines.

**Note:** These release notes cover the changes from `0.8.50` to `0.8.55`


## General
This release is an incremental release as part of the road map for `v.0.9.0`. Please see the full details of the planned changes here: [v0.9.0 Roadmap](../road_maps/0_9_0.md). 

### FeatureSet: training column values
We're got a good suggestion from one of our beta customers to change the training column to use True/False values instead of 1/0. Having boolean values make semantic sense and make filtering easier and more intuitive.

## API Changes
**FeatureSet Queries**

Since the training column now contains True/False, any code that you have where you're doing a query against the training view.

```
fs.query(f'SELECT * FROM "{table}" where training = 1')
<changed to>
fs.query(f'SELECT * FROM "{table}" where training = TRUE')

fs.query(f'SELECT * FROM "{table}" where training = 0')
<changed to>
fs.query(f'SELECT * FROM "{table}" where training = FALSE')
```

Also dataframe filtering is easier now, so if you have a call to filter the dataframe that also needs to change.

```
df_train = all_df[all_df["training"] == 1].copy()
<changed to>
df_train = all_df[all_df["training"]].copy()

df_val = all_df[all_df["training"] == 0].copy()
<changed to>
df_val = all_df[~all_df["training"]].copy()
```
For more details see: [Training View](../core_classes/views/training_view.md)

**Model Instantiation**

We got a request to reduce the time for Model() object instantiation. So we created a new `CachedModel()` class that is much faster to instantiate.

```
%time Model("abalone-regression")
CPU times: user 227 ms, sys: 19.5 ms, total: 246 ms
Wall time: 2.97 s

%time CachedModel("abalone-regression")
CPU times: user 8.83 ms, sys: 2.64 ms, total: 11.5 ms
Wall time: 22.7 ms
```
For more details see: [CachedModel](../cached/cached_model.md)


## Improvements
**Workbench REPL Onboarding**

At some point the onboarding with Workbench REPL got broken and wasn't properly responding when the user didn't have a complete AWS/Workbench setup.

## Internal Changes
The decorator for the CachedMeta class did not work properly in Python 3.9 so had to be slightly refactored.

## Specific Code Changes
 
<a href="https://github.com/supercowpowers/workbench/compare/v0.8.50...v0.8.55" target="_blank">Code Diff v0.8.50 --> v0.8.55</a> 

Who doesn't like looking at code! Also +3 points for getting down this far! Here's a cow joke as a reward:

> ***That feeling like you’ve done this before?
      .... Deja-moo***

## Questions?
<img align="right" src="../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


