# Release 0.8.58

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines.

**Note:** These release notes cover the changes from `0.8.55` to `0.8.58`


## General
This release is an incremental release as part of the road map for `v.0.9.0`. Please see the full details of the planned changes here: [v0.9.0 Roadmap](../road_maps/0_9_0.md). 

### Caching Refactoring
We've created a new set of Cached Classes:

- CachedDataSource
- CachedFeatureSet
- CachedModel
- CacheEndpoint

As part of this there's now a `workbench/cached` directory that housed these classes and the `CachedMeta` class.

## API Changes
**Meta Imports**
Yes, this changed AGAIN :)

```
from workbench.meta import Meta
<change to>
from workbench.api import Meta
```

**CachedModel Import**
```
from workbench.api import CachedModel
<change to>
from workbench.cached.cached_model import CachedModel
```
For more details see: [CachedModel](../cached/cached_model.md)


## Improvements
**Dashboard Responsiveness**

The whole point of these Cached Classes is to improve Dashboard/Web Interface responsiveness. The Dashboard uses both the CachedMeta and Cached(Artifact) classes to make both overview and drilldowns faster.

**Supporting a Client Use Case**
There was a use case where a set of plugin pages needed to iterate over all the models to gather and aggregate information. We've supported that use case with a new decorator that avoids overloading AWS/Throttling issues.


**Internal**
The Dashboard now refreshes all data every 90 seconds, so if you don't see you're new model on the dashboard... just wait longer. :)



## Specific Code Changes
 
<a href="https://github.com/supercowpowers/workbench/compare/v0.8.55...v0.8.58" target="_blank">Code Diff v0.8.55 --> v0.8.58</a> 

Who doesn't like looking at code! Also +3 points for getting down this far! Here's a cow joke as a reward:

> ***What do you call a nonsense meeting?
      .... Moo-larkey***

## Questions?
<img align="right" src="../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


