# Release 0.8.22

!!!tip inline end "Need Help?"
    The SuperCowPowers team is happy to give any assistance needed when setting up AWS and Workbench. So please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 

The Workbench framework continues to flex to support different real world use cases when operating a set of production machine learning pipelines.

**Note:** These release notes cover the changes from `0.8.20` to `0.8.22`


### General
Mostly bug fixes and minor API changes.

### API Changes

- **Removing `target_column` arg when creating FeatureSets**
    
    When creating a FeatureSet via DataSource or Pandas Dataframe there was an optional argument for the `target_column` after some discussion we decided to remove this argument. In general `FeatureSets` are often used to create multiple models with different targets, so it doesn't make sense to specify a `target` at the FeatureSet level.
    
    Changed for both `DataSource.to_features()` and the `PandasToFeatures()` classes.
	
	
### Minor Bug Fixes
**Fixed:** The SHAP computation was occasionally complaining about the additivity check so we flipped that flag to False

```
shap_vals = explainer.shap_values(X_pred, check_additivity=False)
```
 
### Improvements
The optional requirements for `[UI]` now include matplotlib since it will probably be useful in the future.

## Questions?
<img align="right" src="../../../images/scp.png" width="180">

The SuperCowPowers team is happy to answer any questions you may have about AWS and Workbench. Please contact us at [workbench@supercowpowers.com](mailto:workbench@supercowpowers.com) or on chat us up on [Discord](https://discord.gg/WHAJuz8sw8) 


