# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictInt, StrictStr, constr 

class Compounding(BaseModel):
    """
    The compounding settings used on interest rate.  # noqa: E501
    """
    averaging_method:  Optional[StrictStr] = Field(None,alias="averagingMethod", description="Defines whether a weighted or unweighted average is used when calculating the average rate.  It applies only when CompoundingMethod = ‘Averaging‘.    Supported string (enumeration) values are: [Unweighted, UnweightedIncludingWeekends, Weighted].") 
    calculation_shift_method:  Optional[StrictStr] = Field(None,alias="calculationShiftMethod", description="Defines which resets and day counts are used for the rate calculation    Supported string (enumeration) values are: [Lookback, NoShift, ObservationPeriodShift, Lockout].") 
    compounding_method:  StrictStr = Field(...,alias="compoundingMethod", description="If the interest rate is simple, compounded or using a pre-computed compounded index.    Supported string (enumeration) values are: [Averaging, Compounding, CompoundedIndex, NonCumulativeCompounding].") 
    reset_frequency:  StrictStr = Field(...,alias="resetFrequency", description="The interest payment frequency.    For more information on tenors, see [knowledge base article KA-02097](https://support.lusid.com/knowledgebase/article/KA-02097)") 
    shift: Optional[StrictInt] = Field(None, description="Defines the number of days to lockout or shift observation period by - should be a non-negative integer")
    spread_compounding_method:  Optional[StrictStr] = Field(None,alias="spreadCompoundingMethod", description="Defines how the computed leg spread is applied to compounded rate.  It applies only when CompoundingMethod = ‘Compounding‘ or ‘CompoundedIndex‘.    Available compounding methods:    | Method | Description |  | ------ | ----------- |  | Straight | Compounding rate in each compound period includes the spread. |  | Flat | Compounding rate does not include the spread, and the spread is used for simple interest in each compound period. |  | SpreadExclusive | Compounding rate does not include the spread, and the spread is used for simple interest for whole accrual period. |    The values \"IsdaCompounding\", \"NoCompounding\", \"IsdaFlatCompounding\", and \"None\" are accepted for compatibility  with existing instruments and their use is discouraged.    Supported string (enumeration) values are: [Straight, IsdaCompounding, NoCompounding, SpreadExclusive, IsdaFlatCompounding, Flat, None].") 
    rounding_precision: Optional[StrictInt] = Field(None, alias="roundingPrecision", description="Defines the number of decimal places the compounded rate (expressed as a decimal) should be rounded to.  This is an optional field, leaving it blank will mean no rounding takes place in Compounding.")
    __properties = ["averagingMethod", "calculationShiftMethod", "compoundingMethod", "resetFrequency", "shift", "spreadCompoundingMethod", "roundingPrecision"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Compounding:
        """Create an instance of Compounding from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if averaging_method (nullable) is None
        # and __fields_set__ contains the field
        if self.averaging_method is None and "averaging_method" in self.__fields_set__:
            _dict['averagingMethod'] = None

        # set to None if calculation_shift_method (nullable) is None
        # and __fields_set__ contains the field
        if self.calculation_shift_method is None and "calculation_shift_method" in self.__fields_set__:
            _dict['calculationShiftMethod'] = None

        # set to None if spread_compounding_method (nullable) is None
        # and __fields_set__ contains the field
        if self.spread_compounding_method is None and "spread_compounding_method" in self.__fields_set__:
            _dict['spreadCompoundingMethod'] = None

        # set to None if rounding_precision (nullable) is None
        # and __fields_set__ contains the field
        if self.rounding_precision is None and "rounding_precision" in self.__fields_set__:
            _dict['roundingPrecision'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Compounding:
        """Create an instance of Compounding from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Compounding.parse_obj(obj)

        _obj = Compounding.parse_obj({
            "averaging_method": obj.get("averagingMethod"),
            "calculation_shift_method": obj.get("calculationShiftMethod"),
            "compounding_method": obj.get("compoundingMethod"),
            "reset_frequency": obj.get("resetFrequency"),
            "shift": obj.get("shift"),
            "spread_compounding_method": obj.get("spreadCompoundingMethod"),
            "rounding_precision": obj.get("roundingPrecision")
        })
        return _obj
