# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, constr 
from lusid.models.model_property import ModelProperty

class CreateClosedPeriodRequest(BaseModel):
    """
    CreateClosedPeriodRequest
    """
    closed_period_id:  StrictStr = Field(...,alias="closedPeriodId", description="The unique Id of the Closed Period. The ClosedPeriodId, together with the Timeline Scope and Code, uniquely identifies a Closed Period") 
    effective_end: Optional[datetime] = Field(None, alias="effectiveEnd", description="The effective end of the Closed Period")
    properties: Optional[Dict[str, ModelProperty]] = Field(None, description="The Closed Periods properties. These will be from the 'ClosedPeriod' domain.")
    as_at_closed: Optional[datetime] = Field(None, alias="asAtClosed", description="The asAt closed datetime for the Closed Period")
    display_name:  Optional[StrictStr] = Field(None,alias="displayName", description="The name of the Closed Period.") 
    description:  Optional[StrictStr] = Field(None,alias="description", description="A description for the Closed Period.") 
    __properties = ["closedPeriodId", "effectiveEnd", "properties", "asAtClosed", "displayName", "description"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateClosedPeriodRequest:
        """Create an instance of CreateClosedPeriodRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in properties (dict)
        _field_dict = {}
        if self.properties:
            for _key in self.properties:
                if self.properties[_key]:
                    _field_dict[_key] = self.properties[_key].to_dict()
            _dict['properties'] = _field_dict
        # set to None if properties (nullable) is None
        # and __fields_set__ contains the field
        if self.properties is None and "properties" in self.__fields_set__:
            _dict['properties'] = None

        # set to None if as_at_closed (nullable) is None
        # and __fields_set__ contains the field
        if self.as_at_closed is None and "as_at_closed" in self.__fields_set__:
            _dict['asAtClosed'] = None

        # set to None if display_name (nullable) is None
        # and __fields_set__ contains the field
        if self.display_name is None and "display_name" in self.__fields_set__:
            _dict['displayName'] = None

        # set to None if description (nullable) is None
        # and __fields_set__ contains the field
        if self.description is None and "description" in self.__fields_set__:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateClosedPeriodRequest:
        """Create an instance of CreateClosedPeriodRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateClosedPeriodRequest.parse_obj(obj)

        _obj = CreateClosedPeriodRequest.parse_obj({
            "closed_period_id": obj.get("closedPeriodId"),
            "effective_end": obj.get("effectiveEnd"),
            "properties": dict(
                (_k, ModelProperty.from_dict(_v))
                for _k, _v in obj.get("properties").items()
            )
            if obj.get("properties") is not None
            else None,
            "as_at_closed": obj.get("asAtClosed"),
            "display_name": obj.get("displayName"),
            "description": obj.get("description")
        })
        return _obj
