# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List
from pydantic.v1 import StrictStr, Field, BaseModel, Field, conlist 
from lusid.models.error_detail import ErrorDetail
from lusid.models.lusid_trade_ticket import LusidTradeTicket

class CreateTradeTicketsResponse(BaseModel):
    """
    Batch trade ticket creation response  # noqa: E501
    """
    values: conlist(LusidTradeTicket) = Field(...)
    failures: conlist(ErrorDetail) = Field(...)
    __properties = ["values", "failures"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateTradeTicketsResponse:
        """Create an instance of CreateTradeTicketsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in values (list)
        _items = []
        if self.values:
            for _item in self.values:
                if _item:
                    _items.append(_item.to_dict())
            _dict['values'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in failures (list)
        _items = []
        if self.failures:
            for _item in self.failures:
                if _item:
                    _items.append(_item.to_dict())
            _dict['failures'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateTradeTicketsResponse:
        """Create an instance of CreateTradeTicketsResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateTradeTicketsResponse.parse_obj(obj)

        _obj = CreateTradeTicketsResponse.parse_obj({
            "values": [LusidTradeTicket.from_dict(_item) for _item in obj.get("values")] if obj.get("values") is not None else None,
            "failures": [ErrorDetail.from_dict(_item) for _item in obj.get("failures")] if obj.get("failures") is not None else None
        })
        return _obj
