# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictInt, constr 

class FxTenorConvention(BaseModel):
    """
    A wrapper of conventions that should be used when interpreting tenors in the context of FX.  For instance, can be used to control how tenors are interpreted on an FxForwardTenorCurveData instance.  # noqa: E501
    """
    calendar_code:  StrictStr = Field(...,alias="calendarCode", description="The code of the holiday calendar that should be used when interpreting FX tenors.") 
    spot_days: StrictInt = Field(..., alias="spotDays", description="The minimum number of business days that must pass within this calendar when calculating the spot date.")
    __properties = ["calendarCode", "spotDays"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FxTenorConvention:
        """Create an instance of FxTenorConvention from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FxTenorConvention:
        """Create an instance of FxTenorConvention from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FxTenorConvention.parse_obj(obj)

        _obj = FxTenorConvention.parse_obj({
            "calendar_code": obj.get("calendarCode"),
            "spot_days": obj.get("spotDays")
        })
        return _obj
