# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr, conlist, constr, validator 

class LockPeriodDiaryEntryRequest(BaseModel):
    """
    A definition for the period you wish to lock  # noqa: E501
    """
    diary_entry_code:  Optional[StrictStr] = Field(None,alias="diaryEntryCode", description="Unique code assigned to a period. When left blank last closed period will be located.") 
    closing_options: Optional[conlist(StrictStr)] = Field(None, alias="closingOptions", description="The options which will be executed once a period is closed or locked.")
    __properties = ["diaryEntryCode", "closingOptions"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LockPeriodDiaryEntryRequest:
        """Create an instance of LockPeriodDiaryEntryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if diary_entry_code (nullable) is None
        # and __fields_set__ contains the field
        if self.diary_entry_code is None and "diary_entry_code" in self.__fields_set__:
            _dict['diaryEntryCode'] = None

        # set to None if closing_options (nullable) is None
        # and __fields_set__ contains the field
        if self.closing_options is None and "closing_options" in self.__fields_set__:
            _dict['closingOptions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LockPeriodDiaryEntryRequest:
        """Create an instance of LockPeriodDiaryEntryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LockPeriodDiaryEntryRequest.parse_obj(obj)

        _obj = LockPeriodDiaryEntryRequest.parse_obj({
            "diary_entry_code": obj.get("diaryEntryCode"),
            "closing_options": obj.get("closingOptions")
        })
        return _obj
