# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr 

class NewInstrument(BaseModel):
    """
    Set of identifiers of an existing instrument that will be the subject or distribution of a corporate action.  # noqa: E501
    """
    instrument_identifiers: Dict[str, StrictStr] = Field(..., alias="instrumentIdentifiers", description="Unique instrument identifiers.")
    lusid_instrument_id:  Optional[StrictStr] = Field(None,alias="lusidInstrumentId", description="LUSID's internal unique instrument identifier, resolved from the instrument identifiers.") 
    instrument_scope:  Optional[StrictStr] = Field(None,alias="instrumentScope", description="The scope in which the instrument lies, resolved from the instrument identifiers.") 
    dom_ccy:  Optional[StrictStr] = Field(None,alias="domCcy", description="The domestic currency of the instrument, resolved from the instrument identifiers.") 
    __properties = ["instrumentIdentifiers", "lusidInstrumentId", "instrumentScope", "domCcy"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> NewInstrument:
        """Create an instance of NewInstrument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "lusid_instrument_id",
                            "instrument_scope",
                            "dom_ccy",
                          },
                          exclude_none=True)
        # set to None if lusid_instrument_id (nullable) is None
        # and __fields_set__ contains the field
        if self.lusid_instrument_id is None and "lusid_instrument_id" in self.__fields_set__:
            _dict['lusidInstrumentId'] = None

        # set to None if instrument_scope (nullable) is None
        # and __fields_set__ contains the field
        if self.instrument_scope is None and "instrument_scope" in self.__fields_set__:
            _dict['instrumentScope'] = None

        # set to None if dom_ccy (nullable) is None
        # and __fields_set__ contains the field
        if self.dom_ccy is None and "dom_ccy" in self.__fields_set__:
            _dict['domCcy'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> NewInstrument:
        """Create an instance of NewInstrument from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return NewInstrument.parse_obj(obj)

        _obj = NewInstrument.parse_obj({
            "instrument_identifiers": obj.get("instrumentIdentifiers"),
            "lusid_instrument_id": obj.get("lusidInstrumentId"),
            "instrument_scope": obj.get("instrumentScope"),
            "dom_ccy": obj.get("domCcy")
        })
        return _obj
