# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Union
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictFloat, StrictInt 
from lusid.models.contract_details import ContractDetails

class RolloverConstituent(BaseModel):
    """
    RolloverConstituent
    """
    contract_details: ContractDetails = Field(..., alias="contractDetails")
    balance_change: Union[StrictFloat, StrictInt] = Field(..., alias="balanceChange", description="Balance of the new contract holding.")
    __properties = ["contractDetails", "balanceChange"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RolloverConstituent:
        """Create an instance of RolloverConstituent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of contract_details
        if self.contract_details:
            _dict['contractDetails'] = self.contract_details.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RolloverConstituent:
        """Create an instance of RolloverConstituent from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return RolloverConstituent.parse_obj(obj)

        _obj = RolloverConstituent.parse_obj({
            "contract_details": ContractDetails.from_dict(obj.get("contractDetails")) if obj.get("contractDetails") is not None else None,
            "balance_change": obj.get("balanceChange")
        })
        return _obj
