# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    Contact: info@finbourne.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic.v1 import StrictStr, Field, BaseModel, Field, StrictStr 

class StagedModificationDecision(BaseModel):
    """
    StagedModificationDecision
    """
    as_at: Optional[datetime] = Field(None, alias="asAt", description="Time the decision request is made.")
    user_id:  Optional[StrictStr] = Field(None,alias="userId", description="ID of user that approved the request.") 
    request_id:  Optional[StrictStr] = Field(None,alias="requestId", description="ID of user that made the request.") 
    decision:  Optional[StrictStr] = Field(None,alias="decision", description="The decision on the requested staged modification, can be 'Approve' or 'Reject'.") 
    comment:  Optional[StrictStr] = Field(None,alias="comment", description="Comment on decision.") 
    __properties = ["asAt", "userId", "requestId", "decision", "comment"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def __str__(self):
        """For `print` and `pprint`"""
        return pprint.pformat(self.dict(by_alias=False))

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StagedModificationDecision:
        """Create an instance of StagedModificationDecision from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if user_id (nullable) is None
        # and __fields_set__ contains the field
        if self.user_id is None and "user_id" in self.__fields_set__:
            _dict['userId'] = None

        # set to None if request_id (nullable) is None
        # and __fields_set__ contains the field
        if self.request_id is None and "request_id" in self.__fields_set__:
            _dict['requestId'] = None

        # set to None if decision (nullable) is None
        # and __fields_set__ contains the field
        if self.decision is None and "decision" in self.__fields_set__:
            _dict['decision'] = None

        # set to None if comment (nullable) is None
        # and __fields_set__ contains the field
        if self.comment is None and "comment" in self.__fields_set__:
            _dict['comment'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StagedModificationDecision:
        """Create an instance of StagedModificationDecision from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return StagedModificationDecision.parse_obj(obj)

        _obj = StagedModificationDecision.parse_obj({
            "as_at": obj.get("asAt"),
            "user_id": obj.get("userId"),
            "request_id": obj.get("requestId"),
            "decision": obj.get("decision"),
            "comment": obj.get("comment")
        })
        return _obj
