<div align="center">
<img src="https://docs.matflow.io/stable/_static/images/logo-90dpi.png" width="250" alt="MatFlow logo"/>
</div>

# MatFlow

![PyPI - Version](https://img.shields.io/pypi/v/matflow) ![PyPI - Python Version](https://img.shields.io/pypi/pyversions/matflow)

**Design, run, and share computational materials science workflows**

Documentation: [https://docs.matflow.io/](https://docs.matflow.io/)

## Feature parity with the [old code (LightForm-group/matflow)](https://github.com/LightForm-group/matflow)

This is a list tracking which workflows/tasks we have reimplemented/tested in the new code.

| Symbol | Meaning                                                                                |
| ------ | -------------------------------------------------------------------------------------- |
| ✅      | Tested and functional (may be undocumented)                                            |
| ❓      | Untested but should in principle work; may need tweaks to the template parametrisation |
| ❌      | Requires a missing core feature in hpcflow, or a missing software integration          |
| -      | Will not be reimplemented (e.g. superseded by another)                                 |

### Demo workflows

| Workflow                                                                                                                                          | Status | Notes                                                                                                                                                 |
| ------------------------------------------------------------------------------------------------------------------------------------------------- | ------ | ----------------------------------------------------------------------------------------------------------------------------------------------------- |
| [tension_DAMASK_Al](https://github.com/LightForm-group/UoM-CSF-matflow/blob/master/workflows/tension_DAMASK_Al.yml)                               | ✅      | Available as a [demo workflow](https://docs.matflow.io/stable/reference/workflows.html#tension-damask-al) (tension_DAMASK_Al)                         |
| [tension_DAMASK_Mg](https://github.com/LightForm-group/UoM-CSF-matflow/blob/master/workflows/tension_DAMASK_Mg.yml)                               | ✅      | Available as a [demo workflow](https://docs.matflow.io/stable/reference/workflows.html#tension-damask-mg) (tension_DAMASK_Mg)                         |
| [single_crystal_parameter_fitting](https://github.com/LightForm-group/UoM-CSF-matflow/blob/master/workflows/single_crystal_parameter_fitting.yml) | ✅      | Available as a [demo workflow](https://docs.matflow.io/stable/reference/workflows.html#fit-single-crystal-parameters) (fit_single_crystal_parameters) |
| [Dream3D_RVE_simulation](https://github.com/LightForm-group/UoM-CSF-matflow/blob/master/workflows/Dream3D_RVE_simulation.yml)                     | ❌      | Requires `generate_volume_element/from_statistics/Dream3D`                                                                                            |
| [fit_yield_function](https://github.com/LightForm-group/UoM-CSF-matflow/blob/master/workflows/fit_yield_function.yml)                             | ✅      | Available as as a [demo workflow](https://docs.matflow.io/stable/reference/workflows.html#fit-yield-funcs)                                            |


### Task schemas

| Task                                                                                                                                                                                | Status | Notes                                                                                                                                                                                                                                                                    |
| ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| **generate_microstructure_seeds**                                                                                                                                                   |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [random/damask](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L363)                                   | ✅      | [generate_microstructure_seeds](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#generate-microstructure-seeds) / [MicrostructureSeeds](https://docs.matflow.io/stable/reference/template_components/parameters.html#microstructure-seeds) |
| **generate_volume_element**                                                                                                                                                         |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [single_voxel_grains/damask](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L452)                      | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [particle_RVE/damask](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L477)                             | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [dual_phase_ti_alpha_colony](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L486)                      | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [from_damask_input_files](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L495)                         | ✅/❌    | Demo workflow: [damask-input-files](https://docs.matflow.io/stable/reference/workflows.html#damask-input-files); orientations not yet accepted                                                                                                                           |
| ⇒ method: [from_dream3d_pipeline](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L505)                           | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [extrusion](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L511)                                       | ✅      | [`generate_volume_element/extrusion`](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#generate-volume-element-extrusion)                                                                                                                  |
| ⇒ method: [from_statistics/Dream3D](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L525)                         | ✅/❌    | `generate_volume_element/from_statistics` - Not yet tested with `orientations` input                                                                                                                                                                                     |
| ⇒ method: [from_statistics_dual_phase_orientations/Dream3D](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L568) | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [random_voronoi/damask](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L624)                           | ✅      | [generate_volume_element/from_voronoi](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#generate-volume-element)                                                                                                                           |
| ⇒ method: [random_voronoi/neper](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L647)                            | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [random_voronoi_from_orientations](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L686)                | ✅      | Use [generate_volume_element/from_voronoi](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#generate-volume-element)                                                                                                                       |
| ⇒ method: [random_voronoi_from_dual_phase_orientations](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L716)     | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| **modify_volume_element**                                                                                                                                                           |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [add_buffer_zones/damask](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L760)                         | ✅      | [modify_VE/add_buffer_zones](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#modify-ve-add-buffer-zones)                                                                                                                                  |
| ⇒ method: [new_orientations/damask](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L770)                         | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [geometry](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L775)                                        | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [spread_orientations/damask](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L780)                      | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [grid_size/damask](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L786)                                | ✅      | [modify_VE/grid_size](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#modify-ve-grid-size)                                                                                                                                                |
| **generate_load_case**                                                                                                                                                              |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [mixed/formable](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L912)                                  | ✅      | [define_load_case](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#define-load-case) / [LoadCase](https://docs.matflow.io/stable/reference/template_components/parameters.html#load-case)                                                 |
| ⇒ method: [cyclic_uniaxial/formable](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L933)                        | ✅      | [define_load_case](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#define-load-case) / [LoadCase](https://docs.matflow.io/stable/reference/template_components/parameters.html#load-case)                                                 |
| ⇒ method: [uniaxial/formable](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L966)                               | ✅      | [define_load_case](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#define-load-case) / [LoadCase](https://docs.matflow.io/stable/reference/template_components/parameters.html#load-case)                                                 |
| ⇒ method: [biaxial/formable](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L999)                                | ✅      | [define_load_case](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#define-load-case) / [LoadCase](https://docs.matflow.io/stable/reference/template_components/parameters.html#load-case)                                                 |
| ⇒ method: [plane_strain/formable](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1034)                          | ✅      | [define_load_case](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#define-load-case) / [LoadCase](https://docs.matflow.io/stable/reference/template_components/parameters.html#load-case)                                                 |
| ⇒ method: [planar_2D/formable](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1076)                             | ✅      | [define_load_case](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#define-load-case) / [LoadCase](https://docs.matflow.io/stable/reference/template_components/parameters.html#load-case)                                                 |
| ⇒ method: [random_2D/formable](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1111)                             | ✅      | [define_load_case](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#define-load-case) / [LoadCase](https://docs.matflow.io/stable/reference/template_components/parameters.html#load-case)                                                 |
| ⇒ method: [random_3D/formable](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1146)                             | ✅      | [define_load_case](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#define-load-case) / [LoadCase](https://docs.matflow.io/stable/reference/template_components/parameters.html#load-case)                                                 |
| **get_tensile_test**                                                                                                                                                                |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [from_CSV/formable](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1385)                              | ✅      | [read_tensile_test](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#read-tensile-test)                                                                                                                                                    |
| **simulate_volume_element_loading**                                                                                                                                                 |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [simulate_volume_element_loading](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1243)                | ✅      | [simulate_VE_loading](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#simulate-ve-loading)                                                                                                                                                |
| **optimise_single_crystal_parameters**                                                                                                                                              |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [levenberg_marquardt/formable](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1447)                   | ✅      | [fit_single_crystal_parameters](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#fit-single-crystal-parameters)                                                                                                                            |
| **load_microstructure**                                                                                                                                                             |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [EBSD+DIC/DefDAP](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L407)                                 | ✅      | [load_microstructure/EBSD](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#load-microstructure-ebsd)                                                                                                                                      |
| ⇒ method: [EBSD/DefDAP](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L432)                                     | ✅      | [load_microstructure/EBSD_DIC](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#load-microstructure-ebsd-dic)                                                                                                                              |
| **visualise_volume_element**                                                                                                                                                        |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [vtk/damask](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L800)                                      | ✅      | [visualise_VE/vtk](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#visualise-VE-VTK)                                                                                                                                                      |
| ⇒ method: [Dream3D/Dream3D](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L805)                                 | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| **visualise_volume_element_response**                                                                                                                                               |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [texture_pole_figure/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L845)                        | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [texture_odf_section/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L886)                        | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| **generate_MK_model**                                                                                                                                                               |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [default/abaqus](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1507)                                 | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| **simulate_MK_deformation**                                                                                                                                                         |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [FE/abaqus](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1515)                                      | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| **find_forming_limit_curve**                                                                                                                                                        |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [strain_rate_ratio/abaqus](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1568)                       | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| **visualise_orientations**                                                                                                                                                          |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [pole_figure/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1594)                               | ✅      | [visualise_orientations](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#visualise-orientations)                                                                                                                                          |
| **generate_phase_field_input**                                                                                                                                                      |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [from_random_voronoi/cipher](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1619)                     | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [from_random_voronoi_with_orientations/cipher](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1659)   | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [from_volume_element/cipher](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1704)                     | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| **simulate_grain_growth**                                                                                                                                                           |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [phase_field/cipher](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1751)                             | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| **fit_yield_function**                                                                                                                                                              |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [least_squares/formable](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1350)                         | ✅      | [fit_yield_function](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#fit-yield-function)                                                                                                                                                  |
| **simulate_orientations_loading**                                                                                                                                                   |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [Taylor/damask](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L1202)                                  | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| **sample_orientations**                                                                                                                                                             |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [from_CTF_file/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L298)                              | ✅      | [sample_orientations_from_ctf_file/mtex](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#sample-orientations-from-ctf-file-mtex)                                                                                                          |
| ⇒ method: [from_CRC_file/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L331)                              | ✅      | [sample_orientations_from_crc_file/mtex](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#sample-orientations-from-crc-file-mtex)                                                                                                          |
| **sample_texture**                                                                                                                                                                  |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [from_ODF/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L127)                                   | -      | Use [sample_texture_from_ODF_mat/mtex](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#id1)                                                                                                                                               |
| ⇒ method: [from_model_ODF/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L157)                             | ✅      | [sample_texture_from_model_ODF/mtex](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#id2)                                                                                                                                                 |
| ⇒ method: [from_CTF_file/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L187)                              | ✅      | [sample_texture_from_CTF_file/mtex](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#sample-texture-from-ctf-file-mtex)                                                                                                                    |
| ⇒ method: [from_CRC_file/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L220)                              | ✅      | [sample_texture_from_CRC_file/mtex](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#sample-texture-from-crc-file-mtex)                                                                                                                    |
| ⇒ method: [from_random/damask](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L244)                              | ❌      | Unimplemented                                                                                                                                                                                                                                                            |
| ⇒ method: [from_ODF_mat/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L262)                               | ✅      | [sample_texture_from_ODF_mat/mtex](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#id1)                                                                                                                                                   |
| **estimate_ODF**                                                                                                                                                                    |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [from_CTF_file/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L81)                               | -      | Bug in MTEX's ODF export.                                                                                                                                                                                                                                                |
| ⇒ method: [from_CRC_file/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L101)                              | -      | Bug in MTEX's ODF export.                                                                                                                                                                                                                                                |
| **get_model_texture**                                                                                                                                                               |        |                                                                                                                                                                                                                                                                          |
| ⇒ method: [unimodal/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L14)                                    | -      | Use [sample_texture_from_model_ODF/mtex](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#id2)                                                                                                                                             |
| ⇒ method: [fibre/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L35)                                       | -      | Use [sample_texture_from_model_ODF/mtex](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#id2)                                                                                                                                             |
| ⇒ method: [random/mtex](https://github.com/LightForm-group/UoM-CSF-matflow/blob/569fa7bdc7006d04bd6ed2d4e4b6a114df23492e/task_schemas.yml#L54)                                      | ✅      | [sample_texture_random/mtex](https://docs.matflow.io/stable/reference/template_components/task_schemas.html#sample-texture-random-mtex)                                                                                                                                  |


## Acknowledgements

MatFlow development is funded by [UKAEA](https://www.gov.uk/government/organisations/uk-atomic-energy-authority), and was initially developed using funding from the [LightForm](https://lightform.org.uk/) EPSRC programme grant ([EP/R001715/1](https://gow.epsrc.ukri.org/NGBOViewGrant.aspx?GrantRef=EP/R001715/1)).

<img src="docs/source/_static/images/UKAEA_logo.png" width="90"/>
<br/><br/>
<img src="https://lightform-group.github.io/wiki/assets/images/site/lightform-logo.png" width="150"/>
