"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .giftcarderrorcode import GiftCardErrorCode
from datetime import datetime
from gr4vy.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from gr4vy.utils import validate_const, validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator, PlainValidator
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GiftCardSummaryTypedDict(TypedDict):
    merchant_account_id: str
    r"""The ID of the merchant account this buyer belongs to."""
    bin: str
    r"""The first 6 digits of the full gift card number."""
    sub_bin: str
    r"""The 3 digits after the `bin` of the full gift card number."""
    last4: str
    r"""The last 4 digits for the gift card."""
    type: Literal["gift-card"]
    r"""Always `gift-card`."""
    id: NotRequired[Nullable[str]]
    r"""The ID for the gift card."""
    currency: NotRequired[Nullable[str]]
    r"""The ISO-4217 currency code that this gift card has a balance for."""
    expiration_date: NotRequired[Nullable[datetime]]
    r"""The date and time when this gift card expires. This is a full date/time and may be more accurate than the actual expiry date received by the gift card service."""
    balance: NotRequired[Nullable[int]]
    r"""The amount remaining on the balance for this gift card according to the gift card service. This may be `null` if the balance could not be fetched."""
    balance_error_code: NotRequired[Nullable[GiftCardErrorCode]]
    r"""If the last balance update failed, this will contain the internal code for this error."""
    balance_raw_error_code: NotRequired[Nullable[str]]
    r"""If the last balance update failed, this will contain the the raw error code received from the gift card provider."""
    balance_raw_error_message: NotRequired[Nullable[str]]
    r"""If the last balance update failed, this will contain the the raw error message received from the gift card provider."""


class GiftCardSummary(BaseModel):
    merchant_account_id: str
    r"""The ID of the merchant account this buyer belongs to."""

    bin: str
    r"""The first 6 digits of the full gift card number."""

    sub_bin: str
    r"""The 3 digits after the `bin` of the full gift card number."""

    last4: str
    r"""The last 4 digits for the gift card."""

    TYPE: Annotated[
        Annotated[
            Optional[Literal["gift-card"]], AfterValidator(validate_const("gift-card"))
        ],
        pydantic.Field(alias="type"),
    ] = "gift-card"
    r"""Always `gift-card`."""

    id: OptionalNullable[str] = UNSET
    r"""The ID for the gift card."""

    currency: OptionalNullable[str] = UNSET
    r"""The ISO-4217 currency code that this gift card has a balance for."""

    expiration_date: OptionalNullable[datetime] = UNSET
    r"""The date and time when this gift card expires. This is a full date/time and may be more accurate than the actual expiry date received by the gift card service."""

    balance: OptionalNullable[int] = UNSET
    r"""The amount remaining on the balance for this gift card according to the gift card service. This may be `null` if the balance could not be fetched."""

    balance_error_code: Annotated[
        OptionalNullable[GiftCardErrorCode], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""If the last balance update failed, this will contain the internal code for this error."""

    balance_raw_error_code: OptionalNullable[str] = UNSET
    r"""If the last balance update failed, this will contain the the raw error code received from the gift card provider."""

    balance_raw_error_message: OptionalNullable[str] = UNSET
    r"""If the last balance update failed, this will contain the the raw error message received from the gift card provider."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "type",
            "id",
            "currency",
            "expiration_date",
            "balance",
            "balance_error_code",
            "balance_raw_error_code",
            "balance_raw_error_message",
        ]
        nullable_fields = [
            "id",
            "currency",
            "expiration_date",
            "balance",
            "balance_error_code",
            "balance_raw_error_code",
            "balance_raw_error_message",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
